/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.AbstractRegionMap;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.HDFSRegionMap;
import com.gemstone.gemfire.internal.cache.HDFSRegionMapDelegate;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionMap;
import java.util.Collection;

public class HDFSRegionMapImpl
extends AbstractRegionMap
implements HDFSRegionMap {
    private final HDFSRegionMapDelegate delegate;
    private static final boolean DEBUG = Boolean.getBoolean("hdfsRegionMap.DEBUG");

    public HDFSRegionMapImpl(LocalRegion owner, RegionMap.Attributes attrs, InternalRegionArguments internalRegionArgs) {
        super(internalRegionArgs);
        assert (owner instanceof BucketRegion);
        this.initialize(owner, attrs, internalRegionArgs, false);
        this.delegate = new HDFSRegionMapDelegate(owner, attrs, internalRegionArgs, this);
    }

    @Override
    public RegionEntry getEntry(Object key) {
        return this.delegate.getEntry(key, null);
    }

    @Override
    protected RegionEntry getEntry(EntryEventImpl event) {
        return this.delegate.getEntry(event);
    }

    @Override
    public Collection<RegionEntry> regionEntries() {
        return this.delegate.regionEntries();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public HDFSRegionMapDelegate getDelegate() {
        return this.delegate;
    }
}

