/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.asyncqueue.internal.AsyncEventQueueImpl;
import com.gemstone.gemfire.cache.hdfs.HDFSIOException;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSBucketRegionQueue;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSEntriesSet;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSGatewayEventImpl;
import com.gemstone.gemfire.cache.hdfs.internal.PersistedEventImpl;
import com.gemstone.gemfire.cache.hdfs.internal.SortedHoplogPersistedEvent;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.AbstractLRURegionMap;
import com.gemstone.gemfire.internal.cache.AbstractRegionMap;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.OffHeapRegionEntry;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PrimaryBucketException;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryFactory;
import com.gemstone.gemfire.internal.cache.RegionMap;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.lru.EnableLRU;
import com.gemstone.gemfire.internal.cache.lru.LRUEntry;
import com.gemstone.gemfire.internal.cache.versions.RegionVersionVector;
import com.gemstone.gemfire.internal.cache.versions.VersionStamp;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.parallel.ConcurrentParallelGatewaySenderQueue;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.util.concurrent.FutureResult;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class HDFSRegionMapDelegate {
    private static final Logger logger = LogService.getLogger();
    private final BucketRegion owner;
    private ConcurrentParallelGatewaySenderQueue hdfsQueue;
    private final RegionMap backingRM;
    private final ReferenceQueue<HDFSEntriesSet.HDFSIterator> refs;
    private static final boolean DEBUG = Boolean.getBoolean("hdfsRegionMap.DEBUG");
    private ConcurrentMap<Object, FutureResult> futures = new ConcurrentHashMap<Object, FutureResult>();

    public HDFSRegionMapDelegate(LocalRegion owner, RegionMap.Attributes attrs, InternalRegionArguments internalRegionArgs, RegionMap backingRM) {
        assert (owner instanceof BucketRegion);
        this.owner = (BucketRegion)owner;
        this.backingRM = backingRM;
        this.refs = new ReferenceQueue();
    }

    public RegionEntry getEntry(Object key, EntryEventImpl event) {
        RegionEntry re = this.getEntry(key, event, true);
        return re;
    }

    private RegionEntry getEntry(Object key, EntryEventImpl event, boolean forceOnHeap) {
        this.closeDeadIterators();
        RegionEntry re = this.backingRM.getEntryInVM(key);
        if (logger.isTraceEnabled() || DEBUG) {
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.DEBUG, "HDFS: Found the key in CHM: " + key + " ,value=" + (re == null ? "null" : "[" + re._getValue() + " or (" + re.getValueAsToken() + ")]")));
        }
        if ((re == null || re.isRemoved() && !re.isTombstone()) && this.owner.getBucketAdvisor().isPrimary() && this.allowReadFromHDFS()) {
            if (logger.isTraceEnabled() || DEBUG) {
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.DEBUG, "HDFS: fetching from hdfs key:" + key));
            }
            try {
                RegionVersionVector vector;
                this.owner.getPartitionedRegion().hdfsCalled(key);
                re = this.getEntryFromFuture(key);
                if (re != null) {
                    RegionEntry regionEntry = re;
                    return regionEntry;
                }
                assert (this.owner.getPartitionedRegion().getDataPolicy().withHDFS());
                byte[] k = EntryEventImpl.serialize(key);
                re = this.getFromHDFSQueue(key, k, forceOnHeap);
                if (re == null) {
                    re = this.getFromHDFS(key, k, forceOnHeap);
                }
                if (re != null && re.isTombstone() && ((vector = this.owner.getVersionVector()) == null || vector.isTombstoneTooOld(re.getVersionStamp().getMemberID(), re.getVersionStamp().getRegionVersion()))) {
                    re = null;
                }
                if (logger.isTraceEnabled() || DEBUG) {
                    logger.info((Message)LocalizedMessage.create(LocalizedStrings.DEBUG, "HDFS: returning from hdfs re:" + re));
                }
            }
            catch (ForceReattemptException e) {
                throw new PrimaryBucketException(e.getLocalizedMessage(), e);
            }
            catch (IOException e) {
                throw new HDFSIOException("Error reading from HDFS", e);
            }
            finally {
                this.notifyFuture(key, re);
                if (re != null && event != null && !re.isTombstone()) {
                    if (logger.isTraceEnabled() || DEBUG) {
                        logger.info((Message)LocalizedMessage.create(LocalizedStrings.DEBUG, "HDFS: loaded from hdfs re:" + re));
                    }
                    BucketRegion br = this.owner;
                    event.setLoadedFromHDFS(true);
                }
            }
        }
        if (re != null && re.isMarkedForEviction() && !re.isTombstone() && event != null) {
            event.setLoadedFromHDFS(true);
        }
        return re;
    }

    private boolean allowReadFromHDFS() {
        return !this.owner.getDataPolicy().withPersistence() || this.owner.getCustomEvictionAttributes() != null || this.isEvictionActionLocalDestroy();
    }

    private boolean isEvictionActionLocalDestroy() {
        PartitionedRegion pr = this.owner.getPartitionedRegion();
        if (pr.getEvictionAttributes() != null) {
            return pr.getEvictionAttributes().getAction() == EvictionAction.LOCAL_DESTROY;
        }
        return false;
    }

    protected RegionEntry getEntry(EntryEventImpl event) {
        RegionEntry re = this.getEntry(event.getKey(), event, false);
        if (re != null && event.isLoadedFromHDFS()) {
            RegionEntry oldRe = this.backingRM.putEntryIfAbsent(event.getKey(), re);
            if (oldRe != null) {
                if (re instanceof OffHeapRegionEntry && !oldRe.equals(re)) {
                    ((OffHeapRegionEntry)re).release();
                }
                return oldRe;
            }
            re.setMarkedForEviction();
            this.owner.updateSizeOnCreate(event.getKey(), this.owner.calculateRegionEntryValueSize(re));
            ((AbstractRegionMap)this.backingRM).incEntryCount(1);
            ((AbstractRegionMap)this.backingRM).lruEntryCreate(re);
        }
        return re;
    }

    public Collection<RegionEntry> regionEntries() {
        this.closeDeadIterators();
        if (!this.owner.getPartitionedRegion().includeHDFSResults()) {
            if (logger.isDebugEnabled() || DEBUG) {
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.DEBUG, "Ignoring HDFS results for #regionEntries"));
            }
            return this.backingRM.regionEntriesInVM();
        }
        try {
            return this.createEntriesSet(LocalRegion.IteratorType.ENTRIES);
        }
        catch (ForceReattemptException e) {
            throw new PrimaryBucketException(e.getLocalizedMessage(), e);
        }
    }

    public int size() {
        this.closeDeadIterators();
        if (!this.owner.getPartitionedRegion().includeHDFSResults()) {
            if (logger.isDebugEnabled() || DEBUG) {
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.DEBUG, "Ignoring HDFS results for #size"));
            }
            return this.backingRM.sizeInVM();
        }
        try {
            return this.createEntriesSet(LocalRegion.IteratorType.KEYS).size();
        }
        catch (ForceReattemptException e) {
            throw new PrimaryBucketException(e.getLocalizedMessage(), e);
        }
    }

    public boolean isEmpty() {
        this.closeDeadIterators();
        if (!this.owner.getPartitionedRegion().includeHDFSResults()) {
            if (logger.isDebugEnabled() || DEBUG) {
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.DEBUG, "Ignoring HDFS results for #isEmpty"));
            }
            return this.backingRM.sizeInVM() == 0;
        }
        try {
            return this.createEntriesSet(LocalRegion.IteratorType.KEYS).isEmpty();
        }
        catch (ForceReattemptException e) {
            throw new PrimaryBucketException(e.getLocalizedMessage(), e);
        }
    }

    private void notifyFuture(Object key, RegionEntry re) {
        FutureResult future = (FutureResult)this.futures.remove(key);
        if (future != null) {
            future.set(re);
        }
    }

    private RegionEntry getEntryFromFuture(Object key) {
        FutureResult future = new FutureResult(this.owner.getCancelCriterion());
        FutureResult old = this.futures.putIfAbsent(key, future);
        if (old != null) {
            if (logger.isTraceEnabled() || DEBUG) {
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.DEBUG, "HDFS: waiting for concurrent fetch to complete for key:" + key));
            }
            try {
                return (RegionEntry)old.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.owner.getCache().getCancelCriterion().checkCancelInProgress(null);
            }
        }
        return null;
    }

    private RegionEntry getFromHDFS(Object key, byte[] k, boolean forceOnHeap) throws IOException, ForceReattemptException {
        SortedHoplogPersistedEvent ev;
        try {
            ev = (SortedHoplogPersistedEvent)this.owner.getHoplogOrganizer().read(k);
        }
        catch (IOException e) {
            this.owner.checkForPrimary();
            throw e;
        }
        if (ev != null) {
            if (logger.isTraceEnabled() || DEBUG) {
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.DEBUG, "HDFS: got from hdfs ev:" + ev));
            }
            return this.getEntryFromEvent(key, ev, forceOnHeap, false);
        }
        return null;
    }

    private void setVersionTag(RegionEntry re, VersionTag versionTag) {
        if (this.owner.concurrencyChecksEnabled) {
            versionTag.setMemberID(this.owner.getVersionVector().getCanonicalId(versionTag.getMemberID()));
            VersionStamp versionedRe = (VersionStamp)((Object)re);
            versionedRe.setVersions(versionTag);
        }
    }

    private RegionEntry getFromHDFSQueue(Object key, byte[] k, boolean forceOnHeap) throws ForceReattemptException {
        ConcurrentParallelGatewaySenderQueue q = this.getHDFSQueue();
        if (q == null) {
            return null;
        }
        HDFSGatewayEventImpl hdfsGatewayEvent = q.get(this.owner.getPartitionedRegion(), k, this.owner.getId());
        if (hdfsGatewayEvent != null) {
            if (logger.isTraceEnabled() || DEBUG) {
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.DEBUG, "HDFS: got from hdfs queue: " + hdfsGatewayEvent));
            }
            return this.getEntryFromEvent(key, hdfsGatewayEvent, forceOnHeap, false);
        }
        return null;
    }

    private ConcurrentParallelGatewaySenderQueue getHDFSQueue() throws ForceReattemptException {
        HDFSBucketRegionQueue brq;
        if (this.hdfsQueue == null) {
            String asyncQId = this.owner.getPartitionedRegion().getHDFSEventQueueName();
            AsyncEventQueueImpl asyncQ = (AsyncEventQueueImpl)this.owner.getCache().getAsyncEventQueue(asyncQId);
            AbstractGatewaySender gatewaySender = (AbstractGatewaySender)asyncQ.getSender();
            AbstractGatewaySenderEventProcessor ep = gatewaySender.getEventProcessor();
            if (ep == null) {
                return null;
            }
            this.hdfsQueue = (ConcurrentParallelGatewaySenderQueue)ep.getQueue();
        }
        if ((brq = this.hdfsQueue.getBucketRegionQueue(this.owner.getPartitionedRegion(), this.owner.getId())) != null && this.owner.getBucketAdvisor().isPrimary() && !brq.getBucketAdvisor().isPrimaryWithWait()) {
            InternalDistributedMember primaryHolder = brq.getBucketAdvisor().basicGetPrimaryMember();
            throw new PrimaryBucketException("Bucket " + brq.getName() + " is not primary. Current primary holder is " + primaryHolder);
        }
        return this.hdfsQueue;
    }

    public RegionEntry getEntryFromEvent(Object key, HDFSGatewayEventImpl event, boolean forceOnHeap, boolean forUpdate) {
        Object val = event.getOperation().isDestroy() ? Token.TOMBSTONE : (event.getOperation().isInvalidate() ? Token.INVALID : event.getValue());
        RegionEntry re = null;
        TXStateProxy tx = this.owner.getTXState();
        if (tx == null) {
            re = this.createRegionEntry(key, val, event.getVersionTag(), forceOnHeap);
            return re;
        }
        if (val != null && ((re = this.backingRM.getEntryInVM(key)) == null || re.isRemoved() && !re.isTombstone())) {
            boolean shouldCreateOnHeapEntry = !this.owner.getOffHeap() || !forUpdate;
            re = this.createRegionEntry(key, val, event.getVersionTag(), shouldCreateOnHeapEntry);
            if (forUpdate && re != null && tx != null) {
                RegionEntry oldRe = this.backingRM.putEntryIfAbsent(key, re);
                if (oldRe != null) {
                    if (re instanceof OffHeapRegionEntry && !oldRe.equals(re)) {
                        ((OffHeapRegionEntry)re).release();
                    }
                    return oldRe;
                }
                re.setMarkedForEviction();
                this.owner.updateSizeOnCreate(key, this.owner.calculateRegionEntryValueSize(re));
                ((AbstractRegionMap)this.backingRM).incEntryCount(1);
                ((AbstractRegionMap)this.backingRM).lruEntryCreate(re);
            }
        }
        return re;
    }

    public RegionEntry getEntryFromEvent(Object key, SortedHoplogPersistedEvent event, boolean forceOnHeap, boolean forUpdate) {
        Object val = this.getValueFromEvent(event);
        RegionEntry re = null;
        TXStateProxy tx = this.owner.getTXState();
        if (tx == null) {
            re = this.createRegionEntry(key, val, event.getVersionTag(), forceOnHeap);
            return re;
        }
        if (val != null && ((re = this.backingRM.getEntryInVM(key)) == null || re.isRemoved() && !re.isTombstone())) {
            boolean shouldCreateOnHeapEntry = !this.owner.getOffHeap() || !forUpdate;
            re = this.createRegionEntry(key, val, event.getVersionTag(), shouldCreateOnHeapEntry);
            if (forUpdate && re != null && tx != null) {
                RegionEntry oldRe = this.backingRM.putEntryIfAbsent(key, re);
                if (oldRe != null) {
                    if (re instanceof OffHeapRegionEntry && !oldRe.equals(re)) {
                        ((OffHeapRegionEntry)re).release();
                    }
                    return oldRe;
                }
                re.setMarkedForEviction();
                this.owner.updateSizeOnCreate(key, this.owner.calculateRegionEntryValueSize(re));
                ((AbstractRegionMap)this.backingRM).incEntryCount(1);
                ((AbstractRegionMap)this.backingRM).lruEntryCreate(re);
            }
        }
        return re;
    }

    private RegionEntry createRegionEntry(Object key, Object value, VersionTag tag, boolean forceOnHeap) {
        RegionEntryFactory ref = this.backingRM.getEntryFactory();
        if (forceOnHeap) {
            ref = ref.makeOnHeap();
        }
        value = this.getValueDuringGII(key, value);
        RegionEntry re = ref.createEntry(this.owner, key, value);
        this.setVersionTag(re, tag);
        if (re instanceof LRUEntry) {
            assert (this.backingRM instanceof AbstractLRURegionMap);
            EnableLRU ccHelper = ((AbstractLRURegionMap)this.backingRM)._getCCHelper();
            ((LRUEntry)re).updateEntrySize(ccHelper);
        }
        return re;
    }

    private Object getValueDuringGII(Object key, Object value) {
        if (this.owner.getIndexUpdater() != null && !this.owner.isInitialized()) {
            return AbstractRegionMap.listOfDeltasCreator.newValue(key, this.owner, value, null);
        }
        return value;
    }

    private Set createEntriesSet(LocalRegion.IteratorType type) throws ForceReattemptException {
        ConcurrentParallelGatewaySenderQueue q = this.getHDFSQueue();
        if (q == null) {
            return Collections.emptySet();
        }
        HDFSBucketRegionQueue brq = q.getBucketRegionQueue(this.owner.getPartitionedRegion(), this.owner.getId());
        return new HDFSEntriesSet(this.owner, brq, this.owner.getHoplogOrganizer(), type, this.refs);
    }

    private void closeDeadIterators() {
        Reference<HDFSEntriesSet.HDFSIterator> weak;
        while ((weak = this.refs.poll()) != null) {
            if (logger.isTraceEnabled() || DEBUG) {
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.DEBUG, "Closing weak ref for iterator " + weak.get()));
            }
            weak.get().close();
        }
    }

    private Object getValueFromEvent(PersistedEventImpl ev) {
        if (ev.getOperation().isDestroy()) {
            return Token.TOMBSTONE;
        }
        if (ev.getOperation().isInvalidate()) {
            return Token.INVALID;
        }
        return ev.getValue();
    }
}

