/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.SystemTimer;
import com.gemstone.gemfire.internal.cache.EntryExpiryTask;
import com.gemstone.gemfire.internal.cache.ExpiryTask;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class ExpirationScheduler {
    private static final Logger logger = LogService.getLogger();
    private final SystemTimer timer;
    private final AtomicInteger pendingCancels = new AtomicInteger();
    private static final int MAX_PENDING_CANCELS = Integer.getInteger("gemfire.MAX_PENDING_CANCELS", 10000);

    public ExpirationScheduler(InternalDistributedSystem ds) {
        this.timer = new SystemTimer(ds, true);
    }

    public void forcePurge() {
        this.pendingCancels.getAndSet(0);
        this.timer.timerPurge();
    }

    public void incCancels() {
        int pc = this.pendingCancels.incrementAndGet();
        if (pc > MAX_PENDING_CANCELS) {
            pc = this.pendingCancels.getAndSet(0);
            if (pc > MAX_PENDING_CANCELS) {
                this.timer.timerPurge();
            } else {
                this.pendingCancels.addAndGet(pc);
            }
        }
    }

    public ExpiryTask addExpiryTask(ExpiryTask task) {
        try {
            if (logger.isTraceEnabled()) {
                logger.trace((Message)LocalizedMessage.create(LocalizedStrings.ExpirationScheduler_SCHEDULING__0__TO_FIRE_IN__1__MS, new Object[]{task, task.getExpiryMillis()}));
            }
            this.timer.schedule((SystemTimer.SystemTimerTask)task, task.getExpiryMillis());
        }
        catch (EntryNotFoundException e) {
            return null;
        }
        catch (IllegalStateException e) {
            return null;
        }
        return task;
    }

    public boolean addEntryExpiryTask(EntryExpiryTask task) {
        return this.addExpiryTask(task) != null;
    }

    public void cancel() {
        this.timer.cancel();
    }
}

