/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.EvictionCriteria;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.PrimaryBucketException;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.offheap.Releasable;
import com.google.common.util.concurrent.AbstractScheduledService;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class EvictorService
extends AbstractScheduledService {
    private final EvictionCriteria<Object, Object> criteria;
    private long interval;
    private volatile boolean stopScheduling;
    private long nextScheduleTime;
    private GemFireCacheImpl cache;
    private Region region;
    private volatile ScheduledExecutorService executorService;

    public EvictorService(EvictionCriteria<Object, Object> criteria, long evictorStartTime, long evictorInterval, TimeUnit unit, Region r) {
        this.criteria = criteria;
        this.interval = unit.toSeconds(evictorInterval);
        this.region = r;
        try {
            this.cache = GemFireCacheImpl.getExisting();
        }
        catch (CacheClosedException cacheClosedException) {
            // empty catch block
        }
        long now = this.cache.getDistributionManager().cacheTimeMillis() / 1000L;
        if (this.cache.getLoggerI18n().fineEnabled()) {
            this.cache.getLoggerI18n().fine("EvictorService: The startTime(now) is " + now + " evictorStartTime : " + evictorStartTime);
        }
        this.nextScheduleTime = now + 10L;
        if (this.cache.getLoggerI18n().fineEnabled()) {
            this.cache.getLoggerI18n().fine("EvictorService: The startTime is " + this.nextScheduleTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runOneIteration() throws Exception {
        if (this.cache.getLoggerI18n().fineEnabled()) {
            this.cache.getLoggerI18n().fine("EvictorService: Running the iteration at " + this.cache.cacheTimeMillis());
        }
        if (this.stopScheduling || this.checkCancelled(this.cache)) {
            this.stopScheduling();
            if (this.cache.getLoggerI18n().fineEnabled()) {
                this.cache.getLoggerI18n().fine("EvictorService: Abort eviction since stopScheduling OR cancel in progress. Evicted 0 entries ");
            }
            return;
        }
        CachePerfStats stats = ((LocalRegion)this.region).getCachePerfStats();
        long startEvictionTime = stats.startCustomEviction();
        int evicted = 0;
        long startEvaluationTime = stats.startEvaluation();
        Iterator<Map.Entry<Object, Object>> keysItr = null;
        long totalIterationsTime = 0L;
        keysItr = this.criteria.getKeysToBeEvicted(this.cache.getDistributionManager().cacheTimeMillis(), this.region);
        try {
            stats.incEvaluations(this.region.size());
            while (keysItr.hasNext() && !this.stopScheduling && !this.checkCancelled(this.cache)) {
                Map.Entry<Object, Object> entry = keysItr.next();
                long startIterationTime = this.cache.getDistributionManager().cacheTimeMillis();
                Object routingObj = entry.getValue();
                if (this.cache.getLoggerI18n().fineEnabled()) {
                    this.cache.getLoggerI18n().fine("EvictorService: Going to evict the following entry " + entry);
                }
                if (!(this.region instanceof PartitionedRegion)) continue;
                try {
                    PartitionedRegion pr = (PartitionedRegion)this.region;
                    stats.incEvictionsInProgress();
                    int bucketId = PartitionedRegionHelper.getHashKey(pr, routingObj);
                    BucketRegion br = pr.getDataStore().getLocalBucketById(bucketId);
                    if (br != null) {
                        if (this.cache.getLoggerI18n().fineEnabled()) {
                            this.cache.getLoggerI18n().fine("EvictorService: Going to evict the following entry " + entry + " from bucket " + br);
                        }
                        if (br.getBucketAdvisor().isPrimary()) {
                            boolean succ;
                            block22: {
                                succ = false;
                                try {
                                    succ = br.customEvictDestroy(entry.getKey());
                                }
                                catch (PrimaryBucketException e) {
                                    if (!this.cache.getLoggerI18n().fineEnabled()) break block22;
                                    this.cache.getLoggerI18n().warning(LocalizedStrings.EVICTORSERVICE_CAUGHT_EXCEPTION_0, e);
                                }
                            }
                            if (succ) {
                                ++evicted;
                            }
                            if (this.cache.getLoggerI18n().fineEnabled()) {
                                this.cache.getLoggerI18n().fine("EvictorService: Evicted the following entry " + entry + " from bucket " + br + " successfully " + succ + " the value in buk is ");
                            }
                        }
                    }
                    stats.incEvictions();
                }
                catch (Exception e) {
                    if (!this.cache.getLoggerI18n().fineEnabled()) continue;
                    this.cache.getLoggerI18n().warning(LocalizedStrings.EVICTORSERVICE_CAUGHT_EXCEPTION_0, e);
                }
                finally {
                    stats.decEvictionsInProgress();
                    long endIterationTime = this.cache.getDistributionManager().cacheTimeMillis();
                    totalIterationsTime += endIterationTime - startIterationTime;
                }
            }
        }
        finally {
            if (keysItr instanceof Releasable) {
                ((Releasable)((Object)keysItr)).release();
            }
        }
        stats.endEvaluation(startEvaluationTime, totalIterationsTime);
        if (this.cache.getLoggerI18n().fineEnabled()) {
            this.cache.getLoggerI18n().fine("EvictorService: Completed an iteration at time " + this.cache.getDistributionManager().cacheTimeMillis() / 1000L + ". Evicted " + evicted + " entries.");
        }
        stats.endCustomEviction(startEvictionTime);
    }

    private boolean checkCancelled(GemFireCacheImpl cache) {
        return cache.getCancelCriterion().cancelInProgress() != null;
    }

    protected AbstractScheduledService.Scheduler scheduler() {
        return new AbstractScheduledService.CustomScheduler(){

            protected AbstractScheduledService.CustomScheduler.Schedule getNextSchedule() throws Exception {
                long now = EvictorService.this.cache.getDistributionManager().cacheTimeMillis() / 1000L;
                if (EvictorService.this.cache.getLoggerI18n().fineEnabled()) {
                    EvictorService.this.cache.getLoggerI18n().fine("EvictorService: Now is " + now);
                }
                long delay = 0L;
                if (now < EvictorService.this.nextScheduleTime) {
                    delay = EvictorService.this.nextScheduleTime - now;
                }
                EvictorService.this.nextScheduleTime = EvictorService.this.nextScheduleTime + EvictorService.this.interval;
                if (EvictorService.this.cache.getLoggerI18n().fineEnabled()) {
                    EvictorService.this.cache.getLoggerI18n().fine("EvictorService: Returning the next schedule with delay " + delay + " next schedule is at : " + EvictorService.this.nextScheduleTime);
                }
                return new AbstractScheduledService.CustomScheduler.Schedule(delay, TimeUnit.SECONDS);
            }
        };
    }

    public void stopScheduling() {
        this.stopScheduling = true;
    }

    protected void shutDown() throws Exception {
        this.executorService.shutdownNow();
        this.region = null;
        this.cache = null;
    }

    protected void startUp() throws Exception {
    }

    public void changeEvictionInterval(long newInterval) {
        this.interval = newInterval / 1000L;
        if (this.cache.getLoggerI18n().fineEnabled()) {
            this.cache.getLoggerI18n().fine("EvictorService: New interval is " + this.interval);
        }
    }

    public void changeStartTime(long newStart) {
        this.nextScheduleTime = newStart / 1000L;
        if (this.cache.getLoggerI18n().fineEnabled()) {
            this.cache.getLoggerI18n().fine("EvictorService: New start time is " + this.nextScheduleTime);
        }
    }

    protected ScheduledExecutorService executor() {
        this.executorService = super.executor();
        return this.executorService;
    }
}

