/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.EntryOperation;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.AbstractRegion;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.WrappedCallbackArgument;

public class EntryOperationImpl
implements EntryOperation {
    private final Region region;
    private final Operation operation;
    private final Object value;
    private final Object key;
    private Object callbackArgument = Token.NOT_AVAILABLE;

    public EntryOperationImpl(Region region, Operation operation, Object key, Object value, Object callbackArgument) {
        this.region = region;
        this.operation = operation;
        this.key = key;
        this.value = value;
        this.callbackArgument = callbackArgument;
    }

    public Region getRegion() {
        return this.region;
    }

    @Override
    public Operation getOperation() {
        return this.operation;
    }

    public Object getKey() {
        return this.key;
    }

    @Override
    public Object getCallbackArgument() {
        Object result = this.callbackArgument;
        if (result == Token.NOT_AVAILABLE) {
            result = AbstractRegion.handleNotAvailable(result);
        } else if (result instanceof WrappedCallbackArgument) {
            WrappedCallbackArgument wca = (WrappedCallbackArgument)result;
            result = wca.getOriginalCallbackArg();
        }
        return result;
    }

    @Override
    public boolean isCallbackArgumentAvailable() {
        return this.callbackArgument != Token.NOT_AVAILABLE;
    }

    public Object getNewValue() {
        return this.value;
    }

    public Object getRawNewValue() {
        return this.value;
    }

    public void setCallbackArgument(Object newCallbackArgument) {
        if (this.callbackArgument instanceof WrappedCallbackArgument) {
            ((WrappedCallbackArgument)this.callbackArgument).setOriginalCallbackArgument(newCallbackArgument);
        } else {
            this.callbackArgument = newCallbackArgument;
        }
    }
}

