/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CommitIncompleteException;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.UnsupportedOperationInTransactionException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyMessage;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.ReplySender;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.CommitReplyException;
import com.gemstone.gemfire.internal.cache.DistTXCoordinatorInterface;
import com.gemstone.gemfire.internal.cache.DistTXStateProxyImplOnCoordinator;
import com.gemstone.gemfire.internal.cache.DistTXStateProxyImplOnDatanode;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.RemoteOperationException;
import com.gemstone.gemfire.internal.cache.TXCommitMessage;
import com.gemstone.gemfire.internal.cache.TXEntryState;
import com.gemstone.gemfire.internal.cache.TXId;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.TXMessage;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class DistTXCommitMessage
extends TXMessage {
    private static final Logger logger = LogService.getLogger();
    protected ArrayList<ArrayList<TXEntryState.DistTxThinEntryState>> entryStateList = null;

    public DistTXCommitMessage() {
    }

    public DistTXCommitMessage(TXId txUniqId, InternalDistributedMember onBehalfOfClientMember, ReplyProcessor21 processor) {
        super(txUniqId.getUniqId(), onBehalfOfClientMember, processor);
    }

    @Override
    public int getDSFID() {
        return -4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean operateOnTx(TXId txId, DistributionManager dm) throws RemoteOperationException {
        if (logger.isDebugEnabled()) {
            logger.debug("DistTXCommitMessage.operateOnTx: Tx {}", new Object[]{txId});
        }
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        TXManagerImpl txMgr = cache.getTXMgr();
        TXStateProxy txStateProxy = txMgr.getTXState();
        TXCommitMessage cmsg = null;
        try {
            if (txMgr.isHostedTxRecentlyCompleted(txId)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("DistTXCommitMessage.operateOnTx: found a previously committed transaction:{}", new Object[]{txId});
                }
                if (txMgr.isExceptionToken(cmsg = txMgr.getRecentlyCompletedMessage(txId))) {
                    throw txMgr.getExceptionForToken(cmsg, txId);
                }
            } else if (txStateProxy != null) {
                if (!txStateProxy.isDistTx() || txStateProxy.isCreatedOnDistTxCoordinator()) {
                    throw new UnsupportedOperationInTransactionException(LocalizedStrings.DISTTX_TX_EXPECTED.toLocalizedString("DistTXStateProxyImplOnDatanode", txStateProxy.getClass().getSimpleName()));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("DistTXCommitMessage.operateOnTx Commiting {}  incoming entryEventList:{} coming from {} ", new Object[]{txId, DistTXStateProxyImplOnCoordinator.printEntryEventList(this.entryStateList), this.getSender().getId()});
                }
                String memberID = this.getSender().getId();
                for (ArrayList<TXEntryState.DistTxThinEntryState> esList : this.entryStateList) {
                    for (TXEntryState.DistTxThinEntryState es : esList) {
                        es.setMemberID(memberID);
                    }
                }
                ((DistTXStateProxyImplOnDatanode)txStateProxy).populateDistTxEntryStates(this.entryStateList);
                txStateProxy.setCommitOnBehalfOfRemoteStub(true);
                txMgr.commit();
                cmsg = txStateProxy.getCommitMessage();
            }
        }
        finally {
            txMgr.removeHostedTXState(txId);
        }
        DistTXCommitReplyMessage.send(this.getSender(), this.getProcessorId(), cmsg, this.getReplySender(dm));
        return false;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.entryStateList = DataSerializer.readArrayList(in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeArrayList(this.entryStateList, out);
    }

    @Override
    public boolean isTransactionDistributed() {
        return true;
    }

    @Override
    public boolean canStartRemoteTransaction() {
        return true;
    }

    public void setEntryStateList(ArrayList<ArrayList<TXEntryState.DistTxThinEntryState>> entryStateList) {
        this.entryStateList = entryStateList;
    }

    public static class DistTxCommitExceptionCollectingException
    extends ReplyException {
        private static final long serialVersionUID = -2681117727592137893L;
        private final Set<InternalDistributedMember> cacheExceptions = new HashSet<InternalDistributedMember>();
        private final Map<String, Set<InternalDistributedMember>> regionExceptions = new HashMap<String, Set<InternalDistributedMember>>();
        private final Map fatalExceptions = new HashMap();
        private final TXId id;

        public DistTxCommitExceptionCollectingException(TXId txIdent) {
            this.id = txIdent;
        }

        public void handlePotentialCommitFailure(HashMap<DistributedMember, DistTXCoordinatorInterface> msgMap) {
            if (this.fatalExceptions.size() > 0) {
                StringBuffer errorMessage = new StringBuffer("Incomplete commit of transaction ").append(this.id).append(".  Caused by the following exceptions: ");
                for (Map.Entry me : this.fatalExceptions.entrySet()) {
                    DistributedMember mem = (DistributedMember)me.getKey();
                    errorMessage.append(" From member: ").append(mem).append(" ");
                    List exceptions = (List)me.getValue();
                    Iterator ei = exceptions.iterator();
                    while (ei.hasNext()) {
                        Exception e = (Exception)ei.next();
                        errorMessage.append(e);
                        for (StackTraceElement ste : e.getStackTrace()) {
                            errorMessage.append("\n\tat ").append(ste);
                        }
                        if (!ei.hasNext()) continue;
                        errorMessage.append("\nAND\n");
                    }
                    errorMessage.append(".");
                }
                throw new CommitIncompleteException(errorMessage.toString());
            }
        }

        public Set<InternalDistributedMember> getCacheClosedMembers() {
            return this.cacheExceptions;
        }

        public Set getRegionDestroyedMembers(String regionFullPath) {
            Set members = this.regionExceptions.get(regionFullPath);
            if (members == null) {
                members = Collections.EMPTY_SET;
            }
            return members;
        }

        public void addExceptionsFromMember(InternalDistributedMember member, Set exceptions) {
            for (Exception ex : exceptions) {
                if (ex instanceof CancelException) {
                    this.cacheExceptions.add(member);
                    continue;
                }
                if (ex instanceof RegionDestroyedException) {
                    String r = ((RegionDestroyedException)ex).getRegionFullPath();
                    Set<InternalDistributedMember> members = this.regionExceptions.get(r);
                    if (members == null) {
                        members = new HashSet<InternalDistributedMember>();
                        this.regionExceptions.put(r, members);
                    }
                    members.add(member);
                    continue;
                }
                ArrayList<Exception> el = (ArrayList<Exception>)this.fatalExceptions.get(member);
                if (el == null) {
                    el = new ArrayList<Exception>(2);
                    this.fatalExceptions.put(member, el);
                }
                el.add(ex);
            }
        }
    }

    public static final class DistTxCommitReplyProcessor
    extends ReplyProcessor21 {
        private HashMap<DistributedMember, DistTXCoordinatorInterface> msgMap;
        private Map<DistributedMember, TXCommitMessage> commitResponseMap;
        private transient TXId txIdent = null;

        public DistTxCommitReplyProcessor(TXId txUniqId, DM dm, Set initMembers, HashMap<DistributedMember, DistTXCoordinatorInterface> msgMap) {
            super(dm, (Collection)initMembers);
            this.msgMap = msgMap;
            this.commitResponseMap = Collections.synchronizedMap(new HashMap());
            this.txIdent = txUniqId;
        }

        @Override
        public void process(DistributionMessage msg) {
            if (msg instanceof DistTXCommitReplyMessage) {
                DistTXCommitReplyMessage reply = (DistTXCommitReplyMessage)msg;
                this.commitResponseMap.put(reply.getSender(), reply.getCommitMessage());
            }
            super.process(msg);
        }

        public void waitForPrecommitCompletion() {
            try {
                this.waitForRepliesUninterruptibly();
            }
            catch (DistTxCommitExceptionCollectingException e) {
                e.handlePotentialCommitFailure(this.msgMap);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void processException(DistributionMessage msg, ReplyException ex) {
            if (msg instanceof ReplyMessage) {
                DistTxCommitReplyProcessor distTxCommitReplyProcessor = this;
                synchronized (distTxCommitReplyProcessor) {
                    if (this.exception == null) {
                        this.exception = new DistTxCommitExceptionCollectingException(this.txIdent);
                    }
                    DistTxCommitExceptionCollectingException cce = (DistTxCommitExceptionCollectingException)this.exception;
                    if (ex instanceof CommitReplyException) {
                        CommitReplyException cre = (CommitReplyException)ex;
                        cce.addExceptionsFromMember(msg.getSender(), cre.getExceptions());
                    } else {
                        cce.addExceptionsFromMember(msg.getSender(), Collections.singleton(ex));
                    }
                }
            }
        }

        @Override
        protected boolean stopBecauseOfExceptions() {
            return false;
        }

        public Set getCacheClosedMembers() {
            if (this.exception != null) {
                DistTxCommitExceptionCollectingException cce = (DistTxCommitExceptionCollectingException)this.exception;
                return cce.getCacheClosedMembers();
            }
            return Collections.EMPTY_SET;
        }

        public Set getRegionDestroyedMembers(String regionFullPath) {
            if (this.exception != null) {
                DistTxCommitExceptionCollectingException cce = (DistTxCommitExceptionCollectingException)this.exception;
                return cce.getRegionDestroyedMembers(regionFullPath);
            }
            return Collections.EMPTY_SET;
        }

        public Map<DistributedMember, TXCommitMessage> getCommitResponseMap() {
            return this.commitResponseMap;
        }
    }

    public static final class DistTXCommitReplyMessage
    extends ReplyMessage {
        private transient TXCommitMessage commitMessage;

        public DistTXCommitReplyMessage() {
        }

        public DistTXCommitReplyMessage(DataInput in) throws IOException, ClassNotFoundException {
            this.fromData(in);
        }

        private DistTXCommitReplyMessage(int processorId, TXCommitMessage val) {
            this.setProcessorId(processorId);
            this.commitMessage = val;
        }

        @Override
        public boolean getInlineProcess() {
            return true;
        }

        public static void send(InternalDistributedMember recipient, int processorId, TXCommitMessage val, ReplySender replySender) throws RemoteOperationException {
            Assert.assertTrue(recipient != null, "DistTXCommitPhaseTwoReplyMessage NULL reply message");
            DistTXCommitReplyMessage m = new DistTXCommitReplyMessage(processorId, val);
            m.setRecipient(recipient);
            replySender.putOutgoing(m);
        }

        @Override
        public void process(DM dm, ReplyProcessor21 processor) {
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "DistTXCommitPhaseTwoReplyMessage process invoking reply processor with processorId:{}", new Object[]{this.processorId});
            }
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM)) {
                    logger.trace(LogMarker.DM, "DistTXCommitPhaseTwoReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
        }

        @Override
        public int getDSFID() {
            return -2;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeObject(this.commitMessage, out);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.commitMessage = (TXCommitMessage)DataSerializer.readObject(in);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("DistTXCommitPhaseTwoReplyMessage ").append("processorid=").append(this.processorId).append(" reply to sender ").append(this.getSender());
            return sb.toString();
        }

        public TXCommitMessage getCommitMessage() {
            return this.commitMessage;
        }
    }
}

