/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DiskAccessException;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.persistence.PersistentID;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.i18n.StringId;
import com.gemstone.gemfire.internal.FileUtil;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.cache.AbstractDiskRegion;
import com.gemstone.gemfire.internal.cache.CacheObserverHolder;
import com.gemstone.gemfire.internal.cache.CachedDeserializable;
import com.gemstone.gemfire.internal.cache.CompactableOplog;
import com.gemstone.gemfire.internal.cache.DirectoryHolder;
import com.gemstone.gemfire.internal.cache.DiskEntry;
import com.gemstone.gemfire.internal.cache.DiskId;
import com.gemstone.gemfire.internal.cache.DiskInitFile;
import com.gemstone.gemfire.internal.cache.DiskRegion;
import com.gemstone.gemfire.internal.cache.DiskStoreAttributes;
import com.gemstone.gemfire.internal.cache.DiskStoreBackup;
import com.gemstone.gemfire.internal.cache.DiskStoreFactoryImpl;
import com.gemstone.gemfire.internal.cache.DiskStoreMonitor;
import com.gemstone.gemfire.internal.cache.DiskStoreObserver;
import com.gemstone.gemfire.internal.cache.DiskStoreStats;
import com.gemstone.gemfire.internal.cache.DiskStoreTask;
import com.gemstone.gemfire.internal.cache.EntryBits;
import com.gemstone.gemfire.internal.cache.EvictionAttributesImpl;
import com.gemstone.gemfire.internal.cache.ExportDiskRegion;
import com.gemstone.gemfire.internal.cache.ForceableLinkedBlockingQueue;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.GemfireCacheHelper;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.OfflineCompactionDiskRegion;
import com.gemstone.gemfire.internal.cache.Oplog;
import com.gemstone.gemfire.internal.cache.OplogSet;
import com.gemstone.gemfire.internal.cache.OverflowOplog;
import com.gemstone.gemfire.internal.cache.OverflowOplogSet;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PersistentOplogSet;
import com.gemstone.gemfire.internal.cache.PlaceHolderDiskRegion;
import com.gemstone.gemfire.internal.cache.RegionClearedException;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.ValidatingDiskRegion;
import com.gemstone.gemfire.internal.cache.lru.LRUAlgorithm;
import com.gemstone.gemfire.internal.cache.lru.LRUStatistics;
import com.gemstone.gemfire.internal.cache.persistence.BackupInspector;
import com.gemstone.gemfire.internal.cache.persistence.BackupManager;
import com.gemstone.gemfire.internal.cache.persistence.BytesAndBits;
import com.gemstone.gemfire.internal.cache.persistence.DiskRecoveryStore;
import com.gemstone.gemfire.internal.cache.persistence.DiskRegionView;
import com.gemstone.gemfire.internal.cache.persistence.DiskStoreFilter;
import com.gemstone.gemfire.internal.cache.persistence.DiskStoreID;
import com.gemstone.gemfire.internal.cache.persistence.OplogType;
import com.gemstone.gemfire.internal.cache.persistence.PRPersistentConfig;
import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberID;
import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberPattern;
import com.gemstone.gemfire.internal.cache.persistence.RestoreScript;
import com.gemstone.gemfire.internal.cache.snapshot.GFSnapshot;
import com.gemstone.gemfire.internal.cache.snapshot.SnapshotPacket;
import com.gemstone.gemfire.internal.cache.versions.RegionVersionVector;
import com.gemstone.gemfire.internal.cache.versions.VersionSource;
import com.gemstone.gemfire.internal.cache.versions.VersionStamp;
import com.gemstone.gemfire.internal.cache.versions.VersionTag;
import com.gemstone.gemfire.internal.concurrent.ConcurrentHashSet;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.LoggingThreadGroup;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.util.BlobHelper;
import com.gemstone.gemfire.pdx.internal.EnumInfo;
import com.gemstone.gemfire.pdx.internal.PdxField;
import com.gemstone.gemfire.pdx.internal.PdxType;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class DiskStoreImpl
implements DiskStore {
    private static final Logger logger = LogService.getLogger();
    private static final String BACKUP_DIR_PREFIX = "dir";
    public static final boolean KRF_DEBUG = Boolean.getBoolean("disk.KRF_DEBUG");
    public static final int MAX_OPEN_INACTIVE_OPLOGS = Integer.getInteger("gemfire.MAX_OPEN_INACTIVE_OPLOGS", 7);
    public static final int MIN_DISK_SPACE_FOR_LOGS = Integer.getInteger("gemfire.MIN_DISK_SPACE_FOR_LOGS", 20);
    public static final long INVALID_ID = 0L;
    public static final String COMPLETE_COMPACTION_BEFORE_TERMINATION_PROPERTY_NAME = "gemfire.disk.completeCompactionBeforeTermination";
    static final int MINIMUM_DIR_SIZE = 1024;
    static volatile long DEBUG_DELAY_JOINING_WITH_COMPACTOR = 500L;
    private static final boolean ENABLE_NOTIFY_TO_ROLL = Boolean.getBoolean("gemfire.ENABLE_NOTIFY_TO_ROLL");
    public static final String RECOVER_VALUE_PROPERTY_NAME = "gemfire.disk.recoverValues";
    public static final String RECOVER_VALUES_SYNC_PROPERTY_NAME = "gemfire.disk.recoverValuesSync";
    boolean RECOVER_VALUES = DiskStoreImpl.getBoolean("gemfire.disk.recoverValues", true);
    boolean RECOVER_VALUES_SYNC = DiskStoreImpl.getBoolean("gemfire.disk.recoverValuesSync", false);
    boolean FORCE_KRF_RECOVERY = DiskStoreImpl.getBoolean("gemfire.disk.FORCE_KRF_RECOVERY", false);
    public static final long MIN_RESERVED_DRID = 1L;
    public static final long MAX_RESERVED_DRID = 8L;
    static final long MIN_DRID = 9L;
    static final int BYTES_PER_ID = 8;
    private final int MAX_OPLOGS_PER_COMPACTION = Integer.getInteger("gemfire.MAX_OPLOGS_PER_COMPACTION", (int)Integer.getInteger("gemfire.MAX_OPLOGS_PER_ROLL", 1));
    public static final int MAX_CONCURRENT_COMPACTIONS = Integer.getInteger("gemfire.MAX_CONCURRENT_COMPACTIONS", (int)Integer.getInteger("gemfire.MAX_CONCURRENT_ROLLS", 1));
    public static final int MAX_PENDING_TASKS = Integer.getInteger("gemfire.disk.MAX_PENDING_TASKS", 6);
    static final boolean PREALLOCATE_IF = !System.getProperty("gemfire.preAllocateIF", "true").equalsIgnoreCase("false");
    static final boolean PREALLOCATE_OPLOGS = !System.getProperty("gemfire.preAllocateDisk", "true").equalsIgnoreCase("false");
    public static boolean SET_IGNORE_PREALLOCATE = false;
    static final boolean SYNC_IF_WRITES = Boolean.getBoolean("gemfire.syncMetaDataWrites");
    public static volatile HashSet<String> TEST_CHK_FALLOC_DIRS;
    public static volatile HashSet<String> TEST_NO_FALLOC_DIRS;
    private final GemFireCacheImpl cache;
    private final DiskStoreStats stats;
    private final AtomicInteger entryOpsCount = new AtomicInteger();
    private final Object closeRegionGuard = new Object();
    final int dirLength;
    DirectoryHolder[] directories;
    private final long maxDirSize;
    private int infoFileDirIndex;
    private final int compactionThreshold;
    private final int maxAsyncItems;
    private final AtomicInteger forceFlushCount;
    private final Object asyncMonitor;
    private final OplogCompactor oplogCompactor;
    private DiskInitFile initFile = null;
    private volatile DiskStoreBackup diskStoreBackup = null;
    private final ReentrantReadWriteLock compactorLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.WriteLock compactorWriteLock = this.compactorLock.writeLock();
    private final ReentrantReadWriteLock.ReadLock compactorReadLock = this.compactorLock.readLock();
    private final AtomicReference<DiskAccessException> diskException = new AtomicReference();
    PersistentOplogSet persistentOplogs = new PersistentOplogSet(this);
    OverflowOplogSet overflowOplogs = new OverflowOplogSet(this);
    private final AtomicLong regionIdCtr = new AtomicLong(9L);
    private final ConcurrentMap<Long, DiskRegion> drMap = new ConcurrentHashMap<Long, DiskRegion>();
    private final Set<DiskRegion> overflowMap = new ConcurrentHashSet<DiskRegion>();
    private final Map<Long, DiskRecoveryStore> currentAsyncValueRecoveryMap = new HashMap<Long, DiskRecoveryStore>();
    private final Object asyncValueRecoveryLock = new Object();
    private DiskStoreID diskStoreID;
    private final CountDownLatch _testHandleDiskAccessException = new CountDownLatch(1);
    private final ThreadPoolExecutor diskStoreTaskPool;
    private final ThreadPoolExecutor delayedWritePool;
    private volatile Future lastDelayedWrite;
    private final BytesAndBits CLEAR_BB = new BytesAndBits(null, 0);
    private FlushPauser fp = null;
    private final ForceableLinkedBlockingQueue<Object> asyncQueue;
    private final Object drainSync = new Object();
    private ArrayList drainList = null;
    private Thread flusherThread;
    private final AtomicInteger pendingAsyncEnqueue = new AtomicInteger();
    private volatile boolean stoppingFlusher;
    private volatile boolean stopFlusher;
    private volatile boolean flusherThreadTerminated;
    private static final String LOCK_FILE_EXT = ".lk";
    private FileLock fl;
    private File lockFile;
    private final boolean isCompactionPossible;
    private final Object lock = new Object();
    private volatile boolean closing = false;
    private volatile boolean closed = false;
    private final AtomicInteger backgroundTasks = new AtomicInteger();
    final AtomicLong undeletedOplogSize = new AtomicLong();
    private final CancelCriterion stopper = new Stopper();
    private final String name;
    private final boolean autoCompact;
    private final boolean allowForceCompaction;
    private final long maxOplogSizeInBytes;
    private final long timeInterval;
    private final int queueSize;
    private final int writeBufferSize;
    private final File[] diskDirs;
    private final int[] diskDirSizes;
    private volatile float warningPercent;
    private volatile float criticalPercent;
    private final boolean ownedByRegion;
    private final InternalRegionArguments internalRegionArgs;
    private final AtomicInteger ownCount = new AtomicInteger();
    private final boolean validating;
    private final boolean offline;
    public final boolean upgradeVersionOnly;
    private final boolean offlineCompacting;
    private final boolean offlineModify;
    private int liveEntryCount;
    private int deadRecordCount;
    private final HashMap<String, LRUStatistics> prlruStatMap = new HashMap();
    private static Cache offlineCache;
    private static DistributedSystem offlineDS;
    private static final ThreadLocal<Boolean> backgroundTaskThread;

    public static boolean getBoolean(String sysProp, boolean def) {
        return Boolean.valueOf(System.getProperty(sysProp, Boolean.valueOf(def).toString()));
    }

    private static int calcCompactionThreshold(int ct) {
        if (ct == 50 && System.getProperty("gemfire.OVERFLOW_ROLL_PERCENTAGE") != null) {
            ct = (int)(Double.parseDouble(System.getProperty("gemfire.OVERFLOW_ROLL_PERCENTAGE", "0.50")) * 100.0);
        }
        return ct;
    }

    DiskStoreImpl(Cache cache, DiskStoreAttributes props) {
        this(cache, props, false, null);
    }

    DiskStoreImpl(Cache cache, DiskStoreAttributes props, boolean ownedByRegion, InternalRegionArguments internalRegionArgs) {
        this(cache, props.getName(), props, ownedByRegion, internalRegionArgs, false, false, false, false, true, false);
    }

    DiskStoreImpl(Cache cache, String name, DiskStoreAttributes props, boolean ownedByRegion, InternalRegionArguments internalRegionArgs, boolean offline, boolean upgradeVersionOnly, boolean offlineValidating, boolean offlineCompacting, boolean needsOplogs, boolean offlineModify) {
        this.offline = offline;
        this.upgradeVersionOnly = upgradeVersionOnly;
        this.validating = offlineValidating;
        this.offlineCompacting = offlineCompacting;
        this.offlineModify = offlineModify;
        assert (internalRegionArgs == null || ownedByRegion) : "internalRegionArgs should be non-null only if the DiskStore is owned by region";
        this.ownedByRegion = ownedByRegion;
        this.internalRegionArgs = internalRegionArgs;
        this.name = name;
        this.autoCompact = props.getAutoCompact();
        this.allowForceCompaction = props.getAllowForceCompaction();
        this.compactionThreshold = DiskStoreImpl.calcCompactionThreshold(props.getCompactionThreshold());
        this.maxOplogSizeInBytes = props.getMaxOplogSizeInBytes();
        this.timeInterval = props.getTimeInterval();
        this.queueSize = props.getQueueSize();
        this.writeBufferSize = props.getWriteBufferSize();
        this.diskDirs = props.getDiskDirs();
        this.diskDirSizes = props.getDiskDirSizes();
        this.warningPercent = props.getDiskUsageWarningPercentage();
        this.criticalPercent = props.getDiskUsageCriticalPercentage();
        this.cache = (GemFireCacheImpl)cache;
        DistributedSystem factory = cache.getDistributedSystem();
        this.stats = new DiskStoreStats(factory, this.getName());
        this.isCompactionPossible = this.isOfflineCompacting() || !this.isOffline() && (this.getAutoCompact() || this.getAllowForceCompaction() || ENABLE_NOTIFY_TO_ROLL);
        this.maxAsyncItems = this.getQueueSize();
        this.forceFlushCount = new AtomicInteger();
        this.asyncMonitor = new Object();
        this.asyncQueue = this.maxAsyncItems > 0 ? new ForceableLinkedBlockingQueue(this.maxAsyncItems) : new ForceableLinkedBlockingQueue();
        if (!this.isValidating() && !this.isOfflineCompacting()) {
            this.startAsyncFlusher();
        }
        File[] dirs = this.getDiskDirs();
        int[] dirSizes = this.getDiskDirSizes();
        int length = dirs.length;
        this.directories = new DirectoryHolder[length];
        long tempMaxDirSize = 0L;
        for (int i = 0; i < length; ++i) {
            this.directories[i] = new DirectoryHolder(this.getName() + "_DIR#" + i, factory, dirs[i], dirSizes[i], i);
            if (tempMaxDirSize >= (long)dirSizes[i]) continue;
            tempMaxDirSize = dirSizes[i];
        }
        this.maxDirSize = tempMaxDirSize * 1024L * 1024L;
        this.infoFileDirIndex = 0;
        this.dirLength = length;
        this.loadFiles(needsOplogs);
        if (this.isCompactionPossible() && !this.isOfflineCompacting()) {
            this.oplogCompactor = new OplogCompactor();
            this.oplogCompactor.startCompactor();
        } else {
            this.oplogCompactor = null;
        }
        int MAXT = MAX_CONCURRENT_COMPACTIONS;
        LoggingThreadGroup compactThreadGroup = LoggingThreadGroup.createThreadGroup("Oplog Compactor Thread Group", logger);
        ThreadFactory compactThreadFactory = GemfireCacheHelper.CreateThreadFactory(compactThreadGroup, "Idle OplogCompactor");
        this.diskStoreTaskPool = new ThreadPoolExecutor(MAXT, MAXT, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), compactThreadFactory);
        this.diskStoreTaskPool.allowCoreThreadTimeOut(true);
        LoggingThreadGroup deleteThreadGroup = LoggingThreadGroup.createThreadGroup("Oplog Delete Thread Group", logger);
        ThreadFactory deleteThreadFactory = GemfireCacheHelper.CreateThreadFactory(deleteThreadGroup, "Oplog Delete Task");
        this.delayedWritePool = new ThreadPoolExecutor(1, 1, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(MAX_PENDING_TASKS), deleteThreadFactory, new ThreadPoolExecutor.CallerRunsPolicy());
        this.delayedWritePool.allowCoreThreadTimeOut(true);
    }

    public boolean sameAs(DiskStoreAttributes props) {
        if (this.getAllowForceCompaction() != props.getAllowForceCompaction() && logger.isDebugEnabled()) {
            logger.debug("allowForceCompaction {} != {}", new Object[]{this.getAllowForceCompaction(), props.getAllowForceCompaction()});
        }
        if (this.getAutoCompact() != props.getAutoCompact() && logger.isDebugEnabled()) {
            logger.debug("AutoCompact {} != {}", new Object[]{this.getAutoCompact(), props.getAutoCompact()});
        }
        if (this.getCompactionThreshold() != props.getCompactionThreshold() && logger.isDebugEnabled()) {
            logger.debug("CompactionThreshold {} != {}", new Object[]{this.getCompactionThreshold(), props.getCompactionThreshold()});
        }
        if (this.getMaxOplogSizeInBytes() != props.getMaxOplogSizeInBytes() && logger.isDebugEnabled()) {
            logger.debug("MaxOplogSizeInBytes {} != {}", new Object[]{this.getMaxOplogSizeInBytes(), props.getMaxOplogSizeInBytes()});
        }
        if (!this.getName().equals(props.getName()) && logger.isDebugEnabled()) {
            logger.debug("Name {} != {}", new Object[]{this.getName(), props.getName()});
        }
        if (this.getQueueSize() != props.getQueueSize() && logger.isDebugEnabled()) {
            logger.debug("QueueSize {} != {}", new Object[]{this.getQueueSize(), props.getQueueSize()});
        }
        if (this.getTimeInterval() != props.getTimeInterval() && logger.isDebugEnabled()) {
            logger.debug("TimeInterval {} != {}", new Object[]{this.getTimeInterval(), props.getTimeInterval()});
        }
        if (this.getWriteBufferSize() != props.getWriteBufferSize()) {
            logger.debug("WriteBufferSize {} != {}", new Object[]{this.getWriteBufferSize(), props.getWriteBufferSize()});
        }
        if (!Arrays.equals(this.getDiskDirs(), props.getDiskDirs()) && logger.isDebugEnabled()) {
            logger.debug("DiskDirs {} != {}", new Object[]{Arrays.toString(this.getDiskDirs()), Arrays.toString(props.getDiskDirs())});
        }
        if (!Arrays.equals(this.getDiskDirSizes(), props.getDiskDirSizes()) && logger.isDebugEnabled()) {
            logger.debug("DiskDirSizes {} != {}", new Object[]{Arrays.toString(this.getDiskDirSizes()), Arrays.toString(props.getDiskDirSizes())});
        }
        return this.getAllowForceCompaction() == props.getAllowForceCompaction() && this.getAutoCompact() == props.getAutoCompact() && this.getCompactionThreshold() == props.getCompactionThreshold() && this.getMaxOplogSizeInBytes() == props.getMaxOplogSizeInBytes() && this.getName().equals(props.getName()) && this.getQueueSize() == props.getQueueSize() && this.getTimeInterval() == props.getTimeInterval() && this.getWriteBufferSize() == props.getWriteBufferSize() && Arrays.equals(this.getDiskDirs(), props.getDiskDirs()) && Arrays.equals(this.getDiskDirSizes(), props.getDiskDirSizes());
    }

    public DiskStoreStats getStats() {
        return this.stats;
    }

    public Map<Long, AbstractDiskRegion> getAllDiskRegions() {
        HashMap<Long, AbstractDiskRegion> results = new HashMap<Long, AbstractDiskRegion>();
        results.putAll(this.drMap);
        results.putAll(this.initFile.getDRMap());
        return results;
    }

    void scheduleForRecovery(DiskRecoveryStore drs) {
        DiskRegionView dr = drs.getDiskRegionView();
        PersistentOplogSet oplogSet = this.getPersistentOplogSet(dr);
        oplogSet.scheduleForRecovery(drs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void initializeOwner(LocalRegion lr) {
        DiskRegion dr = lr.getDiskRegion();
        if (!lr.getDataPolicy().withPersistence() || !dr.isRecreated()) {
            return;
        }
        Map<Long, DiskRecoveryStore> map = this.currentAsyncValueRecoveryMap;
        synchronized (map) {
            DiskRegionView drv = lr.getDiskRegionView();
            if (drv.getRecoveredEntryMap() != null) {
                PersistentOplogSet oplogSet = this.getPersistentOplogSet(drv);
                boolean releaseCompactorWriteLock = false;
                if (drv.isEntriesMapIncompatible()) {
                    this.acquireCompactorWriteLock();
                    releaseCompactorWriteLock = true;
                }
                try {
                    drv.copyExistingRegionMap(lr);
                    this.getStats().incUncreatedRecoveredRegions(-1);
                    for (Oplog oplog : oplogSet.getAllOplogs()) {
                        if (oplog == null) continue;
                        oplog.updateDiskRegion(lr.getDiskRegionView());
                    }
                }
                finally {
                    if (releaseCompactorWriteLock) {
                        this.releaseCompactorWriteLock();
                    }
                }
                if (this.currentAsyncValueRecoveryMap.containsKey(drv.getId())) {
                    this.currentAsyncValueRecoveryMap.put(drv.getId(), lr);
                }
                return;
            }
        }
        this.scheduleForRecovery(lr);
        try {
            this.recoverRegionsThatAreReady();
        }
        catch (DiskAccessException dae) {
            throw dae;
        }
        catch (RuntimeException re) {
            throw new DiskAccessException("RuntimeException in initializing the disk store from the disk", (Throwable)re, this);
        }
    }

    private OplogSet getOplogSet(DiskRegionView drv) {
        if (drv.isBackup()) {
            return this.persistentOplogs;
        }
        return this.overflowOplogs;
    }

    PersistentOplogSet getPersistentOplogSet(DiskRegionView drv) {
        assert (drv.isBackup());
        return this.persistentOplogs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void put(LocalRegion region, DiskEntry entry, DiskEntry.Helper.ValueWrapper value, boolean async) throws RegionClearedException {
        block18: {
            long start;
            DiskRegion dr = region.getDiskRegion();
            DiskId id = entry.getDiskId();
            if (dr.isBackup() && id.getKeyId() < 0L) {
                throw new IllegalArgumentException(LocalizedStrings.DiskRegion_CANT_PUT_A_KEYVALUE_PAIR_WITH_ID_0.toLocalizedString(id));
            }
            long l = start = async ? this.stats.startFlush() : this.stats.startWrite();
            if (!async) {
                dr.getStats().startWrite();
            }
            try {
                if (!async) {
                    this.acquireReadLock(dr);
                }
                try {
                    if (dr.isRegionClosed()) {
                        region.getCancelCriterion().checkCancelInProgress(null);
                        throw new RegionDestroyedException(LocalizedStrings.DiskRegion_THE_DISKREGION_HAS_BEEN_CLOSED_OR_DESTROYED.toLocalizedString(), dr.getName());
                    }
                    boolean doingCreate = false;
                    if (dr.isBackup() && id.getKeyId() == 0L) {
                        doingCreate = true;
                    }
                    boolean goahead = true;
                    if (dr.didClearCountChange()) {
                        boolean bl = goahead = region.basicGetEntry(entry.getKey()) == entry;
                    }
                    if (goahead) {
                        OplogSet oplogSet = this.getOplogSet(dr);
                        if (doingCreate) {
                            oplogSet.create(region, entry, value, async);
                        } else {
                            oplogSet.modify(region, entry, value, async);
                        }
                        break block18;
                    }
                    throw new RegionClearedException(LocalizedStrings.DiskRegion_CLEAR_OPERATION_ABORTING_THE_ONGOING_ENTRY_0_OPERATION_FOR_ENTRY_WITH_DISKID_1.toLocalizedString(doingCreate ? "creation" : "modification", id));
                }
                finally {
                    if (!async) {
                        this.releaseReadLock(dr);
                    }
                }
            }
            finally {
                if (async) {
                    this.stats.endFlush(start);
                } else {
                    dr.getStats().endWrite(start, this.stats.endWrite(start));
                    dr.getStats().incWrittenBytes(id.getValueLength());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void putVersionTagOnly(LocalRegion region, VersionTag tag, boolean async) {
        DiskRegion dr = region.getDiskRegion();
        assert (dr.isBackup());
        if (!async) {
            this.acquireReadLock(dr);
        }
        try {
            if (dr.isRegionClosed()) {
                region.getCancelCriterion().checkCancelInProgress(null);
                throw new RegionDestroyedException(LocalizedStrings.DiskRegion_THE_DISKREGION_HAS_BEEN_CLOSED_OR_DESTROYED.toLocalizedString(), dr.getName());
            }
            if (dr.getRegionVersionVector().contains(tag.getMemberID(), tag.getRegionVersion())) {
                return;
            }
            PersistentOplogSet oplogSet = this.getPersistentOplogSet(dr);
            oplogSet.getChild().saveConflictVersionTag(region, tag, async);
        }
        finally {
            if (!async) {
                this.releaseReadLock(dr);
            }
        }
    }

    final Object get(DiskRegion dr, DiskId id) {
        IllegalArgumentException ex;
        block13: {
            this.acquireReadLock(dr);
            int count = 0;
            ex = null;
            while (count < 3) {
                BytesAndBits bb;
                block12: {
                    bb = null;
                    try {
                        if (dr.isRegionClosed()) {
                            throw new RegionDestroyedException(LocalizedStrings.DiskRegion_THE_DISKREGION_HAS_BEEN_CLOSED_OR_DESTROYED.toLocalizedString(), dr.getName());
                        }
                        if (!dr.didClearCountChange()) break block12;
                        Token.Removed removed = Token.REMOVED_PHASE1;
                        return removed;
                    }
                    catch (IllegalArgumentException e) {
                        ++count;
                        if (logger.isDebugEnabled()) {
                            logger.debug("DiskRegion: Tried {}, getBytesAndBitsWithoutLock returns wrong byte array: {}", new Object[]{count, Arrays.toString(bb.getBytes())});
                        }
                        ex = e;
                        continue;
                    }
                }
                bb = this.getBytesAndBitsWithoutLock(dr, id, true, false);
                if (bb == this.CLEAR_BB) {
                    Token.Removed removed = Token.REMOVED_PHASE1;
                    return removed;
                }
                Object object = DiskStoreImpl.convertBytesAndBitsIntoObject(bb);
                return object;
            }
            if (!logger.isDebugEnabled()) break block13;
            logger.debug("Retried 3 times, getting entry from DiskRegion still failed. It must be Oplog file corruption due to HA");
        }
        throw ex;
        finally {
            this.releaseReadLock(dr);
        }
    }

    final Object getRaw(DiskRegionView dr, DiskId id) {
        if (dr.isRegionClosed()) {
            throw new RegionDestroyedException(LocalizedStrings.DiskRegion_THE_DISKREGION_HAS_BEEN_CLOSED_OR_DESTROYED.toLocalizedString(), dr.getName());
        }
        if (dr.didClearCountChange()) {
            return Token.REMOVED_PHASE1;
        }
        BytesAndBits bb = dr.getDiskStore().getBytesAndBitsWithoutLock(dr, id, true, false);
        if (bb == this.CLEAR_BB) {
            return Token.REMOVED_PHASE1;
        }
        return bb;
    }

    static Object convertBytesAndBitsIntoObject(BytesAndBits bb) {
        byte[] bytes = bb.getBytes();
        Object value = EntryBits.isInvalid(bb.getBits()) ? Token.INVALID : (EntryBits.isSerialized(bb.getBits()) ? DiskEntry.Helper.readSerializedValue(bytes, bb.getVersion(), null, true) : (EntryBits.isLocalInvalid(bb.getBits()) ? Token.LOCAL_INVALID : (EntryBits.isTombstone(bb.getBits()) ? Token.TOMBSTONE : DiskEntry.Helper.readRawValue(bytes, bb.getVersion(), null))));
        return value;
    }

    static Object convertBytesAndBitsToSerializedForm(BytesAndBits bb) {
        byte[] bytes = bb.getBytes();
        Object value = EntryBits.isInvalid(bb.getBits()) ? Token.INVALID : (EntryBits.isSerialized(bb.getBits()) ? DiskEntry.Helper.readSerializedValue(bytes, bb.getVersion(), null, false) : (EntryBits.isLocalInvalid(bb.getBits()) ? Token.LOCAL_INVALID : (EntryBits.isTombstone(bb.getBits()) ? Token.TOMBSTONE : DiskEntry.Helper.readRawValue(bytes, bb.getVersion(), null))));
        return value;
    }

    final BytesAndBits getBytesAndBitsWithoutLock(DiskRegionView dr, DiskId id, boolean faultIn, boolean bitOnly) {
        long oplogId = id.getOplogId();
        OplogSet oplogSet = this.getOplogSet(dr);
        CompactableOplog oplog = oplogSet.getChild(oplogId);
        if (oplog == null) {
            if (dr.didClearCountChange()) {
                return this.CLEAR_BB;
            }
            throw new DiskAccessException(LocalizedStrings.DiskRegion_DATA_FOR_DISKENTRY_HAVING_DISKID_AS_0_COULD_NOT_BE_OBTAINED_FROM_DISK_A_CLEAR_OPERATION_MAY_HAVE_DELETED_THE_OPLOGS.toLocalizedString(id), dr.getName());
        }
        return oplog.getBytesAndBits(dr, id, faultIn, bitOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final BytesAndBits getBytesAndBits(DiskRegion dr, DiskId id, boolean faultingIn) {
        this.acquireReadLock(dr);
        try {
            if (dr.isRegionClosed()) {
                throw new RegionDestroyedException(LocalizedStrings.DiskRegion_THE_DISKREGION_HAS_BEEN_CLOSED_OR_DESTROYED.toLocalizedString(), dr.getName());
            }
            if (dr.didClearCountChange()) {
                throw new DiskAccessException(LocalizedStrings.DiskRegion_ENTRY_HAS_BEEN_CLEARED_AND_IS_NOT_PRESENT_ON_DISK.toLocalizedString(), dr.getName());
            }
            BytesAndBits bb = this.getBytesAndBitsWithoutLock(dr, id, faultingIn, false);
            if (bb == this.CLEAR_BB) {
                throw new DiskAccessException(LocalizedStrings.DiskRegion_ENTRY_HAS_BEEN_CLEARED_AND_IS_NOT_PRESENT_ON_DISK.toLocalizedString(), dr.getName());
            }
            BytesAndBits bytesAndBits = bb;
            return bytesAndBits;
        }
        finally {
            this.releaseReadLock(dr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final byte getBits(DiskRegion dr, DiskId id) {
        this.acquireReadLock(dr);
        try {
            if (dr.isRegionClosed()) {
                throw new RegionDestroyedException(LocalizedStrings.DiskRegion_THE_DISKREGION_HAS_BEEN_CLOSED_OR_DESTROYED.toLocalizedString(), dr.getName());
            }
            if (dr.didClearCountChange()) {
                byte by = EntryBits.setInvalid((byte)0, true);
                return by;
            }
            BytesAndBits bb = this.getBytesAndBitsWithoutLock(dr, id, true, true);
            if (bb == this.CLEAR_BB) {
                byte by = EntryBits.setInvalid((byte)0, true);
                return by;
            }
            byte by = bb.getBits();
            return by;
        }
        finally {
            this.releaseReadLock(dr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getNoBuffer(DiskRegion dr, DiskId id) {
        BytesAndBits bb = null;
        this.acquireReadLock(dr);
        try {
            long opId = id.getOplogId();
            if (opId != -1L) {
                OplogSet oplogSet = this.getOplogSet(dr);
                bb = oplogSet.getChild(opId).getNoBuffer(dr, id);
                Object object = DiskStoreImpl.convertBytesAndBitsIntoObject(bb);
                return object;
            }
            Object var6_6 = null;
            return var6_6;
        }
        finally {
            this.releaseReadLock(dr);
        }
    }

    void testHookCloseAllOverflowChannels() {
        this.overflowOplogs.testHookCloseAllOverflowChannels();
    }

    ArrayList<OverflowOplog> testHookGetAllOverflowOplogs() {
        return this.overflowOplogs.testHookGetAllOverflowOplogs();
    }

    void testHookCloseAllOverflowOplogs() {
        this.overflowOplogs.testHookCloseAllOverflowOplogs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void remove(LocalRegion region, DiskEntry entry, boolean async, boolean isClear) throws RegionClearedException {
        block7: {
            DiskRegion dr = region.getDiskRegion();
            if (!async) {
                this.acquireReadLock(dr);
            }
            try {
                if (dr.isRegionClosed()) {
                    throw new RegionDestroyedException(LocalizedStrings.DiskRegion_THE_DISKREGION_HAS_BEEN_CLOSED_OR_DESTROYED.toLocalizedString(), dr.getName());
                }
                if (!dr.didClearCountChange()) {
                    long start = this.stats.startRemove();
                    OplogSet oplogSet = this.getOplogSet(dr);
                    oplogSet.remove(region, entry, async, isClear);
                    dr.getStats().endRemove(start, this.stats.endRemove(start));
                    break block7;
                }
                throw new RegionClearedException(LocalizedStrings.DiskRegion_CLEAR_OPERATION_ABORTING_THE_ONGOING_ENTRY_DESTRUCTION_OPERATION_FOR_ENTRY_WITH_DISKID_0.toLocalizedString(entry.getDiskId()));
            }
            finally {
                if (!async) {
                    this.releaseReadLock(dr);
                }
            }
        }
    }

    public void pauseFlusherForTesting() {
        assert (this.fp == null);
        this.fp = new FlushPauser();
        try {
            this.addAsyncItem(this.fp, true);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("unexpected interrupt in test code", ex);
        }
    }

    public void flushForTesting() {
        if (this.fp != null) {
            this.fp.unpause();
            this.fp = null;
        }
        this.forceFlush();
    }

    private void acquireWriteLock(DiskRegion dr) {
        dr.acquireWriteLock();
    }

    private void releaseWriteLock(DiskRegion dr) {
        dr.releaseWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acquireReadLock(DiskRegion dr) {
        dr.basicAcquireReadLock();
        Object object = this.closeRegionGuard;
        synchronized (object) {
            this.entryOpsCount.incrementAndGet();
            if (dr.isRegionClosed()) {
                dr.releaseReadLock();
                throw new RegionDestroyedException("The DiskRegion has been closed or destroyed", dr.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseReadLock(DiskRegion dr) {
        dr.basicReleaseReadLock();
        int currentOpsInProgress = this.entryOpsCount.decrementAndGet();
        if (currentOpsInProgress == 0) {
            Object object = this.closeRegionGuard;
            synchronized (object) {
                if (dr.isRegionClosed() && this.entryOpsCount.get() == 0) {
                    this.closeRegionGuard.notify();
                }
            }
        }
    }

    @Override
    public void forceRoll() {
        this.persistentOplogs.forceRoll(null);
    }

    public void forceRolling(DiskRegion dr) {
        if (!dr.isBackup()) {
            return;
        }
        if (!dr.isSync() && this.maxAsyncItems == 0 && this.getTimeInterval() == 0L) {
            this.forceFlush();
        }
        this.acquireReadLock(dr);
        try {
            PersistentOplogSet oplogSet = this.getPersistentOplogSet(dr);
            oplogSet.forceRoll(dr);
        }
        finally {
            this.releaseReadLock(dr);
        }
    }

    @Override
    public boolean forceCompaction() {
        return this.basicForceCompaction(null);
    }

    public boolean forceCompaction(DiskRegion dr) {
        if (!dr.isBackup()) {
            return false;
        }
        this.acquireReadLock(dr);
        try {
            boolean bl = this.basicForceCompaction(dr);
            return bl;
        }
        finally {
            this.releaseReadLock(dr);
        }
    }

    public Object getSerializedData(DiskRegion dr, DiskId id) {
        return DiskStoreImpl.convertBytesAndBitsToSerializedForm(this.getBytesAndBits(dr, id, true));
    }

    private void checkForFlusherThreadTermination() {
        if (this.flusherThreadTerminated) {
            String message = "Could not schedule asynchronous write because the flusher thread had been terminated.";
            if (this.isClosing()) {
                throw this.cache.getCacheClosedException(message, null);
            }
            throw new DiskAccessException(message, this);
        }
    }

    private void handleFullAsyncQueue(Object o) {
        AsyncDiskEntry ade = (AsyncDiskEntry)o;
        LocalRegion region = ade.region;
        try {
            VersionTag tag = ade.tag;
            if (ade.versionOnly) {
                DiskEntry.Helper.doAsyncFlush(tag, region);
            } else {
                DiskEntry entry = ade.de;
                DiskEntry.Helper.handleFullAsyncQueue(entry, region, tag);
            }
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
    }

    public void addDiskRegionToQueue(LocalRegion lr) {
        try {
            this.addAsyncItem(lr, true);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAsyncItem(Object item, boolean forceAsync) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (item instanceof AsyncDiskEntry) {
                AsyncDiskEntry ade = (AsyncDiskEntry)item;
                DiskRegion dr = ade.region.getDiskRegion();
                if (dr.didClearCountChange() && !ade.versionOnly) {
                    return;
                }
                if (ade.region.isDestroyed) {
                    throw new RegionDestroyedException(ade.region.toString(), ade.region.getFullPath());
                }
            }
            this.checkForFlusherThreadTermination();
            if (forceAsync) {
                this.asyncQueue.forcePut(item);
            } else if (!this.asyncQueue.offer(item)) {
                this.handleFullAsyncQueue(item);
                return;
            }
            this.stats.incQueueSize(1);
        }
        if (this.maxAsyncItems > 0 && this.checkAsyncItemLimit()) {
            object = this.asyncMonitor;
            synchronized (object) {
                this.asyncMonitor.notifyAll();
            }
        }
    }

    private void rmAsyncItem(Object item) {
        if (this.asyncQueue.remove(item)) {
            this.stats.incQueueSize(-1);
        }
    }

    private long startAsyncWrite(DiskRegion dr) {
        if (this.stoppingFlusher) {
            if (this.isClosed()) {
                throw new Stopper().generateCancelledException(null);
            }
            throw new DiskAccessException("The disk store is still open, but flusher is stopped, probably no space left on device", this);
        }
        this.pendingAsyncEnqueue.incrementAndGet();
        dr.getStats().startWrite();
        return this.stats.startWrite();
    }

    private void endAsyncWrite(AsyncDiskEntry ade, DiskRegion dr, long start) {
        this.pendingAsyncEnqueue.decrementAndGet();
        dr.getStats().endWrite(start, this.stats.endWrite(start));
        if (!ade.versionOnly) {
            long bytesWritten = ade.de.getDiskId().getValueLength();
            dr.getStats().incWrittenBytes(bytesWritten);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleAsyncWrite(AsyncDiskEntry ade) {
        DiskRegion dr = ade.region.getDiskRegion();
        long start = this.startAsyncWrite(dr);
        try {
            try {
                this.addAsyncItem(ade, false);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                ade.region.getCancelCriterion().checkCancelInProgress(ie);
                if (!ade.versionOnly) {
                    ade.de.getDiskId().setPendingAsync(false);
                }
            }
        }
        finally {
            this.endAsyncWrite(ade, dr, start);
        }
    }

    public void unscheduleAsyncWrite(DiskId did) {
        if (did != null) {
            did.setPendingAsync(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int fillDrainList() {
        Object object = this.drainSync;
        synchronized (object) {
            this.drainList = new ArrayList(this.asyncQueue.size());
            int drainCount = this.asyncQueue.drainTo(this.drainList);
            return drainCount;
        }
    }

    private ArrayList getDrainList() {
        return this.drainList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearDrainList(LocalRegion r, RegionVersionVector rvv) {
        Object object = this.drainSync;
        synchronized (object) {
            if (this.drainList == null) {
                return;
            }
            for (Object o : this.drainList) {
                AsyncDiskEntry ade;
                if (!(o instanceof AsyncDiskEntry) || !this.shouldClear(r, rvv, ade = (AsyncDiskEntry)o) || ade.de == null) continue;
                this.unsetPendingAsync(ade);
            }
        }
    }

    private boolean shouldClear(LocalRegion r, RegionVersionVector rvv, AsyncDiskEntry ade) {
        if (ade.region != r) {
            return false;
        }
        if (rvv == null) {
            return true;
        }
        if (ade.versionOnly) {
            return rvv.contains(ade.tag.getMemberID(), ade.tag.getRegionVersion());
        }
        VersionStamp stamp = ade.de.getVersionStamp();
        Object member = stamp.getMemberID();
        if (member == null) {
            member = r.getVersionMember();
        }
        return rvv.contains(member, stamp.getRegionVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unsetPendingAsync(AsyncDiskEntry ade) {
        DiskId did = ade.de.getDiskId();
        if (did != null && did.isPendingAsync()) {
            DiskId diskId = did;
            synchronized (diskId) {
                did.setPendingAsync(false);
            }
        }
    }

    private void startAsyncFlusher() {
        String thName = LocalizedStrings.DiskRegion_ASYNCHRONOUS_DISK_WRITER_0.toLocalizedString(this.getName());
        this.flusherThread = new Thread(LoggingThreadGroup.createThreadGroup(LocalizedStrings.DiskRegion_DISK_WRITERS.toLocalizedString(), logger), new FlusherThread(), thName);
        this.flusherThread.setDaemon(true);
        this.flusherThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAsyncFlusher() {
        this.stoppingFlusher = true;
        do {
            this.forceFlush();
        } while (this.pendingAsyncEnqueue.get() > 0);
        Object object = this.asyncMonitor;
        synchronized (object) {
            this.stopFlusher = true;
            this.asyncMonitor.notifyAll();
        }
        while (!this.flusherThreadTerminated) {
            try {
                this.flusherThread.join(100L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                this.getCache().getCancelCriterion().checkCancelInProgress(ie);
            }
        }
    }

    public boolean testWaitForAsyncFlusherThread(int waitMs) {
        try {
            this.flusherThread.join(waitMs);
            return true;
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public void asynchForceFlush() {
        try {
            this.flushFlusher(true);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public GemFireCacheImpl getCache() {
        return this.cache;
    }

    @Override
    public void flush() {
        this.forceFlush();
    }

    public void forceFlush() {
        try {
            this.flushFlusher(false);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            this.getCache().getCancelCriterion().checkCancelInProgress(ie);
        }
    }

    private boolean isFlusherTerminated() {
        return this.stopFlusher || this.flusherThreadTerminated || this.flusherThread == null || !this.flusherThread.isAlive();
    }

    private void flushFlusher(boolean async) throws InterruptedException {
        if (!this.isFlusherTerminated()) {
            FlushNotifier fn = new FlushNotifier();
            this.addAsyncItem(fn, true);
            if (this.isFlusherTerminated()) {
                this.rmAsyncItem(fn);
            } else {
                this.incForceFlush();
                if (!async) {
                    fn.waitForFlush();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incForceFlush() {
        Object object = this.asyncMonitor;
        synchronized (object) {
            this.forceFlushCount.incrementAndGet();
            this.asyncMonitor.notifyAll();
        }
    }

    private boolean checkAndClearForceFlush() {
        boolean result;
        if (this.stopFlusher) {
            return true;
        }
        boolean done = false;
        do {
            int v;
            boolean bl = result = (v = this.forceFlushCount.get()) > 0;
            if (!result) continue;
            done = this.forceFlushCount.compareAndSet(v, 0);
        } while (result && !done);
        return result;
    }

    private boolean checkAsyncItemLimit() {
        return this.asyncQueue.size() >= this.maxAsyncItems;
    }

    private void createLockFile(String name) throws DiskAccessException {
        File f = new File(this.getInfoFileDir().getDir(), "DRLK_IF" + name + LOCK_FILE_EXT);
        if (logger.isDebugEnabled()) {
            logger.debug("Creating lock file {}", new Object[]{f});
        }
        FileOutputStream fs = null;
        int cnt = 0;
        DiskAccessException dae = null;
        do {
            try {
                fs = new FileOutputStream(f);
                this.lockFile = f;
                this.fl = fs.getChannel().tryLock();
                if (this.fl == null) {
                    try {
                        fs.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw new IOException(LocalizedStrings.Oplog_THE_FILE_0_IS_BEING_USED_BY_ANOTHER_PROCESS.toLocalizedString(f));
                }
                f.deleteOnExit();
                dae = null;
                break;
            }
            catch (IOException ex) {
                if (fs != null) {
                    try {
                        fs.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                dae = new DiskAccessException(LocalizedStrings.Oplog_COULD_NOT_LOCK_0.toLocalizedString(f.getPath()), (Throwable)ex, this);
            }
            catch (IllegalStateException ex2) {
                if (fs != null) {
                    try {
                        fs.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                dae = new DiskAccessException(LocalizedStrings.Oplog_COULD_NOT_LOCK_0.toLocalizedString(f.getPath()), (Throwable)ex2, this);
            }
            ++cnt;
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (cnt < 100);
        if (dae != null) {
            throw dae;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Locked disk store {} for exclusive access in directory: {}", new Object[]{name, this.getInfoFileDir().getDir()});
        }
    }

    void closeLockFile() {
        File f;
        FileLock myfl = this.fl;
        if (myfl != null) {
            try {
                FileChannel fc = myfl.channel();
                if (myfl.isValid()) {
                    myfl.release();
                }
                fc.close();
            }
            catch (IOException fc) {
                // empty catch block
            }
            this.fl = null;
        }
        if ((f = this.lockFile) != null) {
            if (f.delete()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Deleted lock file {}", new Object[]{f});
                }
            } else if (f.exists() && logger.isDebugEnabled()) {
                logger.debug("Could not delete lock file {}", new Object[]{f});
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Unlocked disk store {}", new Object[]{this.name});
        }
    }

    private String getRecoveredGFVersionName() {
        String currentVersionStr = "GFE pre-7.0";
        Version version = this.getRecoveredGFVersion();
        if (version != null) {
            currentVersionStr = version.toString();
        }
        return currentVersionStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFiles(boolean needsOplogs) {
        String partialFileName = this.getName();
        boolean foundIfFile = false;
        int ifDirIdx = 0;
        int idx = 0;
        String ifName = "BACKUP" + this.name + ".if";
        for (DirectoryHolder dh : this.directories) {
            File f = new File(dh.getDir(), ifName);
            if (f.exists()) {
                if (foundIfFile) {
                    throw new IllegalStateException("Detected multiple disk store initialization files named \"" + ifName + "\". This disk store directories must only contain one initialization file.");
                }
                foundIfFile = true;
                ifDirIdx = idx;
            }
            ++idx;
        }
        this.infoFileDirIndex = ifDirIdx;
        this.createLockFile(partialFileName);
        boolean finished = false;
        try {
            Map<File, DirectoryHolder> persistentBackupFiles = this.persistentOplogs.findFiles(partialFileName);
            boolean backupFilesExist = !persistentBackupFiles.isEmpty();
            boolean ifRequired = backupFilesExist || this.isOffline();
            this.initFile = new DiskInitFile(partialFileName, this, ifRequired, persistentBackupFiles.keySet());
            if (this.upgradeVersionOnly) {
                if (Version.CURRENT.compareTo(this.getRecoveredGFVersion()) <= 0) {
                    if (this.getCache() != null) {
                        this.getCache().close();
                    }
                    throw new IllegalStateException("Recovered version = " + this.getRecoveredGFVersion() + ": " + LocalizedStrings.DiskStoreAlreadyInVersion_0.toLocalizedString(this.getRecoveredGFVersionName()));
                }
            } else if (Version.GFE_70.compareTo(this.getRecoveredGFVersion()) > 0) {
                if (this.getCache() != null) {
                    this.getCache().close();
                }
                throw new IllegalStateException("Recovered version = " + this.getRecoveredGFVersion() + ": " + LocalizedStrings.DiskStoreStillAtVersion_0.toLocalizedString(this.getRecoveredGFVersionName()));
            }
            DiskStoreFilter overflowFileFilter = new DiskStoreFilter(OplogType.OVERFLOW, true, partialFileName);
            for (DirectoryHolder dh : this.directories) {
                File[] files;
                File dir = dh.getDir();
                for (File file : files = FileUtil.listFiles(dir, overflowFileFilter)) {
                    boolean deleted = file.delete();
                    if (deleted || !file.exists() || !logger.isDebugEnabled()) continue;
                    logger.debug("Could not delete file {}", new Object[]{file});
                }
            }
            this.persistentOplogs.createOplogs(needsOplogs, persistentBackupFiles);
            finished = true;
            if (foundIfFile) {
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.DiskStoreImpl_RecoveredDiskStore_0_With_Id_1, new Object[]{this.getName(), this.getDiskStoreID()}));
            } else {
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.DiskStoreImpl_CreatedDiskStore_0_With_Id_1, new Object[]{this.getName(), this.getDiskStoreID()}));
            }
        }
        finally {
            if (!finished) {
                this.closeLockFile();
                if (this.getDiskInitFile() != null) {
                    this.getDiskInitFile().close();
                }
            }
        }
    }

    private void statsClose() {
        this.stats.close();
        if (this.directories != null) {
            for (int i = 0; i < this.directories.length; ++i) {
                this.directories[i].close();
            }
        }
    }

    void initializeIfNeeded() {
        if (!this.persistentOplogs.alreadyRecoveredOnce.get()) {
            this.recoverRegionsThatAreReady();
        }
    }

    void doInitialRecovery() {
        this.initializeIfNeeded();
    }

    public final void recoverRegionsThatAreReady() {
        this.persistentOplogs.recoverRegionsThatAreReady();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleValueRecovery(Set<Oplog> oplogsNeedingValueRecovery, Map<Long, DiskRecoveryStore> recoveredStores) {
        ValueRecoveryTask task = new ValueRecoveryTask(oplogsNeedingValueRecovery, recoveredStores);
        Map<Long, DiskRecoveryStore> map = this.currentAsyncValueRecoveryMap;
        synchronized (map) {
            this.currentAsyncValueRecoveryMap.putAll(recoveredStores);
        }
        this.executeDiskStoreTask(task);
    }

    DirectoryHolder getInfoFileDir() {
        return this.directories[this.infoFileDirIndex];
    }

    public long getMaxDirSize() {
        return this.maxDirSize;
    }

    boolean isCompactionEnabled() {
        return this.getAutoCompact();
    }

    @Override
    public int getCompactionThreshold() {
        return this.compactionThreshold;
    }

    final boolean isCompactionPossible() {
        return this.isCompactionPossible;
    }

    void scheduleCompaction() {
        if (this.isCompactionEnabled() && !this.isOfflineCompacting()) {
            this.oplogCompactor.scheduleIfNeeded(this.getOplogToBeCompacted());
        }
    }

    private void basicClear(LocalRegion region, DiskRegion dr, RegionVersionVector rvv) {
        if (LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER) {
            CacheObserverHolder.getInstance().beforeDiskClear();
        }
        if (region != null) {
            this.clearAsyncQueue(region, false, rvv);
            this.clearDrainList(region, rvv);
        }
        if (rvv == null) {
            dr.statsClear(region);
        }
        if (dr.isBackup()) {
            PersistentOplogSet oplogSet = this.getPersistentOplogSet(dr);
            oplogSet.clear(dr, rvv);
        } else if (rvv == null) {
            dr.freeAllEntriesOnDisk(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAsyncQueue(LocalRegion region, boolean needsWriteLock, RegionVersionVector rvv) {
        DiskRegion dr = region.getDiskRegion();
        if (needsWriteLock) {
            this.acquireWriteLock(dr);
        }
        try {
            for (Object o : this.asyncQueue) {
                AsyncDiskEntry ade;
                if (!(o instanceof AsyncDiskEntry) || !this.shouldClear(region, rvv, ade = (AsyncDiskEntry)o)) continue;
                this.rmAsyncItem(o);
            }
        }
        finally {
            if (needsWriteLock) {
                this.releaseWriteLock(dr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear(LocalRegion region, DiskRegion dr, RegionVersionVector rvv) {
        this.acquireCompactorWriteLock();
        try {
            Object regionLock;
            Object object = regionLock = region == null ? new Object() : region.getSizeGuard();
            synchronized (object) {
                Object object2 = this.lock;
                synchronized (object2) {
                    this.acquireWriteLock(dr);
                    try {
                        if (dr.isRegionClosed()) {
                            throw new RegionDestroyedException(LocalizedStrings.DiskRegion_THE_DISKREGION_HAS_BEEN_CLOSED_OR_DESTROYED.toLocalizedString(), dr.getName());
                        }
                        this.basicClear(region, dr, rvv);
                        if (rvv == null && region != null) {
                            region.txClearRegion();
                            region.clearEntries(null);
                            dr.incClearCount();
                        }
                    }
                    finally {
                        this.releaseWriteLock(dr);
                    }
                }
            }
        }
        finally {
            this.releaseCompactorWriteLock();
        }
        if (rvv != null && region != null) {
            region.txClearRegion();
            region.clearEntries(rvv);
        }
    }

    private void releaseCompactorWriteLock() {
        this.compactorWriteLock.unlock();
    }

    private void acquireCompactorWriteLock() {
        this.compactorWriteLock.lock();
    }

    public void releaseCompactorReadLock() {
        this.compactorReadLock.unlock();
    }

    public void acquireCompactorReadLock() {
        this.compactorReadLock.lock();
    }

    boolean isClosing() {
        return this.closing;
    }

    boolean isClosed() {
        return this.closed;
    }

    public void close() {
        this.close(false);
    }

    protected void waitForClose() {
        if (this.diskException.get() != null) {
            try {
                this._testHandleDiskAccessException.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(boolean destroy) {
        this.closing = true;
        this.getCache().getDiskStoreMonitor().removeDiskStore(this);
        RuntimeException rte = null;
        try {
            block25: {
                block23: {
                    block22: {
                        try {
                            this.closeCompactor(false);
                        }
                        catch (RuntimeException e) {
                            rte = e;
                        }
                        if (!this.isOffline()) {
                            try {
                                this.stopAsyncFlusher();
                            }
                            catch (RuntimeException e) {
                                if (rte == null) break block22;
                                rte = e;
                            }
                        }
                    }
                    Map<Long, DiskRecoveryStore> e = this.currentAsyncValueRecoveryMap;
                    synchronized (e) {
                        this.currentAsyncValueRecoveryMap.notifyAll();
                    }
                    if (Thread.currentThread() != InternalDistributedSystem.shutdownHook) {
                        this.waitForBackgroundTasks();
                    }
                    try {
                        this.overflowOplogs.closeOverflow();
                    }
                    catch (RuntimeException e2) {
                        if (rte == null) break block23;
                        rte = e2;
                    }
                }
                if (!destroy && this.getDiskInitFile().hasLiveRegions() || this.isValidating()) {
                    RuntimeException exception = this.persistentOplogs.close();
                    if (exception != null && rte != null) {
                        rte = exception;
                    }
                    this.getDiskInitFile().close();
                } else {
                    block24: {
                        try {
                            this.destroyAllOplogs();
                        }
                        catch (RuntimeException e) {
                            if (rte == null) break block24;
                            rte = e;
                        }
                    }
                    this.getDiskInitFile().close();
                }
                try {
                    this.statsClose();
                }
                catch (RuntimeException e) {
                    if (rte == null) break block25;
                    rte = e;
                }
            }
            this.closeLockFile();
            if (rte != null) {
                throw rte;
            }
        }
        finally {
            this.closed = true;
        }
    }

    final DiskAccessException getDiskAccessException() {
        return this.diskException.get();
    }

    boolean allowKrfCreation() {
        return this.diskException.get() == null && (this.oplogCompactor == null || this.oplogCompactor.keepCompactorRunning());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeCompactor(boolean isPrepare) {
        if (this.oplogCompactor == null) {
            return;
        }
        if (isPrepare) {
            this.acquireCompactorWriteLock();
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.oplogCompactor.stopCompactor();
                }
                catch (CancelException cancelException) {
                }
                catch (RuntimeException e) {
                    logger.warn((Message)LocalizedMessage.create(LocalizedStrings.DiskRegion_COMPLEXDISKREGION_CLOSE_EXCEPTION_IN_STOPPING_COMPACTOR), (Throwable)e);
                    throw e;
                }
            }
        }
        finally {
            if (isPrepare) {
                this.releaseCompactorWriteLock();
            }
        }
    }

    private void basicClose(LocalRegion region, DiskRegion dr, boolean closeDataOnly) {
        if (dr.isBackup()) {
            if (region != null) {
                region.closeEntries();
            }
            if (!closeDataOnly) {
                this.getDiskInitFile().closeRegion(dr);
            }
            PersistentOplogSet oplogSet = this.getPersistentOplogSet(dr);
            oplogSet.basicClose(dr);
        } else if (region != null) {
            this.clearAsyncQueue(region, true, null);
            dr.freeAllEntriesOnDisk(region);
            region.closeEntries();
            this.overflowMap.remove(dr);
        }
    }

    void prepareForClose(LocalRegion region, DiskRegion dr) {
        if (dr.isBackup()) {
            this.forceFlush();
        }
    }

    public void prepareForClose() {
        this.forceFlush();
        this.persistentOplogs.prepareForClose();
        this.closeCompactor(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void close(LocalRegion region, DiskRegion dr, boolean closeDataOnly) {
        if (DiskStoreImpl.logger.isDebugEnabled()) {
            DiskStoreImpl.logger.debug("DiskRegion::close:Attempting to close DiskRegion. Region name ={}", new Object[]{dr.getName()});
        }
        closeDiskStore = false;
        this.acquireCompactorWriteLock();
        var6_6 = regionLock = region == null ? new Object() : region.getSizeGuard();
        synchronized (var6_6) {
            var7_7 = this.lock;
            synchronized (var7_7) {
                if (!dr.isRegionClosed()) ** break block33
            }
        }
        this.releaseCompactorWriteLock();
        return;
        {
            catch (Throwable var16_13) {
                throw var16_13;
            }
        }
        {
            this.prepareForClose(region, dr);
            var7_7 = this.lock;
            synchronized (var7_7) {
                gotLock = false;
                try {
                    this.acquireWriteLock(dr);
                    if (!closeDataOnly) {
                        dr.setRegionClosed(true);
                    }
                    gotLock = true;
                    ** GOTO lbl51
                }
                catch (CancelException e) {
                    var10_10 = this.closeRegionGuard;
                    synchronized (var10_10) {
                        if (dr.isRegionClosed()) {
                            // MONITOREXIT @DISABLED, blocks:[17, 18, 19, 28, 15] lbl30 : MonitorExitStatement: MONITOREXIT : var10_10
                            // MONITOREXIT @DISABLED, blocks:[17, 19, 28, 15] lbl31 : MonitorExitStatement: MONITOREXIT : var7_7
                            // MONITOREXIT @DISABLED, blocks:[19, 28, 15] lbl32 : MonitorExitStatement: MONITOREXIT : var6_6
                            this.releaseCompactorWriteLock();
                            return;
                        }
                        if (!closeDataOnly) {
                            dr.setRegionClosed(true);
                        }
                        while (this.entryOpsCount.get() > 0) {
                            try {
                                this.closeRegionGuard.wait(20000L);
                            }
                            catch (InterruptedException ie) {
                                Thread.currentThread().interrupt();
                                dr.setRegionClosed(false);
                                // MONITOREXIT @DISABLED, blocks:[17, 18, 19, 20, 25, 15] lbl48 : MonitorExitStatement: MONITOREXIT : var10_10
                                // MONITOREXIT @DISABLED, blocks:[17, 19, 20, 25, 15] lbl49 : MonitorExitStatement: MONITOREXIT : var7_7
                                // MONITOREXIT @DISABLED, blocks:[19, 20, 25, 15] lbl50 : MonitorExitStatement: MONITOREXIT : var6_6
                                this.releaseCompactorWriteLock();
                                return;
                            }
                        }
                        ** try [egrp 10[TRYBLOCK] [23 : 233->367)] { 
                    }
lbl51:
                    // 2 sources

                    try {
                        if (DiskStoreImpl.logger.isDebugEnabled()) {
                            DiskStoreImpl.logger.debug("DiskRegion::close:Before invoking basic Close. Region name ={}", new Object[]{dr.getName()});
                        }
                        this.basicClose(region, dr, closeDataOnly);
                    }
                    finally {
                        if (gotLock) {
                            this.releaseWriteLock(dr);
                        }
                    }
                    // MONITOREXIT @DISABLED, blocks:[17, 19, 15] lbl64 : MonitorExitStatement: MONITOREXIT : var7_7
                    // MONITOREXIT @DISABLED, blocks:[19, 15] lbl65 : MonitorExitStatement: MONITOREXIT : var6_6
                    if (this.getOwnedByRegion() && !closeDataOnly && this.ownCount.decrementAndGet() <= 0) {
                        closeDiskStore = true;
                    }
lbl-1000:
                    // 1 sources

                    {
                        finally {
                            this.releaseCompactorWriteLock();
                        }
                    }
                }
            }
        }
        if (closeDiskStore == false) return;
        this.cache.removeDiskStore(this);
        this.close();
    }

    void beginDestroyRegion(LocalRegion region, DiskRegion dr) {
        if (dr.isBackup()) {
            this.getDiskInitFile().beginDestroyRegion(dr);
        }
    }

    int incBackgroundTasks() {
        this.getCache().getCachePerfStats().incDiskTasksWaiting();
        int v = this.backgroundTasks.incrementAndGet();
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decBackgroundTasks() {
        int v = this.backgroundTasks.decrementAndGet();
        if (v == 0) {
            AtomicInteger atomicInteger = this.backgroundTasks;
            synchronized (atomicInteger) {
                this.backgroundTasks.notifyAll();
            }
        }
        this.getCache().getCachePerfStats().decDiskTasksWaiting();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForBackgroundTasks() {
        if (DiskStoreImpl.isBackgroundTaskThread()) {
            return;
        }
        if (this.backgroundTasks.get() > 0) {
            boolean interrupted = Thread.interrupted();
            try {
                AtomicInteger atomicInteger = this.backgroundTasks;
                synchronized (atomicInteger) {
                    while (this.backgroundTasks.get() > 0) {
                        try {
                            this.backgroundTasks.wait(500L);
                        }
                        catch (InterruptedException ex) {
                            interrupted = true;
                        }
                    }
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    boolean basicForceCompaction(DiskRegion dr) {
        CompactableOplog[] oplogs;
        PersistentOplogSet oplogSet = this.persistentOplogs;
        Oplog active = oplogSet.getChild();
        if (active != null && active.hadLiveEntries() && active.needsCompaction()) {
            active.forceRolling(dr);
        }
        if ((oplogs = this.getOplogsToBeCompacted(true)) != null && this.oplogCompactor != null) {
            if (this.oplogCompactor.scheduleIfNeeded(oplogs)) {
                this.oplogCompactor.waitForRunToComplete();
            } else {
                oplogs = null;
            }
        }
        return oplogs != null;
    }

    private void basicDestroy(LocalRegion region, DiskRegion dr) {
        if (dr.isBackup()) {
            if (region != null) {
                region.closeEntries();
            }
            PersistentOplogSet oplogSet = this.getPersistentOplogSet(dr);
            oplogSet.basicDestroy(dr);
        } else {
            dr.freeAllEntriesOnDisk(region);
            if (region != null) {
                region.closeEntries();
            }
        }
    }

    private void destroyAllOplogs() {
        this.persistentOplogs.destroyAllOplogs();
        DiskStoreFilter overflowFileFilter = new DiskStoreFilter(OplogType.OVERFLOW, true, this.getName());
        this.deleteFiles(overflowFileFilter);
        DiskStoreFilter backupFileFilter = new DiskStoreFilter(OplogType.BACKUP, true, this.getName());
        this.deleteFiles(backupFileFilter);
    }

    private void deleteFiles(FilenameFilter overflowFileFilter) {
        for (int i = 0; i < this.directories.length; ++i) {
            File[] files;
            File dir = this.directories[i].getDir();
            for (File file : files = FileUtil.listFiles(dir, overflowFileFilter)) {
                boolean deleted = file.delete();
                if (deleted || !file.exists() || !logger.isDebugEnabled()) continue;
                logger.debug("Could not delete file {}", new Object[]{file});
            }
        }
    }

    @Override
    public void destroy() {
        TreeSet<String> liveRegions = new TreeSet<String>();
        for (AbstractDiskRegion abstractDiskRegion : this.getDiskRegions()) {
            liveRegions.add(abstractDiskRegion.getName());
        }
        for (AbstractDiskRegion abstractDiskRegion : this.overflowMap) {
            liveRegions.add(abstractDiskRegion.getName());
        }
        if (!liveRegions.isEmpty()) {
            throw new IllegalStateException("Disk store is currently in use by these regions " + liveRegions);
        }
        this.close(true);
        this.getDiskInitFile().destroy();
        this.cache.removeDiskStore(this);
    }

    CompactableOplog[] getOplogToBeCompacted() {
        return this.getOplogsToBeCompacted(false);
    }

    public int numCompactableOplogs() {
        CompactableOplog[] oplogs = this.getOplogsToBeCompacted(true);
        if (oplogs == null) {
            return 0;
        }
        return oplogs.length;
    }

    private CompactableOplog[] getOplogsToBeCompacted(boolean all) {
        ArrayList<CompactableOplog> l = new ArrayList<CompactableOplog>();
        int max = Integer.MAX_VALUE;
        if (!all && max > this.MAX_OPLOGS_PER_COMPACTION && this.MAX_OPLOGS_PER_COMPACTION > 0) {
            max = this.MAX_OPLOGS_PER_COMPACTION;
        }
        this.persistentOplogs.getCompactableOplogs(l, max);
        this.overflowOplogs.getCompactableOplogs(l, max);
        if (l.isEmpty()) {
            return null;
        }
        return l.toArray(new CompactableOplog[0]);
    }

    public String getBackupDirName() {
        String name = this.getName();
        if (name == null) {
            name = GemFireCacheImpl.DEFAULT_DS_NAME;
        }
        return name + "_" + this.getDiskStoreID().toString();
    }

    private Oplog[] filterBaselineOplogs(BackupInspector baselineInspector, Map<File, File> baselineCopyMap) throws IOException {
        Oplog[] allOplogs;
        File baselineDir = new File(baselineInspector.getBackupDir(), "diskstores");
        baselineDir = new File(baselineDir, this.getBackupDirName());
        List<File> baselineOplogFiles = FileUtil.findAll(baselineDir, ".*\\.[kdc]rf$");
        LinkedList<Oplog> oplogList = new LinkedList<Oplog>();
        for (Oplog log : allOplogs = this.getAllOplogsForBackup()) {
            Set<String> matchingOplogs;
            Map<File, File> oplogMap = log.mapBaseline(baselineOplogFiles);
            if (oplogMap.isEmpty() && baselineInspector.isIncremental() && !(matchingOplogs = log.gatherMatchingOplogFiles(baselineInspector.getIncrementalOplogFileNames())).isEmpty()) {
                for (String matchingOplog : matchingOplogs) {
                    oplogMap.put(new File(baselineInspector.getCopyFromForOplogFile(matchingOplog)), new File(baselineInspector.getCopyToForOplogFile(matchingOplog)));
                }
            }
            if (oplogMap.isEmpty()) {
                oplogList.add(log);
                continue;
            }
            baselineCopyMap.putAll(oplogMap);
        }
        return oplogList.toArray(new Oplog[0]);
    }

    private Oplog[] getAllOplogsForBackup() {
        return this.persistentOplogs.getAllOplogs();
    }

    DiskInitFile getDiskInitFile() {
        return this.initFile;
    }

    public void memberOffline(DiskRegionView dr, PersistentMemberID persistentID) {
        if (this.initFile != null) {
            this.initFile.addOfflinePMID(dr, persistentID);
        }
    }

    public void memberOfflineAndEqual(DiskRegionView dr, PersistentMemberID persistentID) {
        if (this.initFile != null) {
            this.initFile.addOfflineAndEqualPMID(dr, persistentID);
        }
    }

    public void memberOnline(DiskRegionView dr, PersistentMemberID persistentID) {
        if (this.initFile != null) {
            this.initFile.addOnlinePMID(dr, persistentID);
        }
    }

    public void memberRemoved(DiskRegionView dr, PersistentMemberID persistentID) {
        if (this.initFile != null) {
            this.initFile.rmPMID(dr, persistentID);
        }
    }

    public void memberRevoked(PersistentMemberPattern revokedPattern) {
        if (this.initFile != null) {
            this.initFile.revokeMember(revokedPattern);
        }
    }

    public void setInitializing(DiskRegionView dr, PersistentMemberID newId) {
        if (this.initFile != null) {
            this.initFile.addMyInitializingPMID(dr, newId);
        }
    }

    public void setInitialized(DiskRegionView dr) {
        if (this.initFile != null) {
            this.initFile.markInitialized(dr);
        }
    }

    public Set<PersistentMemberPattern> getRevokedMembers() {
        if (this.initFile != null) {
            return this.initFile.getRevokedIDs();
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void endDestroyRegion(LocalRegion region, DiskRegion dr) {
        var4_4 = regionLock = region == null ? new Object() : region.getSizeGuard();
        synchronized (var4_4) {
            var5_5 = this.lock;
            synchronized (var5_5) {
                block37: {
                    if (dr.isRegionClosed()) {
                        return;
                    }
                    gotLock = false;
                    try {
                        this.acquireWriteLock(dr);
                        gotLock = true;
                    }
                    catch (CancelException var7_7) {
                        // empty catch block
                    }
                    if (!gotLock) {
                        var7_8 = this.closeRegionGuard;
                        synchronized (var7_8) {
                            if (dr.isRegionClosed()) {
                                return;
                            }
                            dr.setRegionClosed(true);
                            loopCount = 10;
                            ** break block36
                        }
                    } else lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            continue;
                            break;
                        }
                    }
                    finally {
                        if (gotLock) {
                            this.releaseWriteLock(dr);
                        }
                    }
                    dr.setRegionClosed(true);
                    this.basicDestroy(region, dr);
                    // MONITOREXIT @DISABLED, blocks:[2, 11, 12] lbl36 : MonitorExitStatement: MONITOREXIT : var5_5
                    // MONITOREXIT @DISABLED, blocks:[2, 11] lbl37 : MonitorExitStatement: MONITOREXIT : var4_4
                    if (this.initFile != null && dr.isBackup()) {
                        this.initFile.endDestroyRegion(dr);
                    } else {
                        this.rmById(dr.getId());
                        this.overflowMap.remove(dr);
                    }
                    if (this.getOwnedByRegion() && this.ownCount.decrementAndGet() <= 0) {
                        this.destroy();
                    }
                    return;
lbl-1000:
                    // 1 sources

                    {
                        for (i = 0; i < 10 && this.entryOpsCount.get() != 0; ++i) {
                            interrupted = Thread.interrupted();
                            try {
                                this.closeRegionGuard.wait(1000L);
                                continue;
                            }
                            catch (InterruptedException ie) {
                                interrupted = true;
                                continue;
                            }
                            finally {
                                if (interrupted) {
                                    Thread.currentThread().interrupt();
                                }
                            }
                        }
                        if (this.entryOpsCount.get() <= 0) break block37;
                        DiskStoreImpl.logger.warn((Message)LocalizedMessage.create(LocalizedStrings.DisKRegion_OUTSTANDING_OPS_REMAIN_AFTER_0_SECONDS_FOR_DISK_REGION_1, new Object[]{10, dr.getName()}));
                        while (true) lbl-1000:
                        // 5 sources

                        {
                            if (this.entryOpsCount.get() == 0) {
                                DiskStoreImpl.logger.info((Message)LocalizedMessage.create(LocalizedStrings.DisKRegion_OUTSTANDING_OPS_CLEARED_FOR_DISK_REGION_0, dr.getName()));
                                ** break;
                            }
                            interrupted = Thread.interrupted();
                            try {
                                this.closeRegionGuard.wait(1000L);
                            }
                            catch (InterruptedException ie) {
                                interrupted = true;
                            }
                            finally {
                                if (!interrupted) ** GOTO lbl-1000
                                Thread.currentThread().interrupt();
                                continue;
                            }
                            break;
                        }
                        ** GOTO lbl-1000
                    }
                }
                ** continue;
            }
        }
    }

    public void beginDestroyDataStorage(DiskRegion dr) {
        if (this.initFile != null && dr.isBackup()) {
            this.initFile.beginDestroyDataStorage(dr);
        }
    }

    public void endDestroyDataStorage(LocalRegion region, DiskRegion dr) {
        try {
            this.clear(region, dr, null);
            dr.resetRVV();
            dr.setRVVTrusted(false);
            dr.writeRVV(null, null);
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        if (this.initFile != null && dr.isBackup()) {
            this.initFile.endDestroyDataStorage(dr);
        }
    }

    public PersistentMemberID generatePersistentID(DiskRegionView dr) {
        File firstDir = this.getInfoFileDir().getDir();
        InternalDistributedSystem ids = this.getCache().getDistributedSystem();
        InternalDistributedMember memberId = ids.getDistributionManager().getDistributionManagerId();
        long timestamp = System.currentTimeMillis();
        PersistentMemberID id = new PersistentMemberID(this.getDiskStoreID(), memberId.getInetAddress(), firstDir.getAbsolutePath(), memberId.getName(), timestamp, 0);
        return id;
    }

    public PersistentID getPersistentID() {
        InetAddress host = this.cache.getDistributedSystem().getDistributedMember().getInetAddress();
        String dir = this.getDiskDirs()[0].getAbsolutePath();
        return new PersistentMemberPattern(host, dir, this.diskStoreID.toUUID(), 0L);
    }

    public void forceIFCompaction() {
        if (this.initFile != null) {
            this.initFile.forceCompaction();
        }
    }

    public CancelCriterion getCancelCriterion() {
        return this.stopper;
    }

    void recoverRegionId(long drId) {
        long newVal = drId + 1L;
        if (this.regionIdCtr.get() < newVal) {
            this.regionIdCtr.set(newVal);
        }
    }

    long generateRegionId() {
        long result;
        while ((result = this.regionIdCtr.getAndIncrement()) <= 8L && result >= 1L) {
        }
        return result;
    }

    Collection<DiskRegion> getDiskRegions() {
        return Collections.unmodifiableCollection(this.drMap.values());
    }

    DiskRegion getByName(String name) {
        for (DiskRegion dr : this.getDiskRegions()) {
            if (!dr.getName().equals(name)) continue;
            return dr;
        }
        return null;
    }

    void addDiskRegion(DiskRegion dr) {
        if (dr.isBackup()) {
            DiskRegion old;
            PersistentOplogSet oplogSet = this.getPersistentOplogSet(dr);
            if (!this.isOffline()) {
                oplogSet.initChild();
            }
            if ((old = this.drMap.putIfAbsent(dr.getId(), dr)) != null) {
                throw new IllegalStateException("DiskRegion already exists with id " + dr.getId() + " and name " + old.getName());
            }
            this.getDiskInitFile().createRegion(dr);
        } else {
            this.overflowMap.add(dr);
        }
        if (this.getOwnedByRegion()) {
            this.ownCount.incrementAndGet();
        }
    }

    void addPersistentPR(String name, PRPersistentConfig config) {
        this.getDiskInitFile().createPersistentPR(name, config);
    }

    void removePersistentPR(String name) {
        if (this.isClosed() && this.getOwnedByRegion()) {
            return;
        }
        this.getDiskInitFile().destroyPersistentPR(name);
    }

    PRPersistentConfig getPersistentPRConfig(String name) {
        return this.getDiskInitFile().getPersistentPR(name);
    }

    Map<String, PRPersistentConfig> getAllPRs() {
        return this.getDiskInitFile().getAllPRs();
    }

    DiskRegion getById(long regionId) {
        return (DiskRegion)this.drMap.get(regionId);
    }

    void rmById(long regionId) {
        this.drMap.remove(regionId);
    }

    void handleDiskAccessException(final DiskAccessException dae) {
        boolean causedByRDE = LocalRegion.causedByRDE(dae);
        if (causedByRDE) {
            return;
        }
        if (!this.diskException.compareAndSet(null, dae)) {
            return;
        }
        final StringId sid = LocalizedStrings.LocalRegion_A_DISKACCESSEXCEPTION_HAS_OCCURED_WHILE_WRITING_TO_THE_DISK_FOR_DISKSTORE_0_THE_CACHE_WILL_BE_CLOSED;
        logger.error((Message)LocalizedMessage.create(sid, this.getName()), (Throwable)dae);
        LoggingThreadGroup exceptionHandlingGroup = LoggingThreadGroup.createThreadGroup("Disk Store Exception Handling Group", logger);
        Thread thread = new Thread(exceptionHandlingGroup, "Disk store exception handler"){

            @Override
            public void run() {
                try {
                    DiskStoreImpl.this.getCache().close(sid.toLocalizedString(DiskStoreImpl.this.getName(), dae), dae);
                    DiskStoreImpl.this._testHandleDiskAccessException.countDown();
                }
                catch (Exception e) {
                    logger.error((Message)LocalizedMessage.create(LocalizedStrings.LocalRegion_AN_EXCEPTION_OCCURED_WHILE_CLOSING_THE_CACHE), (Throwable)e);
                }
            }
        };
        thread.start();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean getAutoCompact() {
        return this.autoCompact;
    }

    @Override
    public boolean getAllowForceCompaction() {
        return this.allowForceCompaction;
    }

    @Override
    public long getMaxOplogSize() {
        return this.maxOplogSizeInBytes / 0x100000L;
    }

    public long getMaxOplogSizeInBytes() {
        return this.maxOplogSizeInBytes;
    }

    @Override
    public long getTimeInterval() {
        return this.timeInterval;
    }

    @Override
    public int getQueueSize() {
        return this.queueSize;
    }

    @Override
    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    @Override
    public File[] getDiskDirs() {
        return this.diskDirs;
    }

    @Override
    public int[] getDiskDirSizes() {
        return this.diskDirSizes;
    }

    @Override
    public float getDiskUsageWarningPercentage() {
        return this.warningPercent;
    }

    @Override
    public float getDiskUsageCriticalPercentage() {
        return this.criticalPercent;
    }

    @Override
    public void setDiskUsageWarningPercentage(float warningPercent) {
        DiskStoreMonitor.checkWarning(warningPercent);
        this.warningPercent = warningPercent;
    }

    @Override
    public void setDiskUsageCriticalPercentage(float criticalPercent) {
        DiskStoreMonitor.checkCritical(criticalPercent);
        this.criticalPercent = criticalPercent;
    }

    public boolean getOwnedByRegion() {
        return this.ownedByRegion;
    }

    public InternalRegionArguments getInternalRegionArguments() {
        return this.internalRegionArgs;
    }

    public int getOwnCount() {
        return this.ownCount.get();
    }

    boolean isValidating() {
        return this.validating;
    }

    boolean isOffline() {
        return this.offline;
    }

    boolean isUpgradeVersionOnly() {
        return this.upgradeVersionOnly && Version.GFE_70.compareTo(this.getRecoveredGFVersion()) > 0;
    }

    boolean isOfflineCompacting() {
        return this.offlineCompacting;
    }

    boolean isOfflineModify() {
        return this.offlineModify;
    }

    public void destroyRegion(String regName) {
        DiskRegionView drv = this.getDiskInitFile().getDiskRegionByName(regName);
        if (drv == null) {
            drv = this.getDiskInitFile().getDiskRegionByPrName(regName);
            PRPersistentConfig prConfig = this.getDiskInitFile().getPersistentPR(regName);
            if (drv == null && prConfig == null) {
                throw new IllegalArgumentException("The disk store does not contain a region named: " + regName);
            }
            this.getDiskInitFile().destroyPRRegion(regName);
        } else {
            this.getDiskInitFile().endDestroyRegion(drv);
        }
    }

    public String modifyRegion(String regName, String lruOption, String lruActionOption, String lruLimitOption, String concurrencyLevelOption, String initialCapacityOption, String loadFactorOption, String compressorClassNameOption, String statisticsEnabledOption, String offHeapOption, boolean printToConsole) {
        assert (this.isOffline());
        DiskRegionView drv = this.getDiskInitFile().getDiskRegionByName(regName);
        if (drv == null) {
            drv = this.getDiskInitFile().getDiskRegionByPrName(regName);
            if (drv == null) {
                throw new IllegalArgumentException("The disk store does not contain a region named: " + regName);
            }
            return this.getDiskInitFile().modifyPRRegion(regName, lruOption, lruActionOption, lruLimitOption, concurrencyLevelOption, initialCapacityOption, loadFactorOption, compressorClassNameOption, statisticsEnabledOption, offHeapOption, printToConsole);
        }
        return this.getDiskInitFile().modifyRegion(drv, lruOption, lruActionOption, lruLimitOption, concurrencyLevelOption, initialCapacityOption, loadFactorOption, compressorClassNameOption, statisticsEnabledOption, offHeapOption, printToConsole);
    }

    private void dumpInfo(PrintStream printStream, String regName) {
        assert (this.isOffline());
        this.getDiskInitFile().dumpRegionInfo(printStream, regName);
    }

    private void dumpPdxTypes(PrintStream printStream) {
        try {
            ArrayList<PdxType> types = new ArrayList<PdxType>();
            ArrayList<EnumInfo> enums = new ArrayList<EnumInfo>();
            for (Object i : this.getPdxTypesAndEnums()) {
                if (i instanceof PdxType) {
                    types.add((PdxType)i);
                    continue;
                }
                enums.add((EnumInfo)i);
            }
            Collections.sort(types, new Comparator<PdxType>(){

                @Override
                public int compare(PdxType o1, PdxType o2) {
                    return o1.getClassName().compareTo(o2.getClassName());
                }
            });
            Collections.sort(enums, new Comparator<EnumInfo>(){

                @Override
                public int compare(EnumInfo o1, EnumInfo o2) {
                    return o1.compareTo(o2);
                }
            });
            printStream.println("PDX Types:");
            for (PdxType type : types) {
                type.toStream(printStream, true);
            }
            printStream.println("PDX Enums:");
            for (EnumInfo e : enums) {
                e.toStream(printStream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void dumpMetadata(boolean showBuckets) {
        assert (this.isOffline());
        this.getDiskInitFile().dumpRegionMetadata(showBuckets);
    }

    private Collection<Object> pdxRename(String oldBase, String newBase) throws IOException {
        DiskRegionView foundPdx = null;
        for (DiskRegionView drv : this.getKnown()) {
            if (!drv.getName().equals("/PdxTypes")) continue;
            foundPdx = drv;
            this.scheduleForRecovery((PlaceHolderDiskRegion)drv);
        }
        if (foundPdx == null) {
            throw new IllegalStateException("The disk store does not contain any PDX types.");
        }
        this.recoverRegionsThatAreReady();
        PersistentOplogSet oplogSet = (PersistentOplogSet)this.getOplogSet(foundPdx);
        ArrayList<Object> result = new ArrayList<Object>();
        Pattern pattern = DiskStoreImpl.createPdxRenamePattern(oldBase);
        for (RegionEntry re : foundPdx.getRecoveredEntryMap().regionEntries()) {
            String newName;
            Object value = re._getValueRetain(foundPdx, true);
            if (Token.isRemoved(value)) continue;
            if (value instanceof CachedDeserializable) {
                value = ((CachedDeserializable)value).getDeserializedForReading();
            }
            if (value instanceof EnumInfo) {
                EnumInfo ei = (EnumInfo)value;
                newName = DiskStoreImpl.replacePdxRenamePattern(pattern, ei.getClassName(), newBase);
                if (newName == null) continue;
                ei.setClassName(newName);
                result.add(ei);
                oplogSet.offlineModify(foundPdx, (DiskEntry)re, BlobHelper.serializeToBlob(ei), true);
                continue;
            }
            PdxType type = (PdxType)value;
            newName = DiskStoreImpl.replacePdxRenamePattern(pattern, type.getClassName(), newBase);
            if (newName == null) continue;
            type.setClassName(newName);
            result.add(type);
            oplogSet.offlineModify(foundPdx, (DiskEntry)re, BlobHelper.serializeToBlob(type), true);
        }
        return result;
    }

    public static Pattern createPdxRenamePattern(String patBase) {
        return Pattern.compile(".*(?:^|\\.|\\$)(\\Q" + patBase + "\\E)(?:\\.|\\$|$).*");
    }

    public static String replacePdxRenamePattern(Pattern pattern, String existing, String replacement) {
        Matcher matcher = pattern.matcher(existing);
        if (matcher.matches()) {
            int start = matcher.start(1);
            int end = matcher.end(1);
            StringBuilder sb = new StringBuilder();
            if (start > 0) {
                sb.append(existing.substring(0, start));
            }
            sb.append(replacement);
            if (end < existing.length()) {
                sb.append(existing.substring(end));
            }
            return sb.toString();
        }
        return null;
    }

    private Collection<PdxType> pdxDeleteField(String className, String fieldName) throws IOException {
        DiskRegionView foundPdx = null;
        for (DiskRegionView drv : this.getKnown()) {
            if (!drv.getName().equals("/PdxTypes")) continue;
            foundPdx = drv;
            this.scheduleForRecovery((PlaceHolderDiskRegion)drv);
        }
        if (foundPdx == null) {
            throw new IllegalStateException("The disk store does not contain any PDX types.");
        }
        this.recoverRegionsThatAreReady();
        PersistentOplogSet oplogSet = (PersistentOplogSet)this.getOplogSet(foundPdx);
        ArrayList<PdxType> result = new ArrayList<PdxType>();
        for (RegionEntry re : foundPdx.getRecoveredEntryMap().regionEntries()) {
            PdxField field;
            PdxType type;
            Object value = re._getValueRetain(foundPdx, true);
            if (Token.isRemoved(value)) continue;
            if (value instanceof CachedDeserializable) {
                value = ((CachedDeserializable)value).getDeserializedForReading();
            }
            if (value instanceof EnumInfo || !(type = (PdxType)value).getClassName().equals(className) || (field = type.getPdxField(fieldName)) == null) continue;
            field.setDeleted(true);
            type.setHasDeletedField(true);
            result.add(type);
            oplogSet.offlineModify(foundPdx, (DiskEntry)re, BlobHelper.serializeToBlob(type), true);
        }
        return result;
    }

    private Collection<PdxType> getPdxTypes() throws IOException {
        DiskRegionView foundPdx = null;
        for (DiskRegionView drv : this.getKnown()) {
            if (!drv.getName().equals("/PdxTypes")) continue;
            foundPdx = drv;
            this.scheduleForRecovery((PlaceHolderDiskRegion)drv);
        }
        if (foundPdx == null) {
            return Collections.emptyList();
        }
        this.recoverRegionsThatAreReady();
        ArrayList<PdxType> result = new ArrayList<PdxType>();
        for (RegionEntry re : foundPdx.getRecoveredEntryMap().regionEntries()) {
            Object value = re._getValueRetain(foundPdx, true);
            if (Token.isRemoved(value)) continue;
            if (value instanceof CachedDeserializable) {
                value = ((CachedDeserializable)value).getDeserializedForReading();
            }
            if (!(value instanceof PdxType)) continue;
            PdxType type = (PdxType)value;
            result.add(type);
        }
        Collections.sort(result, new Comparator<PdxType>(){

            @Override
            public int compare(PdxType o1, PdxType o2) {
                return o1.getClassName().compareTo(o2.getClassName());
            }
        });
        return result;
    }

    private Collection<Object> getPdxTypesAndEnums() throws IOException {
        DiskRegionView foundPdx = null;
        for (DiskRegionView drv : this.getKnown()) {
            if (!drv.getName().equals("/PdxTypes")) continue;
            foundPdx = drv;
            this.scheduleForRecovery((PlaceHolderDiskRegion)drv);
        }
        if (foundPdx == null) {
            return Collections.emptyList();
        }
        this.recoverRegionsThatAreReady();
        ArrayList<Object> result = new ArrayList<Object>();
        for (RegionEntry re : foundPdx.getRecoveredEntryMap().regionEntries()) {
            Object value = re._getValueRetain(foundPdx, true);
            if (Token.isRemoved(value)) continue;
            if (value instanceof CachedDeserializable) {
                value = ((CachedDeserializable)value).getDeserializedForReading();
            }
            result.add(value);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportSnapshot(String name, File out) throws IOException {
        HashMap<String, GFSnapshot.SnapshotWriter> regions = new HashMap<String, GFSnapshot.SnapshotWriter>();
        try {
            for (DiskRegionView drv : this.getKnown()) {
                PlaceHolderDiskRegion ph = (PlaceHolderDiskRegion)drv;
                String regionName = drv.isBucket() ? ph.getPrName() : drv.getName();
                GFSnapshot.SnapshotWriter writer = (GFSnapshot.SnapshotWriter)regions.get(regionName);
                if (writer == null) {
                    String fname = regionName.substring(1).replace('/', '-');
                    File f = new File(out, "snapshot-" + name + "-" + fname + ".gfd");
                    writer = GFSnapshot.create(f, regionName);
                    regions.put(regionName, writer);
                }
                regions.put(drv.getName(), writer);
            }
            for (DiskRegionView drv : this.getKnown()) {
                final GFSnapshot.SnapshotWriter writer = (GFSnapshot.SnapshotWriter)regions.get(drv.getName());
                this.scheduleForRecovery(new ExportDiskRegion(this, drv, new ExportDiskRegion.ExportWriter(){

                    @Override
                    public void writeBatch(Map<Object, DiskEntry.RecoveredEntry> entries) throws IOException {
                        for (Map.Entry<Object, DiskEntry.RecoveredEntry> re : entries.entrySet()) {
                            Object key = re.getKey();
                            Object value = re.getValue().getValue();
                            writer.snapshotEntry(new SnapshotPacket.SnapshotRecord(key, value));
                        }
                    }
                }));
            }
            this.recoverRegionsThatAreReady();
        }
        finally {
            HashSet uniqueWriters = new HashSet(regions.values());
            for (final GFSnapshot.SnapshotWriter writer : uniqueWriters) {
                writer.snapshotComplete();
            }
        }
    }

    private void validate() {
        assert (this.isValidating());
        this.RECOVER_VALUES = false;
        this.liveEntryCount = 0;
        this.deadRecordCount = 0;
        for (DiskRegionView drv : this.getKnown()) {
            this.scheduleForRecovery(ValidatingDiskRegion.create(this, drv));
        }
        this.recoverRegionsThatAreReady();
        if (this.getDeadRecordCount() > 0) {
            System.out.println("Disk store contains " + this.getDeadRecordCount() + " compactable records.");
        }
        System.out.println("Total number of region entries in this disk store is: " + this.getLiveEntryCount());
    }

    void incLiveEntryCount(int count) {
        this.liveEntryCount += count;
    }

    public int getLiveEntryCount() {
        return this.liveEntryCount;
    }

    void incDeadRecordCount(int count) {
        this.deadRecordCount += count;
    }

    public int getDeadRecordCount() {
        return this.deadRecordCount;
    }

    private void offlineCompact() {
        assert (this.isOfflineCompacting());
        this.RECOVER_VALUES = false;
        this.deadRecordCount = 0;
        for (DiskRegionView drv : this.getKnown()) {
            this.scheduleForRecovery(OfflineCompactionDiskRegion.create(this, drv));
        }
        this.persistentOplogs.recoverRegionsThatAreReady();
        this.persistentOplogs.offlineCompact();
        this.getDiskInitFile().forceCompaction();
        if (this.upgradeVersionOnly) {
            System.out.println("Upgrade disk store " + this.name + " to version " + this.getRecoveredGFVersionName() + " finished.");
        } else if (this.getDeadRecordCount() == 0) {
            System.out.println("Offline compaction did not find anything to compact.");
        } else {
            System.out.println("Offline compaction removed " + this.getDeadRecordCount() + " records.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LRUStatistics getOrCreatePRLRUStats(PlaceHolderDiskRegion dr) {
        String prName = dr.getPrName();
        LRUStatistics result = null;
        HashMap<String, LRUStatistics> hashMap = this.prlruStatMap;
        synchronized (hashMap) {
            result = this.prlruStatMap.get(prName);
            if (result == null) {
                EvictionAttributes ea = dr.getEvictionAttributes();
                LRUAlgorithm ec = ((EvictionAttributesImpl)ea).createEvictionController(null, dr.getOffHeap());
                InternalDistributedSystem sf = this.cache.getDistributedSystem();
                result = ec.getLRUHelper().initStats(dr, sf);
                this.prlruStatMap.put(prName, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LRUStatistics getPRLRUStats(PartitionedRegion pr) {
        String prName = pr.getFullPath();
        LRUStatistics result = null;
        HashMap<String, LRUStatistics> hashMap = this.prlruStatMap;
        synchronized (hashMap) {
            result = this.prlruStatMap.get(prName);
        }
        return result;
    }

    public void lockStoreBeforeBackup() {
        this.getDiskInitFile().lockForBackup();
    }

    public void releaseBackupLock() {
        this.getDiskInitFile().unlockForBackup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startBackup(File targetDir, BackupInspector baselineInspector, RestoreScript restoreScript) throws IOException {
        this.getDiskInitFile().setBackupThread(Thread.currentThread());
        boolean done = false;
        try {
            block14: {
                while (true) {
                    Object childLock;
                    Oplog childOplog;
                    if ((childOplog = this.persistentOplogs.getChild()) == null) {
                        this.diskStoreBackup = new DiskStoreBackup(new Oplog[0], targetDir);
                        break block14;
                    }
                    Object object = childLock = childOplog == null ? new Object() : childOplog.lock;
                    synchronized (object) {
                        if (this.persistentOplogs.getChild() == childOplog) break;
                    }
                }
                {
                    if (logger.isDebugEnabled()) {
                        logger.debug("snapshotting oplogs for disk store {}", new Object[]{this.getName()});
                    }
                    for (int i = 0; i < this.directories.length; ++i) {
                        File dir = this.getBackupDir(targetDir, i);
                        if (!FileUtil.mkdirs(dir)) {
                            throw new IOException("Could not create directory " + dir);
                        }
                        restoreScript.addFile(this.directories[i].getDir(), dir);
                    }
                    restoreScript.addExistenceTest(this.initFile.getIFFile());
                    Oplog[] allOplogs = null;
                    if (null != baselineInspector) {
                        HashMap<File, File> baselineCopyMap = new HashMap<File, File>();
                        allOplogs = this.filterBaselineOplogs(baselineInspector, baselineCopyMap);
                        restoreScript.addBaselineFiles(baselineCopyMap);
                    } else {
                        allOplogs = this.getAllOplogsForBackup();
                    }
                    this.diskStoreBackup = new DiskStoreBackup(allOplogs, targetDir);
                    File firstDir = this.getBackupDir(targetDir, this.infoFileDirIndex);
                    this.initFile.copyTo(firstDir);
                    this.persistentOplogs.forceRoll(null);
                    if (logger.isDebugEnabled()) {
                        logger.debug("done snaphotting for disk store {}", new Object[]{this.getName()});
                    }
                }
            }
            done = true;
            return;
        }
        finally {
            if (!done) {
                this.clearBackup();
            }
        }
    }

    private File getBackupDir(File targetDir, int index) {
        return new File(targetDir, BACKUP_DIR_PREFIX + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishBackup(BackupManager backupManager) throws IOException {
        if (this.diskStoreBackup == null) {
            return;
        }
        try {
            this.waitForDelayedWrites();
            for (Oplog oplog : this.diskStoreBackup.getPendingBackup()) {
                if (backupManager.isCancelled()) {
                    break;
                }
                int index = oplog.getDirectoryHolder().getArrayIndex();
                File backupDir = this.getBackupDir(this.diskStoreBackup.getTargetDir(), index);
                oplog.copyTo(backupDir);
                this.diskStoreBackup.backupFinished(oplog);
            }
        }
        finally {
            this.clearBackup();
        }
    }

    private int getArrayIndexOfDirectory(File searchDir) {
        for (DirectoryHolder holder : this.directories) {
            if (!holder.getDir().equals(searchDir)) continue;
            return holder.getArrayIndex();
        }
        return 0;
    }

    public DirectoryHolder[] getDirectoryHolders() {
        return this.directories;
    }

    private void clearBackup() {
        DiskStoreBackup backup = this.diskStoreBackup;
        if (backup != null) {
            this.diskStoreBackup = null;
            backup.cleanup();
        }
    }

    public DiskStoreBackup getInProgressBackup() {
        return this.diskStoreBackup;
    }

    public Collection<DiskRegionView> getKnown() {
        return this.initFile.getKnown();
    }

    private static DiskStoreImpl createForOffline(String dsName, File[] dsDirs) throws Exception {
        return DiskStoreImpl.createForOffline(dsName, dsDirs, false, false, false, 0L, true, false);
    }

    private static DiskStoreImpl createForOfflineModify(String dsName, File[] dsDirs) throws Exception {
        return DiskStoreImpl.createForOffline(dsName, dsDirs, false, false, false, 0L, true, true);
    }

    private static DiskStoreImpl createForOffline(String dsName, File[] dsDirs, boolean needsOplogs) throws Exception {
        return DiskStoreImpl.createForOffline(dsName, dsDirs, false, false, false, 0L, needsOplogs, false);
    }

    private static DiskStoreImpl createForOfflineValidate(String dsName, File[] dsDirs) throws Exception {
        return DiskStoreImpl.createForOffline(dsName, dsDirs, false, true, false, 0L, true, false);
    }

    private static void cleanupOffline() {
        if (offlineCache != null) {
            offlineCache.close();
            offlineCache = null;
        }
        if (offlineDS != null) {
            offlineDS.disconnect();
            offlineDS = null;
        }
    }

    private static DiskStoreImpl createForOffline(String dsName, File[] dsDirs, boolean offlineCompacting, boolean offlineValidate, boolean upgradeVersionOnly, long maxOplogSize, boolean needsOplogs, boolean offlineModify) throws Exception {
        Cache c;
        DistributedSystem ds;
        if (dsDirs == null) {
            dsDirs = new File[]{new File("")};
        }
        Properties props = new Properties();
        props.setProperty("locators", "");
        props.setProperty("mcast-port", "0");
        props.setProperty("cache-xml-file", "");
        offlineDS = ds = DistributedSystem.connect(props);
        offlineCache = c = CacheFactory.create(ds);
        DiskStoreFactory dsf = c.createDiskStoreFactory();
        dsf.setDiskDirs(dsDirs);
        if (offlineCompacting && maxOplogSize != -1L) {
            dsf.setMaxOplogSize(maxOplogSize);
        }
        DiskStoreImpl dsi = new DiskStoreImpl(c, dsName, ((DiskStoreFactoryImpl)dsf).getDiskStoreAttributes(), false, null, true, upgradeVersionOnly, offlineValidate, offlineCompacting, needsOplogs, offlineModify);
        ((GemFireCacheImpl)c).addDiskStore(dsi);
        return dsi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyRegion(String dsName, File[] dsDirs, String regName) throws Exception {
        try {
            DiskStoreImpl dsi = DiskStoreImpl.createForOffline(dsName, dsDirs);
            dsi.destroyRegion(regName);
        }
        finally {
            DiskStoreImpl.cleanupOffline();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String modifyRegion(String dsName, File[] dsDirs, String regName, String lruOption, String lruActionOption, String lruLimitOption, String concurrencyLevelOption, String initialCapacityOption, String loadFactorOption, String compressorClassNameOption, String statisticsEnabledOption, String offHeapOption, boolean printToConsole) throws Exception {
        try {
            DiskStoreImpl dsi = DiskStoreImpl.createForOffline(dsName, dsDirs);
            String string = dsi.modifyRegion(regName, lruOption, lruActionOption, lruLimitOption, concurrencyLevelOption, initialCapacityOption, loadFactorOption, compressorClassNameOption, statisticsEnabledOption, offHeapOption, printToConsole);
            return string;
        }
        finally {
            DiskStoreImpl.cleanupOffline();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpInfo(PrintStream printStream, String dsName, File[] dsDirs, String regName, Boolean listPdxTypes) throws Exception {
        try {
            DiskStoreImpl dsi = DiskStoreImpl.createForOffline(dsName, dsDirs, false);
            dsi.dumpInfo(printStream, regName);
            if (listPdxTypes != null && listPdxTypes.booleanValue()) {
                dsi.dumpPdxTypes(printStream);
            }
        }
        finally {
            DiskStoreImpl.cleanupOffline();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpMetadata(String dsName, File[] dsDirs, boolean showBuckets) throws Exception {
        try {
            DiskStoreImpl dsi = DiskStoreImpl.createForOffline(dsName, dsDirs, false);
            dsi.dumpMetadata(showBuckets);
        }
        finally {
            DiskStoreImpl.cleanupOffline();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportOfflineSnapshot(String dsName, File[] dsDirs, File out) throws Exception {
        try {
            DiskStoreImpl dsi = DiskStoreImpl.createForOffline(dsName, dsDirs);
            dsi.exportSnapshot(dsName, out);
        }
        finally {
            DiskStoreImpl.cleanupOffline();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<PdxType> getPdxTypes(String dsName, File[] dsDirs) throws Exception {
        try {
            DiskStoreImpl dsi = DiskStoreImpl.createForOffline(dsName, dsDirs);
            Collection<PdxType> collection = dsi.getPdxTypes();
            return collection;
        }
        finally {
            DiskStoreImpl.cleanupOffline();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Object> pdxRename(String dsName, File[] dsDirs, String oldRegEx, String newName) throws Exception {
        try {
            DiskStoreImpl dsi = DiskStoreImpl.createForOfflineModify(dsName, dsDirs);
            Collection<Object> collection = dsi.pdxRename(oldRegEx, newName);
            return collection;
        }
        finally {
            DiskStoreImpl.cleanupOffline();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<PdxType> pdxDeleteField(String dsName, File[] dsDirs, String className, String fieldName) throws Exception {
        try {
            DiskStoreImpl dsi = DiskStoreImpl.createForOfflineModify(dsName, dsDirs);
            Collection<PdxType> collection = dsi.pdxDeleteField(className, fieldName);
            return collection;
        }
        finally {
            DiskStoreImpl.cleanupOffline();
        }
    }

    public static void validate(String name, File[] dirs) throws Exception {
        try {
            DiskStoreImpl dsi = DiskStoreImpl.createForOfflineValidate(name, dirs);
            dsi.validate();
        }
        finally {
            DiskStoreImpl.cleanupOffline();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DiskStoreImpl offlineCompact(String name, File[] dirs, boolean upgradeVersionOnly, long maxOplogSize) throws Exception {
        try {
            DiskStoreImpl dsi = DiskStoreImpl.createForOffline(name, dirs, true, false, upgradeVersionOnly, maxOplogSize, true, false);
            dsi.offlineCompact();
            dsi.close();
            DiskStoreImpl diskStoreImpl = dsi;
            return diskStoreImpl;
        }
        finally {
            DiskStoreImpl.cleanupOffline();
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Usage: diskStoreName [dirs]");
        } else {
            String dsName = args[0];
            File[] dirs = null;
            if (args.length > 1) {
                dirs = new File[args.length - 1];
                for (int i = 1; i < args.length; ++i) {
                    dirs[i - 1] = new File(args[i]);
                }
            }
            DiskStoreImpl.offlineCompact(dsName, dirs, false, 1024L);
        }
    }

    public boolean hasPersistedData() {
        return this.persistentOplogs.getChild() != null;
    }

    @Override
    public UUID getDiskStoreUUID() {
        return this.diskStoreID.toUUID();
    }

    public DiskStoreID getDiskStoreID() {
        return this.diskStoreID;
    }

    void setDiskStoreID(DiskStoreID diskStoreID) {
        this.diskStoreID = diskStoreID;
    }

    File getInitFile() {
        return this.getDiskInitFile().getIFFile();
    }

    public boolean needsLinkedList() {
        return this.isCompactionPossible() || this.couldHaveKrf();
    }

    boolean couldHaveKrf() {
        return !this.isOffline();
    }

    public String toString() {
        return "DiskStore[" + this.name + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAsyncRecovery(DiskRegion diskRegion) {
        Map<Long, DiskRecoveryStore> map = this.currentAsyncValueRecoveryMap;
        synchronized (map) {
            boolean interrupted = false;
            while (!this.isClosing() && this.currentAsyncValueRecoveryMap.containsKey(diskRegion.getId())) {
                try {
                    this.currentAsyncValueRecoveryMap.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static boolean isBackgroundTaskThread() {
        boolean result = false;
        Boolean tmp = backgroundTaskThread.get();
        if (tmp != null) {
            result = tmp;
        }
        return result;
    }

    private static void markBackgroundTaskThread() {
        backgroundTaskThread.set(Boolean.TRUE);
    }

    public boolean executeDiskStoreTask(Runnable runnable) {
        return this.executeDiskStoreTask(runnable, this.diskStoreTaskPool) != null;
    }

    public boolean executeDelayedExpensiveWrite(Runnable task) {
        Future<?> f;
        this.lastDelayedWrite = f = this.executeDiskStoreTask(task, this.delayedWritePool);
        return f != null;
    }

    protected void waitForDelayedWrites() {
        Future lastWriteTask = this.lastDelayedWrite;
        if (lastWriteTask != null) {
            try {
                lastWriteTask.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Future<?> executeDiskStoreTask(final Runnable runnable, ThreadPoolExecutor executor) {
        this.incBackgroundTasks();
        Future<?> result = this.executeDiskStoreTask(new DiskStoreTask(){

            @Override
            public void run() {
                try {
                    DiskStoreImpl.markBackgroundTaskThread();
                    runnable.run();
                }
                finally {
                    DiskStoreImpl.this.decBackgroundTasks();
                }
            }

            @Override
            public void taskCancelled() {
                DiskStoreImpl.this.decBackgroundTasks();
            }
        }, executor);
        if (result == null) {
            this.decBackgroundTasks();
        }
        return result;
    }

    private Future<?> executeDiskStoreTask(DiskStoreTask r, ThreadPoolExecutor executor) {
        try {
            return executor.submit(r);
        }
        catch (RejectedExecutionException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("Ignored compact schedule during shutdown", (Throwable)ex);
            }
            return null;
        }
    }

    private void stopDiskStoreTaskPool() {
        if (logger.isDebugEnabled()) {
            logger.debug("Stopping DiskStoreTaskPool");
        }
        this.shutdownPool(this.diskStoreTaskPool);
        this.delayedWritePool.shutdown();
        try {
            this.delayedWritePool.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void shutdownPool(ThreadPoolExecutor pool) {
        List<Runnable> l = pool.shutdownNow();
        for (Runnable runnable : l) {
            if (!(l instanceof DiskStoreTask)) continue;
            ((DiskStoreTask)((Object)l)).taskCancelled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRVVGC(DiskRegion dr, LocalRegion region) {
        this.acquireReadLock(dr);
        try {
            if (dr.isRegionClosed()) {
                region.getCancelCriterion().checkCancelInProgress(null);
                throw new RegionDestroyedException(LocalizedStrings.DiskRegion_THE_DISKREGION_HAS_BEEN_CLOSED_OR_DESTROYED.toLocalizedString(), dr.getName());
            }
            RegionVersionVector inMemoryRVV = region.getVersionVector();
            RegionVersionVector diskRVV = dr.getRegionVersionVector();
            this.updateDiskGCRVV(diskRVV, inMemoryRVV, (VersionSource)diskRVV.getOwnerId());
            for (VersionSource member : inMemoryRVV.getMemberToGCVersion().keySet()) {
                this.updateDiskGCRVV(diskRVV, inMemoryRVV, member);
            }
            diskRVV.pruneOldExceptions();
            PersistentOplogSet oplogSet = this.getPersistentOplogSet(dr);
            oplogSet.getChild().writeGCRVV(dr);
        }
        finally {
            this.releaseReadLock(dr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRVV(DiskRegion dr, LocalRegion region, Boolean isRVVTrusted) {
        this.acquireReadLock(dr);
        try {
            if (dr.isRegionClosed()) {
                dr.getCancelCriterion().checkCancelInProgress(null);
                throw new RegionDestroyedException(LocalizedStrings.DiskRegion_THE_DISKREGION_HAS_BEEN_CLOSED_OR_DESTROYED.toLocalizedString(), dr.getName());
            }
            RegionVersionVector inMemoryRVV = region == null ? null : region.getVersionVector();
            PersistentOplogSet oplogSet = this.getPersistentOplogSet(dr);
            oplogSet.getChild().writeRVV(dr, inMemoryRVV, isRVVTrusted);
        }
        finally {
            this.releaseReadLock(dr);
        }
    }

    private void updateDiskGCRVV(RegionVersionVector diskRVV, RegionVersionVector inMemoryRVV, VersionSource member) {
        long diskVersion = diskRVV.getVersionForMember(member);
        long memoryGCVersion = inMemoryRVV.getGCVersion(member);
        if (memoryGCVersion <= diskVersion) {
            diskRVV.recordGCVersion(member, memoryGCVersion);
        }
    }

    public void updateDiskRegion(AbstractDiskRegion dr) {
        PersistentOplogSet oplogSet = this.getPersistentOplogSet(dr);
        oplogSet.updateDiskRegion(dr);
    }

    public final Version getRecoveredGFVersion() {
        return this.getRecoveredGFVersion(this.initFile);
    }

    final Version getRecoveredGFVersion(DiskInitFile initFile) {
        return initFile.currentRecoveredGFVersion();
    }

    public boolean isDirectoryUsageNormal(DirectoryHolder dir) {
        return this.getCache().getDiskStoreMonitor().isNormal(this, dir);
    }

    static /* synthetic */ int access$1300(DiskStoreImpl x0) {
        return x0.fillDrainList();
    }

    static /* synthetic */ DiskStoreStats access$1400(DiskStoreImpl x0) {
        return x0.stats;
    }

    static /* synthetic */ ArrayList access$1500(DiskStoreImpl x0) {
        return x0.getDrainList();
    }

    static /* synthetic */ ForceableLinkedBlockingQueue access$1600(DiskStoreImpl x0) {
        return x0.asyncQueue;
    }

    static /* synthetic */ boolean access$1702(DiskStoreImpl x0, boolean x1) {
        x0.flusherThreadTerminated = x1;
        return x0.flusherThreadTerminated;
    }

    static /* synthetic */ boolean access$1102(DiskStoreImpl x0, boolean x1) {
        x0.stopFlusher = x1;
        return x0.stopFlusher;
    }

    static {
        offlineCache = null;
        offlineDS = null;
        backgroundTaskThread = new ThreadLocal();
    }

    private class ValueRecoveryTask
    implements Runnable {
        private final Set<Oplog> oplogSet;
        private final Map<Long, DiskRecoveryStore> recoveredStores;

        public ValueRecoveryTask(Set<Oplog> oplogSet, Map<Long, DiskRecoveryStore> recoveredStores) {
            this.oplogSet = oplogSet;
            this.recoveredStores = new HashMap<Long, DiskRecoveryStore>(recoveredStores);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = DiskStoreImpl.this.asyncValueRecoveryLock;
            synchronized (object) {
                DiskStoreObserver.startAsyncValueRecovery(DiskStoreImpl.this);
                try {
                    for (Oplog oplog : this.oplogSet) {
                        oplog.recoverValuesIfNeeded(DiskStoreImpl.this.currentAsyncValueRecoveryMap);
                    }
                }
                catch (CancelException cancelException) {
                }
                finally {
                    Map map = DiskStoreImpl.this.currentAsyncValueRecoveryMap;
                    synchronized (map) {
                        DiskStoreImpl.this.currentAsyncValueRecoveryMap.keySet().removeAll(this.recoveredStores.keySet());
                        DiskStoreImpl.this.currentAsyncValueRecoveryMap.notifyAll();
                    }
                    DiskStoreObserver.endAsyncValueRecovery(DiskStoreImpl.this);
                }
            }
        }
    }

    static class OplogEntryIdSet {
        private final IntOpenHashSet ints = new IntOpenHashSet(0);
        private final LongOpenHashSet longs = new LongOpenHashSet(0);

        OplogEntryIdSet() {
        }

        public void add(long id) {
            if (id == 0L) {
                throw new IllegalArgumentException();
            }
            if (id > 0L && id <= 0xFFFFFFFFL) {
                this.ints.add((int)id);
            } else {
                this.longs.add(id);
            }
        }

        public boolean contains(long id) {
            if (id >= 0L && id <= 0xFFFFFFFFL) {
                return this.ints.contains((int)id);
            }
            return this.longs.contains(id);
        }

        public int size() {
            return this.ints.size() + this.longs.size();
        }
    }

    public static class AsyncDiskEntry {
        public final LocalRegion region;
        public final DiskEntry de;
        public final boolean versionOnly;
        public final VersionTag tag;

        public AsyncDiskEntry(LocalRegion region, DiskEntry de, VersionTag tag) {
            this.region = region;
            this.de = de;
            this.tag = tag;
            this.versionOnly = false;
        }

        public AsyncDiskEntry(LocalRegion region, VersionTag tag) {
            this.region = region;
            this.de = null;
            this.tag = tag;
            this.versionOnly = true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("dr=").append(this.region.getDiskRegion().getId());
            sb.append(" versionOnly=" + this.versionOnly);
            if (this.versionOnly) {
                sb.append(" versionTag=" + this.tag);
            }
            if (this.de != null) {
                sb.append(" key=" + this.de.getKey());
            } else {
                sb.append(" <END CLEAR>");
            }
            return sb.toString();
        }
    }

    private class Stopper
    extends CancelCriterion {
        private Stopper() {
        }

        @Override
        public String cancelInProgress() {
            if (DiskStoreImpl.this.isClosed()) {
                return "The disk store is closed.";
            }
            return null;
        }

        @Override
        public RuntimeException generateCancelledException(Throwable e) {
            if (DiskStoreImpl.this.isClosed()) {
                return new CacheClosedException("The disk store is closed", e);
            }
            return null;
        }
    }

    public static class KillCompactorException
    extends RuntimeException {
    }

    class OplogCompactor
    implements Runnable {
        private volatile boolean compactorEnabled;
        private volatile boolean scheduled;
        private CompactableOplog[] scheduledOplogs;
        private volatile Thread me;
        private final boolean compactionCompletionRequired = Boolean.getBoolean("gemfire.disk.completeCompactionBeforeTermination");

        OplogCompactor() {
        }

        private void startCompactor() {
            this.compactorEnabled = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopCompactor() {
            OplogCompactor oplogCompactor = this;
            synchronized (oplogCompactor) {
                if (LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER) {
                    CacheObserverHolder.getInstance().beforeStoppingCompactor();
                }
                this.compactorEnabled = false;
                if (LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER) {
                    CacheObserverHolder.getInstance().afterSignallingCompactor();
                }
            }
            if (LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER) {
                CacheObserverHolder.getInstance().afterStoppingCompactor();
            }
        }

        private synchronized boolean scheduleIfNeeded(CompactableOplog[] opLogs) {
            if (!this.scheduled) {
                return this.schedule(opLogs);
            }
            return false;
        }

        private synchronized boolean schedule(CompactableOplog[] opLogs) {
            assert (!this.scheduled);
            if (!this.compactorEnabled) {
                return false;
            }
            if (opLogs != null) {
                for (int i = 0; i < opLogs.length; ++i) {
                    opLogs[i].prepareForCompact();
                }
                this.scheduled = true;
                this.scheduledOplogs = opLogs;
                boolean result = DiskStoreImpl.this.executeDiskStoreTask(this);
                if (!result) {
                    this.reschedule(false);
                    return false;
                }
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean compact() {
            CompactableOplog[] oplogs = this.scheduledOplogs;
            int totalCount = 0;
            long compactionStart = DiskStoreImpl.this.getStats().startCompaction();
            long start = System.nanoTime();
            try {
                for (int i = 0; i < oplogs.length && this.keepCompactorRunning(); ++i) {
                    totalCount += oplogs[i].compact(this);
                }
            }
            finally {
                DiskStoreImpl.this.getStats().endCompaction(compactionStart);
            }
            long endTime = System.nanoTime();
            logger.info((Message)LocalizedMessage.create(LocalizedStrings.DiskRegion_COMPACTION_SUMMARY, new Object[]{totalCount, (endTime - start) / 1000000L}));
            return true;
        }

        private boolean isClosing() {
            if (DiskStoreImpl.this.getCache().isClosed()) {
                return true;
            }
            CancelCriterion stopper = DiskStoreImpl.this.getCache().getCancelCriterion();
            return stopper.cancelInProgress() != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DiskStoreImpl.this.getCache().getCachePerfStats().decDiskTasksWaiting();
            if (!this.scheduled) {
                return;
            }
            boolean compactedSuccessfully = false;
            try {
                SystemFailure.checkFailure();
                if (this.isClosing()) {
                    return;
                }
                if (!this.compactorEnabled) {
                    return;
                }
                CompactableOplog[] oplogs = this.scheduledOplogs;
                this.me = Thread.currentThread();
                try {
                    String tName = "OplogCompactor " + DiskStoreImpl.this.getName() + " for oplog " + oplogs[0].toString();
                    Thread.currentThread().setName(tName);
                    StringBuffer buffer = new StringBuffer();
                    for (int j = 0; j < oplogs.length; ++j) {
                        buffer.append(oplogs[j].toString());
                        if (j + 1 >= oplogs.length) continue;
                        buffer.append(", ");
                    }
                    String ids = buffer.toString();
                    logger.info((Message)LocalizedMessage.create(LocalizedStrings.DiskRegion_COMPACTION_OPLOGIDS, new Object[]{DiskStoreImpl.this.getName(), ids}));
                    if (LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER) {
                        CacheObserverHolder.getInstance().beforeGoingToCompact();
                    }
                    if (compactedSuccessfully = this.compact()) {
                        if (LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER) {
                            CacheObserverHolder.getInstance().afterHavingCompacted();
                        }
                    } else {
                        logger.warn((Message)LocalizedMessage.create(LocalizedStrings.DiskRegion_COMPACTION_FAILURE, new Object[]{DiskStoreImpl.this.getName(), ids}));
                    }
                }
                catch (DiskAccessException dae) {
                    DiskStoreImpl.this.handleDiskAccessException(dae);
                    throw dae;
                }
                catch (KillCompactorException ex) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("compactor thread terminated by test");
                    }
                    throw ex;
                }
                finally {
                    if (compactedSuccessfully) {
                        this.me.setName("Idle OplogCompactor");
                    }
                    this.me = null;
                }
            }
            catch (CancelException cancelException) {
            }
            finally {
                this.reschedule(compactedSuccessfully);
            }
        }

        synchronized void waitForRunToComplete() {
            if (this.me == Thread.currentThread()) {
                return;
            }
            while (this.scheduled) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private synchronized void reschedule(boolean success) {
            this.scheduled = false;
            this.scheduledOplogs = null;
            this.notifyAll();
            if (!success) {
                return;
            }
            if (!this.compactorEnabled) {
                return;
            }
            if (this.isClosing()) {
                return;
            }
            SystemFailure.checkFailure();
            if (this.compactorEnabled && DiskStoreImpl.this.isCompactionEnabled()) {
                this.schedule(DiskStoreImpl.this.getOplogToBeCompacted());
            }
        }

        boolean keepCompactorRunning() {
            return this.compactorEnabled || this.compactionCompletionRequired;
        }
    }

    private class FlusherThread
    implements Runnable {
        private FlusherThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean waitUntilFlushIsReady() throws InterruptedException {
            if (DiskStoreImpl.this.maxAsyncItems > 0) {
                long time = DiskStoreImpl.this.getTimeInterval();
                Object object = DiskStoreImpl.this.asyncMonitor;
                synchronized (object) {
                    if (time > 0L) {
                        boolean done;
                        long nanosRemaining = TimeUnit.MILLISECONDS.toNanos(time);
                        long endTime = System.nanoTime() + nanosRemaining;
                        boolean bl = done = DiskStoreImpl.this.checkAndClearForceFlush() || DiskStoreImpl.this.checkAsyncItemLimit();
                        while (!done && nanosRemaining > 0L) {
                            TimeUnit.NANOSECONDS.timedWait(DiskStoreImpl.this.asyncMonitor, nanosRemaining);
                            done = DiskStoreImpl.this.checkAndClearForceFlush() || DiskStoreImpl.this.checkAsyncItemLimit();
                            if (done) continue;
                            nanosRemaining = endTime - System.nanoTime();
                        }
                    } else {
                        boolean done;
                        boolean bl = done = DiskStoreImpl.this.checkAndClearForceFlush() || DiskStoreImpl.this.checkAsyncItemLimit();
                        while (!done) {
                            DiskStoreImpl.this.asyncMonitor.wait();
                            done = DiskStoreImpl.this.checkAndClearForceFlush() || DiskStoreImpl.this.checkAsyncItemLimit();
                        }
                    }
                }
            }
            long time = DiskStoreImpl.this.getTimeInterval();
            if (time > 0L) {
                long nanosRemaining = TimeUnit.MILLISECONDS.toNanos(time);
                long endTime = System.nanoTime() + nanosRemaining;
                Object object = DiskStoreImpl.this.asyncMonitor;
                synchronized (object) {
                    boolean done = DiskStoreImpl.this.checkAndClearForceFlush();
                    while (!done && nanosRemaining > 0L) {
                        TimeUnit.NANOSECONDS.timedWait(DiskStoreImpl.this.asyncMonitor, nanosRemaining);
                        done = DiskStoreImpl.this.checkAndClearForceFlush();
                        if (done) continue;
                        nanosRemaining = endTime - System.nanoTime();
                    }
                }
            }
            Object object = DiskStoreImpl.this.asyncMonitor;
            synchronized (object) {
                boolean done = DiskStoreImpl.this.checkAndClearForceFlush();
                while (!done) {
                    DiskStoreImpl.this.asyncMonitor.wait();
                    done = DiskStoreImpl.this.checkAndClearForceFlush();
                }
            }
            return !DiskStoreImpl.this.stopFlusher;
        }

        private void flushChild() {
            DiskStoreImpl.this.persistentOplogs.flushChild();
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private class FlushNotifier {
        private boolean flushed;

        private FlushNotifier() {
        }

        protected boolean isStoppingFlusher() {
            return false;
        }

        public synchronized void waitForFlush() throws InterruptedException {
            while (!(this.flushed || DiskStoreImpl.this.isFlusherTerminated() || this.isStoppingFlusher())) {
                this.wait(333L);
            }
        }

        public synchronized void doFlush() {
            this.flushed = true;
            this.notifyAll();
        }
    }

    private class FlushPauser
    extends FlushNotifier {
        private FlushPauser() {
        }

        @Override
        public synchronized void doFlush() {
            try {
                super.waitForFlush();
            }
            catch (InterruptedException ignore) {
                Thread.currentThread().interrupt();
            }
        }

        public synchronized void unpause() {
            super.doFlush();
        }

        @Override
        protected boolean isStoppingFlusher() {
            return DiskStoreImpl.this.stoppingFlusher;
        }
    }
}

