/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsFactory;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.StatisticsTypeFactory;
import com.gemstone.gemfire.internal.StatisticsTypeFactoryImpl;

public class DiskDirectoryStats {
    private static final StatisticsType type;
    private static final int diskSpaceId;
    private static final int maxSpaceId;
    private static final int volumeSizeId;
    private static final int volumeFreeSpaceId;
    private static final int volumeFreeSpaceChecksId;
    private static final int volumeFreeSpaceTimeId;
    private final Statistics stats;

    public DiskDirectoryStats(StatisticsFactory f, String name) {
        this.stats = f.createStatistics(type, name);
    }

    public void close() {
        this.stats.close();
    }

    public long getDiskSpace() {
        return this.stats.getLong(diskSpaceId);
    }

    public void incDiskSpace(long delta) {
        this.stats.incLong(diskSpaceId, delta);
    }

    public void setMaxSpace(long v) {
        this.stats.setLong(maxSpaceId, v);
    }

    public void addVolumeCheck(long total, long free, long time) {
        this.stats.setLong(volumeSizeId, total);
        this.stats.setLong(volumeFreeSpaceId, free);
        this.stats.incLong(volumeFreeSpaceChecksId, 1L);
        this.stats.incLong(volumeFreeSpaceTimeId, time);
    }

    public Statistics getStats() {
        return this.stats;
    }

    static {
        String statName = "DiskDirStatistics";
        String statDescription = "Statistics about a single disk directory for a region";
        String diskSpaceDesc = "The total number of bytes currently being used on disk in this directory for oplog files.";
        String maxSpaceDesc = "The configured maximum number of bytes allowed in this directory for oplog files. Note that some product configurations allow this maximum to be exceeded.";
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        type = f.createType(statName, statDescription, new StatisticDescriptor[]{f.createLongGauge("diskSpace", "The total number of bytes currently being used on disk in this directory for oplog files.", "bytes"), f.createLongGauge("maximumSpace", "The configured maximum number of bytes allowed in this directory for oplog files. Note that some product configurations allow this maximum to be exceeded.", "bytes"), f.createLongGauge("volumeSize", "The total size in bytes of the disk volume", "bytes"), f.createLongGauge("volumeFreeSpace", "The total free space in bytes on the disk volume", "bytes"), f.createLongCounter("volumeFreeSpaceChecks", "The total number of disk space checks", "checks"), f.createLongCounter("volumeFreeSpaceTime", "The total time spent checking disk usage", "nanoseconds")});
        diskSpaceId = type.nameToId("diskSpace");
        maxSpaceId = type.nameToId("maximumSpace");
        volumeSizeId = type.nameToId("volumeSize");
        volumeFreeSpaceId = type.nameToId("volumeFreeSpace");
        volumeFreeSpaceChecksId = type.nameToId("volumeFreeSpaceChecks");
        volumeFreeSpaceTimeId = type.nameToId("volumeFreeSpaceTime");
    }
}

