/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.UnmodifiableException;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.tcpserver.TcpClient;
import com.gemstone.gemfire.internal.ConfigSource;
import com.gemstone.gemfire.internal.JarClassLoader;
import com.gemstone.gemfire.internal.JarDeployer;
import com.gemstone.gemfire.internal.admin.remote.DistributionLocatorId;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.lang.StringUtils;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.process.ClusterConfigurationNotAvailableException;
import com.gemstone.gemfire.management.internal.configuration.domain.Configuration;
import com.gemstone.gemfire.management.internal.configuration.messages.ConfigurationRequest;
import com.gemstone.gemfire.management.internal.configuration.messages.ConfigurationResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class ClusterConfigurationLoader {
    private static final Logger logger = LogService.getLogger();

    public static void deployJarsReceivedFromClusterConfiguration(Cache cache, ConfigurationResponse response) throws IOException, ClassNotFoundException {
        String[] jarFileNames = response.getJarNames();
        byte[][] jarBytes = response.getJars();
        JarDeployer jarDeployer = new JarDeployer(((GemFireCacheImpl)cache).getDistributedSystem().getConfig().getDeployWorkingDir());
        if (jarFileNames != null && jarBytes != null) {
            JarClassLoader[] jarClassLoaders = jarDeployer.deploy(jarFileNames, jarBytes);
            for (int i = 0; i < jarFileNames.length; ++i) {
                if (jarClassLoaders[i] == null) continue;
                logger.info("Deployed " + jarClassLoaders[i].getFileCanonicalPath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void applyClusterConfiguration(Cache cache, ConfigurationResponse response, List<String> groups) {
        Map<String, Configuration> requestedConfiguration = response.getRequestedConfiguration();
        Properties runtimeProps = new Properties();
        LinkedList<Object> cacheXmlContentList = new LinkedList<Object>();
        if (!requestedConfiguration.isEmpty()) {
            Configuration clusterConfiguration = requestedConfiguration.get("cluster");
            if (clusterConfiguration != null) {
                String cacheXmlContent = clusterConfiguration.getCacheXmlContent();
                if (!StringUtils.isBlank(cacheXmlContent)) {
                    cacheXmlContentList.add(cacheXmlContent);
                }
                runtimeProps.putAll((Map<?, ?>)clusterConfiguration.getGemfireProperties());
            }
            requestedConfiguration.remove("cluster");
            for (String group : groups) {
                Configuration groupConfiguration = requestedConfiguration.get(group);
                if (groupConfiguration == null) continue;
                String string = groupConfiguration.getCacheXmlContent();
                if (!StringUtils.isBlank(string)) {
                    cacheXmlContentList.add(string);
                }
                runtimeProps.putAll((Map<?, ?>)groupConfiguration.getGemfireProperties());
            }
            DistributionConfig config = ((GemFireCacheImpl)cache).getSystem().getConfig();
            Set<Object> attNames = runtimeProps.keySet();
            if (!attNames.isEmpty()) {
                for (Object object : attNames) {
                    String attName = (String)object;
                    String attValue = runtimeProps.getProperty(attName);
                    try {
                        config.setAttribute(attName, attValue, ConfigSource.runtime());
                    }
                    catch (IllegalArgumentException e) {
                        logger.info(e.getMessage());
                    }
                    catch (UnmodifiableException e) {
                        logger.info(e.getMessage());
                    }
                }
            }
            if (!cacheXmlContentList.isEmpty()) {
                for (String string : cacheXmlContentList) {
                    ByteArrayInputStream is = new ByteArrayInputStream(string.getBytes());
                    try {
                        cache.loadCacheXml(is);
                    }
                    finally {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }

    public static ConfigurationResponse requestConfigurationFromLocators(List<String> groups, List<String> locatorList) throws ClusterConfigurationNotAvailableException, UnknownHostException {
        ConfigurationRequest request = new ConfigurationRequest();
        for (String group : groups) {
            request.addGroups(group);
        }
        request.setNumAttempts(10);
        ConfigurationResponse response = null;
        for (String locatorInfo : locatorList) {
            DistributionLocatorId dlId = new DistributionLocatorId(locatorInfo);
            String ipaddress = dlId.getBindAddress();
            InetAddress locatorInetAddress = null;
            locatorInetAddress = !StringUtils.isBlank(ipaddress) ? InetAddress.getByName(ipaddress) : dlId.getHost();
            int port = dlId.getPort();
            try {
                response = (ConfigurationResponse)TcpClient.requestToServer(locatorInetAddress, port, request, 10000);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (response == null || response.failedToGetSharedConfig()) {
            throw new ClusterConfigurationNotAvailableException(LocalizedStrings.Launcher_Command_FAILED_TO_GET_SHARED_CONFIGURATION.toLocalizedString());
        }
        return response;
    }

    public static List<String> getGroups(String groupString) {
        ArrayList<String> groups = new ArrayList<String>();
        groups.add("cluster");
        if (!StringUtils.isBlank(groupString)) {
            groups.addAll(Arrays.asList(groupString.split(",")));
        }
        return groups;
    }

    public static List<String[]> getLocatorsInfo(String locatorsString) {
        ArrayList<String[]> locatorList = new ArrayList<String[]>();
        if (!StringUtils.isBlank(locatorsString)) {
            String[] bootstrappedlocators;
            for (String bootstrappedlocator : bootstrappedlocators = locatorsString.split(",")) {
                locatorList.add(bootstrappedlocator.split("\\[|]"));
            }
        }
        return locatorList;
    }

    public static List<String[]> getLocatorsInfo(List<String> locatorConnectionStrings) {
        ArrayList<String[]> locatorList = new ArrayList<String[]>();
        for (String locatorConnectionString : locatorConnectionStrings) {
            locatorList.add(locatorConnectionString.split("\\[|]"));
        }
        return locatorList;
    }
}

