/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsFactory;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.StatisticsTypeFactory;
import com.gemstone.gemfire.distributed.internal.PoolStatHelper;
import com.gemstone.gemfire.distributed.internal.QueueStatHelper;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.StatisticsTypeFactoryImpl;

public class CachePerfStats {
    public static boolean enableClockStats = false;
    private static final StatisticsType type;
    protected static final int loadsInProgressId;
    protected static final int loadsCompletedId;
    protected static final int loadTimeId;
    protected static final int netloadsInProgressId;
    protected static final int netloadsCompletedId;
    protected static final int netloadTimeId;
    protected static final int netsearchesInProgressId;
    protected static final int netsearchesCompletedId;
    protected static final int netsearchTimeId;
    protected static final int cacheWriterCallsInProgressId;
    protected static final int cacheWriterCallsCompletedId;
    protected static final int cacheWriterCallTimeId;
    protected static final int cacheListenerCallsInProgressId;
    protected static final int cacheListenerCallsCompletedId;
    protected static final int cacheListenerCallTimeId;
    protected static final int getInitialImagesInProgressId;
    protected static final int getInitialImagesCompletedId;
    protected static final int deltaGetInitialImagesCompletedId;
    protected static final int getInitialImageTimeId;
    protected static final int getInitialImageKeysReceivedId;
    protected static final int regionsId;
    protected static final int partitionedRegionsId;
    protected static final int destroysId;
    protected static final int createsId;
    protected static final int putsId;
    protected static final int putTimeId;
    protected static final int putallsId;
    protected static final int putallTimeId;
    protected static final int removeAllsId;
    protected static final int removeAllTimeId;
    protected static final int updatesId;
    protected static final int updateTimeId;
    protected static final int invalidatesId;
    protected static final int getsId;
    protected static final int getTimeId;
    protected static final int eventQueueSizeId;
    protected static final int eventQueueThrottleTimeId;
    protected static final int eventQueueThrottleCountId;
    protected static final int eventThreadsId;
    protected static final int missesId;
    protected static final int queryExecutionsId;
    protected static final int queryExecutionTimeId;
    protected static final int queryResultsHashCollisionsId;
    protected static final int queryResultsHashCollisionProbeTimeId;
    protected static final int partitionedRegionQueryRetriesId;
    protected static final int txSuccessLifeTimeId;
    protected static final int txFailedLifeTimeId;
    protected static final int txRollbackLifeTimeId;
    protected static final int txCommitsId;
    protected static final int txFailuresId;
    protected static final int txRollbacksId;
    protected static final int txCommitTimeId;
    protected static final int txFailureTimeId;
    protected static final int txRollbackTimeId;
    protected static final int txCommitChangesId;
    protected static final int txFailureChangesId;
    protected static final int txRollbackChangesId;
    protected static final int txConflictCheckTimeId;
    protected static final int reliableQueuedOpsId;
    protected static final int reliableQueueSizeId;
    protected static final int reliableQueueMaxId;
    protected static final int reliableRegionsId;
    protected static final int reliableRegionsMissingId;
    protected static final int reliableRegionsQueuingId;
    protected static final int reliableRegionsMissingFullAccessId;
    protected static final int reliableRegionsMissingLimitedAccessId;
    protected static final int reliableRegionsMissingNoAccessId;
    protected static final int entryCountId;
    protected static final int eventsQueuedId;
    protected static final int retriesId;
    protected static final int diskTasksWaitingId;
    protected static final int evictorJobsStartedId;
    protected static final int evictorJobsCompletedId;
    protected static final int evictorQueueSizeId;
    protected static final int evictWorkTimeId;
    protected static final int indexUpdateInProgressId;
    protected static final int indexUpdateCompletedId;
    protected static final int indexUpdateTimeId;
    protected static final int clearsId;
    protected static final int indexInitializationInProgressId;
    protected static final int indexInitializationCompletedId;
    protected static final int indexInitializationTimeId;
    protected static final int nonSingleHopsCountId;
    protected static final int metaDataRefreshCountId;
    protected static final int conflatedEventsId;
    protected static final int tombstoneCountId;
    protected static final int tombstoneGCCountId;
    protected static final int tombstoneOverhead1Id;
    protected static final int tombstoneOverhead2Id;
    protected static final int clearTimeoutsId;
    protected static final int deltaUpdatesId;
    protected static final int deltaUpdatesTimeId;
    protected static final int deltaFailedUpdatesId;
    protected static final int deltasPreparedId;
    protected static final int deltasPreparedTimeId;
    protected static final int deltasSentId;
    protected static final int deltaFullValuesSentId;
    protected static final int deltaFullValuesRequestedId;
    protected static final int importedEntriesCountId;
    protected static final int importTimeId;
    protected static final int exportedEntriesCountId;
    protected static final int exportTimeId;
    protected static final int compressionCompressTimeId;
    protected static final int compressionDecompressTimeId;
    protected static final int compressionCompressionsId;
    protected static final int compressionDecompressionsId;
    protected static final int compressionPreCompressedBytesId;
    protected static final int compressionPostCompressedBytesId;
    protected static final int evictByCriteria_evictionsId;
    protected static final int evictByCriteria_evictionTimeId;
    protected static final int evictByCriteria_evictionsInProgressId;
    protected static final int evictByCriteria_evaluationsId;
    protected static final int evictByCriteria_evaluationTimeId;
    protected final Statistics stats;

    public CachePerfStats() {
        this.stats = null;
    }

    public CachePerfStats(StatisticsFactory factory) {
        this.stats = factory.createAtomicStatistics(type, "cachePerfStats");
    }

    public CachePerfStats(StatisticsFactory factory, String name) {
        this.stats = factory.createAtomicStatistics(type, "RegionStats-" + name);
    }

    public static long getStatTime() {
        return enableClockStats ? NanoTimer.getTime() : 0L;
    }

    public int getLoadsInProgress() {
        return this.stats.getInt(loadsInProgressId);
    }

    public int getLoadsCompleted() {
        return this.stats.getInt(loadsCompletedId);
    }

    public long getLoadTime() {
        return this.stats.getLong(loadTimeId);
    }

    public int getNetloadsInProgress() {
        return this.stats.getInt(netloadsInProgressId);
    }

    public int getNetloadsCompleted() {
        return this.stats.getInt(netloadsCompletedId);
    }

    public long getNetloadTime() {
        return this.stats.getLong(netloadTimeId);
    }

    public int getNetsearchesInProgress() {
        return this.stats.getInt(netsearchesInProgressId);
    }

    public int getNetsearchesCompleted() {
        return this.stats.getInt(netsearchesCompletedId);
    }

    public long getNetsearchTime() {
        return this.stats.getLong(netsearchTimeId);
    }

    public int getGetInitialImagesInProgress() {
        return this.stats.getInt(getInitialImagesInProgressId);
    }

    public int getGetInitialImagesCompleted() {
        return this.stats.getInt(getInitialImagesCompletedId);
    }

    public int getDeltaGetInitialImagesCompleted() {
        return this.stats.getInt(deltaGetInitialImagesCompletedId);
    }

    public long getGetInitialImageTime() {
        return this.stats.getLong(getInitialImageTimeId);
    }

    public int getGetInitialImageKeysReceived() {
        return this.stats.getInt(getInitialImageKeysReceivedId);
    }

    public int getRegions() {
        return this.stats.getInt(regionsId);
    }

    public int getPartitionedRegions() {
        return this.stats.getInt(partitionedRegionsId);
    }

    public int getDestroys() {
        return this.stats.getInt(destroysId);
    }

    public int getCreates() {
        return this.stats.getInt(createsId);
    }

    public int getPuts() {
        return this.stats.getInt(putsId);
    }

    public int getPutAlls() {
        return this.stats.getInt(putallsId);
    }

    public int getRemoveAlls() {
        return this.stats.getInt(removeAllsId);
    }

    public int getUpdates() {
        return this.stats.getInt(updatesId);
    }

    public int getInvalidates() {
        return this.stats.getInt(invalidatesId);
    }

    public int getGets() {
        return this.stats.getInt(getsId);
    }

    public int getMisses() {
        return this.stats.getInt(missesId);
    }

    public int getReliableQueuedOps() {
        return this.stats.getInt(reliableQueuedOpsId);
    }

    public void incReliableQueuedOps(int inc) {
        this.stats.incInt(reliableQueuedOpsId, inc);
    }

    public int getReliableQueueSize() {
        return this.stats.getInt(reliableQueueSizeId);
    }

    public void incReliableQueueSize(int inc) {
        this.stats.incInt(reliableQueueSizeId, inc);
    }

    public int getReliableQueueMax() {
        return this.stats.getInt(reliableQueueMaxId);
    }

    public void incReliableQueueMax(int inc) {
        this.stats.incInt(reliableQueueMaxId, inc);
    }

    public int getReliableRegions() {
        return this.stats.getInt(reliableRegionsId);
    }

    public void incReliableRegions(int inc) {
        this.stats.incInt(reliableRegionsId, inc);
    }

    public int getReliableRegionsMissing() {
        return this.stats.getInt(reliableRegionsMissingId);
    }

    public void incReliableRegionsMissing(int inc) {
        this.stats.incInt(reliableRegionsMissingId, inc);
    }

    public int getReliableRegionsQueuing() {
        return this.stats.getInt(reliableRegionsQueuingId);
    }

    public void incReliableRegionsQueuing(int inc) {
        this.stats.incInt(reliableRegionsQueuingId, inc);
    }

    public int getReliableRegionsMissingFullAccess() {
        return this.stats.getInt(reliableRegionsMissingFullAccessId);
    }

    public void incReliableRegionsMissingFullAccess(int inc) {
        this.stats.incInt(reliableRegionsMissingFullAccessId, inc);
    }

    public int getReliableRegionsMissingLimitedAccess() {
        return this.stats.getInt(reliableRegionsMissingLimitedAccessId);
    }

    public void incReliableRegionsMissingLimitedAccess(int inc) {
        this.stats.incInt(reliableRegionsMissingLimitedAccessId, inc);
    }

    public int getReliableRegionsMissingNoAccess() {
        return this.stats.getInt(reliableRegionsMissingNoAccessId);
    }

    public void incReliableRegionsMissingNoAccess(int inc) {
        this.stats.incInt(reliableRegionsMissingNoAccessId, inc);
    }

    public void incQueuedEvents(int inc) {
        this.stats.incLong(eventsQueuedId, (long)inc);
    }

    public long getQueuedEvents() {
        return this.stats.getInt(eventsQueuedId);
    }

    public int getDeltaUpdates() {
        return this.stats.getInt(deltaUpdatesId);
    }

    public long getDeltaUpdatesTime() {
        return this.stats.getLong(deltaUpdatesTimeId);
    }

    public int getDeltaFailedUpdates() {
        return this.stats.getInt(deltaFailedUpdatesId);
    }

    public int getDeltasPrepared() {
        return this.stats.getInt(deltasPreparedId);
    }

    public long getDeltasPreparedTime() {
        return this.stats.getLong(deltasPreparedTimeId);
    }

    public int getDeltasSent() {
        return this.stats.getInt(deltasSentId);
    }

    public int getDeltaFullValuesSent() {
        return this.stats.getInt(deltaFullValuesSentId);
    }

    public int getDeltaFullValuesRequested() {
        return this.stats.getInt(deltaFullValuesRequestedId);
    }

    public long getTotalCompressionTime() {
        return this.stats.getLong(compressionCompressTimeId);
    }

    public long getTotalDecompressionTime() {
        return this.stats.getLong(compressionDecompressTimeId);
    }

    public long getTotalCompressions() {
        return this.stats.getLong(compressionCompressionsId);
    }

    public long getTotalDecompressions() {
        return this.stats.getLong(compressionDecompressionsId);
    }

    public long getTotalPreCompressedBytes() {
        return this.stats.getLong(compressionPreCompressedBytesId);
    }

    public long getTotalPostCompressedBytes() {
        return this.stats.getLong(compressionPostCompressedBytesId);
    }

    public long startCompression() {
        this.stats.incLong(compressionCompressionsId, 1L);
        return CachePerfStats.getStatTime();
    }

    public void endCompression(long startTime, long startSize, long endSize) {
        if (enableClockStats) {
            this.stats.incLong(compressionCompressTimeId, CachePerfStats.getStatTime() - startTime);
        }
        this.stats.incLong(compressionPreCompressedBytesId, startSize);
        this.stats.incLong(compressionPostCompressedBytesId, endSize);
    }

    public long startDecompression() {
        this.stats.incLong(compressionDecompressionsId, 1L);
        return CachePerfStats.getStatTime();
    }

    public void endDecompression(long startTime) {
        if (enableClockStats) {
            this.stats.incLong(compressionDecompressTimeId, CachePerfStats.getStatTime() - startTime);
        }
    }

    public long startLoad() {
        this.stats.incInt(loadsInProgressId, 1);
        return NanoTimer.getTime();
    }

    public void endLoad(long start) {
        long ts = NanoTimer.getTime();
        this.stats.incLong(loadTimeId, ts - start);
        this.stats.incInt(loadsInProgressId, -1);
        this.stats.incInt(loadsCompletedId, 1);
    }

    public long startNetload() {
        this.stats.incInt(netloadsInProgressId, 1);
        return CachePerfStats.getStatTime();
    }

    public void endNetload(long start) {
        if (enableClockStats) {
            this.stats.incLong(netloadTimeId, CachePerfStats.getStatTime() - start);
        }
        this.stats.incInt(netloadsInProgressId, -1);
        this.stats.incInt(netloadsCompletedId, 1);
    }

    public long startNetsearch() {
        this.stats.incInt(netsearchesInProgressId, 1);
        return NanoTimer.getTime();
    }

    public void endNetsearch(long start) {
        long ts = NanoTimer.getTime();
        this.stats.incLong(netsearchTimeId, ts - start);
        this.stats.incInt(netsearchesInProgressId, -1);
        this.stats.incInt(netsearchesCompletedId, 1);
    }

    public long startCacheWriterCall() {
        this.stats.incInt(cacheWriterCallsInProgressId, 1);
        return CachePerfStats.getStatTime();
    }

    public void endCacheWriterCall(long start) {
        if (enableClockStats) {
            this.stats.incLong(cacheWriterCallTimeId, CachePerfStats.getStatTime() - start);
        }
        this.stats.incInt(cacheWriterCallsInProgressId, -1);
        this.stats.incInt(cacheWriterCallsCompletedId, 1);
    }

    public long startCacheListenerCall() {
        this.stats.incInt(cacheListenerCallsInProgressId, 1);
        return CachePerfStats.getStatTime();
    }

    public void endCacheListenerCall(long start) {
        if (enableClockStats) {
            this.stats.incLong(cacheListenerCallTimeId, CachePerfStats.getStatTime() - start);
        }
        this.stats.incInt(cacheListenerCallsInProgressId, -1);
        this.stats.incInt(cacheListenerCallsCompletedId, 1);
    }

    public long startGetInitialImage() {
        this.stats.incInt(getInitialImagesInProgressId, 1);
        return CachePerfStats.getStatTime();
    }

    public void endGetInitialImage(long start) {
        if (enableClockStats) {
            this.stats.incLong(getInitialImageTimeId, CachePerfStats.getStatTime() - start);
        }
        this.stats.incInt(getInitialImagesInProgressId, -1);
        this.stats.incInt(getInitialImagesCompletedId, 1);
    }

    public void endNoGIIDone(long start) {
        if (enableClockStats) {
            this.stats.incLong(getInitialImageTimeId, CachePerfStats.getStatTime() - start);
        }
        this.stats.incInt(getInitialImagesInProgressId, -1);
    }

    public void incDeltaGIICompleted() {
        this.stats.incInt(deltaGetInitialImagesCompletedId, 1);
    }

    public void incGetInitialImageKeysReceived() {
        this.stats.incInt(getInitialImageKeysReceivedId, 1);
    }

    public long startIndexUpdate() {
        this.stats.incInt(indexUpdateInProgressId, 1);
        return CachePerfStats.getStatTime();
    }

    public void endIndexUpdate(long start) {
        long ts = CachePerfStats.getStatTime();
        this.stats.incLong(indexUpdateTimeId, ts - start);
        this.stats.incInt(indexUpdateInProgressId, -1);
        this.stats.incInt(indexUpdateCompletedId, 1);
    }

    public long startIndexInitialization() {
        this.stats.incInt(indexInitializationInProgressId, 1);
        return CachePerfStats.getStatTime();
    }

    public void endIndexInitialization(long start) {
        long ts = CachePerfStats.getStatTime();
        this.stats.incLong(indexInitializationTimeId, ts - start);
        this.stats.incInt(indexInitializationInProgressId, -1);
        this.stats.incInt(indexInitializationCompletedId, 1);
    }

    public long getIndexInitializationTime() {
        return this.stats.getLong(indexInitializationTimeId);
    }

    public void incRegions(int inc) {
        this.stats.incInt(regionsId, inc);
    }

    public void incPartitionedRegions(int inc) {
        this.stats.incInt(partitionedRegionsId, inc);
    }

    public void incDestroys() {
        this.stats.incInt(destroysId, 1);
    }

    public void incCreates() {
        this.stats.incInt(createsId, 1);
    }

    public void incInvalidates() {
        this.stats.incInt(invalidatesId, 1);
    }

    public long startGet() {
        return CachePerfStats.getStatTime();
    }

    public void endGet(long start, boolean miss) {
        if (enableClockStats) {
            this.stats.incLong(getTimeId, CachePerfStats.getStatTime() - start);
        }
        this.stats.incInt(getsId, 1);
        if (miss) {
            this.stats.incInt(missesId, 1);
        }
    }

    public long endPut(long start, boolean isUpdate) {
        long total = 0L;
        if (isUpdate) {
            this.stats.incInt(updatesId, 1);
            if (enableClockStats) {
                total = CachePerfStats.getStatTime() - start;
                this.stats.incLong(updateTimeId, total);
            }
        } else {
            this.stats.incInt(putsId, 1);
            if (enableClockStats) {
                total = CachePerfStats.getStatTime() - start;
                this.stats.incLong(putTimeId, total);
            }
        }
        return total;
    }

    public void endPutAll(long start) {
        this.stats.incInt(putallsId, 1);
        if (enableClockStats) {
            this.stats.incLong(putallTimeId, CachePerfStats.getStatTime() - start);
        }
    }

    public void endRemoveAll(long start) {
        this.stats.incInt(removeAllsId, 1);
        if (enableClockStats) {
            this.stats.incLong(removeAllTimeId, CachePerfStats.getStatTime() - start);
        }
    }

    public void endQueryExecution(long executionTime) {
        this.stats.incInt(queryExecutionsId, 1);
        if (enableClockStats) {
            this.stats.incLong(queryExecutionTimeId, executionTime);
        }
    }

    public void endQueryResultsHashCollisionProbe(long start) {
        if (enableClockStats) {
            this.stats.incLong(queryResultsHashCollisionProbeTimeId, CachePerfStats.getStatTime() - start);
        }
    }

    public void incQueryResultsHashCollisions() {
        this.stats.incInt(queryResultsHashCollisionsId, 1);
    }

    public int getTxCommits() {
        return this.stats.getInt(txCommitsId);
    }

    public int getTxCommitChanges() {
        return this.stats.getInt(txCommitChangesId);
    }

    public long getTxCommitTime() {
        return this.stats.getLong(txCommitTimeId);
    }

    public long getTxSuccessLifeTime() {
        return this.stats.getLong(txSuccessLifeTimeId);
    }

    public int getTxFailures() {
        return this.stats.getInt(txFailuresId);
    }

    public int getTxFailureChanges() {
        return this.stats.getInt(txFailureChangesId);
    }

    public long getTxFailureTime() {
        return this.stats.getLong(txFailureTimeId);
    }

    public long getTxFailedLifeTime() {
        return this.stats.getLong(txFailedLifeTimeId);
    }

    public int getTxRollbacks() {
        return this.stats.getInt(txRollbacksId);
    }

    public int getTxRollbackChanges() {
        return this.stats.getInt(txRollbackChangesId);
    }

    public long getTxRollbackTime() {
        return this.stats.getLong(txRollbackTimeId);
    }

    public long getTxRollbackLifeTime() {
        return this.stats.getLong(txRollbackLifeTimeId);
    }

    public void incTxConflictCheckTime(long delta) {
        this.stats.incLong(txConflictCheckTimeId, delta);
    }

    public void txSuccess(long opTime, long txLifeTime, int txChanges) {
        this.stats.incInt(txCommitsId, 1);
        this.stats.incInt(txCommitChangesId, txChanges);
        this.stats.incLong(txCommitTimeId, opTime);
        this.stats.incLong(txSuccessLifeTimeId, txLifeTime);
    }

    public void txFailure(long opTime, long txLifeTime, int txChanges) {
        this.stats.incInt(txFailuresId, 1);
        this.stats.incInt(txFailureChangesId, txChanges);
        this.stats.incLong(txFailureTimeId, opTime);
        this.stats.incLong(txFailedLifeTimeId, txLifeTime);
    }

    public void txRollback(long opTime, long txLifeTime, int txChanges) {
        this.stats.incInt(txRollbacksId, 1);
        this.stats.incInt(txRollbackChangesId, txChanges);
        this.stats.incLong(txRollbackTimeId, opTime);
        this.stats.incLong(txRollbackLifeTimeId, txLifeTime);
    }

    public void endDeltaUpdate(long start) {
        this.stats.incInt(deltaUpdatesId, 1);
        if (enableClockStats) {
            this.stats.incLong(deltaUpdatesTimeId, CachePerfStats.getStatTime() - start);
        }
    }

    public void incDeltaFailedUpdates() {
        this.stats.incInt(deltaFailedUpdatesId, 1);
    }

    public void endDeltaPrepared(long start) {
        this.stats.incInt(deltasPreparedId, 1);
        if (enableClockStats) {
            this.stats.incLong(deltasPreparedTimeId, CachePerfStats.getStatTime() - start);
        }
    }

    public void incDeltasSent() {
        this.stats.incInt(deltasSentId, 1);
    }

    public void incDeltaFullValuesSent() {
        this.stats.incInt(deltaFullValuesSentId, 1);
    }

    public void incDeltaFullValuesRequested() {
        this.stats.incInt(deltaFullValuesRequestedId, 1);
    }

    void close() {
        this.stats.close();
    }

    public boolean isClosed() {
        return this.stats.isClosed();
    }

    public int getEventQueueSize() {
        return this.stats.getInt(eventQueueSizeId);
    }

    public void incEventQueueSize(int items) {
        this.stats.incInt(eventQueueSizeId, items);
    }

    public void incEventQueueThrottleCount(int items) {
        this.stats.incInt(eventQueueThrottleCountId, items);
    }

    protected void incEventQueueThrottleTime(long nanos) {
        this.stats.incLong(eventQueueThrottleTimeId, nanos);
    }

    protected void incEventThreads(int items) {
        this.stats.incInt(eventThreadsId, items);
    }

    public void incEntryCount(int delta) {
        this.stats.incLong(entryCountId, (long)delta);
    }

    public long getEntries() {
        return this.stats.getLong(entryCountId);
    }

    public void incRetries() {
        this.stats.incInt(retriesId, 1);
    }

    public void incDiskTasksWaiting() {
        this.stats.incInt(diskTasksWaitingId, 1);
    }

    public void decDiskTasksWaiting() {
        this.stats.incInt(diskTasksWaitingId, -1);
    }

    public void decDiskTasksWaiting(int count) {
        this.stats.incInt(diskTasksWaitingId, -count);
    }

    public void incEvictorJobsStarted() {
        this.stats.incInt(evictorJobsStartedId, 1);
    }

    public void incEvictorJobsCompleted() {
        this.stats.incInt(evictorJobsCompletedId, 1);
    }

    public void incEvictorQueueSize(int delta) {
        this.stats.incInt(evictorQueueSizeId, delta);
    }

    public void incEvictWorkTime(long delta) {
        this.stats.incLong(evictWorkTimeId, delta);
    }

    public Statistics getStats() {
        return this.stats;
    }

    public PoolStatHelper getEventPoolHelper() {
        return new PoolStatHelper(){

            @Override
            public void startJob() {
                CachePerfStats.this.incEventThreads(1);
            }

            @Override
            public void endJob() {
                CachePerfStats.this.incEventThreads(-1);
            }
        };
    }

    public int getClearCount() {
        return this.stats.getInt(clearsId);
    }

    public void incClearCount() {
        this.stats.incInt(clearsId, 1);
    }

    public long getConflatedEventsCount() {
        return this.stats.getLong(conflatedEventsId);
    }

    public void incConflatedEventsCount() {
        this.stats.incLong(conflatedEventsId, 1L);
    }

    public int getTombstoneCount() {
        return this.stats.getInt(tombstoneCountId);
    }

    public void incTombstoneCount(int amount) {
        this.stats.incInt(tombstoneCountId, amount);
    }

    public int getTombstoneGCCount() {
        return this.stats.getInt(tombstoneGCCountId);
    }

    public void incTombstoneGCCount() {
        this.stats.incInt(tombstoneGCCountId, 1);
    }

    public void setReplicatedTombstonesSize(long size) {
        this.stats.setLong(tombstoneOverhead1Id, size);
    }

    public long getReplicatedTombstonesSize() {
        return this.stats.getLong(tombstoneOverhead1Id);
    }

    public void setNonReplicatedTombstonesSize(long size) {
        this.stats.setLong(tombstoneOverhead2Id, size);
    }

    public long getNonReplicatedTombstonesSize() {
        return this.stats.getLong(tombstoneOverhead2Id);
    }

    public int getClearTimeouts() {
        return this.stats.getInt(clearTimeoutsId);
    }

    public void incClearTimeouts() {
        this.stats.incInt(clearTimeoutsId, 1);
    }

    public void incPRQueryRetries() {
        this.stats.incLong(partitionedRegionQueryRetriesId, 1L);
    }

    public long getPRQueryRetries() {
        return this.stats.getLong(partitionedRegionQueryRetriesId);
    }

    public QueueStatHelper getEvictionQueueStatHelper() {
        return new QueueStatHelper(){

            @Override
            public void add() {
                CachePerfStats.this.incEvictorQueueSize(1);
            }

            @Override
            public void remove() {
                CachePerfStats.this.incEvictorQueueSize(-1);
            }

            @Override
            public void remove(int count) {
                CachePerfStats.this.incEvictorQueueSize(count * -1);
            }
        };
    }

    public void incNonSingleHopsCount() {
        this.stats.incLong(nonSingleHopsCountId, 1L);
    }

    public long getNonSingleHopsCount() {
        return this.stats.getLong(nonSingleHopsCountId);
    }

    public void incMetaDataRefreshCount() {
        this.stats.incLong(metaDataRefreshCountId, 1L);
    }

    public long getMetaDataRefreshCount() {
        return this.stats.getLong(metaDataRefreshCountId);
    }

    public long getImportedEntriesCount() {
        return this.stats.getLong(importedEntriesCountId);
    }

    public long getImportTime() {
        return this.stats.getLong(importTimeId);
    }

    public void endImport(long entryCount, long start) {
        this.stats.incLong(importedEntriesCountId, entryCount);
        if (enableClockStats) {
            this.stats.incLong(importTimeId, CachePerfStats.getStatTime() - start);
        }
    }

    public long getExportedEntriesCount() {
        return this.stats.getLong(exportedEntriesCountId);
    }

    public long getExportTime() {
        return this.stats.getLong(exportTimeId);
    }

    public void endExport(long entryCount, long start) {
        this.stats.incLong(exportedEntriesCountId, entryCount);
        if (enableClockStats) {
            this.stats.incLong(exportTimeId, CachePerfStats.getStatTime() - start);
        }
    }

    public long startCustomEviction() {
        return NanoTimer.getTime();
    }

    public void endCustomEviction(long start) {
        long ts = NanoTimer.getTime();
        this.stats.incLong(evictByCriteria_evictionTimeId, ts - start);
    }

    public void incEvictionsInProgress() {
        this.stats.incLong(evictByCriteria_evictionsInProgressId, 1L);
    }

    public void decEvictionsInProgress() {
        this.stats.incLong(evictByCriteria_evictionsInProgressId, -1L);
    }

    public void incEvictions() {
        this.stats.incLong(evictByCriteria_evictionsId, 1L);
    }

    public void incEvaluations() {
        this.stats.incLong(evictByCriteria_evaluationsId, 1L);
    }

    public void incEvaluations(int delta) {
        this.stats.incLong(evictByCriteria_evaluationsId, (long)delta);
    }

    public long startEvaluation() {
        return NanoTimer.getTime();
    }

    public void endEvaluation(long start, long notEvaluationTime) {
        long ts = NanoTimer.getTime();
        long totalTime = ts - start;
        long evaluationTime = totalTime - notEvaluationTime;
        this.stats.incLong(evictByCriteria_evaluationTimeId, evaluationTime);
    }

    public long getEvictions() {
        return this.stats.getLong(evictByCriteria_evictionsId);
    }

    public long getEvictionsInProgress() {
        return this.stats.getLong(evictByCriteria_evictionsInProgressId);
    }

    public long getEvictionsTime() {
        return this.stats.getLong(evictByCriteria_evictionTimeId);
    }

    public long getEvaluations() {
        return this.stats.getLong(evictByCriteria_evaluationsId);
    }

    public long getEvaluationTime() {
        return this.stats.getLong(evictByCriteria_evaluationTimeId);
    }

    static {
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        String loadsInProgressDesc = "Current number of threads in this cache doing a cache load.";
        String loadsCompletedDesc = "Total number of times a load on this cache has completed (as a result of either a local get() or a remote netload).";
        String loadTimeDesc = "Total time spent invoking loaders on this cache.";
        String netloadsInProgressDesc = "Current number of threads doing a network load initiated by a get() in this cache.";
        String netloadsCompletedDesc = "Total number of times a network load initiated on this cache has completed.";
        String netloadTimeDesc = "Total time spent doing network loads on this cache.";
        String netsearchesInProgressDesc = "Current number of threads doing a network search initiated by a get() in this cache.";
        String netsearchesCompletedDesc = "Total number of times network searches initiated by this cache have completed.";
        String netsearchTimeDesc = "Total time spent doing network searches for cache values.";
        String cacheWriterCallsInProgressDesc = "Current number of threads doing a cache writer call.";
        String cacheWriterCallsCompletedDesc = "Total number of times a cache writer call has completed.";
        String cacheWriterCallTimeDesc = "Total time spent doing cache writer calls.";
        String cacheListenerCallsInProgressDesc = "Current number of threads doing a cache listener call.";
        String cacheListenerCallsCompletedDesc = "Total number of times a cache listener call has completed.";
        String cacheListenerCallTimeDesc = "Total time spent doing cache listener calls.";
        String getInitialImagesInProgressDesc = "Current number of getInitialImage operations currently in progress.";
        String getInitialImagesCompletedDesc = "Total number of times getInitialImages (both delta and full GII) initiated by this cache have completed.";
        String deltaGetInitialImagesCompletedDesc = "Total number of times delta getInitialImages initiated by this cache have completed.";
        String getInitialImageTimeDesc = "Total time spent doing getInitialImages for region creation.";
        String getInitialImageKeysReceivedDesc = "Total number of keys received while doing getInitialImage operations.";
        String regionsDesc = "The current number of regions in the cache.";
        String partitionedRegionsDesc = "The current number of partitioned regions in the cache.";
        String destroysDesc = "The total number of times a cache object entry has been destroyed in this cache.";
        String updatesDesc = "The total number of updates originating remotely that have been applied to this cache.";
        String updateTimeDesc = "Total time spent performing an update.";
        String invalidatesDesc = "The total number of times an existing cache object entry value in this cache has been invalidated";
        String getsDesc = "The total number of times a successful get has been done on this cache.";
        String createsDesc = "The total number of times an entry is added to this cache.";
        String putsDesc = "The total number of times an entry is added or replaced in this cache as a result of a local operation (put(), create(), or get() which results in load, netsearch, or netloading a value). Note that this only counts puts done explicitly on this cache. It does not count updates pushed from other caches.";
        String putTimeDesc = "Total time spent adding or replacing an entry in this cache as a result of a local operation.  This includes synchronizing on the map, invoking cache callbacks, sending messages to other caches and waiting for responses (if required).";
        String putallsDesc = "The total number of times a map is added or replaced in this cache as a result of a local operation. Note that this only counts putAlls done explicitly on this cache. It does not count updates pushed from other caches.";
        String putallTimeDesc = "Total time spent replacing a map in this cache as a result of a local operation.  This includes synchronizing on the map, invoking cache callbacks, sending messages to other caches and waiting for responses (if required).";
        String removeAllsDesc = "The total number of removeAll operations that originated in this cache. Note that this only counts removeAlls done explicitly on this cache. It does not count removes pushed from other caches.";
        String removeAllTimeDesc = "Total time spent performing removeAlls that originated in this cache. This includes time spent waiting for the removeAll to be done in remote caches (if required).";
        String getTimeDesc = "Total time spent doing get operations from this cache (including netsearch and netload)";
        String eventQueueSizeDesc = "The number of cache events waiting to be processed.";
        String eventQueueThrottleTimeDesc = "The total amount of time, in nanoseconds, spent delayed by the event queue throttle.";
        String eventQueueThrottleCountDesc = "The total number of times a thread was delayed in adding an event to the event queue.";
        String eventThreadsDesc = "The number of threads currently processing events.";
        String missesDesc = "Total number of times a get on the cache did not find a value already in local memory. The number of hits (i.e. gets that did not miss) can be calculated by subtracting misses from gets.";
        String queryExecutionsDesc = "Total number of times some query has been executed";
        String queryExecutionTimeDesc = "Total time spent executing queries";
        String queryResultsHashCollisionsDesc = "Total number of times an hash code collision occurred when inserting an object into an OQL result set or rehashing it";
        String queryResultsHashCollisionProbeTimeDesc = "Total time spent probing the hashtable in an OQL result set due to hash code collisions, includes reads, writes, and rehashes";
        String partitionedRegionOQLQueryRetriesDesc = "Total number of times an OQL Query on a Partitioned Region had to be retried";
        String txSuccessLifeTimeDesc = "The total amount of time, in nanoseconds, spent in a transaction before a successful commit. The time measured starts at transaction begin and ends when commit is called.";
        String txFailedLifeTimeDesc = "The total amount of time, in nanoseconds, spent in a transaction before a failed commit. The time measured starts at transaction begin and ends when commit is called.";
        String txRollbackLifeTimeDesc = "The total amount of time, in nanoseconds, spent in a transaction before an explicit rollback. The time measured starts at transaction begin and ends when rollback is called.";
        String txCommitsDesc = "Total number times a transaction commit has succeeded.";
        String txFailuresDesc = "Total number times a transaction commit has failed.";
        String txRollbacksDesc = "Total number times a transaction has been explicitly rolled back.";
        String txCommitTimeDesc = "The total amount of time, in nanoseconds, spent doing successful transaction commits.";
        String txFailureTimeDesc = "The total amount of time, in nanoseconds, spent doing failed transaction commits.";
        String txRollbackTimeDesc = "The total amount of time, in nanoseconds, spent doing explicit transaction rollbacks.";
        String txCommitChangesDesc = "Total number of changes made by committed transactions.";
        String txFailureChangesDesc = "Total number of changes lost by failed transactions.";
        String txRollbackChangesDesc = "Total number of changes lost by explicit transaction rollbacks.";
        String txConflictCheckTimeDesc = "The total amount of time, in nanoseconds, spent doing conflict checks during transaction commit";
        String reliableQueuedOpsDesc = "Current number of cache operations queued for distribution to required roles.";
        String reliableQueueSizeDesc = "Current size in megabytes of disk used to queue for distribution to required roles.";
        String reliableQueueMaxDesc = "Maximum size in megabytes allotted for disk usage to queue for distribution to required roles.";
        String reliableRegionsDesc = "Current number of regions configured for reliability.";
        String reliableRegionsMissingDesc = "Current number regions configured for reliability that are missing required roles.";
        String reliableRegionsQueuingDesc = "Current number regions configured for reliability that are queuing for required roles.";
        String reliableRegionsMissingFullAccessDesc = "Current number of regions configured for reliablity that are missing require roles with full access";
        String reliableRegionsMissingLimitedAccessDesc = "Current number of regions configured for reliablity that are missing required roles with Limited access";
        String reliableRegionsMissingNoAccessDesc = "Current number of regions configured for reliablity that are missing required roles with No access";
        String clearsDesc = "The total number of times a clear has been done on this cache.";
        String nonSingleHopsDesc = "Total number of times client request observed more than one hop during operation.";
        String metaDataRefreshCountDesc = "Total number of times the meta data is refreshed due to hopping obsevred.";
        String conflatedEventsDesc = "Number of events not delivered due to conflation.  Typically this means that the event arrived after a later event was already applied to the cache.";
        String tombstoneCountDesc = "Number of destroyed entries that are retained for concurrent modification detection";
        String tombstoneGCCountDesc = "Number of garbage-collections performed on destroyed entries";
        String tombstoneOverhead1Desc = "Amount of memory consumed by destroyed entries in replicated or partitioned regions";
        String tombstoneOverhead2Desc = "Amount of memory consumed by destroyed entries in non-replicated regions";
        String clearTimeoutsDesc = "Number of timeouts waiting for events concurrent to a clear() operation to be received and applied before performing the clear()";
        String deltaUpdatesDesc = "The total number of times entries in this cache are updated through delta bytes.";
        String deltaUpdatesTimeDesc = "Total time spent applying the received delta bytes to entries in this cache.";
        String deltaFailedUpdatesDesc = "The total number of times entries in this cache failed to be updated through delta bytes.";
        String deltasPreparedDesc = "The total number of times delta was prepared in this cache.";
        String deltasPreparedTimeDesc = "Total time spent preparing delta bytes in this cache.";
        String deltasSentDesc = "The total number of times delta was sent to remote caches. This excludes deltas sent from server to client.";
        String deltaFullValuesSentDesc = "The total number of times a full value was sent to a remote cache.";
        String deltaFullValuesRequestedDesc = "The total number of times a full value was requested by this cache.";
        String importedEntriesCountDesc = "The total number of entries imported from a snapshot file.";
        String importTimeDesc = "The total time spent importing entries from a snapshot file.";
        String exportedEntriesCountDesc = "The total number of entries exported into a snapshot file.";
        String exportTimeDesc = "The total time spent exporting entries into a snapshot file.";
        String compressionCompressTimeDesc = "The total time spent compressing data.";
        String compressionDecompressTimeDesc = "The total time spent decompressing data.";
        String compressionCompressionsDesc = "The total number of compression operations.";
        String compressionDecompressionsDesc = "The total number of decompression operations.";
        String compressionPreCompresssedBytesDesc = "The total number of bytes before compressing.";
        String compressionPostCompressedBytesDesc = "The total number of bytes after compressing.";
        String evictByCriteria_evictionsDesc = "The total number of entries evicted";
        String evictByCriteria_evictionTimeDesc = "Time taken for eviction process";
        String evictByCriteria_evictionsInProgressDesc = "Total number of evictions in progress";
        String evictByCriteria_evaluationsDesc = "Total number of evaluations for eviction";
        String evictByCriteria_evaluationTimeDesc = "Total time taken for evaluation of user expression during eviction";
        type = f.createType("CachePerfStats", "Statistics about GemFire cache performance", new StatisticDescriptor[]{f.createIntGauge("loadsInProgress", "Current number of threads in this cache doing a cache load.", "operations"), f.createIntCounter("loadsCompleted", "Total number of times a load on this cache has completed (as a result of either a local get() or a remote netload).", "operations"), f.createLongCounter("loadTime", "Total time spent invoking loaders on this cache.", "nanoseconds", false), f.createIntGauge("netloadsInProgress", "Current number of threads doing a network load initiated by a get() in this cache.", "operations"), f.createIntCounter("netloadsCompleted", "Total number of times a network load initiated on this cache has completed.", "operations"), f.createLongCounter("netloadTime", "Total time spent doing network loads on this cache.", "nanoseconds", false), f.createIntGauge("netsearchesInProgress", "Current number of threads doing a network search initiated by a get() in this cache.", "operations"), f.createIntCounter("netsearchesCompleted", "Total number of times network searches initiated by this cache have completed.", "operations"), f.createLongCounter("netsearchTime", "Total time spent doing network searches for cache values.", "nanoseconds"), f.createIntGauge("cacheWriterCallsInProgress", "Current number of threads doing a cache writer call.", "operations"), f.createIntCounter("cacheWriterCallsCompleted", "Total number of times a cache writer call has completed.", "operations"), f.createLongCounter("cacheWriterCallTime", "Total time spent doing cache writer calls.", "nanoseconds"), f.createIntGauge("cacheListenerCallsInProgress", "Current number of threads doing a cache listener call.", "operations"), f.createIntCounter("cacheListenerCallsCompleted", "Total number of times a cache listener call has completed.", "operations"), f.createLongCounter("cacheListenerCallTime", "Total time spent doing cache listener calls.", "nanoseconds"), f.createIntGauge("indexUpdateInProgress", "Current number of ops in progress", "operations"), f.createIntCounter("indexUpdateCompleted", "Total number of ops that have completed", "operations"), f.createLongCounter("indexUpdateTime", "Total amount of time spent doing this op", "nanoseconds"), f.createIntGauge("indexInitializationInProgress", "Current number of index initializations in progress", "operations"), f.createIntCounter("indexInitializationCompleted", "Total number of index initializations that have completed", "operations"), f.createLongCounter("indexInitializationTime", "Total amount of time spent initializing indexes", "nanoseconds"), f.createIntGauge("getInitialImagesInProgress", "Current number of getInitialImage operations currently in progress.", "operations"), f.createIntCounter("getInitialImagesCompleted", "Total number of times getInitialImages (both delta and full GII) initiated by this cache have completed.", "operations"), f.createIntCounter("deltaGetInitialImagesCompleted", "Total number of times delta getInitialImages initiated by this cache have completed.", "operations"), f.createLongCounter("getInitialImageTime", "Total time spent doing getInitialImages for region creation.", "nanoseconds"), f.createIntCounter("getInitialImageKeysReceived", "Total number of keys received while doing getInitialImage operations.", "keys"), f.createIntGauge("regions", "The current number of regions in the cache.", "regions"), f.createIntGauge("partitionedRegions", "The current number of partitioned regions in the cache.", "partitionedRegions"), f.createIntCounter("destroys", "The total number of times a cache object entry has been destroyed in this cache.", "operations"), f.createIntCounter("updates", "The total number of updates originating remotely that have been applied to this cache.", "operations"), f.createLongCounter("updateTime", "Total time spent performing an update.", "nanoseconds"), f.createIntCounter("invalidates", "The total number of times an existing cache object entry value in this cache has been invalidated", "operations"), f.createIntCounter("gets", "The total number of times a successful get has been done on this cache.", "operations"), f.createIntCounter("misses", "Total number of times a get on the cache did not find a value already in local memory. The number of hits (i.e. gets that did not miss) can be calculated by subtracting misses from gets.", "operations"), f.createIntCounter("creates", "The total number of times an entry is added to this cache.", "operations"), f.createIntCounter("puts", "The total number of times an entry is added or replaced in this cache as a result of a local operation (put(), create(), or get() which results in load, netsearch, or netloading a value). Note that this only counts puts done explicitly on this cache. It does not count updates pushed from other caches.", "operations"), f.createLongCounter("putTime", "Total time spent adding or replacing an entry in this cache as a result of a local operation.  This includes synchronizing on the map, invoking cache callbacks, sending messages to other caches and waiting for responses (if required).", "nanoseconds", false), f.createIntCounter("putalls", "The total number of times a map is added or replaced in this cache as a result of a local operation. Note that this only counts putAlls done explicitly on this cache. It does not count updates pushed from other caches.", "operations"), f.createLongCounter("putallTime", "Total time spent replacing a map in this cache as a result of a local operation.  This includes synchronizing on the map, invoking cache callbacks, sending messages to other caches and waiting for responses (if required).", "nanoseconds", false), f.createIntCounter("removeAlls", "The total number of removeAll operations that originated in this cache. Note that this only counts removeAlls done explicitly on this cache. It does not count removes pushed from other caches.", "operations"), f.createLongCounter("removeAllTime", "Total time spent performing removeAlls that originated in this cache. This includes time spent waiting for the removeAll to be done in remote caches (if required).", "nanoseconds", false), f.createLongCounter("getTime", "Total time spent doing get operations from this cache (including netsearch and netload)", "nanoseconds", false), f.createIntGauge("eventQueueSize", "The number of cache events waiting to be processed.", "messages"), f.createIntGauge("eventQueueThrottleCount", "The total number of times a thread was delayed in adding an event to the event queue.", "delays"), f.createLongCounter("eventQueueThrottleTime", "The total amount of time, in nanoseconds, spent delayed by the event queue throttle.", "nanoseconds", false), f.createIntGauge("eventThreads", "The number of threads currently processing events.", "threads"), f.createIntCounter("queryExecutions", "Total number of times some query has been executed", "operations"), f.createLongCounter("queryExecutionTime", "Total time spent executing queries", "nanoseconds"), f.createIntCounter("queryResultsHashCollisions", "Total number of times an hash code collision occurred when inserting an object into an OQL result set or rehashing it", "operations"), f.createLongCounter("queryResultsHashCollisionProbeTime", "Total time spent probing the hashtable in an OQL result set due to hash code collisions, includes reads, writes, and rehashes", "nanoseconds"), f.createLongCounter("partitionedRegionQueryRetries", "Total number of times an OQL Query on a Partitioned Region had to be retried", "retries"), f.createIntCounter("txCommits", "Total number times a transaction commit has succeeded.", "commits"), f.createIntCounter("txCommitChanges", "Total number of changes made by committed transactions.", "changes"), f.createLongCounter("txCommitTime", "The total amount of time, in nanoseconds, spent doing successful transaction commits.", "nanoseconds", false), f.createLongCounter("txSuccessLifeTime", "The total amount of time, in nanoseconds, spent in a transaction before a successful commit. The time measured starts at transaction begin and ends when commit is called.", "nanoseconds", false), f.createIntCounter("txFailures", "Total number times a transaction commit has failed.", "failures"), f.createIntCounter("txFailureChanges", "Total number of changes lost by failed transactions.", "changes"), f.createLongCounter("txFailureTime", "The total amount of time, in nanoseconds, spent doing failed transaction commits.", "nanoseconds", false), f.createLongCounter("txFailedLifeTime", "The total amount of time, in nanoseconds, spent in a transaction before a failed commit. The time measured starts at transaction begin and ends when commit is called.", "nanoseconds", false), f.createIntCounter("txRollbacks", "Total number times a transaction has been explicitly rolled back.", "rollbacks"), f.createIntCounter("txRollbackChanges", "Total number of changes lost by explicit transaction rollbacks.", "changes"), f.createLongCounter("txRollbackTime", "The total amount of time, in nanoseconds, spent doing explicit transaction rollbacks.", "nanoseconds", false), f.createLongCounter("txRollbackLifeTime", "The total amount of time, in nanoseconds, spent in a transaction before an explicit rollback. The time measured starts at transaction begin and ends when rollback is called.", "nanoseconds", false), f.createLongCounter("txConflictCheckTime", "The total amount of time, in nanoseconds, spent doing conflict checks during transaction commit", "nanoseconds", false), f.createIntGauge("reliableQueuedOps", "Current number of cache operations queued for distribution to required roles.", "operations"), f.createIntGauge("reliableQueueSize", "Current size in megabytes of disk used to queue for distribution to required roles.", "megabytes"), f.createIntGauge("reliableQueueMax", "Maximum size in megabytes allotted for disk usage to queue for distribution to required roles.", "megabytes"), f.createIntGauge("reliableRegions", "Current number of regions configured for reliability.", "regions"), f.createIntGauge("reliableRegionsMissing", "Current number regions configured for reliability that are missing required roles.", "regions"), f.createIntGauge("reliableRegionsQueuing", "Current number regions configured for reliability that are queuing for required roles.", "regions"), f.createIntGauge("reliableRegionsMissingFullAccess", "Current number of regions configured for reliablity that are missing require roles with full access", "regions"), f.createIntGauge("reliableRegionsMissingLimitedAccess", "Current number of regions configured for reliablity that are missing required roles with Limited access", "regions"), f.createIntGauge("reliableRegionsMissingNoAccess", "Current number of regions configured for reliablity that are missing required roles with No access", "regions"), f.createLongGauge("entries", "Current number of entries in the cache. This does not include any entries that are tombstones. See tombstoneCount.", "entries"), f.createLongCounter("eventsQueued", "Number of events attached to other events for callback invocation", "events"), f.createIntCounter("retries", "Number of times a concurrent destroy followed by a create has caused an entry operation to need to retry.", "operations"), f.createIntCounter("clears", "The total number of times a clear has been done on this cache.", "operations"), f.createIntGauge("diskTasksWaiting", "Current number of disk tasks (oplog compactions, asynchronous recoveries, etc) that are waiting for a thread to run the operation", "operations"), f.createLongCounter("conflatedEvents", "Number of events not delivered due to conflation.  Typically this means that the event arrived after a later event was already applied to the cache.", "operations"), f.createIntGauge("tombstones", "Number of destroyed entries that are retained for concurrent modification detection", "entries"), f.createIntCounter("tombstoneGCs", "Number of garbage-collections performed on destroyed entries", "operations"), f.createLongGauge("replicatedTombstonesSize", "Amount of memory consumed by destroyed entries in replicated or partitioned regions", "bytes"), f.createLongGauge("nonReplicatedTombstonesSize", "Amount of memory consumed by destroyed entries in non-replicated regions", "bytes"), f.createIntCounter("clearTimeouts", "Number of timeouts waiting for events concurrent to a clear() operation to be received and applied before performing the clear()", "timeouts"), f.createIntGauge("evictorJobsStarted", "Number of evictor jobs started", "jobs"), f.createIntGauge("evictorJobsCompleted", "Number of evictor jobs completed", "jobs"), f.createIntGauge("evictorQueueSize", "Number of jobs waiting to be picked up by evictor threads", "jobs"), f.createLongCounter("evictWorkTime", "Total time spent doing eviction work in background threads", "nanoseconds", false), f.createLongCounter("nonSingleHopsCount", "Total number of times client request observed more than one hop during operation.", "Total number of times client request observed more than one hop during operation.", false), f.createLongCounter("metaDataRefreshCount", "Total number of times the meta data is refreshed due to hopping obsevred.", "Total number of times the meta data is refreshed due to hopping.", false), f.createIntCounter("deltaUpdates", "The total number of times entries in this cache are updated through delta bytes.", "operations"), f.createLongCounter("deltaUpdatesTime", "Total time spent applying the received delta bytes to entries in this cache.", "nanoseconds", false), f.createIntCounter("deltaFailedUpdates", "The total number of times entries in this cache failed to be updated through delta bytes.", "operations"), f.createIntCounter("deltasPrepared", "The total number of times delta was prepared in this cache.", "operations"), f.createLongCounter("deltasPreparedTime", "Total time spent preparing delta bytes in this cache.", "nanoseconds", false), f.createIntCounter("deltasSent", "The total number of times delta was sent to remote caches. This excludes deltas sent from server to client.", "operations"), f.createIntCounter("deltaFullValuesSent", "The total number of times a full value was sent to a remote cache.", "operations"), f.createIntCounter("deltaFullValuesRequested", "The total number of times a full value was requested by this cache.", "operations"), f.createLongCounter("importedEntries", "The total number of entries imported from a snapshot file.", "entries"), f.createLongCounter("importTime", "The total time spent importing entries from a snapshot file.", "nanoseconds"), f.createLongCounter("exportedEntries", "The total number of entries exported into a snapshot file.", "entries"), f.createLongCounter("exportTime", "The total time spent exporting entries into a snapshot file.", "nanoseconds"), f.createLongCounter("compressTime", "The total time spent compressing data.", "nanoseconds"), f.createLongCounter("decompressTime", "The total time spent decompressing data.", "nanoseconds"), f.createLongCounter("compressions", "The total number of compression operations.", "operations"), f.createLongCounter("decompressions", "The total number of decompression operations.", "operations"), f.createLongCounter("preCompressedBytes", "The total number of bytes before compressing.", "bytes"), f.createLongCounter("postCompressedBytes", "The total number of bytes after compressing.", "bytes"), f.createLongCounter("evictByCriteria_evictions", "The total number of entries evicted", "operations"), f.createLongCounter("evictByCriteria_evictionTime", "Time taken for eviction process", "nanoseconds"), f.createLongCounter("evictByCriteria_evictionsInProgress", "Total number of evictions in progress", "operations"), f.createLongCounter("evictByCriteria_evaluations", "Total number of evaluations for eviction", "operations"), f.createLongCounter("evictByCriteria_evaluationTime", "Total time taken for evaluation of user expression during eviction", "nanoseconds")});
        loadsInProgressId = type.nameToId("loadsInProgress");
        loadsCompletedId = type.nameToId("loadsCompleted");
        loadTimeId = type.nameToId("loadTime");
        netloadsInProgressId = type.nameToId("netloadsInProgress");
        netloadsCompletedId = type.nameToId("netloadsCompleted");
        netloadTimeId = type.nameToId("netloadTime");
        netsearchesInProgressId = type.nameToId("netsearchesInProgress");
        netsearchesCompletedId = type.nameToId("netsearchesCompleted");
        netsearchTimeId = type.nameToId("netsearchTime");
        cacheWriterCallsInProgressId = type.nameToId("cacheWriterCallsInProgress");
        cacheWriterCallsCompletedId = type.nameToId("cacheWriterCallsCompleted");
        cacheWriterCallTimeId = type.nameToId("cacheWriterCallTime");
        cacheListenerCallsInProgressId = type.nameToId("cacheListenerCallsInProgress");
        cacheListenerCallsCompletedId = type.nameToId("cacheListenerCallsCompleted");
        cacheListenerCallTimeId = type.nameToId("cacheListenerCallTime");
        indexUpdateInProgressId = type.nameToId("indexUpdateInProgress");
        indexUpdateCompletedId = type.nameToId("indexUpdateCompleted");
        indexUpdateTimeId = type.nameToId("indexUpdateTime");
        indexInitializationTimeId = type.nameToId("indexInitializationTime");
        indexInitializationInProgressId = type.nameToId("indexInitializationInProgress");
        indexInitializationCompletedId = type.nameToId("indexInitializationCompleted");
        getInitialImagesInProgressId = type.nameToId("getInitialImagesInProgress");
        getInitialImagesCompletedId = type.nameToId("getInitialImagesCompleted");
        deltaGetInitialImagesCompletedId = type.nameToId("deltaGetInitialImagesCompleted");
        getInitialImageTimeId = type.nameToId("getInitialImageTime");
        getInitialImageKeysReceivedId = type.nameToId("getInitialImageKeysReceived");
        regionsId = type.nameToId("regions");
        partitionedRegionsId = type.nameToId("partitionedRegions");
        destroysId = type.nameToId("destroys");
        createsId = type.nameToId("creates");
        putsId = type.nameToId("puts");
        putTimeId = type.nameToId("putTime");
        putallsId = type.nameToId("putalls");
        putallTimeId = type.nameToId("putallTime");
        removeAllsId = type.nameToId("removeAlls");
        removeAllTimeId = type.nameToId("removeAllTime");
        updatesId = type.nameToId("updates");
        updateTimeId = type.nameToId("updateTime");
        invalidatesId = type.nameToId("invalidates");
        getsId = type.nameToId("gets");
        getTimeId = type.nameToId("getTime");
        missesId = type.nameToId("misses");
        eventQueueSizeId = type.nameToId("eventQueueSize");
        eventQueueThrottleTimeId = type.nameToId("eventQueueThrottleTime");
        eventQueueThrottleCountId = type.nameToId("eventQueueThrottleCount");
        eventThreadsId = type.nameToId("eventThreads");
        queryExecutionsId = type.nameToId("queryExecutions");
        queryExecutionTimeId = type.nameToId("queryExecutionTime");
        queryResultsHashCollisionsId = type.nameToId("queryResultsHashCollisions");
        queryResultsHashCollisionProbeTimeId = type.nameToId("queryResultsHashCollisionProbeTime");
        partitionedRegionQueryRetriesId = type.nameToId("partitionedRegionQueryRetries");
        txSuccessLifeTimeId = type.nameToId("txSuccessLifeTime");
        txFailedLifeTimeId = type.nameToId("txFailedLifeTime");
        txRollbackLifeTimeId = type.nameToId("txRollbackLifeTime");
        txCommitsId = type.nameToId("txCommits");
        txFailuresId = type.nameToId("txFailures");
        txRollbacksId = type.nameToId("txRollbacks");
        txCommitTimeId = type.nameToId("txCommitTime");
        txFailureTimeId = type.nameToId("txFailureTime");
        txRollbackTimeId = type.nameToId("txRollbackTime");
        txCommitChangesId = type.nameToId("txCommitChanges");
        txFailureChangesId = type.nameToId("txFailureChanges");
        txRollbackChangesId = type.nameToId("txRollbackChanges");
        txConflictCheckTimeId = type.nameToId("txConflictCheckTime");
        reliableQueuedOpsId = type.nameToId("reliableQueuedOps");
        reliableQueueSizeId = type.nameToId("reliableQueueSize");
        reliableQueueMaxId = type.nameToId("reliableQueueMax");
        reliableRegionsId = type.nameToId("reliableRegions");
        reliableRegionsMissingId = type.nameToId("reliableRegionsMissing");
        reliableRegionsQueuingId = type.nameToId("reliableRegionsQueuing");
        reliableRegionsMissingFullAccessId = type.nameToId("reliableRegionsMissingFullAccess");
        reliableRegionsMissingLimitedAccessId = type.nameToId("reliableRegionsMissingLimitedAccess");
        reliableRegionsMissingNoAccessId = type.nameToId("reliableRegionsMissingNoAccess");
        entryCountId = type.nameToId("entries");
        eventsQueuedId = type.nameToId("eventsQueued");
        retriesId = type.nameToId("retries");
        clearsId = type.nameToId("clears");
        diskTasksWaitingId = type.nameToId("diskTasksWaiting");
        evictorJobsStartedId = type.nameToId("evictorJobsStarted");
        evictorJobsCompletedId = type.nameToId("evictorJobsCompleted");
        evictorQueueSizeId = type.nameToId("evictorQueueSize");
        evictWorkTimeId = type.nameToId("evictWorkTime");
        nonSingleHopsCountId = type.nameToId("nonSingleHopsCount");
        metaDataRefreshCountId = type.nameToId("metaDataRefreshCount");
        conflatedEventsId = type.nameToId("conflatedEvents");
        tombstoneCountId = type.nameToId("tombstones");
        tombstoneGCCountId = type.nameToId("tombstoneGCs");
        tombstoneOverhead1Id = type.nameToId("replicatedTombstonesSize");
        tombstoneOverhead2Id = type.nameToId("nonReplicatedTombstonesSize");
        clearTimeoutsId = type.nameToId("clearTimeouts");
        deltaUpdatesId = type.nameToId("deltaUpdates");
        deltaUpdatesTimeId = type.nameToId("deltaUpdatesTime");
        deltaFailedUpdatesId = type.nameToId("deltaFailedUpdates");
        deltasPreparedId = type.nameToId("deltasPrepared");
        deltasPreparedTimeId = type.nameToId("deltasPreparedTime");
        deltasSentId = type.nameToId("deltasSent");
        deltaFullValuesSentId = type.nameToId("deltaFullValuesSent");
        deltaFullValuesRequestedId = type.nameToId("deltaFullValuesRequested");
        importedEntriesCountId = type.nameToId("importedEntries");
        importTimeId = type.nameToId("importTime");
        exportedEntriesCountId = type.nameToId("exportedEntries");
        exportTimeId = type.nameToId("exportTime");
        compressionCompressTimeId = type.nameToId("compressTime");
        compressionDecompressTimeId = type.nameToId("decompressTime");
        compressionCompressionsId = type.nameToId("compressions");
        compressionDecompressionsId = type.nameToId("decompressions");
        compressionPreCompressedBytesId = type.nameToId("preCompressedBytes");
        compressionPostCompressedBytesId = type.nameToId("postCompressedBytes");
        evictByCriteria_evictionsId = type.nameToId("evictByCriteria_evictions");
        evictByCriteria_evictionTimeId = type.nameToId("evictByCriteria_evictionTime");
        evictByCriteria_evictionsInProgressId = type.nameToId("evictByCriteria_evictionsInProgress");
        evictByCriteria_evaluationsId = type.nameToId("evictByCriteria_evaluations");
        evictByCriteria_evaluationTimeId = type.nameToId("evictByCriteria_evaluationTime");
    }
}

