/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.InterestPolicy;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.SubscriptionAttributes;
import com.gemstone.gemfire.distributed.Role;
import com.gemstone.gemfire.distributed.internal.DistributionAdvisor;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.MembershipListener;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.CacheDistributionAdvisee;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.FilterProfile;
import com.gemstone.gemfire.internal.cache.FilterRoutingInfo;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.ImageState;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.gemstone.gemfire.internal.cache.partitioned.PRLocallyDestroyedException;
import com.gemstone.gemfire.internal.cache.persistence.DiskStoreID;
import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberID;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class CacheDistributionAdvisor
extends DistributionAdvisor {
    private static final Logger logger = LogService.getLogger();
    private static final int INTEREST_MASK = 1;
    private static final int REPLICATE_MASK = 2;
    private static final int LOADER_MASK = 4;
    private static final int WRITER_MASK = 8;
    private static final int LISTENER_MASK = 16;
    private static final int DIST_ACK_MASK = 32;
    private static final int GLOBAL_MASK = 64;
    private static final int IN_RECOVERY_MASK = 128;
    private static final int PERSISTENT_MASK = 256;
    private static final int PROXY_MASK = 512;
    private static final int PRELOADED_MASK = 1024;
    private static final int IS_PARTITIONED_MASK = 2048;
    private static final int REGION_INITIALIZED_MASK = 4096;
    private static final int IS_GATEWAY_ENABLED_MASK = 8192;
    private static final int PERSISTENT_ID_MASK = 16384;
    protected static final int REQUIRES_NOTIFICATION_MASK = 32768;
    private static final int HAS_CACHE_SERVER_MASK = 65536;
    private static final int REQUIRES_OLD_VALUE_MASK = 131072;
    private static final int MEMBER_UNINITIALIZED_MASK = 262144;
    private static final int PERSISTENCE_INITIALIZED_MASK = 524288;
    private static final int GATEWAY_SENDER_IDS_MASK = 0x200000;
    private static final int ASYNC_EVENT_QUEUE_IDS_MASK = 0x400000;
    private static final int IS_OFF_HEAP_MASK = 0x800000;

    protected CacheDistributionAdvisor(CacheDistributionAdvisee region) {
        super(region);
    }

    public static CacheDistributionAdvisor createCacheDistributionAdvisor(CacheDistributionAdvisee region) {
        CacheDistributionAdvisor advisor = new CacheDistributionAdvisor(region);
        advisor.initialize();
        return advisor;
    }

    public String toString() {
        return "CacheDistributionAdvisor for region " + this.getAdvisee().getFullPath();
    }

    private Set adviseAllEventsOrCached(final boolean excludeInRecovery) throws IllegalStateException {
        this.getAdvisee().getCancelCriterion().checkCancelInProgress(null);
        return this.adviseFilter(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                assert (profile instanceof CacheProfile);
                CacheProfile cp = (CacheProfile)profile;
                if (excludeInRecovery && cp.inRecovery) {
                    return false;
                }
                return cp.cachedOrAllEventsWithListener();
            }
        });
    }

    Set adviseUpdate(EntryEventImpl event) throws IllegalStateException {
        if (event.hasNewValue() || event.getOperation().isPutAll()) {
            return this.adviseAllEventsOrCached(true);
        }
        return this.adviseFilter(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                assert (profile instanceof CacheProfile);
                CacheProfile cp = (CacheProfile)profile;
                DataPolicy dp = cp.dataPolicy;
                return dp.withReplication() || cp.allEvents() && (dp.withStorage() || cp.hasCacheListener);
            }
        });
    }

    public Set<InternalDistributedMember> adviseTX() throws IllegalStateException {
        boolean isMetaDataWithTransactions = this.getAdvisee() instanceof LocalRegion && ((LocalRegion)((Object)this.getAdvisee())).isMetaRegionWithTransactions();
        Set<Object> badList = Collections.emptySet();
        if (!TXManagerImpl.ALLOW_PERSISTENT_TRANSACTIONS && !isMetaDataWithTransactions) {
            badList = this.adviseFilter(new DistributionAdvisor.Filter(){

                @Override
                public boolean include(DistributionAdvisor.Profile profile) {
                    assert (profile instanceof CacheProfile);
                    CacheProfile prof = (CacheProfile)profile;
                    return prof.isPersistent();
                }
            });
        }
        if (badList.isEmpty()) {
            return this.adviseFilter(new DistributionAdvisor.Filter(){

                @Override
                public boolean include(DistributionAdvisor.Profile profile) {
                    assert (profile instanceof CacheProfile);
                    CacheProfile cp = (CacheProfile)profile;
                    return cp.cachedOrAllEvents();
                }
            });
        }
        StringBuffer badIds = new StringBuffer();
        Iterator biI = badList.iterator();
        while (biI.hasNext()) {
            badIds.append(biI.next().toString());
            if (!biI.hasNext()) continue;
            badIds.append(", ");
        }
        throw new IllegalStateException(LocalizedStrings.CacheDistributionAdvisor_ILLEGAL_REGION_CONFIGURATION_FOR_MEMBERS_0.toLocalizedString(badIds.toString()));
    }

    public Set adviseNetLoad() {
        return this.adviseFilter(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                assert (profile instanceof CacheProfile);
                CacheProfile prof = (CacheProfile)profile;
                if (!prof.regionInitialized || prof.memberUnInitialized) {
                    return false;
                }
                return prof.hasCacheLoader;
            }
        });
    }

    public FilterRoutingInfo adviseFilterRouting(CacheEvent event, Set cacheOpRecipients) {
        FilterProfile fp = ((LocalRegion)event.getRegion()).getFilterProfile();
        if (fp != null) {
            return fp.getFilterRoutingInfoPart1(event, this.profiles, cacheOpRecipients);
        }
        return null;
    }

    public Set adviseCacheOp() {
        return this.adviseAllEventsOrCached(true);
    }

    public Set adviseCacheOpRole(final Role role) {
        return this.adviseFilter(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                assert (profile instanceof CacheProfile);
                CacheProfile cp = (CacheProfile)profile;
                if (!cp.regionInitialized) {
                    return false;
                }
                if (cp.memberUnInitialized) {
                    return false;
                }
                if (!cp.cachedOrAllEventsWithListener()) {
                    return false;
                }
                return cp.getDistributedMember().getRoles().contains(role);
            }
        });
    }

    public Set adviseInvalidateRegion() {
        return this.adviseFilter(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                assert (profile instanceof CacheProfile);
                CacheProfile cp = (CacheProfile)profile;
                return !cp.inRecovery;
            }
        });
    }

    public Set adviseDestroyRegion() {
        return this.adviseGeneric();
    }

    public Set adviseNetWrite() {
        return this.adviseFilter(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                assert (profile instanceof CacheProfile);
                CacheProfile prof = (CacheProfile)profile;
                if (prof.inRecovery) {
                    return false;
                }
                return prof.hasCacheWriter;
            }
        });
    }

    public Set<InternalDistributedMember> adviseInitializedReplicates() {
        return this.adviseFilter(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                assert (profile instanceof CacheProfile);
                CacheProfile cp = (CacheProfile)profile;
                return cp.dataPolicy.withReplication() && cp.regionInitialized && !cp.memberUnInitialized;
            }
        });
    }

    public Set adviseNetSearch() {
        return this.adviseFilter(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                assert (profile instanceof CacheProfile);
                CacheProfile cp = (CacheProfile)profile;
                if (!cp.regionInitialized) {
                    return false;
                }
                if (cp.memberUnInitialized) {
                    return false;
                }
                DataPolicy dp = cp.dataPolicy;
                return dp.withStorage();
            }
        });
    }

    public InitialImageAdvice adviseInitialImage(InitialImageAdvice previousAdvice) {
        return this.adviseInitialImage(previousAdvice, false);
    }

    public InitialImageAdvice adviseInitialImage(InitialImageAdvice previousAdvice, boolean persistent) {
        DistributionAdvisor.Profile[] allProfiles;
        this.initializationGate();
        if (logger.isTraceEnabled(LogMarker.DA)) {
            this.dumpProfiles("AdviseInitialImage");
        }
        if ((allProfiles = this.profiles).length == 0) {
            return new InitialImageAdvice();
        }
        HashSet<InternalDistributedMember> replicates = new HashSet<InternalDistributedMember>();
        HashSet<InternalDistributedMember> others = new HashSet<InternalDistributedMember>();
        HashSet<InternalDistributedMember> preloaded = new HashSet<InternalDistributedMember>();
        HashSet<InternalDistributedMember> empties = new HashSet<InternalDistributedMember>();
        HashSet<InternalDistributedMember> uninitialized = new HashSet<InternalDistributedMember>();
        HashSet<InternalDistributedMember> nonPersistent = new HashSet<InternalDistributedMember>();
        HashMap<InternalDistributedMember, CacheProfile> memberProfiles = new HashMap<InternalDistributedMember, CacheProfile>();
        for (int i = 0; i < allProfiles.length; ++i) {
            CacheProfile previousProfile;
            CacheProfile profile = (CacheProfile)allProfiles[i];
            if (previousAdvice != null && (previousProfile = (CacheProfile)previousAdvice.memberProfiles.get(profile.getDistributedMember())) != null && previousProfile.getSerialNumber() == profile.getSerialNumber() && previousProfile.getVersion() == profile.getVersion()) continue;
            if (profile.inRecovery) {
                uninitialized.add(profile.getDistributedMember());
                continue;
            }
            if (!profile.regionInitialized) {
                uninitialized.add(profile.getDistributedMember());
                continue;
            }
            if (profile.dataPolicy.withReplication()) {
                if (!persistent || profile.dataPolicy.withPersistence()) {
                    replicates.add(profile.getDistributedMember());
                } else {
                    nonPersistent.add(profile.getDistributedMember());
                }
                memberProfiles.put(profile.getDistributedMember(), profile);
                continue;
            }
            if (profile.dataPolicy.isPreloaded()) {
                preloaded.add(profile.getDistributedMember());
                memberProfiles.put(profile.getDistributedMember(), profile);
                continue;
            }
            if (profile.dataPolicy.withStorage()) {
                others.add(profile.getDistributedMember());
                memberProfiles.put(profile.getDistributedMember(), profile);
                continue;
            }
            empties.add(profile.getDistributedMember());
        }
        InitialImageAdvice advice = new InitialImageAdvice(replicates, others, preloaded, empties, uninitialized, nonPersistent, memberProfiles);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)advice);
        }
        return advice;
    }

    public Set adviseRequiresOldValueInCacheOp() {
        return this.adviseFilter(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                assert (profile instanceof CacheProfile);
                CacheProfile cp = (CacheProfile)profile;
                return cp.requiresOldValueInEvents && !cp.regionInitialized;
            }
        });
    }

    @Override
    protected DistributionAdvisor.Profile instantiateProfile(InternalDistributedMember memberId, int version) {
        return new CacheProfile(memberId, version);
    }

    @Override
    protected boolean evaluateProfiles(DistributionAdvisor.Profile newProfile, DistributionAdvisor.Profile oldProfile) {
        boolean result = super.evaluateProfiles(newProfile, oldProfile);
        if (result) {
            CacheProfile newCP = (CacheProfile)newProfile;
            CacheProfile oldCP = (CacheProfile)oldProfile;
            if ((oldCP == null || !oldCP.regionInitialized) && newCP.regionInitialized) {
                CacheDistributionAdvisee advisee = (CacheDistributionAdvisee)this.getAdvisee();
                advisee.remoteRegionInitialized(newCP);
            }
        }
        return result;
    }

    public Set adviseNewReplicates(final Set oldRecipients) {
        return this.adviseFilter(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                assert (profile instanceof CacheProfile);
                CacheProfile cp = (CacheProfile)profile;
                return cp.dataPolicy.withReplication() && !oldRecipients.contains(cp.getDistributedMember());
            }
        });
    }

    public Set<InternalDistributedMember> adviseReplicates() {
        return this.adviseFilter(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                assert (profile instanceof CacheProfile);
                CacheProfile cp = (CacheProfile)profile;
                return cp.dataPolicy.withReplication();
            }
        });
    }

    public Set advisePreloadeds() {
        return this.adviseFilter(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                assert (profile instanceof CacheProfile);
                CacheProfile cp = (CacheProfile)profile;
                return cp.dataPolicy.withPreloaded();
            }
        });
    }

    public Set adviseEmptys() {
        return this.adviseFilter(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                assert (profile instanceof CacheProfile);
                CacheProfile cp = (CacheProfile)profile;
                return cp.dataPolicy.isEmpty();
            }
        });
    }

    public Set adviseNormals() {
        return this.adviseFilter(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                assert (profile instanceof CacheProfile);
                CacheProfile cp = (CacheProfile)profile;
                return cp.dataPolicy.isNormal();
            }
        });
    }

    @Override
    protected void profileRemoved(DistributionAdvisor.Profile profile) {
        if (logger.isDebugEnabled()) {
            logger.debug("CDA: removing profile {}", new Object[]{profile});
        }
        if (this.getAdvisee() instanceof LocalRegion && profile != null) {
            ((LocalRegion)((Object)this.getAdvisee())).removeMemberFromCriticalList(profile.getDistributedMember());
        }
    }

    public Map<InternalDistributedMember, PersistentMemberID> advisePersistentMembers() {
        DistributionAdvisor.Profile[] snapshot;
        this.initializationGate();
        HashMap<InternalDistributedMember, PersistentMemberID> result = new HashMap<InternalDistributedMember, PersistentMemberID>();
        for (DistributionAdvisor.Profile profile : snapshot = this.profiles) {
            CacheProfile cp = (CacheProfile)profile;
            if (cp.persistentID == null) continue;
            result.put(cp.getDistributedMember(), cp.persistentID);
        }
        return result;
    }

    public Map<InternalDistributedMember, PersistentMemberID> adviseInitializedPersistentMembers() {
        DistributionAdvisor.Profile[] snapshot;
        this.initializationGate();
        HashMap<InternalDistributedMember, PersistentMemberID> result = new HashMap<InternalDistributedMember, PersistentMemberID>();
        for (DistributionAdvisor.Profile profile : snapshot = this.profiles) {
            CacheProfile cp = (CacheProfile)profile;
            if (cp.persistentID == null || !cp.persistenceInitialized) continue;
            result.put(cp.getDistributedMember(), cp.persistentID);
        }
        return result;
    }

    public Set adviseCacheServers() {
        this.getAdvisee().getCancelCriterion().checkCancelInProgress(null);
        return this.adviseFilter(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                assert (profile instanceof CacheProfile);
                CacheProfile cp = (CacheProfile)profile;
                return cp.hasCacheServer;
            }
        });
    }

    public void addMembershipAndProxyListener(MembershipListener listener) {
        this.addMembershipListener(listener);
    }

    public void removeMembershipAndProxyListener(MembershipListener listener) {
        this.removeMembershipListener(listener);
    }

    @Override
    public boolean removeId(DistributionAdvisor.ProfileId memberId, boolean crashed, boolean destroyed, boolean fromMembershipListener) {
        DistributedRegion r;
        boolean isPersistent = false;
        DiskStoreID persistentId = null;
        CacheDistributionAdvisee advisee = (CacheDistributionAdvisee)this.getAdvisee();
        if (advisee.getAttributes().getDataPolicy().withPersistence()) {
            isPersistent = true;
            CacheProfile profile = (CacheProfile)this.getProfile(memberId);
            if (profile != null && profile.persistentID != null) {
                persistentId = ((CacheProfile)this.getProfile((DistributionAdvisor.ProfileId)memberId)).persistentID.diskStoreId;
            }
        }
        boolean result = super.removeId(memberId, crashed, destroyed, fromMembershipListener);
        if (advisee instanceof DistributedRegion && !(r = (DistributedRegion)advisee).isInitialized() && !r.isUsedForPartitionedRegionBucket()) {
            if (logger.isDebugEnabled()) {
                logger.debug("recording that {} has left during initialization of {}", new Object[]{memberId, r.getName()});
            }
            ImageState state = r.getImageState();
            if (isPersistent) {
                if (persistentId != null) {
                    state.addLeftMember(persistentId);
                }
            } else {
                state.addLeftMember((InternalDistributedMember)memberId);
            }
        }
        return result;
    }

    public List<Set<String>> adviseSameGatewaySenderIds(final Set<String> allGatewaySenderIds) {
        final ArrayList<Set<String>> differSenderIds = new ArrayList<Set<String>>();
        this.fetchProfiles(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                if (profile instanceof CacheProfile) {
                    CacheProfile cp = (CacheProfile)profile;
                    if (allGatewaySenderIds.equals(cp.gatewaySenderIds)) {
                        return true;
                    }
                    differSenderIds.add(allGatewaySenderIds);
                    differSenderIds.add(cp.gatewaySenderIds);
                    return false;
                }
                return false;
            }
        });
        return differSenderIds;
    }

    public List<Set<String>> adviseSameAsyncEventQueueIds(final Set<String> allAsyncEventIds) {
        final ArrayList<Set<String>> differAsycnQueueIds = new ArrayList<Set<String>>();
        List l = this.fetchProfiles(new DistributionAdvisor.Filter(){

            @Override
            public boolean include(DistributionAdvisor.Profile profile) {
                if (profile instanceof CacheProfile) {
                    Set<String> profileQueueIdsNoHDFS;
                    CacheProfile cp = (CacheProfile)profile;
                    Set<String> allAsyncEventIdsNoHDFS = this.removeHDFSQueues(allAsyncEventIds);
                    if (allAsyncEventIdsNoHDFS.equals(profileQueueIdsNoHDFS = this.removeHDFSQueues(cp.asyncEventQueueIds))) {
                        return true;
                    }
                    differAsycnQueueIds.add(allAsyncEventIdsNoHDFS);
                    differAsycnQueueIds.add(profileQueueIdsNoHDFS);
                    return false;
                }
                return false;
            }

            private Set<String> removeHDFSQueues(Set<String> queueIds) {
                HashSet<String> queueIdsWithoutHDFSQueues = new HashSet<String>();
                for (String queueId : queueIds) {
                    if (queueId.startsWith("HDFS_QUEUE")) continue;
                    queueIdsWithoutHDFSQueues.add(queueId);
                }
                return queueIdsWithoutHDFSQueues;
            }
        });
        return differAsycnQueueIds;
    }

    public static class InitialImageAdvice {
        protected final Set<InternalDistributedMember> replicates;
        protected final Set<InternalDistributedMember> preloaded;
        protected Set<InternalDistributedMember> others;
        protected final Set<InternalDistributedMember> empties;
        protected final Set<InternalDistributedMember> uninitialized;
        protected final Set<InternalDistributedMember> nonPersistent;
        private final Map<InternalDistributedMember, CacheProfile> memberProfiles;

        public Set<InternalDistributedMember> getOthers() {
            return this.others;
        }

        public void setOthers(Set<InternalDistributedMember> others) {
            this.others = others;
        }

        public Set<InternalDistributedMember> getReplicates() {
            return this.replicates;
        }

        public Set<InternalDistributedMember> getNonPersistent() {
            return this.nonPersistent;
        }

        public Set<InternalDistributedMember> getPreloaded() {
            return this.preloaded;
        }

        public Set<InternalDistributedMember> getEmpties() {
            return this.empties;
        }

        public Set<InternalDistributedMember> getUninitialized() {
            return this.uninitialized;
        }

        protected InitialImageAdvice(Set<InternalDistributedMember> replicates, Set<InternalDistributedMember> others, Set<InternalDistributedMember> preloaded, Set<InternalDistributedMember> empties, Set<InternalDistributedMember> uninitialized, Set<InternalDistributedMember> nonPersistent, Map<InternalDistributedMember, CacheProfile> memberProfiles) {
            this.replicates = replicates;
            this.others = others;
            this.preloaded = preloaded;
            this.empties = empties;
            this.uninitialized = uninitialized;
            this.nonPersistent = nonPersistent;
            this.memberProfiles = memberProfiles;
        }

        public InitialImageAdvice() {
            this(Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.emptyMap());
        }

        public String toString() {
            return "InitialImageAdvice(replicates=" + this.replicates + "; others=" + this.others + "; preloaded=" + this.preloaded + "; empty=" + this.empties + "; initializing=" + this.uninitialized + ")";
        }
    }

    public static class CacheProfile
    extends DistributionAdvisor.Profile {
        public DataPolicy dataPolicy = DataPolicy.REPLICATE;
        public InterestPolicy interestPolicy = InterestPolicy.DEFAULT;
        public boolean hasCacheLoader = false;
        public boolean hasCacheWriter = false;
        public boolean hasCacheListener = false;
        public Scope scope = Scope.DISTRIBUTED_NO_ACK;
        public boolean inRecovery = false;
        public Set<String> gatewaySenderIds = Collections.emptySet();
        public Set<String> asyncEventQueueIds = Collections.emptySet();
        public SubscriptionAttributes subscriptionAttributes = null;
        public boolean isPartitioned = false;
        public boolean isGatewayEnabled = false;
        public boolean isPersistent = false;
        public boolean isOffHeap = false;
        public FilterProfile filterProfile;
        public boolean requiresOldValueInEvents;
        public boolean regionInitialized;
        public boolean memberUnInitialized = false;
        public boolean persistenceInitialized;
        public PersistentMemberID persistentID;
        public boolean hasCacheServer = false;

        public CacheProfile() {
        }

        public CacheProfile(FilterProfile localProfile) {
            this.filterProfile = localProfile;
        }

        public CacheProfile(InternalDistributedMember memberId, int version) {
            super(memberId, version);
        }

        public CacheProfile(CacheProfile toCopy) {
            super(toCopy.getDistributedMember(), toCopy.version);
            this.setIntInfo(toCopy.getIntInfo());
        }

        protected int getIntInfo() {
            int s = 0;
            if (this.dataPolicy.withReplication()) {
                s |= 2;
                if (this.dataPolicy.isPersistentReplicate()) {
                    s |= 0x100;
                }
            } else {
                if (this.dataPolicy.isEmpty()) {
                    s |= 0x200;
                }
                if (this.dataPolicy.isPreloaded()) {
                    s |= 0x400;
                }
            }
            if (this.subscriptionAttributes != null && this.subscriptionAttributes.getInterestPolicy().isAll()) {
                s |= 1;
            }
            if (this.hasCacheLoader) {
                s |= 4;
            }
            if (this.hasCacheWriter) {
                s |= 8;
            }
            if (this.hasCacheListener) {
                s |= 0x10;
            }
            if (this.scope.isDistributedAck()) {
                s |= 0x20;
            }
            if (this.scope.isGlobal()) {
                s |= 0x40;
            }
            if (this.inRecovery) {
                s |= 0x80;
            }
            if (this.isPartitioned) {
                s |= 0x800;
            }
            if (this.isGatewayEnabled) {
                s |= 0x2000;
            }
            if (this.isPersistent) {
                s |= 0x100;
            }
            if (this.regionInitialized) {
                s |= 0x1000;
            }
            if (this.memberUnInitialized) {
                s |= 0x40000;
            }
            if (this.persistentID != null) {
                s |= 0x4000;
            }
            if (this.hasCacheServer) {
                s |= 0x10000;
            }
            if (this.requiresOldValueInEvents) {
                s |= 0x20000;
            }
            if (this.persistenceInitialized) {
                s |= 0x80000;
            }
            if (!this.gatewaySenderIds.isEmpty()) {
                s |= 0x200000;
            }
            if (!this.asyncEventQueueIds.isEmpty()) {
                s |= 0x400000;
            }
            if (this.isOffHeap) {
                s |= 0x800000;
            }
            Assert.assertTrue(!this.scope.isLocal());
            return s;
        }

        private boolean hasGatewaySenderIds(int bits) {
            return (bits & 0x200000) != 0;
        }

        private boolean hasAsyncEventQueueIds(int bits) {
            return (bits & 0x400000) != 0;
        }

        private boolean hasPersistentID(int bits) {
            return (bits & 0x4000) != 0;
        }

        public boolean isPersistent() {
            return this.dataPolicy.withPersistence();
        }

        protected void setIntInfo(int s) {
            this.dataPolicy = (s & 2) != 0 ? ((s & 0x100) != 0 ? DataPolicy.PERSISTENT_REPLICATE : DataPolicy.REPLICATE) : ((s & 0x200) != 0 ? DataPolicy.EMPTY : ((s & 0x400) != 0 ? DataPolicy.PRELOADED : DataPolicy.NORMAL));
            if ((s & 0x800) != 0) {
                this.dataPolicy = (s & 0x100) != 0 ? DataPolicy.PERSISTENT_PARTITION : DataPolicy.PARTITION;
            }
            this.subscriptionAttributes = (s & 1) != 0 ? new SubscriptionAttributes(InterestPolicy.ALL) : new SubscriptionAttributes(InterestPolicy.CACHE_CONTENT);
            this.hasCacheLoader = (s & 4) != 0;
            this.hasCacheWriter = (s & 8) != 0;
            boolean bl = this.hasCacheListener = (s & 0x10) != 0;
            this.scope = (s & 0x20) != 0 ? Scope.DISTRIBUTED_ACK : ((s & 0x40) != 0 ? Scope.GLOBAL : Scope.DISTRIBUTED_NO_ACK);
            this.inRecovery = (s & 0x80) != 0;
            this.isPartitioned = (s & 0x800) != 0;
            this.isGatewayEnabled = (s & 0x2000) != 0;
            this.isPersistent = (s & 0x100) != 0;
            this.regionInitialized = (s & 0x1000) != 0;
            this.memberUnInitialized = (s & 0x40000) != 0;
            this.hasCacheServer = (s & 0x10000) != 0;
            this.requiresOldValueInEvents = (s & 0x20000) != 0;
            this.persistenceInitialized = (s & 0x80000) != 0;
            this.isOffHeap = (s & 0x800000) != 0;
        }

        public void setSubscriptionAttributes(SubscriptionAttributes sa) {
            this.subscriptionAttributes = sa;
        }

        public boolean cachedOrAllEventsWithListener() {
            return this.cachedOrAllEvents();
        }

        public boolean cachedOrAllEvents() {
            return this.dataPolicy.withStorage() || this.allEvents();
        }

        public boolean allEvents() {
            return this.subscriptionAttributes.getInterestPolicy().isAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processIncoming(DistributionManager dm, String adviseePath, boolean removeProfile, boolean exchangeProfiles, List<DistributionAdvisor.Profile> replyProfiles) {
            block14: {
                try {
                    LocalRegion lclRgn;
                    Assert.assertTrue(adviseePath != null, "adviseePath was null");
                    int oldLevel = LocalRegion.setThreadInitLevelRequirement(2);
                    try {
                        lclRgn = LocalRegion.getRegionFromPath(dm.getSystem(), adviseePath);
                    }
                    finally {
                        LocalRegion.setThreadInitLevelRequirement(oldLevel);
                    }
                    if (lclRgn instanceof CacheDistributionAdvisee) {
                        if (lclRgn.isUsedForPartitionedRegionBucket() && !((BucketRegion)lclRgn).isPartitionedRegionOpen()) {
                            return;
                        }
                        this.handleCacheDistributionAdvisee((CacheDistributionAdvisee)((Object)lclRgn), adviseePath, removeProfile, exchangeProfiles, true, replyProfiles);
                    } else if (lclRgn == null) {
                        this.handleCacheDistributionAdvisee(PartitionedRegionHelper.getProxyBucketRegion(GemFireCacheImpl.getInstance(), adviseePath, false), adviseePath, removeProfile, exchangeProfiles, false, replyProfiles);
                    } else if (logger.isDebugEnabled()) {
                        logger.debug("While processing UpdateAttributes message, region has local scope: {}", new Object[]{adviseePath});
                    }
                }
                catch (PRLocallyDestroyedException fre) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("<Region Locally destroyed> /// {}", new Object[]{this});
                    }
                }
                catch (RegionDestroyedException e) {
                    if (!logger.isDebugEnabled()) break block14;
                    logger.debug("<region destroyed> /// {}", new Object[]{this});
                }
            }
        }

        @Override
        public void cleanUp() {
            if (this.filterProfile != null) {
                this.filterProfile.cleanUp();
            }
        }

        private void handleCacheDistributionAdvisee(CacheDistributionAdvisee cda, String adviseePath, boolean removeProfile, boolean exchangeProfiles, boolean isRealRegion, List<DistributionAdvisor.Profile> replyProfiles) {
            if (cda != null) {
                this.handleDistributionAdvisee(cda, removeProfile, isRealRegion && exchangeProfiles, replyProfiles);
                if (logger.isDebugEnabled()) {
                    logger.debug("While processing UpdateAttributes message, handled advisee: {}", new Object[]{cda});
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("While processing UpdateAttributes message, region not found: {}", new Object[]{adviseePath});
            }
        }

        @Override
        public int getDSFID() {
            return 104;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            out.writeInt(this.getIntInfo());
            if (this.persistentID != null) {
                InternalDataSerializer.invokeToData(this.persistentID, out);
            }
            if (!this.gatewaySenderIds.isEmpty()) {
                this.writeSet(this.gatewaySenderIds, out);
            }
            if (!this.asyncEventQueueIds.isEmpty()) {
                this.writeSet(this.asyncEventQueueIds, out);
            }
            DataSerializer.writeObject(this.filterProfile, out);
        }

        private void writeSet(Set<String> set, DataOutput out) throws IOException {
            out.writeByte(66);
            InternalDataSerializer.writeSet(set, out);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            int bits = in.readInt();
            this.setIntInfo(bits);
            if (this.hasPersistentID(bits)) {
                this.persistentID = new PersistentMemberID();
                InternalDataSerializer.invokeFromData(this.persistentID, in);
            }
            if (this.hasGatewaySenderIds(bits)) {
                this.gatewaySenderIds = (Set)DataSerializer.readObject(in);
            }
            if (this.hasAsyncEventQueueIds(bits)) {
                this.asyncEventQueueIds = (Set)DataSerializer.readObject(in);
            }
            this.filterProfile = (FilterProfile)DataSerializer.readObject(in);
        }

        @Override
        public StringBuilder getToStringHeader() {
            return new StringBuilder("CacheProfile");
        }

        @Override
        public void fillInToString(StringBuilder sb) {
            super.fillInToString(sb);
            sb.append("; dataPolicy=" + this.dataPolicy);
            sb.append("; hasCacheLoader=" + this.hasCacheLoader);
            sb.append("; hasCacheWriter=" + this.hasCacheWriter);
            sb.append("; hasCacheListener=" + this.hasCacheListener);
            sb.append("; hasCacheServer=").append(this.hasCacheServer);
            sb.append("; scope=" + this.scope);
            sb.append("; regionInitialized=").append(String.valueOf(this.regionInitialized));
            sb.append("; memberUnInitialized=").append(String.valueOf(this.memberUnInitialized));
            sb.append("; inRecovery=" + this.inRecovery);
            sb.append("; subcription=" + this.subscriptionAttributes);
            sb.append("; isPartitioned=" + this.isPartitioned);
            sb.append("; isGatewayEnabled=" + this.isGatewayEnabled);
            sb.append("; isPersistent=" + this.isPersistent);
            sb.append("; persistentID=" + this.persistentID);
            if (this.filterProfile != null) {
                sb.append("; ").append(this.filterProfile);
            }
            sb.append("; gatewaySenderIds =" + this.gatewaySenderIds);
            sb.append("; asyncEventQueueIds =" + this.asyncEventQueueIds);
            sb.append("; IsOffHeap=" + this.isOffHeap);
        }
    }
}

