/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.internal.cache.AbstractRegionEntry;
import com.gemstone.gemfire.internal.cache.BucketRegionQueue;
import com.gemstone.gemfire.internal.cache.DiskEntry;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.OffHeapRegionEntry;
import com.gemstone.gemfire.internal.cache.RegionClearedException;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventImpl;
import com.gemstone.gemfire.internal.cache.wan.serial.SerialGatewaySenderQueue;

public abstract class AbstractDiskRegionEntry
extends AbstractRegionEntry
implements DiskEntry {
    protected AbstractDiskRegionEntry(RegionEntryContext context, Object value) {
        super(context, value);
    }

    @Override
    public void setValue(RegionEntryContext context, Object v) throws RegionClearedException {
        this.setValue(context, v, null);
    }

    @Override
    public void setValue(RegionEntryContext context, Object value, EntryEventImpl event) throws RegionClearedException {
        DiskEntry.Helper.update(this, (LocalRegion)context, value, event);
        this.setRecentlyUsed();
    }

    @Override
    public void setValueWithContext(RegionEntryContext context, Object value) {
        this._setValue(value);
        if (value != null && context != null && this instanceof OffHeapRegionEntry && context instanceof LocalRegion && ((LocalRegion)context).isThisRegionBeingClosedOrDestroyed()) {
            ((OffHeapRegionEntry)((Object)this)).release();
            ((LocalRegion)context).checkReadiness();
        }
    }

    @Override
    public void handleValueOverflow(RegionEntryContext context) {
        if (context instanceof BucketRegionQueue || context instanceof SerialGatewaySenderQueue.SerialGatewaySenderQueueMetaRegion) {
            GatewaySenderEventImpl.release(this._getValue());
        }
    }

    @Override
    public void afterValueOverflow(RegionEntryContext context) {
    }
}

