/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.cache;

import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSBucketRegionQueue;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSGatewayEventImpl;
import com.gemstone.gemfire.internal.cache.AbstractLRURegionMap;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.CachePerfStats;
import com.gemstone.gemfire.internal.cache.ColocationHelper;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.InternalRegionArguments;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionQueue;
import com.gemstone.gemfire.internal.cache.lru.LRUStatistics;
import com.gemstone.gemfire.internal.cache.versions.RegionVersionVector;
import com.gemstone.gemfire.internal.cache.versions.VersionSource;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySenderEventProcessor;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventImpl;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderStats;
import com.gemstone.gemfire.internal.cache.wan.parallel.ConcurrentParallelGatewaySenderQueue;
import com.gemstone.gemfire.internal.concurrent.ConcurrentHashSet;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.offheap.OffHeapRegionEntryHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.Logger;

public abstract class AbstractBucketRegionQueue
extends BucketRegion {
    protected static final Logger logger = LogService.getLogger();
    private final long maximumSize = 0x100000L * Long.getLong("gemfire.GATEWAY_QUEUE_THROTTLE_SIZE_MB", -1L);
    private final long throttleTime = Long.getLong("gemfire.GATEWAY_QUEUE_THROTTLE_TIME_MS", 100L);
    private final LRUStatistics stats;
    private final ReentrantReadWriteLock initializationLock = new ReentrantReadWriteLock();
    private final GatewaySenderStats gatewaySenderStats;
    protected volatile boolean initialized = false;
    private final ConcurrentHashSet<Object> failedBatchRemovalMessageKeys = new ConcurrentHashSet();

    public AbstractBucketRegionQueue(String regionName, RegionAttributes attrs, LocalRegion parentRegion, GemFireCacheImpl cache, InternalRegionArguments internalRegionArgs) {
        super(regionName, attrs, parentRegion, cache, internalRegionArgs);
        this.stats = ((AbstractLRURegionMap)this.getRegionMap()).getLRUStatistics();
        this.gatewaySenderStats = this.getPartitionedRegion().getParallelGatewaySender().getStatistics();
    }

    @Override
    public boolean supportsConcurrencyChecks() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitIfQueueFull() {
        if (this.maximumSize <= 0L) {
            return;
        }
        if (this.stats.getCounter() > this.maximumSize) {
            try {
                LRUStatistics lRUStatistics = this.stats;
                synchronized (lRUStatistics) {
                    this.stats.wait(this.throttleTime);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyEntriesRemoved() {
        if (this.maximumSize > 0L) {
            LRUStatistics lRUStatistics = this.stats;
            synchronized (lRUStatistics) {
                this.stats.notifyAll();
            }
        }
    }

    @Override
    protected void distributeUpdateOperation(EntryEventImpl event, long lastModified) {
    }

    @Override
    protected boolean needWriteLock(EntryEventImpl event) {
        return false;
    }

    @Override
    protected long basicPutPart2(EntryEventImpl event, RegionEntry entry, boolean isInitialized, long lastModified, boolean clearConflict) {
        return System.currentTimeMillis();
    }

    @Override
    protected void basicDestroyBeforeRemoval(RegionEntry entry, EntryEventImpl event) {
        if (logger.isDebugEnabled()) {
            logger.debug("For Key {}, BasicDestroyBeforeRemoval: no need to send destroy operation to remote nodes. This will be done using BatchRemoval Message.", new Object[]{event.getKey()});
        }
    }

    @Override
    protected void distributeDestroyOperation(EntryEventImpl event) {
    }

    @Override
    protected void updateSizeOnClearRegion(int sizeBeforeClear) {
    }

    public ReentrantReadWriteLock getInitializationLock() {
        return this.initializationLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyKey(Object key) throws ForceReattemptException {
        if (logger.isDebugEnabled()) {
            logger.debug(" destroying primary key {}", new Object[]{key});
        }
        EntryEventImpl event = this.getPartitionedRegion().newDestroyEntryEvent(key, null);
        event.setEventId(new EventID(this.cache.getSystem()));
        try {
            event.setRegion(this);
            this.basicDestroy(event, true, null);
            this.checkReadiness();
        }
        catch (EntryNotFoundException enf) {
            if (this.getPartitionedRegion().isDestroyed()) {
                this.getPartitionedRegion().checkReadiness();
                if (this.isBucketDestroyed()) {
                    throw new ForceReattemptException("Bucket moved", new RegionDestroyedException(LocalizedStrings.PartitionedRegionDataStore_REGION_HAS_BEEN_DESTROYED.toLocalizedString(), this.getPartitionedRegion().getFullPath()));
                }
            }
            throw enf;
        }
        catch (RegionDestroyedException rde) {
            this.getPartitionedRegion().checkReadiness();
            if (this.isBucketDestroyed()) {
                throw new ForceReattemptException("Bucket moved while destroying key " + key, rde);
            }
        }
        finally {
            event.release();
        }
        this.notifyEntriesRemoved();
    }

    public void decQueueSize(int size) {
        this.gatewaySenderStats.decQueueSize(size);
    }

    public void decQueueSize() {
        this.gatewaySenderStats.decQueueSize();
    }

    public void incQueueSize(int size) {
        this.gatewaySenderStats.incQueueSize(size);
    }

    public void incQueueSize() {
        this.gatewaySenderStats.incQueueSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadEventsFromTempQueue() {
        ConcurrentParallelGatewaySenderQueue prq;
        BlockingQueue<GatewaySenderEventImpl> tempQueue;
        Set<RegionQueue> queues;
        if (logger.isDebugEnabled()) {
            logger.debug("For bucket {} about to load events from the temp queue...", new Object[]{this.getId()});
        }
        if ((queues = this.getPartitionedRegion().getParallelGatewaySender().getQueues()) != null && (tempQueue = (prq = (ConcurrentParallelGatewaySenderQueue)queues.toArray()[0]).getBucketTmpQueue(this.getId())) != null && !tempQueue.isEmpty()) {
            BlockingQueue<GatewaySenderEventImpl> blockingQueue = tempQueue;
            synchronized (blockingQueue) {
                try {
                    GatewaySenderEventImpl event;
                    this.getInitializationLock().writeLock().lock();
                    while ((event = (GatewaySenderEventImpl)tempQueue.poll()) != null) {
                        try {
                            event.setPossibleDuplicate(true);
                            if (!this.addToQueue(event.getShadowKey(), event)) continue;
                            event = null;
                        }
                        catch (ForceReattemptException e) {
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("For bucket {} , enqueing event {} caused exception", new Object[]{this.getId(), event, e});
                        }
                        finally {
                            if (event == null) continue;
                            event.release();
                        }
                    }
                }
                finally {
                    if (!tempQueue.isEmpty()) {
                        for (GatewaySenderEventImpl e : tempQueue) {
                            e.release();
                        }
                        tempQueue.clear();
                    }
                    this.getInitializationLock().writeLock().unlock();
                }
            }
        }
    }

    protected void markEventsAsDuplicate(int batchSize, Iterator itr) {
        for (int i = 0; i < batchSize && itr.hasNext(); ++i) {
            Object key = itr.next();
            Object senderEvent = this.getNoLRU(key, true, false, false);
            if (senderEvent == null) continue;
            ((GatewaySenderEventImpl)senderEvent).setPossibleDuplicate(true);
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Set possibleDuplicate to true on event: {}", new Object[]{senderEvent});
        }
    }

    @Override
    public void forceSerialized(EntryEventImpl event) {
    }

    @Override
    protected boolean virtualPut(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed) throws TimeoutException, CacheWriterException {
        boolean success = super.virtualPut(event, ifNew, ifOld, expectedOldValue, requireOldValue, lastModified, overwriteDestroyed);
        if (success) {
            if (logger.isDebugEnabled()) {
                logger.debug("Key : ----> {}", new Object[]{event.getKey()});
            }
            GatewaySenderEventImpl.release(event.getRawOldValue());
        }
        return success;
    }

    @Override
    protected void basicDestroy(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) throws EntryNotFoundException, CacheWriterException, TimeoutException {
        super.basicDestroy(event, cacheWrite, expectedOldValue);
        GatewaySenderEventImpl.release(event.getRawOldValue());
    }

    public Collection<BucketRegion> getCorrespondingUserPRBuckets() {
        ArrayList<BucketRegion> userPRBuckets = new ArrayList<BucketRegion>(4);
        Map<String, PartitionedRegion> colocatedPRs = ColocationHelper.getAllColocationRegions(this.getPartitionedRegion());
        for (PartitionedRegion colocatedPR : colocatedPRs.values()) {
            BucketRegion parentBucket;
            if (colocatedPR.isShadowPR() || !this.isThisSenderAttached(colocatedPR) || (parentBucket = colocatedPR.getDataStore().getLocalBucketById(this.getId())) == null) continue;
            userPRBuckets.add(parentBucket);
        }
        return userPRBuckets;
    }

    private boolean isThisSenderAttached(PartitionedRegion pr) {
        return pr.getParallelGatewaySenderIds().contains(this.getPartitionedRegion().getParallelGatewaySender().getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addToQueue(Object key, Object value) throws ForceReattemptException {
        if (this.failedBatchRemovalMessageKeys.remove(key)) {
            return false;
        }
        boolean didPut = false;
        long startPut = CachePerfStats.getStatTime();
        EntryEventImpl event = EntryEventImpl.create((LocalRegion)this, Operation.UPDATE, key, value, null, false, this.getMyId());
        event.copyOffHeapToHeap();
        if (logger.isDebugEnabled()) {
            logger.debug("Value : {}", new Object[]{event.getRawNewValue()});
        }
        this.waitIfQueueFull();
        int sizeOfHdfsEvent = -1;
        try {
            if (this instanceof HDFSBucketRegionQueue && this.getBucketAdvisor().isPrimary()) {
                HDFSGatewayEventImpl hdfsEvent = (HDFSGatewayEventImpl)event.getValue();
                sizeOfHdfsEvent = hdfsEvent.getSizeOnHDFSInBytes(!((HDFSBucketRegionQueue)this).isBucketSorted);
            }
            didPut = this.virtualPut(event, false, false, null, false, startPut, true);
            this.checkReadiness();
        }
        catch (RegionDestroyedException rde) {
            this.getPartitionedRegion().checkReadiness();
            if (this.isBucketDestroyed()) {
                throw new ForceReattemptException("Bucket moved", rde);
            }
        }
        finally {
            if (!didPut) {
                GatewaySenderEventImpl.release(value);
            }
        }
        if (this.failedBatchRemovalMessageKeys.remove(key) && didPut) {
            this.destroyKey(key);
            didPut = false;
        } else {
            this.addToEventQueue(key, didPut, event, sizeOfHdfsEvent);
        }
        return didPut;
    }

    @Override
    public void closeEntries() {
        OffHeapRegionEntryHelper.doWithOffHeapClear(new Runnable(){

            @Override
            public void run() {
                AbstractBucketRegionQueue.super.closeEntries();
            }
        });
        this.clearQueues();
    }

    @Override
    public Set<VersionSource> clearEntries(final RegionVersionVector rvv) {
        final AtomicReference result = new AtomicReference();
        OffHeapRegionEntryHelper.doWithOffHeapClear(new Runnable(){

            @Override
            public void run() {
                result.set(AbstractBucketRegionQueue.super.clearEntries(rvv));
            }
        });
        this.clearQueues();
        return (Set)result.get();
    }

    protected abstract void clearQueues();

    protected abstract void addToEventQueue(Object var1, boolean var2, EntryEventImpl var3, int var4);

    @Override
    public void afterAcquiringPrimaryState() {
        super.afterAcquiringPrimaryState();
        this.notifyEventProcessor();
    }

    protected void notifyEventProcessor() {
        AbstractGatewaySenderEventProcessor ep;
        AbstractGatewaySender sender = this.getPartitionedRegion().getParallelGatewaySender();
        if (sender != null && (ep = sender.getEventProcessor()) != null) {
            ConcurrentParallelGatewaySenderQueue queue = (ConcurrentParallelGatewaySenderQueue)ep.getQueue();
            if (logger.isDebugEnabled()) {
                logger.debug("notifyEventProcessor : {} event processor {} queue {}", new Object[]{sender, ep, queue});
            }
            queue.notifyEventProcessorIfRequired(this.getId());
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    public void addToFailedBatchRemovalMessageKeys(Object key) {
        this.failedBatchRemovalMessageKeys.add(key);
    }

    public ConcurrentHashSet<Object> getFailedBatchRemovalMessageKeys() {
        return this.failedBatchRemovalMessageKeys;
    }
}

