/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.admin.remote.AdminMultipleReplyProcessor;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import com.gemstone.gemfire.internal.admin.remote.CliLegacyMessage;
import com.gemstone.gemfire.internal.admin.remote.RevokePersistentIDResponse;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberManager;
import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberPattern;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;

public class RevokePersistentIDRequest
extends CliLegacyMessage {
    PersistentMemberPattern pattern;

    public RevokePersistentIDRequest() {
    }

    public RevokePersistentIDRequest(PersistentMemberPattern pattern) {
        this.pattern = pattern;
    }

    public static void send(DM dm, PersistentMemberPattern pattern) {
        Set recipients = dm.getOtherDistributionManagerIds();
        RevokePersistentIDRequest request = new RevokePersistentIDRequest(pattern);
        request.setRecipients(recipients);
        AdminMultipleReplyProcessor replyProcessor = new AdminMultipleReplyProcessor(dm, (Collection)recipients);
        request.msgId = replyProcessor.getProcessorId();
        dm.putOutgoing(request);
        try {
            replyProcessor.waitForReplies();
        }
        catch (ReplyException e) {
            if (e.getCause() instanceof CancelException) {
                return;
            }
            throw e;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        request.createResponse((DistributionManager)dm);
    }

    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache != null && !cache.isClosed()) {
            PersistentMemberManager mm = cache.getPersistentMemberManager();
            mm.revokeMember(this.pattern);
        }
        return new RevokePersistentIDResponse(this.getSender());
    }

    @Override
    public int getDSFID() {
        return 2107;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.pattern = new PersistentMemberPattern();
        InternalDataSerializer.invokeFromData(this.pattern, in);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        InternalDataSerializer.invokeToData(this.pattern, out);
    }
}

