/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.IncompatibleSystemException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.admin.OperationCancelledException;
import com.gemstone.gemfire.admin.RuntimeAdminException;
import com.gemstone.gemfire.distributed.DistributedSystemDisconnectedException;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.MembershipListener;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.admin.Alert;
import com.gemstone.gemfire.internal.admin.AlertListener;
import com.gemstone.gemfire.internal.admin.ApplicationVM;
import com.gemstone.gemfire.internal.admin.CacheCollector;
import com.gemstone.gemfire.internal.admin.CacheSnapshot;
import com.gemstone.gemfire.internal.admin.GfManagerAgent;
import com.gemstone.gemfire.internal.admin.GfManagerAgentConfig;
import com.gemstone.gemfire.internal.admin.JoinLeaveListener;
import com.gemstone.gemfire.internal.admin.remote.AdminRequest;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import com.gemstone.gemfire.internal.admin.remote.AdminWaiters;
import com.gemstone.gemfire.internal.admin.remote.AlertLevelChangeMessage;
import com.gemstone.gemfire.internal.admin.remote.RemoteApplicationVM;
import com.gemstone.gemfire.internal.admin.remote.RemoteGemFireVM;
import com.gemstone.gemfire.internal.admin.remote.RemoteTransportConfig;
import com.gemstone.gemfire.internal.admin.remote.SnapshotResultMessage;
import com.gemstone.gemfire.internal.admin.remote.VersionMismatchAlert;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.InternalLogWriter;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.LogWriterFactory;
import com.gemstone.gemfire.internal.logging.LoggingThreadGroup;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import com.gemstone.gemfire.security.AuthenticationFailedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public final class RemoteGfManagerAgent
implements GfManagerAgent {
    private static final Logger logger = LogService.getLogger();
    protected InternalDistributedSystem system;
    protected volatile boolean connected = false;
    private volatile boolean listening = true;
    private DSConnectionDaemon daemon;
    private final AlertListener alertListener;
    protected int alertLevel;
    private final RemoteTransportConfig transport;
    private final String displayName;
    protected volatile Set listeners = Collections.EMPTY_SET;
    private final Object listenersLock = new Object();
    private CacheCollector collector;
    private volatile Map membersMap = Collections.EMPTY_MAP;
    private final Object membersLock = new Object();
    private final InternalLogWriter securityLogWriter;
    protected BlockingQueue snapshotResults = new LinkedBlockingQueue();
    private SnapshotResultDispatcher snapshotDispatcher;
    protected JoinProcessor joinProcessor;
    protected volatile List pendingJoins = Collections.EMPTY_LIST;
    private final Object pendingJoinsLock = new Object();
    protected volatile InternalDistributedMember currentJoin;
    protected volatile boolean abortCurrentJoin = false;
    protected ThreadGroup threadGroup;
    protected volatile boolean initialized = false;
    private boolean disconnected = false;
    private MyMembershipListener myMembershipListener;
    private final Object myMembershipListenerLock = new Object();
    private InternalDistributedSystem.DisconnectListener disconnectListener;
    private static final Object enumerationSync = new Object();
    private static volatile ArrayList allAgents = new ArrayList();
    private static volatile boolean emergencyClassesLoaded = false;
    private static ThreadLocal sending = new ThreadLocal(){

        protected Object initialValue() {
            return Boolean.FALSE;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addAgent(RemoteGfManagerAgent toAdd) {
        Object object = enumerationSync;
        synchronized (object) {
            ArrayList<RemoteGfManagerAgent> replace = new ArrayList<RemoteGfManagerAgent>(allAgents);
            replace.add(toAdd);
            allAgents = replace;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeAgent(RemoteGfManagerAgent toRemove) {
        Object object = enumerationSync;
        synchronized (object) {
            ArrayList replace = new ArrayList(allAgents);
            replace.remove(toRemove);
            allAgents = replace;
        }
    }

    public static void loadEmergencyClasses() {
        if (emergencyClassesLoaded) {
            return;
        }
        emergencyClassesLoaded = true;
        InternalDistributedSystem.loadEmergencyClasses();
    }

    public static void emergencyClose() {
        ArrayList members = allAgents;
        for (int i = 0; i < members.size(); ++i) {
            RemoteGfManagerAgent each = (RemoteGfManagerAgent)members.get(i);
            each.system.emergencyClose();
        }
    }

    public static ArrayList getAgents() {
        return allAgents;
    }

    public RemoteGfManagerAgent(GfManagerAgentConfig cfg) {
        if (!(cfg.getTransport() instanceof RemoteTransportConfig)) {
            throw new IllegalArgumentException(LocalizedStrings.RemoteGfManagerAgent_EXPECTED_0_TO_BE_A_REMOTETRANSPORTCONFIG.toLocalizedString(cfg.getTransport()));
        }
        this.transport = (RemoteTransportConfig)cfg.getTransport();
        this.displayName = cfg.getDisplayName();
        this.alertListener = cfg.getAlertListener();
        if (this.alertListener != null && this.alertListener instanceof JoinLeaveListener) {
            this.addJoinLeaveListener((JoinLeaveListener)((Object)this.alertListener));
        }
        int tmp = cfg.getAlertLevel();
        if (this.alertListener == null) {
            tmp = Integer.MAX_VALUE;
        }
        this.alertLevel = tmp;
        InternalLogWriter logWriter = cfg.getLogWriter();
        if (logWriter == null) {
            throw new NullPointerException("LogWriter must not be null");
        }
        this.securityLogWriter = logWriter.isSecure() ? logWriter : LogWriterFactory.toSecurityLogWriter(logWriter);
        this.disconnectListener = cfg.getDisconnectListener();
        this.threadGroup = LoggingThreadGroup.createThreadGroup("ConsoleDMDaemon", logger);
        this.joinProcessor = new JoinProcessor();
        this.joinProcessor.start();
        this.join();
        this.snapshotDispatcher = new SnapshotResultDispatcher();
        this.snapshotDispatcher.start();
        RemoteGfManagerAgent.addAgent(this);
    }

    private void join() {
        this.daemon = new DSConnectionDaemon();
        this.daemon.start();
        try {
            long endTime = System.currentTimeMillis() + 2000L;
            while (!this.connected && this.daemon.isAlive() && System.currentTimeMillis() < endTime) {
                this.daemon.join(200L);
            }
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
            this.system.getCancelCriterion().checkCancelInProgress(ignore);
        }
    }

    private static void handle(ExecutionException ex) {
        Throwable cause = ex.getCause();
        if (cause instanceof OperationCancelledException) {
            return;
        }
        if (cause instanceof DistributedSystemDisconnectedException) {
            throw new DistributedSystemDisconnectedException("While waiting for Future", ex);
        }
        throw new RuntimeAdminException(LocalizedStrings.RemoteGfManagerAgent_AN_EXCEPUTIONEXCEPTION_WAS_THROWN_WHILE_WAITING_FOR_FUTURE.toLocalizedString(), ex);
    }

    public String toString() {
        return "Distributed System " + this.transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean disconnect() {
        boolean disconnectedTrue = false;
        RemoteGfManagerAgent remoteGfManagerAgent = this;
        synchronized (remoteGfManagerAgent) {
            if (this.disconnected) {
                return false;
            }
            this.disconnected = true;
            disconnectedTrue = true;
        }
        try {
            boolean removeListener;
            this.listening = false;
            this.joinProcessor.shutDown();
            boolean bl = removeListener = this.alertLevel != Integer.MAX_VALUE;
            if (this.isConnected() || this.membersMap.size() > 0) {
                RemoteApplicationVM[] apps = (RemoteApplicationVM[])this.listApplications(disconnectedTrue);
                for (int i = 0; i < apps.length; ++i) {
                    try {
                        apps[i].disconnect(removeListener);
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                try {
                    DM dm = this.system.getDistributionManager();
                    Object object = this.myMembershipListenerLock;
                    synchronized (object) {
                        if (this.myMembershipListener != null) {
                            dm.removeMembershipListener(this.myMembershipListener);
                        }
                    }
                    if (dm instanceof DistributionManager) {
                        ((DistributionManager)dm).setAgent(null);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (DistributedSystemDisconnectedException distributedSystemDisconnectedException) {
                    // empty catch block
                }
                if (this.system != null && DistributionManager.isDedicatedAdminVM && this.system.isConnected()) {
                    this.system.disconnect();
                }
                this.system = null;
                this.connected = false;
            }
            this.daemon.shutDown();
            if (this.snapshotDispatcher != null) {
                this.snapshotDispatcher.shutDown();
            }
        }
        finally {
            RemoteGfManagerAgent.removeAgent(this);
        }
        return true;
    }

    @Override
    public boolean isListening() {
        return this.listening;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public boolean isConnected() {
        return this.connected && this.system != null && this.system.isConnected();
    }

    @Override
    public ApplicationVM[] listApplications() {
        return this.listApplications(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApplicationVM[] listApplications(boolean disconnected) {
        if (this.isConnected() || this.membersMap.size() > 0 && disconnected) {
            ArrayList remoteApplicationVMs = new ArrayList(this.membersMap.size());
            Iterator iter = this.membersMap.values().iterator();
            block11: while (true) {
                if (!iter.hasNext()) {
                    ApplicationVM[] array = new RemoteApplicationVM[remoteApplicationVMs.size()];
                    remoteApplicationVMs.toArray(array);
                    return array;
                }
                Future future = (Future)iter.next();
                while (true) {
                    try {
                        this.system.getCancelCriterion().checkCancelInProgress(null);
                    }
                    catch (DistributedSystemDisconnectedException distributedSystemDisconnectedException) {
                        // empty catch block
                    }
                    boolean interrupted = Thread.interrupted();
                    try {
                        Object obj = future.get();
                        if (obj == null) continue block11;
                        remoteApplicationVMs.add(obj);
                        continue block11;
                    }
                    catch (InterruptedException ex) {
                        interrupted = true;
                        continue;
                    }
                    catch (CancellationException ex) {
                        continue block11;
                    }
                    catch (ExecutionException ex) {
                        RemoteGfManagerAgent.handle(ex);
                        continue block11;
                    }
                    finally {
                        if (!interrupted) continue;
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    break;
                }
                break;
            }
        }
        return new RemoteApplicationVM[0];
    }

    @Override
    public GfManagerAgent[] listPeers() {
        return new GfManagerAgent[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addJoinLeaveListener(JoinLeaveListener observer) {
        Object object = this.listenersLock;
        synchronized (object) {
            Set oldListeners = this.listeners;
            if (!oldListeners.contains(observer)) {
                HashSet<JoinLeaveListener> newListeners = new HashSet<JoinLeaveListener>(oldListeners);
                newListeners.add(observer);
                this.listeners = newListeners;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeJoinLeaveListener(JoinLeaveListener observer) {
        Object object = this.listenersLock;
        synchronized (object) {
            HashSet newListeners;
            Set oldListeners = this.listeners;
            if (oldListeners.contains(observer) && (newListeners = new HashSet(oldListeners)).remove(observer)) {
                this.listeners = newListeners;
            }
        }
    }

    @Override
    public synchronized void setCacheCollector(CacheCollector collector) {
        this.collector = collector;
    }

    public RemoteTransportConfig getTransport() {
        return this.transport;
    }

    AdminResponse sendAndWait(AdminRequest msg) {
        try {
            if (((Boolean)sending.get()).booleanValue()) {
                throw new OperationCancelledException(LocalizedStrings.RemoteGfManagerAgent_RECURSION_DETECTED_WHILE_SENDING_0.toLocalizedString(msg));
            }
            sending.set(Boolean.TRUE);
            DistributionManager dm = (DistributionManager)this.system.getDistributionManager();
            if (this.isConnected()) {
                AdminResponse adminResponse = msg.sendAndWait(dm);
                return adminResponse;
            }
            dm.getCancelCriterion().checkCancelInProgress(null);
            throw new RuntimeAdminException(LocalizedStrings.RemoteGfManagerAgent_0_IS_NOT_CURRENTLY_CONNECTED.toLocalizedString(this));
        }
        finally {
            sending.set(Boolean.FALSE);
        }
    }

    void sendAsync(DistributionMessage msg) {
        if (this.system != null) {
            this.system.getDistributionManager().putOutgoing(msg);
        }
    }

    public RemoteGemFireVM getMemberById(InternalDistributedMember id) {
        return this.getApplicationById(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RemoteApplicationVM getApplicationById(InternalDistributedMember id) {
        if (!this.isConnected()) return null;
        Future future = (Future)this.membersMap.get(id);
        if (future == null) {
            return null;
        }
        while (true) {
            this.system.getCancelCriterion().checkCancelInProgress(null);
            boolean interrupted = Thread.interrupted();
            try {
                RemoteApplicationVM remoteApplicationVM = (RemoteApplicationVM)future.get();
                return remoteApplicationVM;
            }
            catch (InterruptedException ex) {
                interrupted = true;
                continue;
            }
            catch (CancellationException ex) {
                RemoteApplicationVM remoteApplicationVM = null;
                return remoteApplicationVM;
            }
            catch (ExecutionException ex) {
                RemoteGfManagerAgent.handle(ex);
                RemoteApplicationVM remoteApplicationVM = null;
                return remoteApplicationVM;
            }
            finally {
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteApplicationVM addMember(final InternalDistributedMember id) {
        FutureTask future;
        Object oldMembersMap;
        boolean runFuture = false;
        Object object = this.membersLock;
        synchronized (object) {
            oldMembersMap = this.membersMap;
            future = (FutureTask)oldMembersMap.get(id);
            if (future == null) {
                runFuture = true;
                if (this.abortCurrentJoin) {
                    return null;
                }
                future = new FutureTask(new Callable(){

                    public Object call() throws Exception {
                        RemoteGfManagerAgent agent = RemoteGfManagerAgent.this;
                        RemoteApplicationVM result = new RemoteApplicationVM(agent, id, RemoteGfManagerAgent.this.alertLevel);
                        result.startStatDispatcher();
                        if (agent.abortCurrentJoin) {
                            result.stopStatListening();
                            return null;
                        }
                        return result;
                    }
                });
                HashMap newMembersMap = new HashMap(oldMembersMap);
                newMembersMap.put(id, future);
                if (this.abortCurrentJoin) {
                    return null;
                }
                this.membersMap = newMembersMap;
            }
        }
        if (runFuture) {
            future.run();
        }
        while (true) {
            RemoteApplicationVM remoteApplicationVM;
            this.system.getCancelCriterion().checkCancelInProgress(null);
            boolean interrupted = Thread.interrupted();
            try {
                oldMembersMap = (RemoteApplicationVM)future.get();
                return oldMembersMap;
            }
            catch (InterruptedException ex) {
                interrupted = true;
                continue;
            }
            catch (CancellationException ex) {
                remoteApplicationVM = null;
                return remoteApplicationVM;
            }
            catch (ExecutionException ex) {
                RemoteGfManagerAgent.handle(ex);
                remoteApplicationVM = null;
                return remoteApplicationVM;
            }
            finally {
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected RemoteApplicationVM removeMember(InternalDistributedMember id) {
        Object oldMembersMap;
        Future future = null;
        Object object = this.membersLock;
        synchronized (object) {
            HashMap newMembersMap;
            oldMembersMap = this.membersMap;
            if (oldMembersMap.containsKey(id) && (future = (Future)(newMembersMap = new HashMap(oldMembersMap)).remove(id)) != null) {
                this.membersMap = newMembersMap;
            }
        }
        if (future == null) return null;
        future.cancel(true);
        while (true) {
            RemoteApplicationVM remoteApplicationVM;
            this.system.getCancelCriterion().checkCancelInProgress(null);
            boolean interrupted = Thread.interrupted();
            try {
                oldMembersMap = (RemoteApplicationVM)future.get();
                return oldMembersMap;
            }
            catch (InterruptedException ex) {
                interrupted = true;
                continue;
            }
            catch (CancellationException ex) {
                remoteApplicationVM = null;
                return remoteApplicationVM;
            }
            catch (ExecutionException ex) {
                RemoteGfManagerAgent.handle(ex);
                remoteApplicationVM = null;
                return remoteApplicationVM;
            }
            finally {
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueueSnapshotResults(SnapshotResultMessage msg) {
        if (!this.isListening()) {
            return;
        }
        while (true) {
            this.system.getCancelCriterion().checkCancelInProgress(null);
            boolean interrupted = Thread.interrupted();
            try {
                this.snapshotResults.put(msg);
            }
            catch (InterruptedException ignore) {
                interrupted = true;
                continue;
            }
            finally {
                if (!interrupted) continue;
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    void callAlertListener(Alert alert) {
        if (!this.isListening()) {
            return;
        }
        if (this.alertListener != null && alert.getLevel() >= this.alertLevel) {
            this.alertListener.alert(alert);
        }
    }

    protected void callCacheCollector(CacheSnapshot results, InternalDistributedMember sender, int snapshotId) {
        RemoteGemFireVM vm;
        if (!this.isListening()) {
            return;
        }
        if (this.collector != null && (vm = this.getMemberById(sender)) != null && this.collector != null) {
            this.collector.resultsReturned(results, vm, snapshotId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InternalDistributedSystem.DisconnectListener getDisconnectListener() {
        RemoteGfManagerAgent remoteGfManagerAgent = this;
        synchronized (remoteGfManagerAgent) {
            return this.disconnectListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectToDS() {
        if (!this.isListening()) {
            return;
        }
        if (this.system != null) {
            this.system.disconnect();
            this.system = null;
        }
        Properties props = this.transport.toDSProperties();
        if (this.displayName != null && this.displayName.length() > 0) {
            props.setProperty("name", this.displayName);
        }
        this.system = (InternalDistributedSystem)InternalDistributedSystem.connectForAdmin(props);
        DM dm = this.system.getDistributionManager();
        if (dm instanceof DistributionManager) {
            ((DistributionManager)dm).setAgent(this);
        }
        Object object = this;
        synchronized (object) {
            this.disconnected = false;
        }
        this.system.addDisconnectListener(new InternalDistributedSystem.DisconnectListener(){

            public String toString() {
                return LocalizedStrings.RemoteGfManagerAgent_DISCONNECT_LISTENER_FOR_0.toLocalizedString(RemoteGfManagerAgent.this);
            }

            @Override
            public void onDisconnect(InternalDistributedSystem sys) {
                boolean reconnect = sys.isReconnecting();
                if (!reconnect) {
                    InternalDistributedSystem.DisconnectListener listener = RemoteGfManagerAgent.this.getDisconnectListener();
                    if (RemoteGfManagerAgent.this.disconnect() && listener != null) {
                        listener.onDisconnect(sys);
                    }
                }
            }
        });
        InternalDistributedSystem.addReconnectListener(new InternalDistributedSystem.ReconnectListener(){

            @Override
            public void reconnecting(InternalDistributedSystem oldsys) {
            }

            @Override
            public void onReconnect(InternalDistributedSystem oldsys, InternalDistributedSystem newsys) {
                if (logger.isDebugEnabled()) {
                    logger.debug("RemoteGfManagerAgent.onReconnect attempting to join new distributed system");
                }
                RemoteGfManagerAgent.this.join();
            }
        });
        object = this.myMembershipListenerLock;
        synchronized (object) {
            this.myMembershipListener = new MyMembershipListener();
            dm.addMembershipListener(this.myMembershipListener);
            Set initialMembers = dm.getDistributionManagerIds();
            this.myMembershipListener.addMembers(initialMembers);
            if (logger.isDebugEnabled()) {
                StringBuffer sb = new StringBuffer("[RemoteGfManagerAgent] ");
                sb.append("Connected to DS with ");
                sb.append(initialMembers.size());
                sb.append(" members: ");
                for (InternalDistributedMember member : initialMembers) {
                    sb.append(member);
                    sb.append(" ");
                }
                logger.debug(sb.toString());
            }
            this.connected = true;
            for (InternalDistributedMember member : initialMembers) {
                try {
                    this.handleJoined(member);
                }
                catch (OperationCancelledException ex) {
                    if (!logger.isTraceEnabled(LogMarker.DM)) continue;
                    logger.trace(LogMarker.DM, "join cancelled by departure");
                }
            }
            this.initialized = true;
        }
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    @Override
    public DM getDM() {
        InternalDistributedSystem sys = this.system;
        if (sys == null) {
            return null;
        }
        return sys.getDistributionManager();
    }

    public String getBindAddress() {
        return this.transport.getBindAddress();
    }

    public boolean hasNonDefaultBindAddress() {
        if (this.getBindAddress() == null) {
            return false;
        }
        return !"".equals(this.getBindAddress());
    }

    @Override
    public void setAlertLevel(int level) {
        this.alertLevel = level;
        AlertLevelChangeMessage m = AlertLevelChangeMessage.create(level);
        this.sendAsync(m);
    }

    @Override
    public InternalDistributedSystem getDSConnection() {
        return this.system;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleJoined(InternalDistributedMember id) {
        if (!this.isListening()) {
            return;
        }
        this.currentJoin = id;
        try {
            RemoteApplicationVM member = null;
            switch (id.getVmKind()) {
                case 10: {
                    member = this.addMember(id);
                    break;
                }
                case 11: {
                    break;
                }
                case 12: {
                    break;
                }
                case 13: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(LocalizedStrings.RemoteGfManagerAgent_UNKNOWN_VM_KIND_0.toLocalizedString(id.getVmKind()));
                }
            }
            if (this.abortCurrentJoin) {
                return;
            }
            if (member != null) {
                if (this.abortCurrentJoin) {
                    return;
                }
                Iterator it = this.listeners.iterator();
                while (it.hasNext()) {
                    if (this.abortCurrentJoin) {
                        return;
                    }
                    JoinLeaveListener l = (JoinLeaveListener)it.next();
                    try {
                        l.nodeJoined(this, member);
                    }
                    catch (VirtualMachineError e) {
                        SystemFailure.initiateFailure(e);
                        throw e;
                    }
                    catch (Throwable e) {
                        SystemFailure.checkFailure();
                        logger.warn((Message)LocalizedMessage.create(LocalizedStrings.RemoteGfManagerAgent_LISTENER_THREW_AN_EXCEPTION), e);
                    }
                }
            }
        }
        finally {
            this.removePendingJoins(id);
            if (this.abortCurrentJoin) {
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.RemoteGfManagerAgent_ABORTED__0, id));
            }
            this.currentJoin = null;
            this.abortCurrentJoin = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPendingJoin(InternalDistributedMember id) {
        Object object = this.pendingJoinsLock;
        synchronized (object) {
            List oldPendingJoins = this.pendingJoins;
            if (!oldPendingJoins.contains(id)) {
                ArrayList<InternalDistributedMember> newPendingJoins = new ArrayList<InternalDistributedMember>(oldPendingJoins);
                newPendingJoins.add(id);
                this.pendingJoins = newPendingJoins;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePendingJoins(InternalDistributedMember id) {
        Object object = this.pendingJoinsLock;
        synchronized (object) {
            List oldPendingJoins = this.pendingJoins;
            if (oldPendingJoins.contains(id)) {
                ArrayList newPendingJoins = new ArrayList(oldPendingJoins);
                newPendingJoins.remove(id);
                this.pendingJoins = newPendingJoins;
            }
        }
    }

    protected void cancelPendingJoins(InternalDistributedMember id) {
        try {
            this.joinProcessor.pauseHandling();
            this.removePendingJoins(id);
            this.joinProcessor.abort(id);
        }
        finally {
            AdminWaiters.cancelWaiters(id);
            this.joinProcessor.resumeHandling();
        }
    }

    private class MyMembershipListener
    implements MembershipListener {
        private final Set distributedMembers = new HashSet();

        protected MyMembershipListener() {
        }

        protected void addMembers(Set initMembers) {
            this.distributedMembers.addAll(initMembers);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void memberJoined(InternalDistributedMember id) {
            if (!RemoteGfManagerAgent.this.isListening()) {
                return;
            }
            MyMembershipListener myMembershipListener = this;
            synchronized (myMembershipListener) {
                if (!this.distributedMembers.contains(id)) {
                    this.distributedMembers.add(id);
                    RemoteGfManagerAgent.this.addPendingJoin(id);
                    RemoteGfManagerAgent.this.joinProcessor.resumeHandling();
                }
            }
        }

        @Override
        public void memberSuspect(InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
        }

        @Override
        public void quorumLost(Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void memberDeparted(InternalDistributedMember id, boolean crashed) {
            MyMembershipListener myMembershipListener = this;
            synchronized (myMembershipListener) {
                if (!this.distributedMembers.remove(id)) {
                    return;
                }
                RemoteGfManagerAgent.this.cancelPendingJoins(id);
                if (!RemoteGfManagerAgent.this.isListening()) {
                    return;
                }
            }
            RemoteApplicationVM member = null;
            switch (id.getVmKind()) {
                case 10: {
                    member = RemoteGfManagerAgent.this.removeMember(id);
                    break;
                }
                case 12: {
                    break;
                }
                case 11: {
                    break;
                }
                case 13: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(LocalizedStrings.RemoteGfManagerAgent_UNKNOWN_VM_KIND.toLocalizedString());
                }
            }
            if (member != null) {
                for (JoinLeaveListener l : RemoteGfManagerAgent.this.listeners) {
                    if (crashed) {
                        l.nodeCrashed(RemoteGfManagerAgent.this, member);
                        continue;
                    }
                    l.nodeLeft(RemoteGfManagerAgent.this, member);
                }
                member.stopStatListening();
            }
        }
    }

    private class JoinProcessor
    extends Thread {
        private volatile boolean paused;
        private volatile boolean shutDown;
        private volatile InternalDistributedMember id;
        private final Object lock;

        public JoinProcessor() {
            super(RemoteGfManagerAgent.this.threadGroup, "JoinProcessor");
            this.paused = false;
            this.shutDown = false;
            this.lock = new Object();
            this.setDaemon(true);
        }

        public void shutDown() {
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "JoinProcessor: shutting down");
            }
            this.shutDown = true;
            this.interrupt();
        }

        private void pauseHandling() {
            this.paused = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resumeHandling() {
            if (logger.isTraceEnabled(LogMarker.DM)) {
                logger.trace(LogMarker.DM, "JoinProcessor: resuming.  Is alive? {}", new Object[]{this.isAlive()});
            }
            this.paused = false;
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        public void abort(InternalDistributedMember memberId) {
            if (memberId.equals(RemoteGfManagerAgent.this.currentJoin)) {
                RemoteGfManagerAgent.this.abortCurrentJoin = true;
                this.interrupt();
            }
            if (this.id != null && this.id.equals(memberId)) {
                this.id = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean noPendingJoins = false;
            block12: while (!this.shutDown) {
                SystemFailure.checkFailure();
                try {
                    if (!RemoteGfManagerAgent.this.isListening()) {
                        this.shutDown();
                    }
                    if ((noPendingJoins = RemoteGfManagerAgent.this.pendingJoins.isEmpty()) && logger.isDebugEnabled()) {
                        logger.debug("Pausing as there are no pending joins ... ");
                    }
                    if (this.paused || noPendingJoins) {
                        if (logger.isTraceEnabled(LogMarker.DM)) {
                            logger.trace(LogMarker.DM, "JoinProcessor is about to wait...");
                        }
                        Object object = this.lock;
                        synchronized (object) {
                            this.lock.wait();
                        }
                    }
                    if (logger.isTraceEnabled(LogMarker.DM)) {
                        logger.trace(LogMarker.DM, "JoinProcessor has woken up...");
                    }
                    if (this.paused) continue;
                    if (this.id == null) {
                        List pendingJoinsRef = RemoteGfManagerAgent.this.pendingJoins;
                        if (logger.isTraceEnabled(LogMarker.DM)) {
                            logger.trace(LogMarker.DM, "JoinProcessor pendingJoins: {}", new Object[]{pendingJoinsRef.size()});
                        }
                        if (pendingJoinsRef.size() > 0) {
                            this.id = (InternalDistributedMember)pendingJoinsRef.get(0);
                            if (logger.isTraceEnabled(LogMarker.DM)) {
                                logger.trace(LogMarker.DM, "JoinProcessor got a membership event for {}", new Object[]{this.id});
                            }
                        }
                    }
                    if (this.paused || this.id == null) continue;
                    if (logger.isTraceEnabled(LogMarker.DM)) {
                        logger.trace(LogMarker.DM, "JoinProcessor handling join for {}", new Object[]{this.id});
                    }
                    try {
                        RemoteGfManagerAgent.this.handleJoined(this.id);
                    }
                    finally {
                        this.id = null;
                    }
                }
                catch (CancelException e) {
                    this.shutDown = true;
                    break;
                }
                catch (InterruptedException ignore) {
                    if (logger.isTraceEnabled(LogMarker.DM)) {
                        logger.trace(LogMarker.DM, "JoinProcessor has been interrupted...");
                    }
                    if (this.shutDown || !this.paused && !noPendingJoins) break;
                    if (logger.isDebugEnabled()) {
                        logger.debug("JoinProcessor was interrupted when it was paused, now resuming ...", (Throwable)ignore);
                    }
                    noPendingJoins = false;
                }
                catch (OperationCancelledException ex) {
                    if (!logger.isTraceEnabled(LogMarker.DM)) continue;
                    logger.trace(LogMarker.DM, "join cancelled by departure");
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable e) {
                    SystemFailure.checkFailure();
                    for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
                        if (!(cause instanceof InterruptedException)) continue;
                        if (!logger.isTraceEnabled(LogMarker.DM)) continue block12;
                        logger.trace(LogMarker.DM, "JoinProcessor has been interrupted...");
                        continue block12;
                    }
                    logger.error((Message)LocalizedMessage.create(LocalizedStrings.RemoteGfManagerAgent_JOINPROCESSOR_CAUGHT_EXCEPTION), e);
                }
            }
        }
    }

    private class SnapshotResultDispatcher
    extends Thread {
        private volatile boolean shutDown;

        public SnapshotResultDispatcher() {
            super(RemoteGfManagerAgent.this.threadGroup, "SnapshotResultDispatcher");
            this.shutDown = false;
            this.setDaemon(true);
        }

        public void shutDown() {
            this.shutDown = true;
            this.interrupt();
        }

        @Override
        public void run() {
            while (!this.shutDown) {
                SystemFailure.checkFailure();
                try {
                    SnapshotResultMessage msg = (SnapshotResultMessage)RemoteGfManagerAgent.this.snapshotResults.take();
                    RemoteGfManagerAgent.this.callCacheCollector(msg.getSnapshot(), msg.getSender(), msg.getSnapshotId());
                    SnapshotResultDispatcher.yield();
                }
                catch (InterruptedException ignore) {
                    if (this.shutDown) break;
                    logger.warn((Message)LocalizedMessage.create(LocalizedStrings.RemoteGfManagerAgent_IGNORING_STRANGE_INTERRUPT), (Throwable)ignore);
                }
                catch (Exception ex) {
                    logger.fatal(ex.getMessage(), (Throwable)ex);
                }
            }
        }
    }

    private class DSConnectionDaemon
    extends Thread {
        private volatile boolean shutDown;

        protected DSConnectionDaemon() {
            super(RemoteGfManagerAgent.this.threadGroup, "DSConnectionDaemon");
            this.shutDown = false;
            this.setDaemon(true);
        }

        public void shutDown() {
            this.shutDown = true;
            this.interrupt();
        }

        @Override
        public void run() {
            block5: while (!this.shutDown) {
                SystemFailure.checkFailure();
                try {
                    RemoteGfManagerAgent.this.connected = false;
                    RemoteGfManagerAgent.this.initialized = false;
                    if (!this.shutDown) {
                        RemoteGfManagerAgent.this.connectToDS();
                        if (RemoteGfManagerAgent.this.isListening()) {
                            Assert.assertTrue(RemoteGfManagerAgent.this.system != null);
                        }
                        return;
                    }
                }
                catch (IncompatibleSystemException ise) {
                    logger.fatal(ise.getMessage(), (Throwable)ise);
                    RemoteGfManagerAgent.this.callAlertListener(new VersionMismatchAlert(RemoteGfManagerAgent.this, ise.getMessage()));
                }
                catch (Exception e) {
                    for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                        if (cause instanceof InterruptedException && this.shutDown) break block5;
                        if (!(cause instanceof AuthenticationFailedException)) continue;
                        this.shutDown = true;
                        RemoteGfManagerAgent.this.securityLogWriter.warning(LocalizedStrings.RemoteGFManagerAgent_AN_AUTHENTICATIONFAILEDEXCEPTION_WAS_CAUGHT_WHILE_CONNECTING_TO_DS, (Throwable)e);
                        break block5;
                    }
                    logger.debug("[RemoteGfManagerAgent] While connecting to DS", (Throwable)e);
                }
                try {
                    DSConnectionDaemon.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            RemoteGfManagerAgent.this.connected = false;
            RemoteGfManagerAgent.this.initialized = false;
        }
    }
}

