/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.PooledDistributionMessage;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class RegionAdminMessage
extends PooledDistributionMessage {
    private String regionName;

    public void setRegionName(String name) {
        this.regionName = name;
    }

    public String getRegionName() {
        return this.regionName;
    }

    protected Region getRegion(DistributedSystem sys) {
        Cache cache = CacheFactory.getInstance(sys);
        return cache.getRegion(this.regionName);
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeString(this.regionName, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.regionName = DataSerializer.readString(in);
    }
}

