/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import com.gemstone.gemfire.internal.admin.remote.Cancellable;
import com.gemstone.gemfire.internal.admin.remote.CancellationRegistry;
import com.gemstone.gemfire.internal.admin.remote.ObjectDetailsResponse;
import com.gemstone.gemfire.internal.admin.remote.RegionAdminRequest;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class ObjectDetailsRequest
extends RegionAdminRequest
implements Cancellable {
    private Object objName;
    private int inspectionType;
    private transient boolean cancelled;
    private ObjectDetailsResponse resp;

    public static ObjectDetailsRequest create(Object objName, int inspectionType) {
        ObjectDetailsRequest m = new ObjectDetailsRequest();
        m.objName = objName;
        m.inspectionType = inspectionType;
        return m;
    }

    public ObjectDetailsRequest() {
        this.friendlyName = LocalizedStrings.ObjectDetailsRequest_INSPECT_CACHED_OBJECT.toLocalizedString();
    }

    @Override
    public synchronized void cancel() {
        this.cancelled = true;
        if (this.resp != null) {
            this.resp.cancel();
        }
    }

    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        CancellationRegistry.getInstance().registerMessage(this);
        this.resp = ObjectDetailsResponse.create(dm, this.getSender());
        if (this.cancelled) {
            return null;
        }
        this.resp.buildDetails(this.getRegion(dm.getSystem()), this.objName, this.inspectionType);
        if (this.cancelled) {
            return null;
        }
        CancellationRegistry.getInstance().deregisterMessage(this);
        return this.resp;
    }

    @Override
    public int getDSFID() {
        return 1037;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.objName, out);
        out.writeInt(this.inspectionType);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.objName = DataSerializer.readObject(in);
        this.inspectionType = in.readInt();
    }

    @Override
    public String toString() {
        return "ObjectDetailsRequest from " + this.getRecipient() + " region=" + this.getRegionName() + " object=" + this.objName;
    }
}

