/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.cache.persistence.PersistentID;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberPattern;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class MissingPersistentIDsResponse
extends AdminResponse {
    private Set<PersistentID> missingIds;
    private Set<PersistentID> localIds;

    public MissingPersistentIDsResponse() {
    }

    public MissingPersistentIDsResponse(Set<PersistentID> missingIds, Set<PersistentID> localIds, InternalDistributedMember recipient) {
        this.missingIds = missingIds;
        this.localIds = localIds;
        this.setRecipient(recipient);
    }

    @Override
    public int getDSFID() {
        return 2106;
    }

    @Override
    protected void process(DistributionManager dm) {
        super.process(dm);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        PersistentMemberPattern pattern;
        int i;
        super.fromData(in);
        int size = in.readInt();
        this.missingIds = new HashSet<PersistentID>(size);
        for (i = 0; i < size; ++i) {
            pattern = new PersistentMemberPattern();
            InternalDataSerializer.invokeFromData(pattern, in);
            this.missingIds.add(pattern);
        }
        size = in.readInt();
        this.localIds = new HashSet<PersistentID>(size);
        for (i = 0; i < size; ++i) {
            pattern = new PersistentMemberPattern();
            InternalDataSerializer.invokeFromData(pattern, in);
            this.localIds.add(pattern);
        }
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.missingIds.size());
        for (PersistentID pattern : this.missingIds) {
            InternalDataSerializer.invokeToData(pattern, out);
        }
        out.writeInt(this.localIds.size());
        for (PersistentID pattern : this.localIds) {
            InternalDataSerializer.invokeToData(pattern, out);
        }
    }

    public Set<PersistentID> getMissingIds() {
        return this.missingIds;
    }

    public Set<PersistentID> getLocalIds() {
        return this.localIds;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public String toString() {
        return this.getClass().getName() + ": missing=" + this.missingIds + "local=" + this.localIds;
    }
}

