/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class InspectionClasspathManager {
    private static InspectionClasspathManager internalRef;
    private Map pathsToLoaders = new HashMap();
    private ThreadLocal oldClassLoader = new ThreadLocal();

    public static synchronized InspectionClasspathManager getInstance() {
        if (internalRef == null) {
            internalRef = new InspectionClasspathManager();
        }
        return internalRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jumpToModifiedClassLoader(String modifiedClasspath) {
        if (modifiedClasspath != null && modifiedClasspath.length() > 0) {
            ClassLoader current = Thread.currentThread().getContextClassLoader();
            this.oldClassLoader.set(current);
            Map map = this.pathsToLoaders;
            synchronized (map) {
                ClassLoader newClassLoader = (ClassLoader)this.pathsToLoaders.get(modifiedClasspath);
                if (newClassLoader == null) {
                    URL[] urls = this.convertToURLs(modifiedClasspath);
                    URLClassLoader userClassLoader = new URLClassLoader(urls, current);
                    this.pathsToLoaders.put(modifiedClasspath, userClassLoader);
                    newClassLoader = userClassLoader;
                }
                Thread.currentThread().setContextClassLoader(newClassLoader);
            }
        }
    }

    public void revertToOldClassLoader() {
        ClassLoader loader = (ClassLoader)this.oldClassLoader.get();
        if (loader != null) {
            Thread.currentThread().setContextClassLoader(loader);
            this.oldClassLoader.set(null);
        }
    }

    private URL[] convertToURLs(String classpath) {
        ArrayList<URL> urls = new ArrayList<URL>();
        StringTokenizer tokenizer = new StringTokenizer(classpath, ":;");
        while (tokenizer.hasMoreTokens()) {
            File f = new File(tokenizer.nextToken());
            try {
                f = f.getCanonicalFile();
            }
            catch (IOException ex) {
                continue;
            }
            try {
                urls.add(f.toURL());
            }
            catch (MalformedURLException mue) {}
        }
        URL[] array = new URL[urls.size()];
        return urls.toArray(array);
    }
}

