/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import com.gemstone.gemfire.internal.admin.remote.RemoteGemFireVM;
import com.gemstone.gemfire.internal.admin.remote.RemoteStatResource;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;

public final class FetchStatsResponse
extends AdminResponse {
    private RemoteStatResource[] stats;

    public static FetchStatsResponse create(DistributionManager dm, InternalDistributedMember recipient, final String statisticsTypeName) {
        FetchStatsResponse m = new FetchStatsResponse();
        m.setRecipient(recipient);
        final ArrayList statList = new ArrayList();
        if (statisticsTypeName == null) {
            dm.getSystem().visitStatistics(new InternalDistributedSystem.StatisticsVisitor(){

                @Override
                public void visit(Statistics s) {
                    statList.add(new RemoteStatResource(s));
                }
            });
        } else {
            dm.getSystem().visitStatistics(new InternalDistributedSystem.StatisticsVisitor(){

                @Override
                public void visit(Statistics s) {
                    if (s.getType().getName().equals(statisticsTypeName)) {
                        statList.add(new RemoteStatResource(s));
                    }
                }
            });
        }
        m.stats = new RemoteStatResource[statList.size()];
        m.stats = statList.toArray(m.stats);
        return m;
    }

    @Override
    public boolean sendViaUDP() {
        return true;
    }

    @Override
    public int getDSFID() {
        return 1030;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.stats, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.stats = (RemoteStatResource[])DataSerializer.readObject(in);
    }

    public RemoteStatResource[] getAllStats(RemoteGemFireVM vm) {
        for (int i = 0; i < this.stats.length; ++i) {
            this.stats[i].setGemFireVM(vm);
        }
        return this.stats;
    }

    public RemoteStatResource[] getStats(RemoteGemFireVM vm) {
        ArrayList<RemoteStatResource> statList = new ArrayList<RemoteStatResource>();
        for (int i = 0; i < this.stats.length; ++i) {
            this.stats[i].setGemFireVM(vm);
            statList.add(this.stats[i]);
        }
        return statList.toArray(new RemoteStatResource[0]);
    }

    @Override
    public String toString() {
        return "FetchStatsResponse from " + this.getRecipient() + " stats.length=" + this.stats.length;
    }
}

