/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.internal.admin.remote.AdminRequest;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import com.gemstone.gemfire.internal.admin.remote.FetchResourceAttributesResponse;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class FetchResourceAttributesRequest
extends AdminRequest {
    private long resourceUniqueId;

    public static FetchResourceAttributesRequest create(long id) {
        FetchResourceAttributesRequest m = new FetchResourceAttributesRequest();
        m.resourceUniqueId = id;
        return m;
    }

    public FetchResourceAttributesRequest() {
        this.friendlyName = LocalizedStrings.FetchResourceAttributesRequest_FETCH_STATISTICS_FOR_RESOURCE.toLocalizedString();
    }

    @Override
    public AdminResponse createResponse(DistributionManager dm) {
        return FetchResourceAttributesResponse.create(dm, this.getSender(), this.resourceUniqueId);
    }

    @Override
    public int getDSFID() {
        return 1027;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeLong(this.resourceUniqueId);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.resourceUniqueId = in.readLong();
    }

    @Override
    public String toString() {
        return LocalizedStrings.FetchResourceAttributesRequest_FETCHRESOURCEATTRIBUTESREQUEST_FOR_0.toLocalizedString(this.getRecipient());
    }
}

