/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.admin.GemFireHealth;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.internal.admin.remote.AdminRequest;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import com.gemstone.gemfire.internal.admin.remote.FetchHealthDiagnosisResponse;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class FetchHealthDiagnosisRequest
extends AdminRequest {
    private int id = 0;
    private GemFireHealth.Health healthCode = null;

    public static FetchHealthDiagnosisRequest create(int id, GemFireHealth.Health healthCode) {
        FetchHealthDiagnosisRequest m = new FetchHealthDiagnosisRequest();
        m.init_(id, healthCode);
        return m;
    }

    public FetchHealthDiagnosisRequest() {
        this.init_(0, null);
    }

    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        return FetchHealthDiagnosisResponse.create(dm, this.getSender(), this.id, this.healthCode);
    }

    @Override
    public int getDSFID() {
        return 1023;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.id);
        DataSerializer.writeObject(this.healthCode, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        int i = in.readInt();
        GemFireHealth.Health oHC = (GemFireHealth.Health)DataSerializer.readObject(in);
        this.init_(i, oHC);
    }

    @Override
    public String toString() {
        return LocalizedStrings.FetchHealthDiagnosisRequest_FETCHHEALTHDIAGNOSISREQUEST_FROM_ID_1_HEALTHCODE_2.toLocalizedString(this.getRecipient(), this.id, this.healthCode);
    }

    private void init_(int i, GemFireHealth.Health oHC) {
        this.id = i;
        this.healthCode = oHC;
        this.friendlyName = LocalizedStrings.FetchHealthDiagnosisRequest_FETCH_HEALTH_DIAGNOSIS_FOR_HEALTH_CODE_0.toLocalizedString(this.healthCode);
    }
}

