/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import com.gemstone.gemfire.internal.admin.remote.DurableClientInfoRequest;
import com.gemstone.gemfire.internal.cache.CacheServerImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DurableClientInfoResponse
extends AdminResponse {
    private boolean returnVal = false;

    public static DurableClientInfoResponse create(DistributionManager dm, InternalDistributedMember recipient, DurableClientInfoRequest request) {
        DurableClientInfoResponse m = new DurableClientInfoResponse();
        m.setRecipient(recipient);
        try {
            GemFireCacheImpl c = (GemFireCacheImpl)CacheFactory.getInstanceCloseOk(dm.getSystem());
            if (c.getCacheServers().size() > 0) {
                CacheServerImpl server = (CacheServerImpl)c.getCacheServers().iterator().next();
                switch (request.action) {
                    case 10: {
                        m.returnVal = server.getAcceptor().getCacheClientNotifier().hasDurableClient(request.durableId);
                        break;
                    }
                    case 11: {
                        m.returnVal = server.getAcceptor().getCacheClientNotifier().hasPrimaryForDurableClient(request.durableId);
                    }
                }
            }
        }
        catch (CacheClosedException cacheClosedException) {
            // empty catch block
        }
        return m;
    }

    public boolean getResultBoolean() {
        return this.returnVal;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeBoolean(this.returnVal);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.returnVal = in.readBoolean();
    }

    @Override
    public String toString() {
        return "DurableClientInfoResponse from " + this.getSender();
    }

    @Override
    public int getDSFID() {
        return -23;
    }
}

