/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import com.gemstone.gemfire.internal.admin.remote.RemoteCacheInfo;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class CacheInfoResponse
extends AdminResponse {
    private RemoteCacheInfo info;

    public static CacheInfoResponse create(DistributionManager dm, InternalDistributedMember recipient) {
        CacheInfoResponse m = new CacheInfoResponse();
        m.setRecipient(recipient);
        try {
            GemFireCacheImpl c = (GemFireCacheImpl)CacheFactory.getInstanceCloseOk(dm.getSystem());
            m.info = new RemoteCacheInfo(c);
        }
        catch (CancelException ex) {
            m.info = null;
        }
        return m;
    }

    public RemoteCacheInfo getCacheInfo() {
        return this.info;
    }

    @Override
    public int getDSFID() {
        return 1015;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.info, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.info = (RemoteCacheInfo)DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return "CacheInfoResponse from " + this.getSender() + " info=" + this.info;
    }
}

