/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import com.gemstone.gemfire.internal.admin.remote.RemoteCacheInfo;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class CacheConfigResponse
extends AdminResponse {
    private RemoteCacheInfo info;
    private Exception exception;

    public static CacheConfigResponse create(DistributionManager dm, InternalDistributedMember recipient, int cacheId, byte attributeCode, int newValue) {
        CacheConfigResponse m = new CacheConfigResponse();
        m.setRecipient(recipient);
        try {
            GemFireCacheImpl c = (GemFireCacheImpl)CacheFactory.getInstanceCloseOk(dm.getSystem());
            if (cacheId != System.identityHashCode(c)) {
                m.info = null;
            } else {
                switch (attributeCode) {
                    case 1: {
                        c.setLockTimeout(newValue);
                        break;
                    }
                    case 2: {
                        c.setLockLease(newValue);
                        break;
                    }
                    case 3: {
                        c.setSearchTimeout(newValue);
                        break;
                    }
                    default: {
                        Assert.assertTrue(false, "Unknown config code: " + attributeCode);
                    }
                }
            }
            m.info = new RemoteCacheInfo(c);
        }
        catch (CancelException ex) {
            m.info = null;
        }
        catch (Exception ex) {
            m.exception = ex;
            m.info = null;
        }
        return m;
    }

    public RemoteCacheInfo getCacheInfo() {
        return this.info;
    }

    public Exception getException() {
        return this.exception;
    }

    @Override
    public int getDSFID() {
        return 1013;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.info, out);
        DataSerializer.writeObject(this.exception, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.info = (RemoteCacheInfo)DataSerializer.readObject(in);
        this.exception = (Exception)DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return "CacheConfigResponse from " + this.getSender() + " info=" + this.info;
    }
}

