/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.admin.OperationCancelledException;
import com.gemstone.gemfire.admin.RuntimeAdminException;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.admin.remote.AdminFailureResponse;
import com.gemstone.gemfire.internal.admin.remote.AdminReplyProcessor;
import com.gemstone.gemfire.internal.admin.remote.AdminRequest;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import com.gemstone.gemfire.internal.admin.remote.CancellationMessage;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class AdminWaiters {
    private static final Logger logger = LogService.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AdminResponse sendAndWait(AdminRequest msg, DistributionManager dm) {
        if (dm.getId().equals(msg.getRecipient())) {
            msg.setSender(dm.getId());
            return msg.createResponse(dm);
        }
        AdminResponse result = null;
        try {
            AdminRequest adminRequest = msg;
            synchronized (adminRequest) {
                Set failures = dm.putOutgoing(msg);
                if (failures != null && failures.size() > 0) {
                    if (dm.getDistributionManagerIds().contains(msg.getRecipient())) {
                        String s = "";
                        if (logger.isTraceEnabled(LogMarker.DM)) {
                            s = s + " (" + msg + ")";
                        }
                        throw new RuntimeAdminException(LocalizedStrings.AdminWaiters_COULD_NOT_SEND_REQUEST_0.toLocalizedString(s));
                    }
                    throw new OperationCancelledException(LocalizedStrings.AdminWaiters_REQUEST_SENT_TO_0_FAILED_SINCE_MEMBER_DEPARTED_1.toLocalizedString(msg.getRecipient(), ""));
                }
                long timeout = AdminWaiters.getWaitTimeout();
                boolean gotResponse = msg.waitForResponse(timeout);
                if (!gotResponse) {
                    if (dm.isCurrentMember(msg.getRecipient())) {
                        StringBuffer sb = new StringBuffer("Administration request ");
                        sb.append(msg);
                        sb.append(" sent to ");
                        sb.append(msg.getRecipient());
                        sb.append(" timed out after ");
                        sb.append(timeout / 1000L);
                        sb.append(" seconds.");
                        throw new RuntimeAdminException(sb.toString());
                    }
                    String s = "";
                    if (logger.isTraceEnabled(LogMarker.DM)) {
                        s = " (" + msg + ")";
                    }
                    throw new OperationCancelledException(LocalizedStrings.AdminWaiters_REQUEST_SENT_TO_0_FAILED_SINCE_MEMBER_DEPARTED_1.toLocalizedString(msg.getRecipient(), s));
                }
                result = msg.getResponse();
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            dm.getCancelCriterion().checkCancelInProgress(ex);
            String s = LocalizedStrings.AdminWaiters_REQUEST_WAIT_WAS_INTERRUPTED.toLocalizedString();
            if (logger.isTraceEnabled(LogMarker.DM)) {
                s = s + " (" + msg + ")";
            }
            throw new RuntimeAdminException(s, ex);
        }
        if (result == null) {
            String s = "";
            if (logger.isTraceEnabled(LogMarker.DM)) {
                s = s + " (" + msg + ")";
            }
            throw new OperationCancelledException(LocalizedStrings.AdminWaiters_REQUEST_SEND_TO_0_WAS_CANCELLED_1.toLocalizedString(msg.getRecipient(), s));
        }
        if (result instanceof AdminFailureResponse) {
            throw new RuntimeAdminException(LocalizedStrings.AdminWaiters_REQUEST_FAILED.toLocalizedString(), ((AdminFailureResponse)result).getCause());
        }
        return result;
    }

    public static void sendResponse(AdminResponse msg) {
        int id = msg.getMsgId();
        ReplyProcessor21 processor = ReplyProcessor21.getProcessor(id);
        if (processor == null) {
            return;
        }
        processor.process(msg);
    }

    public static void cancelWaiters(InternalDistributedMember id) {
    }

    public static void cancelRequest(int msgId, DistributionManager dm) {
        AdminReplyProcessor processor = (AdminReplyProcessor)ReplyProcessor21.getProcessor(msgId);
        if (processor != null) {
            InternalDistributedMember recipient = processor.getResponder();
            dm.putOutgoing(CancellationMessage.create(recipient, msgId));
            processor.cancel();
        }
    }

    private static long getWaitTimeout() {
        String prop = System.getProperty("remote.call.timeout", "1800");
        try {
            int val = Integer.parseInt(prop);
            return Math.abs((long)val * 1000L);
        }
        catch (NumberFormatException nfe) {
            return 1800000L;
        }
    }
}

