/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.distributed.internal.DistributionMessage;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;

class AdminReplyProcessor
extends ReplyProcessor21 {
    private volatile AdminResponse response;
    private volatile Thread thread;
    private volatile boolean isCancelled = false;
    private final InternalDistributedMember responder;

    AdminReplyProcessor(InternalDistributedSystem system, InternalDistributedMember member) {
        super(system, member);
        this.responder = member;
    }

    @Override
    public void process(DistributionMessage message) {
        try {
            this.response = (AdminResponse)message;
        }
        finally {
            super.process(message);
        }
    }

    @Override
    protected void preWait() {
        this.thread = Thread.currentThread();
        super.preWait();
    }

    public void cancel() {
        this.isCancelled = true;
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    protected boolean handleInterruption(InterruptedException ie, long msecsRemaining) throws InterruptedException, ReplyException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.isCancelled) {
            return true;
        }
        throw ie;
    }

    public AdminResponse getResponse() {
        return this.response;
    }

    public InternalDistributedMember getResponder() {
        return this.responder;
    }
}

