/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.GemFireStatSampler;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class AddStatListenerResponse
extends AdminResponse {
    int listenerId;

    public static AddStatListenerResponse create(DistributionManager dm, InternalDistributedMember recipient, long resourceId, String statName) {
        AddStatListenerResponse m = new AddStatListenerResponse();
        m.setRecipient(recipient);
        GemFireStatSampler sampler = null;
        sampler = dm.getSystem().getStatSampler();
        if (sampler != null) {
            m.listenerId = sampler.addListener(recipient, resourceId, statName);
        }
        return m;
    }

    public int getListenerId() {
        return this.listenerId;
    }

    @Override
    public int getDSFID() {
        return 1003;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.listenerId);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.listenerId = in.readInt();
    }

    @Override
    public String toString() {
        return "AddStatListenerResponse from " + this.getRecipient() + " listenerId=" + this.listenerId;
    }
}

