/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin.remote;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.admin.GemFireHealthConfig;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.internal.admin.remote.AddHealthListenerResponse;
import com.gemstone.gemfire.internal.admin.remote.AdminRequest;
import com.gemstone.gemfire.internal.admin.remote.AdminResponse;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class AddHealthListenerRequest
extends AdminRequest {
    private GemFireHealthConfig cfg;

    public static AddHealthListenerRequest create(GemFireHealthConfig cfg) {
        if (cfg == null) {
            throw new NullPointerException(LocalizedStrings.AddHealthListenerRequest_NULL_GEMFIREHEALTHCONFIG.toLocalizedString());
        }
        AddHealthListenerRequest m = new AddHealthListenerRequest();
        m.cfg = cfg;
        return m;
    }

    public AddHealthListenerRequest() {
        this.friendlyName = LocalizedStrings.AddHealthListenerRequest_ADD_HEALTH_LISTENER.toLocalizedString();
    }

    @Override
    protected AdminResponse createResponse(DistributionManager dm) {
        return AddHealthListenerResponse.create(dm, this.getSender(), this.cfg);
    }

    @Override
    public int getDSFID() {
        return 1000;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject(this.cfg, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.cfg = (GemFireHealthConfig)DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return "AddHealthListenerRequest from " + this.getRecipient() + " cfg=" + this.cfg;
    }
}

