/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin;

import java.util.Properties;

public class SSLConfig {
    private boolean enabled = false;
    private String protocols = "any";
    private String ciphers = "any";
    private boolean requireAuth = true;
    private Properties properties = new Properties();

    public SSLConfig() {
    }

    public SSLConfig(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getProtocols() {
        return this.protocols;
    }

    public void setProtocols(String protocols) {
        this.protocols = protocols;
    }

    public String getCiphers() {
        return this.ciphers;
    }

    public void setCiphers(String ciphers) {
        this.ciphers = ciphers;
    }

    public boolean isRequireAuth() {
        return this.requireAuth;
    }

    public void setRequireAuth(boolean requireAuth) {
        this.requireAuth = requireAuth;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties newProps) {
        this.properties = new Properties();
        for (String string : newProps.keySet()) {
            this.properties.setProperty(string, newProps.getProperty(string));
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[SSLConfig: ");
        sb.append("enabled=").append(this.enabled);
        sb.append(", protocols=").append(this.protocols);
        sb.append(", ciphers=").append(this.ciphers);
        sb.append(", requireAuth=").append(this.requireAuth);
        sb.append(", properties=").append(this.properties);
        sb.append("]");
        return sb.toString();
    }

    public void toDSProperties(Properties props) {
        props.setProperty("ssl-enabled", String.valueOf(this.enabled));
        if (this.enabled) {
            props.setProperty("ssl-protocols", this.protocols);
            props.setProperty("ssl-ciphers", this.ciphers);
            props.setProperty("ssl-require-authentication", String.valueOf(this.requireAuth));
        }
    }
}

