/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.admin;

import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.GemFireHealth;
import com.gemstone.gemfire.admin.GemFireHealthConfig;
import com.gemstone.gemfire.admin.GemFireMemberStatus;
import com.gemstone.gemfire.admin.RegionSubRegionSnapshot;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Config;
import com.gemstone.gemfire.internal.admin.AdminBridgeServer;
import com.gemstone.gemfire.internal.admin.CacheInfo;
import com.gemstone.gemfire.internal.admin.DLockInfo;
import com.gemstone.gemfire.internal.admin.GfManagerAgent;
import com.gemstone.gemfire.internal.admin.HealthListener;
import com.gemstone.gemfire.internal.admin.Stat;
import com.gemstone.gemfire.internal.admin.StatAlertDefinition;
import com.gemstone.gemfire.internal.admin.StatListener;
import com.gemstone.gemfire.internal.admin.StatResource;
import java.io.File;
import java.net.InetAddress;
import java.util.Date;

public interface GemFireVM {
    public static final int LIGHTWEIGHT_CACHE_VALUE = 100;
    public static final int LOGICAL_CACHE_VALUE = 200;
    public static final int PHYSICAL_CACHE_VALUE = 300;

    public InetAddress getHost();

    public String getName();

    public File getWorkingDirectory();

    public File getGemFireDir();

    public Date getBirthDate();

    public String getVersionInfo();

    public StatResource[] getStats(String var1);

    public StatResource[] getAllStats();

    public DLockInfo[] getDistributedLockInfo();

    public void addStatListener(StatListener var1, StatResource var2, Stat var3);

    public void removeStatListener(StatListener var1);

    public void addHealthListener(HealthListener var1, GemFireHealthConfig var2);

    public void removeHealthListener();

    public void resetHealthStatus();

    public String[] getHealthDiagnosis(GemFireHealth.Health var1);

    public Config getConfig();

    public GemFireMemberStatus getSnapshot();

    public RegionSubRegionSnapshot getRegionSnapshot();

    public void setConfig(Config var1);

    public GfManagerAgent getManagerAgent();

    public String[] getSystemLogs();

    public void setInspectionClasspath(String var1);

    public String getInspectionClasspath();

    public Region[] getRootRegions();

    public Region getRegion(CacheInfo var1, String var2);

    public Region createVMRootRegion(CacheInfo var1, String var2, RegionAttributes var3) throws AdminException;

    public Region createSubregion(CacheInfo var1, String var2, String var3, RegionAttributes var4) throws AdminException;

    public void setCacheInspectionMode(int var1);

    public int getCacheInspectionMode();

    public void takeRegionSnapshot(String var1, int var2);

    public InternalDistributedMember getId();

    public CacheInfo getCacheInfo();

    public CacheInfo setCacheLockTimeout(CacheInfo var1, int var2) throws AdminException;

    public CacheInfo setCacheLockLease(CacheInfo var1, int var2) throws AdminException;

    public CacheInfo setCacheSearchTimeout(CacheInfo var1, int var2) throws AdminException;

    public AdminBridgeServer addCacheServer(CacheInfo var1) throws AdminException;

    public AdminBridgeServer getBridgeInfo(CacheInfo var1, int var2) throws AdminException;

    public AdminBridgeServer startBridgeServer(CacheInfo var1, AdminBridgeServer var2) throws AdminException;

    public AdminBridgeServer stopBridgeServer(CacheInfo var1, AdminBridgeServer var2) throws AdminException;

    public void setAlertsManager(StatAlertDefinition[] var1, long var2, boolean var4);

    public void setRefreshInterval(long var1);

    public void updateAlertDefinitions(StatAlertDefinition[] var1, int var2);
}

