/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import com.gemstone.gemfire.cache.UnsupportedVersionException;
import com.gemstone.gemfire.internal.cache.tier.sockets.CommandInitializer;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class Version
implements Comparable<Version> {
    private final transient String name;
    private final transient String productName;
    private final transient String methodSuffix;
    private final byte majorVersion;
    private final byte minorVersion;
    private final byte release;
    private final byte patch;
    private Version gemfireVersion;
    private final short ordinal;
    public static final int HIGHEST_VERSION = 45;
    private static final Version[] VALUES = new Version[46];
    private static final byte TOKEN_ORDINAL = -1;
    private static final int TOKEN_ORDINAL_INT = 255;
    public static final Version TOKEN = new Version("", "TOKEN", -1, 0, 0, 0, -1);
    private static final byte GFE_56_ORDINAL = 0;
    public static final Version GFE_56 = new Version("GFE", "5.6", 5, 6, 0, 0, 0);
    private static final byte GFE_57_ORDINAL = 1;
    public static final Version GFE_57 = new Version("GFE", "5.7", 5, 7, 0, 0, 1);
    private static final byte GFE_58_ORDINAL = 3;
    public static final Version GFE_58 = new Version("GFE", "5.8", 5, 8, 0, 0, 3);
    private static final byte GFE_603_ORDINAL = 4;
    public static final Version GFE_603 = new Version("GFE", "6.0.3", 6, 0, 3, 0, 4);
    private static final byte GFE_61_ORDINAL = 5;
    public static final Version GFE_61 = new Version("GFE", "6.1", 6, 1, 0, 0, 5);
    private static final byte GFE_65_ORDINAL = 6;
    public static final Version GFE_65 = new Version("GFE", "6.5", 6, 5, 0, 0, 6);
    private static final byte GFE_651_ORDINAL = 7;
    public static final Version GFE_651 = new Version("GFE", "6.5.1", 6, 5, 1, 0, 7);
    private static final byte GFE_6516_ORDINAL = 12;
    public static final Version GFE_6516 = new Version("GFE", "6.5.1.6", 6, 5, 1, 6, 12);
    private static final byte GFE_66_ORDINAL = 16;
    public static final Version GFE_66 = new Version("GFE", "6.6", 6, 6, 0, 0, 16);
    private static final byte GFE_662_ORDINAL = 17;
    public static final Version GFE_662 = new Version("GFE", "6.6.2", 6, 6, 2, 0, 17);
    private static final byte GFE_6622_ORDINAL = 18;
    public static final Version GFE_6622 = new Version("GFE", "6.6.2.2", 6, 6, 2, 2, 18);
    private static final byte GFE_70_ORDINAL = 19;
    public static final Version GFE_70 = new Version("GFE", "7.0", 7, 0, 0, 0, 19);
    private static final byte GFE_701_ORDINAL = 20;
    public static final Version GFE_701 = new Version("GFE", "7.0.1", 7, 0, 1, 0, 20);
    private static final byte GFE_7099_ORDINAL = 21;
    public static final Version GFE_7099 = new Version("GFE", "7.0.99", 7, 0, 99, 0, 21);
    private static final byte GFE_71_ORDINAL = 22;
    public static final Version GFE_71 = new Version("GFE", "7.1", 7, 1, 0, 0, 22);
    private static final byte GFE_80_ORDINAL = 30;
    public static final Version GFE_80 = new Version("GFE", "8.0", 8, 0, 0, 0, 30);
    private static final byte GFE_8009_ORDINAL = 31;
    public static final Version GFE_8009 = new Version("GFE", "8.0.0.9", 8, 0, 0, 9, 31);
    private static final byte GFE_81_ORDINAL = 35;
    public static final Version GFE_81 = new Version("GFE", "8.1", 8, 1, 0, 0, 35);
    private static final byte GFE_82_ORDINAL = 40;
    public static final Version GFE_82 = new Version("GFE", "8.2", 8, 2, 0, 0, 40);
    private static final byte GFE_90_ORDINAL = 45;
    public static final Version GFE_90;
    public static final Version CURRENT;
    public static final short CURRENT_ORDINAL;
    public static final short NOT_SUPPORTED_ORDINAL = 59;
    private static final byte validOrdinalForTesting = 2;
    public static final Version TEST_VERSION;

    private Version(String product, String name, byte major, byte minor, byte release, byte patch, byte ordinal) {
        this.productName = product;
        this.name = name;
        this.majorVersion = major;
        this.minorVersion = minor;
        this.release = release;
        this.patch = patch;
        this.ordinal = ordinal;
        this.methodSuffix = this.productName + "_" + this.majorVersion + "_" + this.minorVersion + "_" + this.release + "_" + this.patch;
        this.gemfireVersion = null;
        if (ordinal != -1) {
            Version.VALUES[this.ordinal] = this;
        }
    }

    private Version(String product, String name, byte major, byte minor, byte release, byte patch, byte ordinal, Version gemfireVersion) {
        this(product, name, major, minor, release, patch, ordinal);
        this.gemfireVersion = gemfireVersion;
    }

    public static Version fromOrdinal(short ordinal, boolean forGFEClients) throws UnsupportedVersionException {
        if (ordinal == 59) {
            throw new UnsupportedVersionException("Un-versioned clients are not supported. ");
        }
        if (ordinal == -1) {
            return TOKEN;
        }
        if (VALUES.length < ordinal + 1 || VALUES[ordinal] == null || forGFEClients && CommandInitializer.getCommands(VALUES[ordinal]) == null) {
            throw new UnsupportedVersionException(LocalizedStrings.Version_REMOTE_VERSION_NOT_SUPPORTED.toLocalizedString(ordinal, Version.CURRENT.name));
        }
        return VALUES[ordinal];
    }

    public static Version fromOrdinalOrCurrent(short ordinal) {
        Version version;
        if (ordinal == -1) {
            return TOKEN;
        }
        if (VALUES.length < ordinal + 1 || (version = VALUES[ordinal]) == null) {
            return CURRENT;
        }
        return version;
    }

    public static void writeOrdinal(DataOutput out, short ordinal, boolean compressed) throws IOException {
        if (compressed && ordinal <= 127) {
            out.writeByte(ordinal);
        } else {
            out.writeByte(-1);
            out.writeShort(ordinal);
        }
    }

    public final void writeOrdinal(DataOutput out, boolean compressed) throws IOException {
        Version.writeOrdinal(out, this.ordinal, compressed);
    }

    public static final int uncompressedSize() {
        return 3;
    }

    public final int compressedSize() {
        if (this.ordinal <= 127) {
            return 1;
        }
        return 3;
    }

    public static void writeOrdinal(ByteBuffer buffer, short ordinal, boolean compressed) throws IOException {
        if (compressed && ordinal <= 127) {
            buffer.put((byte)ordinal);
        } else {
            buffer.put((byte)-1);
            buffer.putShort(ordinal);
        }
    }

    public static short readOrdinal(DataInput in) throws IOException {
        byte ordinal = in.readByte();
        if (ordinal != -1) {
            return ordinal;
        }
        return in.readShort();
    }

    public static Version readVersion(DataInput in, boolean returnNullForCurrent) throws IOException {
        return Version.fromOrdinalNoThrow(Version.readOrdinal(in), returnNullForCurrent);
    }

    public static Version fromOrdinalNoThrow(short ordinal, boolean returnNullForCurrent) {
        if (ordinal == -1) {
            return TOKEN;
        }
        if (ordinal >= VALUES.length || VALUES[ordinal] == null) {
            return returnNullForCurrent ? null : CURRENT;
        }
        return VALUES[ordinal];
    }

    public static short readOrdinalFromInputStream(InputStream is) throws IOException {
        int ordinal = is.read();
        if (ordinal != -1) {
            int ordinalPart2;
            if (ordinal != 255) {
                return (short)ordinal;
            }
            int ordinalPart1 = is.read();
            if ((ordinalPart1 | (ordinalPart2 = is.read())) >= 0) {
                return (short)(ordinalPart1 << 8 | ordinalPart2);
            }
            return -1;
        }
        return -1;
    }

    public Version getGemFireVersion() {
        return this.gemfireVersion != null ? this.gemfireVersion : this;
    }

    public final String getMethodSuffix() {
        return this.methodSuffix;
    }

    public final String getProductName() {
        return this.productName;
    }

    public final String getName() {
        return this.name;
    }

    public final short getMajorVersion() {
        return this.majorVersion;
    }

    public final short getMinorVersion() {
        return this.minorVersion;
    }

    public final short getRelease() {
        return this.release;
    }

    public final short getPatch() {
        return this.patch;
    }

    public final short ordinal() {
        return this.ordinal;
    }

    public boolean compatibleWith(Version version) {
        return true;
    }

    @Override
    public final int compareTo(short other) {
        Version v = Version.fromOrdinalNoThrow(other, false);
        if (v == null) {
            return this.ordinal() - other;
        }
        return this.compareTo(v);
    }

    @Override
    public final int compareTo(Version other) {
        if (other != null) {
            if (this.majorVersion > other.majorVersion) {
                return 1;
            }
            if (other.majorVersion > this.majorVersion) {
                return -1;
            }
            if (this.minorVersion > other.minorVersion) {
                return 1;
            }
            if (other.minorVersion > this.minorVersion) {
                return -1;
            }
            if (this.release > other.release) {
                return 1;
            }
            if (other.release > this.release) {
                return -1;
            }
            if (this.patch > other.patch) {
                return 1;
            }
            if (other.patch > this.patch) {
                return -1;
            }
            return 0;
        }
        return 1;
    }

    public String toString() {
        if (this.gemfireVersion == null) {
            return this.productName + " " + this.name;
        }
        return this.productName + " " + this.name + '[' + this.gemfireVersion.toString() + ']';
    }

    public static String toString(short ordinal) {
        if (ordinal <= Version.CURRENT.ordinal) {
            try {
                return Version.fromOrdinal(ordinal, false).toString();
            }
            catch (UnsupportedVersionException unsupportedVersionException) {
                // empty catch block
            }
        }
        return "UNKNOWN[ordinal=" + ordinal + ']';
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other != null && other.getClass() == Version.class) {
            return this.ordinal == ((Version)other).ordinal;
        }
        return false;
    }

    public boolean equals(Version other) {
        return other != null && this.ordinal == other.ordinal;
    }

    public int hashCode() {
        int result = 17;
        int mult = 37;
        result = 37 * result + this.ordinal;
        return result;
    }

    public byte[] toBytes() {
        byte[] bytes = new byte[]{(byte)(this.ordinal >> 8), (byte)this.ordinal};
        return bytes;
    }

    static {
        CURRENT = GFE_90 = new Version("GFE", "9.0", 9, 0, 0, 0, 45);
        CURRENT_ORDINAL = CURRENT.ordinal();
        TEST_VERSION = new Version("TEST", "VERSION", 0, 0, 0, 0, 2);
    }
}

