/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import com.gemstone.gemfire.GemFireConfigException;
import com.gemstone.gemfire.SystemConnectException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.admin.internal.InetAddressUtil;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.cache.wan.GatewayTransportFilter;
import com.gemstone.gemfire.distributed.ClientSocketFactory;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.distributed.internal.DistributionConfigImpl;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.ConnectionWatcher;
import com.gemstone.gemfire.internal.GfeConsoleReaderFactory;
import com.gemstone.gemfire.internal.SocketUtils;
import com.gemstone.gemfire.internal.cache.wan.TransportFilterServerSocket;
import com.gemstone.gemfire.internal.cache.wan.TransportFilterSocketFactory;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LocalizedMessage;
import com.gemstone.gemfire.internal.tcp.TCPConduit;
import com.gemstone.gemfire.internal.util.PasswordUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.BindException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;

public class SocketCreator {
    private static final Logger logger = LogService.getLogger();
    public static final String USE_LINK_LOCAL_ADDRESSES_PROPERTY = "gemfire.net.useLinkLocalAddresses";
    private static final boolean useLinkLocalAddresses = Boolean.getBoolean("gemfire.net.useLinkLocalAddresses");
    private static final InetAddress localHost;
    private static boolean useIPv6Addresses;
    private static final Map<InetAddress, String> hostNames;
    public static final boolean FORCE_DNS_USE;
    public static volatile boolean resolve_dns;
    private static SocketCreator DEFAULT_INSTANCE;
    private boolean ready = false;
    private boolean useSSL;
    private boolean needClientAuth;
    private String[] protocols;
    private String[] ciphers;
    private boolean configShown = false;
    private SSLContext sslContext;
    private ClientSocketFactory clientSocketFactory;
    public static final boolean ENABLE_TCP_KEEP_ALIVE;

    private SocketCreator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SocketCreator getDefaultInstance() {
        SocketCreator socketCreator = DEFAULT_INSTANCE;
        synchronized (socketCreator) {
            if (!SocketCreator.DEFAULT_INSTANCE.ready) {
                DEFAULT_INSTANCE.initialize();
            }
        }
        return DEFAULT_INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SocketCreator getDefaultInstance(DistributionConfig config) {
        SocketCreator socketCreator = DEFAULT_INSTANCE;
        synchronized (socketCreator) {
            DEFAULT_INSTANCE.initialize(config);
        }
        return DEFAULT_INSTANCE;
    }

    public static SocketCreator getDefaultInstance(Properties props) {
        return SocketCreator.getDefaultInstance(new DistributionConfigImpl(props));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SocketCreator createNonDefaultInstance(boolean useSSL, boolean needClientAuth, String protocols, String ciphers, Properties sysProps) {
        SocketCreator sc;
        SocketCreator socketCreator = sc = new SocketCreator();
        synchronized (socketCreator) {
            sc.initialize(useSSL, needClientAuth, SocketCreator.readArray(protocols), SocketCreator.readArray(ciphers), sysProps);
        }
        return sc;
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        if (localHost == null) {
            throw new UnknownHostException();
        }
        return localHost;
    }

    public static boolean preferIPv6Addresses() {
        return useIPv6Addresses;
    }

    public static synchronized String getHostName(InetAddress addr) {
        String result = hostNames.get(addr);
        if (result == null) {
            result = addr.getHostName();
            hostNames.put(addr, result);
        }
        return result;
    }

    public static synchronized String getCanonicalHostName(InetAddress addr, String hostName) {
        String result = hostNames.get(addr);
        if (result == null) {
            hostNames.put(addr, hostName);
            return hostName;
        }
        return result;
    }

    public static synchronized void resetHostNameCache() {
        hostNames.clear();
    }

    /*
     * Unable to fully structure code
     */
    private void initialize(boolean useSSL, boolean needClientAuth, String[] protocols, String[] ciphers, Properties props) {
        Assert.assertHoldsLock(this, true);
        try {
            this.useSSL = useSSL;
            this.needClientAuth = needClientAuth;
            this.protocols = protocols;
            this.ciphers = ciphers;
            if (this == SocketCreator.DEFAULT_INSTANCE) {
                if (this.useSSL) {
                    System.setProperty("p2p.useSSL", "true");
                    System.setProperty("p2p.oldIO", "true");
                    System.setProperty("p2p.nodirectBuffers", "true");
                    try {
                        if (this.sslContext != null) ** GOTO lbl25
                        this.sslContext = this.createAndConfigureSSLContext(protocols, props);
                        SSLContext.setDefault(this.sslContext);
                    }
                    catch (Exception e) {
                        throw new GemFireConfigException("Error configuring GemFire ssl ", e);
                    }
                } else {
                    System.setProperty("p2p.useSSL", "false");
                }
lbl25:
                // 3 sources

                TCPConduit.init();
            } else if (this.useSSL && this.sslContext == null) {
                try {
                    this.sslContext = this.createAndConfigureSSLContext(protocols, props);
                }
                catch (Exception e) {
                    throw new GemFireConfigException("Error configuring GemFire ssl ", e);
                }
            }
            this.initializeClientSocketFactory();
            this.ready = true;
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Error t) {
            SystemFailure.checkFailure();
            t.printStackTrace();
            throw t;
        }
        catch (RuntimeException re) {
            re.printStackTrace();
            throw re;
        }
    }

    private SSLContext createAndConfigureSSLContext(String[] protocolNames, Properties props) throws GeneralSecurityException, IOException {
        SSLContext newSSLContext = SocketCreator.getSSLContextInstance(protocolNames);
        KeyManager[] keyManagers = this.getKeyManagers(props);
        TrustManager[] trustManagers = this.getTrustManagers(props);
        newSSLContext.init(keyManagers, trustManagers, null);
        return newSSLContext;
    }

    public static void readSSLProperties(Map<String, String> env) {
        SocketCreator.readSSLProperties(env, false);
    }

    public static void readSSLProperties(Map<String, String> env, boolean ignoreGemFirePropsFile) {
        Properties props = new Properties();
        DistributionConfigImpl.loadGemFireProperties(props, ignoreGemFirePropsFile);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            Map.Entry<Object, Object> ent = entry;
            if (!((String)ent.getKey()).startsWith("javax.net.ssl") && !((String)ent.getKey()).startsWith("sysprop-")) continue;
            String key = (String)ent.getKey();
            if (key.startsWith("sysprop-")) {
                key = key.substring("sysprop-".length());
            }
            if (ent.getValue() != null && !((String)ent.getValue()).trim().equals("")) continue;
            GfeConsoleReaderFactory.GfeConsoleReader consoleReader = GfeConsoleReaderFactory.getDefaultConsoleReader();
            if (!consoleReader.isSupported()) {
                throw new GemFireConfigException("SSL properties are empty, but a console is not available");
            }
            if (key.toLowerCase().contains("password")) {
                char[] password = consoleReader.readPassword("Please enter " + key + ": ");
                env.put(key, PasswordUtil.encrypt(new String(password), false));
                continue;
            }
            String val = consoleReader.readLine("Please enter " + key + ": ");
            env.put(key, val);
        }
    }

    private static SSLContext getSSLContextInstance(String[] protocols) {
        String[] knownAlgorithms;
        SSLContext c = null;
        if (protocols != null && protocols.length > 0) {
            for (String protocol : protocols) {
                if (protocol.equals("any")) continue;
                try {
                    c = SSLContext.getInstance(protocol);
                    break;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
            }
        }
        if (c != null) {
            return c;
        }
        for (String algo : knownAlgorithms = new String[]{"SSL", "SSLv2", "SSLv3", "TLS", "TLSv1", "TLSv1.1", "TLSv1.2"}) {
            try {
                c = SSLContext.getInstance(algo);
                break;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
        }
        return c;
    }

    private TrustManager[] getTrustManagers(Properties sysProps) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        TrustManager[] trustManagers = null;
        String trustStoreType = sysProps.getProperty("javax.net.ssl.trustStoreType");
        GfeConsoleReaderFactory.GfeConsoleReader consoleReader = GfeConsoleReaderFactory.getDefaultConsoleReader();
        if (trustStoreType == null) {
            trustStoreType = System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType());
        } else if (trustStoreType.trim().equals("")) {
            if (consoleReader.isSupported()) {
                trustStoreType = consoleReader.readLine("Please enter the trustStoreType (javax.net.ssl.trustStoreType) : ");
            }
            if (this.isEmpty(trustStoreType)) {
                trustStoreType = KeyStore.getDefaultType();
            }
        }
        KeyStore ts = KeyStore.getInstance(trustStoreType);
        String trustStorePath = System.getProperty("javax.net.ssl.trustStore");
        if (trustStorePath == null) {
            trustStorePath = sysProps.getProperty("javax.net.ssl.trustStore");
        }
        if (trustStorePath != null) {
            if (trustStorePath.trim().equals("") && this.isEmpty(trustStorePath = System.getenv("javax.net.ssl.trustStore")) && consoleReader.isSupported()) {
                trustStorePath = consoleReader.readLine("Please enter the trustStore location (javax.net.ssl.trustStore) : ");
            }
            FileInputStream fis = new FileInputStream(trustStorePath);
            String passwordString = System.getProperty("javax.net.ssl.trustStorePassword");
            if (passwordString == null) {
                passwordString = sysProps.getProperty("javax.net.ssl.trustStorePassword");
            }
            char[] password = null;
            if (passwordString != null) {
                if (passwordString.trim().equals("")) {
                    String encryptedPass = System.getenv("javax.net.ssl.trustStorePassword");
                    if (!this.isEmpty(encryptedPass)) {
                        String toDecrypt = "encrypted(" + encryptedPass + ")";
                        passwordString = PasswordUtil.decrypt(toDecrypt);
                        password = passwordString.toCharArray();
                    }
                    if (this.isEmpty(passwordString) && consoleReader.isSupported()) {
                        password = consoleReader.readPassword("Please enter password for trustStore (javax.net.ssl.trustStorePassword) : ");
                    }
                } else {
                    password = passwordString.toCharArray();
                }
            }
            ts.load(fis, password);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ts);
            trustManagers = tmf.getTrustManagers();
            if (password != null) {
                Arrays.fill(password, ' ');
            }
        }
        return trustManagers;
    }

    private KeyManager[] getKeyManagers(Properties sysProps) throws KeyStoreException, FileNotFoundException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        KeyManager[] keyManagers = null;
        String keyStoreType = sysProps.getProperty("javax.net.ssl.keyStoreType");
        GfeConsoleReaderFactory.GfeConsoleReader consoleReader = GfeConsoleReaderFactory.getDefaultConsoleReader();
        if (keyStoreType == null) {
            keyStoreType = System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType());
        } else if (keyStoreType.trim().equals("")) {
            if (consoleReader.isSupported()) {
                keyStoreType = consoleReader.readLine("Please enter the keyStoreType (javax.net.ssl.keyStoreType) : ");
            }
            if (this.isEmpty(keyStoreType)) {
                keyStoreType = KeyStore.getDefaultType();
            }
        }
        KeyStore ks = KeyStore.getInstance(keyStoreType);
        String keyStoreFilePath = sysProps.getProperty("javax.net.ssl.keyStore");
        if (keyStoreFilePath == null) {
            keyStoreFilePath = System.getProperty("javax.net.ssl.keyStore");
        }
        if (keyStoreFilePath != null) {
            if (keyStoreFilePath.trim().equals("")) {
                keyStoreFilePath = System.getenv("javax.net.ssl.keyStore");
                if (this.isEmpty(keyStoreFilePath) && consoleReader.isSupported()) {
                    keyStoreFilePath = consoleReader.readLine("Please enter the keyStore location (javax.net.ssl.keyStore) : ");
                }
                if (this.isEmpty(keyStoreFilePath)) {
                    keyStoreFilePath = System.getProperty("user.home") + System.getProperty("file.separator") + ".keystore";
                }
            }
            FileInputStream fis = null;
            fis = new FileInputStream(keyStoreFilePath);
            String passwordString = sysProps.getProperty("javax.net.ssl.keyStorePassword");
            if (passwordString == null) {
                passwordString = System.getProperty("javax.net.ssl.keyStorePassword");
            }
            char[] password = null;
            if (passwordString != null) {
                if (passwordString.trim().equals("")) {
                    String encryptedPass = System.getenv("javax.net.ssl.keyStorePassword");
                    if (!this.isEmpty(encryptedPass)) {
                        String toDecrypt = "encrypted(" + encryptedPass + ")";
                        passwordString = PasswordUtil.decrypt(toDecrypt);
                        password = passwordString.toCharArray();
                    }
                    if (this.isEmpty(passwordString) && consoleReader != null) {
                        password = consoleReader.readPassword("Please enter password for keyStore (javax.net.ssl.keyStorePassword) : ");
                    }
                } else {
                    password = passwordString.toCharArray();
                }
            }
            ks.load(fis, password);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, password);
            keyManagers = kmf.getKeyManagers();
            if (password != null) {
                Arrays.fill(password, ' ');
            }
        }
        return keyManagers;
    }

    private boolean isEmpty(String string) {
        return string == null || string.trim().equals("");
    }

    private void initialize() {
        this.initialize(new DistributionConfigImpl(new Properties()));
    }

    private void initialize(DistributionConfig config) {
        DistributionConfig conf = config;
        if (conf == null) {
            conf = new DistributionConfigImpl(new Properties());
        }
        this.initialize(conf.getClusterSSLEnabled(), conf.getClusterSSLRequireAuthentication(), SocketCreator.readArray(conf.getClusterSSLProtocols()), SocketCreator.readArray(conf.getClusterSSLCiphers()), conf.getClusterSSLProperties());
    }

    public boolean useSSL() {
        return this.useSSL;
    }

    public ServerSocket createServerSocket(int nport, int backlog) throws IOException {
        return this.createServerSocket(nport, backlog, null);
    }

    public ServerSocket createServerSocket(int nport, int backlog, InetAddress bindAddr, List<GatewayTransportFilter> transportFilters, int socketBufferSize) throws IOException {
        if (transportFilters.isEmpty()) {
            return this.createServerSocket(nport, backlog, bindAddr, socketBufferSize);
        }
        this.printConfig();
        TransportFilterServerSocket result = new TransportFilterServerSocket(transportFilters);
        result.setReuseAddress(true);
        result.setReceiveBufferSize(socketBufferSize);
        try {
            result.bind(new InetSocketAddress(bindAddr, nport), backlog);
        }
        catch (BindException e) {
            BindException throwMe = new BindException(LocalizedStrings.SocketCreator_FAILED_TO_CREATE_SERVER_SOCKET_ON_0_1.toLocalizedString(bindAddr, nport));
            throwMe.initCause(e);
            throw throwMe;
        }
        return result;
    }

    public ServerSocket createServerSocket(int nport, int backlog, InetAddress bindAddr) throws IOException {
        return this.createServerSocket(nport, backlog, bindAddr, -1);
    }

    public ServerSocket createServerSocket(int nport, int backlog, InetAddress bindAddr, int socketBufferSize) throws IOException {
        this.printConfig();
        if (this.useSSL) {
            if (this.sslContext == null) {
                throw new GemFireConfigException("SSL not configured correctly, Please look at previous error");
            }
            SSLServerSocketFactory ssf = this.sslContext.getServerSocketFactory();
            SSLServerSocket serverSocket = (SSLServerSocket)ssf.createServerSocket();
            serverSocket.setReuseAddress(true);
            if (socketBufferSize != -1) {
                serverSocket.setReceiveBufferSize(socketBufferSize);
            }
            serverSocket.bind(new InetSocketAddress(bindAddr, nport), backlog);
            this.finishServerSocket(serverSocket);
            return serverSocket;
        }
        ServerSocket result = new ServerSocket();
        result.setReuseAddress(true);
        if (socketBufferSize != -1) {
            result.setReceiveBufferSize(socketBufferSize);
        }
        try {
            result.bind(new InetSocketAddress(bindAddr, nport), backlog);
        }
        catch (BindException e) {
            BindException throwMe = new BindException(LocalizedStrings.SocketCreator_FAILED_TO_CREATE_SERVER_SOCKET_ON_0_1.toLocalizedString(bindAddr, nport));
            throwMe.initCause(e);
            throw throwMe;
        }
        return result;
    }

    public ServerSocket createServerSocketUsingPortRange(InetAddress ba, int backlog, boolean isBindAddress, boolean useNIO, int tcpBufferSize, int[] tcpPortRange) throws IOException {
        int randPort;
        ServerSocket socket = null;
        int localPort = 0;
        int startingPort = 0;
        SecureRandom rand = new SecureRandom();
        int portLimit = tcpPortRange[1];
        localPort = startingPort = (randPort = tcpPortRange[0] + rand.nextInt(tcpPortRange[1] - tcpPortRange[0] + 1));
        while (true) {
            if (localPort > portLimit) {
                if (startingPort != 0) {
                    localPort = tcpPortRange[0];
                    portLimit = startingPort - 1;
                    startingPort = 0;
                } else {
                    throw new SystemConnectException(LocalizedStrings.TCPConduit_UNABLE_TO_FIND_FREE_PORT.toLocalizedString());
                }
            }
            try {
                if (useNIO) {
                    ServerSocketChannel channl = ServerSocketChannel.open();
                    socket = channl.socket();
                    InetSocketAddress addr = new InetSocketAddress(isBindAddress ? ba : null, localPort);
                    socket.bind(addr, backlog);
                    break;
                }
                socket = SocketCreator.getDefaultInstance().createServerSocket(localPort, backlog, isBindAddress ? ba : null, tcpBufferSize);
            }
            catch (SocketException ex) {
                if (useNIO || SocketCreator.treatAsBindException(ex)) {
                    ++localPort;
                    continue;
                }
                throw ex;
            }
            break;
        }
        return socket;
    }

    public static boolean treatAsBindException(SocketException se) {
        if (se instanceof BindException) {
            return true;
        }
        String msg = se.getMessage();
        return msg != null && msg.contains("Invalid argument: listen failed");
    }

    public Socket connectForClient(String host, int port, int timeout) throws IOException {
        return this.connect(InetAddress.getByName(host), port, timeout, null, true, -1);
    }

    public Socket connectForClient(String host, int port, int timeout, int socketBufferSize) throws IOException {
        return this.connect(InetAddress.getByName(host), port, timeout, null, true, socketBufferSize);
    }

    public Socket connectForServer(InetAddress inetadd, int port) throws IOException {
        return this.connect(inetadd, port, 0, null, false, -1);
    }

    public Socket connectForServer(InetAddress inetadd, int port, int socketBufferSize) throws IOException {
        return this.connect(inetadd, port, 0, null, false, socketBufferSize);
    }

    public Socket connect(InetAddress inetadd, int port, int timeout, ConnectionWatcher optionalWatcher, boolean clientSide) throws IOException {
        return this.connect(inetadd, port, timeout, optionalWatcher, clientSide, -1);
    }

    public Socket connect(InetAddress inetadd, int port, int timeout, ConnectionWatcher optionalWatcher, boolean clientSide, int socketBufferSize) throws IOException {
        return this.connect(inetadd, port, timeout, optionalWatcher, clientSide, socketBufferSize, this.useSSL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket connect(InetAddress inetadd, int port, int timeout, ConnectionWatcher optionalWatcher, boolean clientSide, int socketBufferSize, boolean sslConnection) throws IOException {
        InetSocketAddress sockaddr;
        Socket socket;
        block17: {
            socket = null;
            sockaddr = new InetSocketAddress(inetadd, port);
            this.printConfig();
            try {
                if (!sslConnection) break block17;
                if (this.sslContext == null) {
                    throw new GemFireConfigException("SSL not configured correctly, Please look at previous error");
                }
                SSLSocketFactory sf = this.sslContext.getSocketFactory();
                socket = sf.createSocket();
                socket.setKeepAlive(ENABLE_TCP_KEEP_ALIVE);
                if (socketBufferSize != -1) {
                    socket.setReceiveBufferSize(socketBufferSize);
                }
                if (optionalWatcher != null) {
                    optionalWatcher.beforeConnect(socket);
                }
                if (timeout > 0) {
                    SocketUtils.connect(socket, sockaddr, timeout);
                } else {
                    SocketUtils.connect(socket, sockaddr, 0);
                }
                this.configureClientSSLSocket(socket);
                Socket socket2 = socket;
                if (optionalWatcher != null) {
                    optionalWatcher.afterConnect(socket);
                }
                return socket2;
            }
            catch (Throwable throwable) {
                if (optionalWatcher != null) {
                    optionalWatcher.afterConnect(socket);
                }
                throw throwable;
            }
        }
        if (clientSide && this.clientSocketFactory != null) {
            socket = this.clientSocketFactory.createSocket(inetadd, port);
        } else {
            socket = new Socket();
            socket.setKeepAlive(ENABLE_TCP_KEEP_ALIVE);
            if (socketBufferSize != -1) {
                socket.setReceiveBufferSize(socketBufferSize);
            }
            if (optionalWatcher != null) {
                optionalWatcher.beforeConnect(socket);
            }
            if (timeout > 0) {
                SocketUtils.connect(socket, sockaddr, timeout);
            } else {
                SocketUtils.connect(socket, sockaddr, 0);
            }
        }
        Socket socket3 = socket;
        if (optionalWatcher != null) {
            optionalWatcher.afterConnect(socket);
        }
        return socket3;
    }

    public void configureServerSSLSocket(Socket socket) throws IOException {
        if (socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            try {
                sslSocket.startHandshake();
                SSLSession session = sslSocket.getSession();
                Certificate[] peer = session.getPeerCertificates();
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.SocketCreator_SSL_CONNECTION_FROM_PEER_0, ((X509Certificate)peer[0]).getSubjectDN()));
            }
            catch (SSLPeerUnverifiedException ex) {
                if (this.needClientAuth) {
                    logger.fatal((Message)LocalizedMessage.create(LocalizedStrings.SocketCreator_SSL_ERROR_IN_AUTHENTICATING_PEER_0_1, new Object[]{socket.getInetAddress(), socket.getPort()}), (Throwable)ex);
                    throw ex;
                }
            }
            catch (SSLException ex) {
                logger.fatal((Message)LocalizedMessage.create(LocalizedStrings.SocketCreator_SSL_ERROR_IN_CONNECTING_TO_PEER_0_1, new Object[]{socket.getInetAddress(), socket.getPort()}), (Throwable)ex);
                throw ex;
            }
        }
    }

    private void finishServerSocket(SSLServerSocket serverSocket) throws IOException {
        serverSocket.setUseClientMode(false);
        if (this.needClientAuth) {
            serverSocket.setNeedClientAuth(true);
        }
        serverSocket.setEnableSessionCreation(true);
        if (!"any".equalsIgnoreCase(this.protocols[0])) {
            serverSocket.setEnabledProtocols(this.protocols);
        }
        if (!"any".equalsIgnoreCase(this.ciphers[0])) {
            serverSocket.setEnabledCipherSuites(this.ciphers);
        }
    }

    private void configureClientSSLSocket(Socket socket) throws IOException {
        if (socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            sslSocket.setUseClientMode(true);
            sslSocket.setEnableSessionCreation(true);
            if (this.protocols != null && !"any".equalsIgnoreCase(this.protocols[0])) {
                sslSocket.setEnabledProtocols(this.protocols);
            }
            if (this.ciphers != null && !"any".equalsIgnoreCase(this.ciphers[0])) {
                sslSocket.setEnabledCipherSuites(this.ciphers);
            }
            try {
                sslSocket.startHandshake();
                SSLSession session = sslSocket.getSession();
                Certificate[] peer = session.getPeerCertificates();
                logger.info((Message)LocalizedMessage.create(LocalizedStrings.SocketCreator_SSL_CONNECTION_FROM_PEER_0, ((X509Certificate)peer[0]).getSubjectDN()));
            }
            catch (SSLPeerUnverifiedException ex) {
                if (this.needClientAuth) {
                    logger.fatal((Message)LocalizedMessage.create(LocalizedStrings.SocketCreator_SSL_ERROR_IN_AUTHENTICATING_PEER), (Throwable)ex);
                    throw ex;
                }
            }
            catch (SSLException ex) {
                logger.fatal((Message)LocalizedMessage.create(LocalizedStrings.SocketCreator_SSL_ERROR_IN_CONNECTING_TO_PEER_0_1, new Object[]{socket.getInetAddress(), socket.getPort()}), (Throwable)ex);
                throw ex;
            }
        }
    }

    private void printConfig() {
        if (!this.configShown && logger.isDebugEnabled()) {
            this.configShown = true;
            StringBuffer sb = new StringBuffer();
            sb.append("SSL Configuration: \n");
            sb.append("  ssl-enabled = " + this.useSSL).append("\n");
            for (String key : System.getProperties().stringPropertyNames()) {
                if (!key.startsWith("javax.net.ssl")) continue;
                sb.append("  ").append(key).append(" = ").append(System.getProperty(key)).append("\n");
            }
            logger.debug(sb.toString());
        }
    }

    private static String[] readArray(String text) {
        if (text == null || text.trim().equals("")) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(text);
        Vector<String> v = new Vector<String>();
        while (st.hasMoreTokens()) {
            v.add(st.nextToken());
        }
        return v.toArray(new String[v.size()]);
    }

    protected void initializeClientSocketFactory() {
        this.clientSocketFactory = null;
        String className = System.getProperty("gemfire.clientSocketFactory");
        if (className != null) {
            Object o;
            try {
                Class<?> c = ClassPathLoader.getLatest().forName(className);
                o = c.newInstance();
            }
            catch (Exception e) {
                String s = "An unexpected exception occurred while instantiating a " + className + ": " + e;
                throw new IllegalArgumentException(s);
            }
            if (o instanceof ClientSocketFactory) {
                this.clientSocketFactory = (ClientSocketFactory)o;
            } else {
                String s = "Class \"" + className + "\" is not a ClientSocketFactory";
                throw new IllegalArgumentException(s);
            }
        }
    }

    public void initializeTransportFilterClientSocketFactory(GatewaySender sender) {
        this.clientSocketFactory = new TransportFilterSocketFactory().setGatewayTransportFilters(sender.getGatewayTransportFilters());
    }

    public static Set<InetAddress> getMyAddresses() {
        Enumeration<NetworkInterface> interfaces;
        HashSet<InetAddress> result = new HashSet<InetAddress>();
        HashSet<InetAddress> locals = new HashSet<InetAddress>();
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new IllegalArgumentException(LocalizedStrings.StartupMessage_UNABLE_TO_EXAMINE_NETWORK_INTERFACES.toLocalizedString(), e);
        }
        while (interfaces.hasMoreElements()) {
            boolean faceIsUp;
            NetworkInterface face;
            block8: {
                face = interfaces.nextElement();
                faceIsUp = false;
                try {
                    faceIsUp = face.isUp();
                }
                catch (SocketException e) {
                    InternalDistributedSystem ids = InternalDistributedSystem.getAnyInstance();
                    if (ids == null) break block8;
                    logger.info("Failed to check if network interface is up. Skipping {}", new Object[]{face, e});
                }
            }
            if (!faceIsUp) continue;
            Enumeration<InetAddress> addrs = face.getInetAddresses();
            while (addrs.hasMoreElements()) {
                InetAddress addr = addrs.nextElement();
                if (addr.isLoopbackAddress() || addr.isAnyLocalAddress() || !useLinkLocalAddresses && addr.isLinkLocalAddress()) {
                    locals.add(addr);
                    continue;
                }
                result.add(addr);
            }
        }
        if (result.size() == 0) {
            return locals;
        }
        return result;
    }

    public static String reverseDNS(InetAddress addr) {
        byte[] addrBytes = addr.getAddress();
        String lookup = "";
        for (int index = addrBytes.length - 1; index >= 0; --index) {
            lookup = lookup + (addrBytes[index] & 0xFF) + '.';
        }
        lookup = lookup + "in-addr.arpa";
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            InitialDirContext ctx = new InitialDirContext(env);
            Attributes attrs = ctx.getAttributes(lookup, new String[]{"PTR"});
            NamingEnumeration<? extends Attribute> ae = attrs.getAll();
            while (ae.hasMoreElements()) {
                Attribute attr = ae.next();
                NamingEnumeration<?> vals = attr.getAll();
                while (vals.hasMoreElements()) {
                    Object elem = vals.nextElement();
                    if (!"PTR".equals(attr.getID()) || elem == null) continue;
                    return elem.toString();
                }
            }
            ctx.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static boolean isLocalHost(Object host) {
        if (host instanceof InetAddress) {
            if (InetAddressUtil.LOCALHOST.equals(host)) {
                return true;
            }
            if (((InetAddress)host).isLoopbackAddress()) {
                return true;
            }
            try {
                Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
                while (en.hasMoreElements()) {
                    NetworkInterface i = en.nextElement();
                    Enumeration<InetAddress> en2 = i.getInetAddresses();
                    while (en2.hasMoreElements()) {
                        InetAddress addr = en2.nextElement();
                        if (!host.equals(addr)) continue;
                        return true;
                    }
                }
                return false;
            }
            catch (SocketException e) {
                throw new IllegalArgumentException(LocalizedStrings.InetAddressUtil_UNABLE_TO_QUERY_NETWORK_INTERFACE.toLocalizedString(), e);
            }
        }
        return SocketCreator.isLocalHost(SocketCreator.toInetAddress(host.toString()));
    }

    public static InetAddress toInetAddress(String host) {
        if (host == null || host.length() == 0) {
            return null;
        }
        try {
            if (host.indexOf("/") > -1) {
                return InetAddress.getByName(host.substring(host.indexOf("/") + 1));
            }
            return InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    static {
        useIPv6Addresses = !Boolean.getBoolean("java.net.preferIPv4Stack") && Boolean.getBoolean("java.net.preferIPv6Addresses");
        hostNames = new HashMap<InetAddress, String>();
        FORCE_DNS_USE = Boolean.getBoolean("gemfire.forceDnsUse");
        resolve_dns = true;
        DEFAULT_INSTANCE = new SocketCreator();
        InetAddress lh = null;
        try {
            lh = InetAddress.getByAddress(InetAddress.getLocalHost().getAddress());
            if (lh.isLoopbackAddress()) {
                InetAddress addr;
                InetAddress ipv4Fallback = null;
                InetAddress ipv6Fallback = null;
                Set<InetAddress> myInterfaces = SocketCreator.getMyAddresses();
                boolean preferIPv6 = useIPv6Addresses;
                String lhName = null;
                Iterator<InetAddress> it = myInterfaces.iterator();
                while (lhName == null && it.hasNext() && !(addr = it.next()).isLoopbackAddress() && !addr.isAnyLocalAddress()) {
                    boolean ipv6 = addr instanceof Inet6Address;
                    boolean ipv4 = addr instanceof Inet4Address;
                    if (preferIPv6 && ipv6 || !preferIPv6 && ipv4) {
                        String addrName = SocketCreator.reverseDNS(addr);
                        if (lh.isLoopbackAddress()) {
                            lh = addr;
                            lhName = addrName;
                            continue;
                        }
                        if (addrName == null) continue;
                        lh = addr;
                        lhName = addrName;
                        continue;
                    }
                    if (preferIPv6 && ipv4 && ipv4Fallback == null) {
                        ipv4Fallback = addr;
                        continue;
                    }
                    if (preferIPv6 || !ipv6 || ipv6Fallback != null) continue;
                    ipv6Fallback = addr;
                }
                if (lh.isLoopbackAddress()) {
                    if (ipv4Fallback != null) {
                        lh = ipv4Fallback;
                        useIPv6Addresses = false;
                    } else if (ipv6Fallback != null) {
                        lh = ipv6Fallback;
                        useIPv6Addresses = true;
                    }
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        localHost = lh;
        String str = System.getProperty("gemfire.setTcpKeepAlive");
        ENABLE_TCP_KEEP_ALIVE = str != null ? Boolean.getBoolean("gemfire.setTcpKeepAlive") : true;
    }
}

