/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.LoggingThreadGroup;
import java.io.IOException;
import java.net.Socket;
import java.security.ProviderException;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.Logger;

public class SocketCloser {
    private static final Logger logger = LogService.getLogger();
    static final long ASYNC_CLOSE_POOL_KEEP_ALIVE_SECONDS = Long.getLong("p2p.ASYNC_CLOSE_POOL_KEEP_ALIVE_SECONDS", 120L);
    static final int ASYNC_CLOSE_POOL_MAX_THREADS = Integer.getInteger("p2p.ASYNC_CLOSE_POOL_MAX_THREADS", 8);
    static final long ASYNC_CLOSE_WAIT_MILLISECONDS = Long.getLong("p2p.ASYNC_CLOSE_WAIT_MILLISECONDS", 0L);
    private final HashMap<String, ThreadPoolExecutor> asyncCloseExecutors = new HashMap();
    private final long asyncClosePoolKeepAliveSeconds;
    private final int asyncClosePoolMaxThreads;
    private final long asyncCloseWaitTime;
    private final TimeUnit asyncCloseWaitUnits;
    private boolean closed;

    public SocketCloser() {
        this(ASYNC_CLOSE_POOL_KEEP_ALIVE_SECONDS, ASYNC_CLOSE_POOL_MAX_THREADS, ASYNC_CLOSE_WAIT_MILLISECONDS, TimeUnit.MILLISECONDS);
    }

    public SocketCloser(int asyncClosePoolMaxThreads, long asyncCloseWaitMillis) {
        this(ASYNC_CLOSE_POOL_KEEP_ALIVE_SECONDS, asyncClosePoolMaxThreads, asyncCloseWaitMillis, TimeUnit.MILLISECONDS);
    }

    public SocketCloser(long asyncClosePoolKeepAliveSeconds, int asyncClosePoolMaxThreads, long asyncCloseWaitTime, TimeUnit asyncCloseWaitUnits) {
        this.asyncClosePoolKeepAliveSeconds = asyncClosePoolKeepAliveSeconds;
        this.asyncClosePoolMaxThreads = asyncClosePoolMaxThreads;
        this.asyncCloseWaitTime = asyncCloseWaitTime;
        this.asyncCloseWaitUnits = asyncCloseWaitUnits;
    }

    public int getMaxThreads() {
        return this.asyncClosePoolMaxThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThreadPoolExecutor getAsyncThreadExecutor(String address) {
        HashMap<String, ThreadPoolExecutor> hashMap = this.asyncCloseExecutors;
        synchronized (hashMap) {
            ThreadPoolExecutor pool = this.asyncCloseExecutors.get(address);
            if (pool == null) {
                final LoggingThreadGroup tg = LoggingThreadGroup.createThreadGroup("Socket asyncClose", logger);
                ThreadFactory tf = new ThreadFactory(){

                    @Override
                    public Thread newThread(Runnable command) {
                        Thread thread = new Thread(tg, command);
                        thread.setDaemon(true);
                        return thread;
                    }
                };
                LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
                pool = new ThreadPoolExecutor(this.asyncClosePoolMaxThreads, this.asyncClosePoolMaxThreads, this.asyncClosePoolKeepAliveSeconds, TimeUnit.SECONDS, workQueue, tf);
                pool.allowCoreThreadTimeOut(true);
                this.asyncCloseExecutors.put(address, pool);
            }
            return pool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseResourcesForAddress(String address) {
        HashMap<String, ThreadPoolExecutor> hashMap = this.asyncCloseExecutors;
        synchronized (hashMap) {
            ThreadPoolExecutor pool = this.asyncCloseExecutors.get(address);
            if (pool != null) {
                pool.shutdown();
                this.asyncCloseExecutors.remove(address);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isClosed() {
        HashMap<String, ThreadPoolExecutor> hashMap = this.asyncCloseExecutors;
        synchronized (hashMap) {
            return this.closed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        HashMap<String, ThreadPoolExecutor> hashMap = this.asyncCloseExecutors;
        synchronized (hashMap) {
            if (!this.closed) {
                this.closed = true;
                for (ThreadPoolExecutor pool : this.asyncCloseExecutors.values()) {
                    pool.shutdown();
                }
                this.asyncCloseExecutors.clear();
            }
        }
    }

    private void asyncExecute(String address, Runnable r) {
        if (this.asyncCloseWaitTime == 0L) {
            this.getAsyncThreadExecutor(address).execute(r);
        } else {
            Future<?> future = this.getAsyncThreadExecutor(address).submit(r);
            try {
                future.get(this.asyncCloseWaitTime, this.asyncCloseWaitUnits);
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncClose(final Socket sock, final String address, final Runnable extra) {
        if (sock == null || sock.isClosed()) {
            return;
        }
        boolean doItInline = false;
        try {
            HashMap<String, ThreadPoolExecutor> hashMap = this.asyncCloseExecutors;
            synchronized (hashMap) {
                if (this.isClosed()) {
                    doItInline = true;
                } else {
                    this.asyncExecute(address, new Runnable(){

                        @Override
                        public void run() {
                            Thread.currentThread().setName("AsyncSocketCloser for " + address);
                            try {
                                if (extra != null) {
                                    extra.run();
                                }
                                SocketCloser.inlineClose(sock);
                            }
                            finally {
                                Thread.currentThread().setName("unused AsyncSocketCloser");
                            }
                        }
                    });
                }
            }
        }
        catch (OutOfMemoryError ignore) {
            doItInline = true;
        }
        if (doItInline) {
            if (extra != null) {
                extra.run();
            }
            SocketCloser.inlineClose(sock);
        }
    }

    private static void inlineClose(Socket sock) {
        block7: {
            try {
                sock.shutdownInput();
                sock.shutdownOutput();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                sock.close();
            }
            catch (IOException iOException) {
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (ProviderException err) {
            }
            catch (Error e) {
                SystemFailure.checkFailure();
                if (e.getCause() instanceof IOException) break block7;
                throw e;
            }
        }
    }
}

