/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import com.gemstone.gemfire.internal.SharedLibrary;

public final class PureJavaMode {
    public static final String PURE_MODE_PROPERTY = "gemfire.pureJavaMode";
    public static final String LOADLIBRARY_DEBUG_PROPERTY = "gemfire.loadLibrary.debug";
    private static final boolean debug = Boolean.getBoolean("gemfire.loadLibrary.debug");
    private static final boolean isPure;
    private static final boolean is64Bit;
    private static final boolean osStatsAreAvailable;

    public static final boolean isPure() {
        return isPure;
    }

    public static final boolean is64Bit() {
        return is64Bit;
    }

    public static final boolean osStatsAreAvailable() {
        return osStatsAreAvailable;
    }

    static {
        boolean tmpIsPure = false;
        if (Boolean.getBoolean(PURE_MODE_PROPERTY)) {
            if (debug) {
                System.out.println("property gemfire.pureJavaMode is true");
            }
            tmpIsPure = true;
        } else {
            tmpIsPure = false;
            try {
                SharedLibrary.loadLibrary(debug);
            }
            catch (UnsatisfiedLinkError ignore) {
                if (debug) {
                    System.out.println("java.library.path is set to:\n" + System.getProperty("java.library.path"));
                    System.out.println("Error: Failed to load library " + SharedLibrary.getName());
                    ignore.printStackTrace();
                }
                tmpIsPure = true;
            }
        }
        isPure = tmpIsPure;
        is64Bit = SharedLibrary.is64Bit();
        String osName = System.getProperty("os.name", "unknown");
        osStatsAreAvailable = osName.startsWith("Linux") || !isPure;
    }
}

