/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.internal.OSProcess;
import com.gemstone.gemfire.internal.StatisticsImpl;
import com.gemstone.gemfire.internal.StatisticsManager;
import com.gemstone.gemfire.internal.StatisticsTypeImpl;

public class LocalStatisticsImpl
extends StatisticsImpl {
    private final int[] intStorage;
    private final long[] longStorage;
    private final double[] doubleStorage;
    private final transient Object[] intLocks;
    private final transient Object[] longLocks;
    private final transient Object[] doubleLocks;
    private final StatisticsManager dSystem;

    public LocalStatisticsImpl(StatisticsType type, String textId, long numericId, long uniqueId, boolean atomicIncrements, int osStatFlags, StatisticsManager system) {
        super(type, LocalStatisticsImpl.calcTextId(system, textId), LocalStatisticsImpl.calcNumericId(system, numericId), uniqueId, osStatFlags);
        int i;
        this.dSystem = system;
        StatisticsTypeImpl realType = (StatisticsTypeImpl)type;
        int intCount = realType.getIntStatCount();
        int longCount = realType.getLongStatCount();
        int doubleCount = realType.getDoubleStatCount();
        if (intCount > 0) {
            this.intStorage = new int[intCount];
            if (atomicIncrements) {
                this.intLocks = new Object[intCount];
                for (i = 0; i < this.intLocks.length; ++i) {
                    this.intLocks[i] = new Object();
                }
            } else {
                this.intLocks = null;
            }
        } else {
            this.intStorage = null;
            this.intLocks = null;
        }
        if (longCount > 0) {
            this.longStorage = new long[longCount];
            if (atomicIncrements) {
                this.longLocks = new Object[longCount];
                for (i = 0; i < this.longLocks.length; ++i) {
                    this.longLocks[i] = new Object();
                }
            } else {
                this.longLocks = null;
            }
        } else {
            this.longStorage = null;
            this.longLocks = null;
        }
        if (doubleCount > 0) {
            this.doubleStorage = new double[doubleCount];
            if (atomicIncrements) {
                this.doubleLocks = new Object[doubleCount];
                for (i = 0; i < this.doubleLocks.length; ++i) {
                    this.doubleLocks[i] = new Object();
                }
            } else {
                this.doubleLocks = null;
            }
        } else {
            this.doubleStorage = null;
            this.doubleLocks = null;
        }
    }

    private static long calcNumericId(StatisticsManager system, long userValue) {
        if (userValue != 0L) {
            return userValue;
        }
        long result = OSProcess.getId();
        if (result == 0L && system != null) {
            result = system.getId();
        }
        return result;
    }

    private static String calcTextId(StatisticsManager system, String userValue) {
        if (userValue != null && !userValue.equals("")) {
            return userValue;
        }
        if (system != null) {
            return system.getName();
        }
        return "";
    }

    @Override
    public final boolean isAtomic() {
        return this.intLocks != null || this.longLocks != null || this.doubleLocks != null;
    }

    @Override
    public void close() {
        super.close();
        if (this.dSystem != null) {
            this.dSystem.destroyStatistics(this);
        }
    }

    @Override
    protected final void _setInt(int offset, int value) {
        this.intStorage[offset] = value;
    }

    @Override
    protected final void _setLong(int offset, long value) {
        this.longStorage[offset] = value;
    }

    @Override
    protected final void _setDouble(int offset, double value) {
        this.doubleStorage[offset] = value;
    }

    @Override
    protected final int _getInt(int offset) {
        return this.intStorage[offset];
    }

    @Override
    protected final long _getLong(int offset) {
        return this.longStorage[offset];
    }

    @Override
    protected final double _getDouble(int offset) {
        return this.doubleStorage[offset];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void _incInt(int offset, int delta) {
        if (this.intLocks != null) {
            Object object = this.intLocks[offset];
            synchronized (object) {
                int n = offset;
                this.intStorage[n] = this.intStorage[n] + delta;
            }
        } else {
            int n = offset;
            this.intStorage[n] = this.intStorage[n] + delta;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void _incLong(int offset, long delta) {
        if (this.longLocks != null) {
            Object object = this.longLocks[offset];
            synchronized (object) {
                int n = offset;
                this.longStorage[n] = this.longStorage[n] + delta;
            }
        } else {
            int n = offset;
            this.longStorage[n] = this.longStorage[n] + delta;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void _incDouble(int offset, double delta) {
        if (this.doubleLocks != null) {
            Object object = this.doubleLocks[offset];
            synchronized (object) {
                int n = offset;
                this.doubleStorage[n] = this.doubleStorage[n] + delta;
            }
        } else {
            int n = offset;
            this.doubleStorage[n] = this.doubleStorage[n] + delta;
        }
    }

    final int[] _getIntStorage() {
        return this.intStorage;
    }

    final long[] _getLongStorage() {
        return this.longStorage;
    }

    final double[] _getDoubleStorage() {
        return this.doubleStorage;
    }
}

