/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.StatisticsTypeFactory;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.HostStatHelper;
import com.gemstone.gemfire.internal.LocalStatisticsImpl;
import com.gemstone.gemfire.internal.ProcessStats;
import com.gemstone.gemfire.internal.StatisticsTypeFactoryImpl;

public class LinuxProcessStats {
    static final int imageSizeINT = 0;
    static final int rssSizeINT = 1;
    private static final StatisticsType myType;

    private static void checkOffset(String name, int offset) {
        int id = myType.nameToId(name);
        Assert.assertTrue(offset == id, "Expected the offset for " + name + " to be " + offset + " but it was " + id);
    }

    private LinuxProcessStats() {
    }

    public static StatisticsType getType() {
        return myType;
    }

    static ProcessStats createProcessStats(final Statistics stats) {
        if (stats instanceof LocalStatisticsImpl) {
            HostStatHelper.refresh((LocalStatisticsImpl)stats);
        }
        return new ProcessStats(stats){

            @Override
            public long getProcessSize() {
                return stats.getInt(1);
            }
        };
    }

    static {
        StatisticsTypeFactory f = StatisticsTypeFactoryImpl.singleton();
        myType = f.createType("LinuxProcessStats", "Statistics on a Linux process.", new StatisticDescriptor[]{f.createIntGauge("imageSize", "The size of the process's image in megabytes.", "megabytes"), f.createIntGauge("rssSize", "The size of the process's resident set size in megabytes. (assumes PAGESIZE=4096, specify -Dgemfire.statistics.linux.pageSize=<pagesize> to adjust)", "megabytes")});
        LinuxProcessStats.checkOffset("imageSize", 0);
        LinuxProcessStats.checkOffset("rssSize", 1);
    }
}

