/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import java.io.Serializable;

public class ConfigSource
implements Serializable {
    private static final long serialVersionUID = -4097017272431018553L;
    private final Type type;
    private final String description;
    private static final ConfigSource API_SINGLETON = new ConfigSource(Type.API);
    private static final ConfigSource SYSPROP_SINGLETON = new ConfigSource(Type.SYSTEM_PROPERTY);
    private static final ConfigSource XML_SINGLETON = new ConfigSource(Type.XML);
    private static final ConfigSource RUNTIME_SINGLETON = new ConfigSource(Type.RUNTIME);
    private static final ConfigSource LAUNCHER_SINGLETON = new ConfigSource(Type.LAUNCHER);

    private ConfigSource(Type t) {
        this.type = t;
        switch (t) {
            case API: {
                this.description = "api";
                break;
            }
            case SYSTEM_PROPERTY: {
                this.description = "system property";
                break;
            }
            case FILE: {
                this.description = "file";
                break;
            }
            case SECURE_FILE: {
                this.description = "secure file";
                break;
            }
            case XML: {
                this.description = "cache.xml";
                break;
            }
            case RUNTIME: {
                this.description = "runtime modification";
                break;
            }
            case LAUNCHER: {
                this.description = "launcher";
                break;
            }
            default: {
                this.description = "";
            }
        }
    }

    private ConfigSource(String fileName, boolean secure) {
        if (secure) {
            this.type = Type.SECURE_FILE;
            this.description = fileName == null ? "secure file" : fileName;
        } else {
            this.type = Type.FILE;
            this.description = fileName == null ? "file" : fileName;
        }
    }

    public Type getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public static ConfigSource api() {
        return API_SINGLETON;
    }

    public static ConfigSource sysprop() {
        return SYSPROP_SINGLETON;
    }

    public static ConfigSource xml() {
        return XML_SINGLETON;
    }

    public static ConfigSource runtime() {
        return RUNTIME_SINGLETON;
    }

    public static ConfigSource file(String fileName, boolean secure) {
        return new ConfigSource(fileName, secure);
    }

    public static ConfigSource launcher() {
        return LAUNCHER_SINGLETON;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigSource other = (ConfigSource)obj;
        return this.type == other.type && this.description.equals(other.description);
    }

    public String toString() {
        return this.description;
    }

    public static enum Type {
        API,
        SYSTEM_PROPERTY,
        FILE,
        SECURE_FILE,
        XML,
        RUNTIME,
        LAUNCHER;

    }
}

