/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal;

import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.UnmodifiableException;
import com.gemstone.gemfire.distributed.internal.FlowControlParams;
import com.gemstone.gemfire.internal.Config;
import com.gemstone.gemfire.internal.ConfigSource;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.SystemAdmin;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;

public abstract class AbstractConfig
implements Config {
    public static final String sourceHeader = "PropertiesSourceHeader";

    protected String _getUnmodifiableMsg(String attName) {
        return LocalizedStrings.AbstractConfig_THE_0_CONFIGURATION_ATTRIBUTE_CAN_NOT_BE_MODIFIED.toLocalizedString(attName);
    }

    protected abstract Map getAttDescMap();

    protected abstract Map<String, ConfigSource> getAttSourceMap();

    protected boolean _modifiableDefault() {
        return false;
    }

    public final String toString() {
        return this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
    }

    @Override
    public String toLoggerString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.printSourceSection(ConfigSource.runtime(), pw);
        this.printSourceSection(ConfigSource.sysprop(), pw);
        this.printSourceSection(ConfigSource.api(), pw);
        for (ConfigSource fileSource : this.getFileSources()) {
            this.printSourceSection(fileSource, pw);
        }
        this.printSourceSection(ConfigSource.xml(), pw);
        this.printSourceSection(ConfigSource.launcher(), pw);
        this.printSourceSection(null, pw);
        pw.close();
        return sw.toString();
    }

    public Map<String, String> getConfigPropsFromSource(ConfigSource source) {
        HashMap<String, String> configProps = new HashMap<String, String>();
        String[] validAttributeNames = this.getAttributeNames();
        Map<String, ConfigSource> sm = this.getAttSourceMap();
        for (int i = 0; i < validAttributeNames.length; ++i) {
            String attName = validAttributeNames[i];
            if (source == null ? sm.get(attName) != null : !source.equals(sm.get(attName))) continue;
            configProps.put(attName, this.getAttribute(attName));
        }
        return configProps;
    }

    public Map<String, String> getConfigPropsDefinedUsingFiles() {
        HashMap<String, String> configProps = new HashMap<String, String>();
        for (ConfigSource fileSource : this.getFileSources()) {
            configProps.putAll(this.getConfigPropsFromSource(fileSource));
        }
        return configProps;
    }

    private List<ConfigSource> getFileSources() {
        ArrayList<ConfigSource> result = new ArrayList<ConfigSource>();
        for (ConfigSource cs : this.getAttSourceMap().values()) {
            if (cs.getType() != ConfigSource.Type.FILE && cs.getType() != ConfigSource.Type.SECURE_FILE || result.contains(cs)) continue;
            result.add(cs);
        }
        return result;
    }

    private void printSourceSection(ConfigSource source, PrintWriter pw) {
        String[] validAttributeNames = this.getAttributeNames();
        boolean sourceFound = false;
        Map<String, ConfigSource> sm = this.getAttSourceMap();
        boolean secureSource = false;
        if (source != null && source.getType() == ConfigSource.Type.SECURE_FILE) {
            secureSource = true;
        }
        for (int i = 0; i < validAttributeNames.length; ++i) {
            String attName = validAttributeNames[i];
            if (source != null ? !source.equals(sm.get(attName)) : sm.get(attName) != null) continue;
            if (!sourceFound) {
                sourceFound = true;
                if (source == null) {
                    pw.println("### GemFire Properties using default values ###");
                } else {
                    pw.println("### GemFire Properties defined with " + source.getDescription() + " ###");
                }
            }
            pw.print(attName);
            pw.print('=');
            if (source == null || !secureSource && this.okToDisplayPropertyValue(attName)) {
                pw.println(this.getAttribute(attName));
                continue;
            }
            pw.println("********");
        }
    }

    private boolean okToDisplayPropertyValue(String attName) {
        if (attName.startsWith("security-")) {
            return false;
        }
        if (attName.startsWith("javax.net.ssl")) {
            return false;
        }
        if (attName.startsWith("sysprop-")) {
            return false;
        }
        return !attName.toLowerCase().contains("password");
    }

    public boolean isDeprecated(String attName) {
        if (attName.equals("ssl-ciphers")) {
            return true;
        }
        if (attName.equals("ssl-enabled")) {
            return true;
        }
        if (attName.equals("ssl-protocols")) {
            return true;
        }
        if (attName.equals("ssl-require-authentication")) {
            return true;
        }
        return attName.equals("jmx-manager-ssl");
    }

    @Override
    public Properties toProperties() {
        SortedProperties result = new SortedProperties();
        String[] attNames = this.getAttributeNames();
        for (int i = 0; i < attNames.length; ++i) {
            if (this.isDeprecated(attNames[i])) continue;
            result.setProperty(attNames[i], this.getAttribute(attNames[i]));
        }
        return result;
    }

    @Override
    public void toFile(File f) throws IOException {
        try (FileOutputStream out = new FileOutputStream(f);){
            this.toProperties().store(out, null);
        }
    }

    @Override
    public boolean sameAs(Config other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        String[] validAttributeNames = this.getAttributeNames();
        for (int i = 0; i < validAttributeNames.length; ++i) {
            Object otherAtt;
            Object thisAtt;
            String attName = validAttributeNames[i];
            if (this.isDeprecated(attName) || (thisAtt = this.getAttributeObject(attName)) == (otherAtt = other.getAttributeObject(attName))) continue;
            if (thisAtt == null) {
                return false;
            }
            if (thisAtt.getClass().isArray()) {
                int otherLength;
                int thisLength = Array.getLength(thisAtt);
                if (thisLength != (otherLength = Array.getLength(otherAtt))) {
                    return false;
                }
                for (int j = 0; j < thisLength; ++j) {
                    Object otherArrObj;
                    Object thisArrObj = Array.get(thisAtt, j);
                    if (thisArrObj == (otherArrObj = Array.get(otherAtt, j))) continue;
                    if (thisArrObj == null) {
                        return false;
                    }
                    if (thisArrObj.equals(otherArrObj)) continue;
                    return false;
                }
                continue;
            }
            if (thisAtt.equals(otherAtt)) continue;
            return false;
        }
        return true;
    }

    protected void checkAttributeName(String attName) {
        Object[] validAttNames = this.getAttributeNames();
        if (!Arrays.asList(validAttNames).contains(attName.toLowerCase())) {
            throw new IllegalArgumentException(LocalizedStrings.AbstractConfig_UNKNOWN_CONFIGURATION_ATTRIBUTE_NAME_0_VALID_ATTRIBUTE_NAMES_ARE_1.toLocalizedString(attName, SystemAdmin.join(validAttNames)));
        }
    }

    @Override
    public String getAttribute(String attName) {
        Object result = this.getAttributeObject(attName);
        if (result instanceof String) {
            return (String)result;
        }
        if (attName.equalsIgnoreCase("membership-port-range")) {
            int[] value = (int[])result;
            return "" + value[0] + "-" + value[1];
        }
        if (result.getClass().isArray()) {
            return SystemAdmin.join((Object[])result);
        }
        if (result instanceof InetAddress) {
            InetAddress addr = (InetAddress)result;
            String addrName = null;
            addrName = addr.isMulticastAddress() || !SocketCreator.resolve_dns ? addr.getHostAddress() : SocketCreator.getHostName(addr);
            return addrName;
        }
        return result.toString();
    }

    @Override
    public ConfigSource getAttributeSource(String attName) {
        return this.getAttSourceMap().get(attName);
    }

    @Override
    public void setAttribute(String attName, String attValue, ConfigSource source) {
        Object attObjectValue;
        block18: {
            Class valueType = this.getAttributeType(attName);
            try {
                if (valueType.equals(String.class)) {
                    attObjectValue = attValue;
                    break block18;
                }
                if (valueType.equals(Integer.class)) {
                    attObjectValue = Integer.valueOf(attValue);
                    break block18;
                }
                if (valueType.equals(Long.class)) {
                    attObjectValue = Long.valueOf(attValue);
                    break block18;
                }
                if (valueType.equals(Boolean.class)) {
                    attObjectValue = Boolean.valueOf(attValue);
                    break block18;
                }
                if (valueType.equals(File.class)) {
                    attObjectValue = new File(attValue);
                    break block18;
                }
                if (valueType.equals(int[].class)) {
                    int[] value = new int[2];
                    int minus = attValue.indexOf(45);
                    if (minus <= 0) {
                        throw new IllegalArgumentException("expected a setting in the form X-Y but found no dash for attribute " + attName);
                    }
                    value[0] = Integer.valueOf(attValue.substring(0, minus));
                    value[1] = Integer.valueOf(attValue.substring(minus + 1));
                    attObjectValue = value;
                    break block18;
                }
                if (valueType.equals(InetAddress.class)) {
                    try {
                        attObjectValue = InetAddress.getByName(attValue);
                        break block18;
                    }
                    catch (UnknownHostException ex) {
                        throw new IllegalArgumentException(LocalizedStrings.AbstractConfig_0_VALUE_1_MUST_BE_A_VALID_HOST_NAME_2.toLocalizedString(attName, attValue, ex.toString()));
                    }
                }
                if (valueType.equals(String[].class)) {
                    if (attValue == null || attValue.length() == 0) {
                        attObjectValue = null;
                        break block18;
                    }
                    String trimAttName = AbstractConfig.trimAttributeName(attName);
                    throw new UnmodifiableException(LocalizedStrings.AbstractConfig_THE_0_CONFIGURATION_ATTRIBUTE_CAN_NOT_BE_SET_FROM_THE_COMMAND_LINE_SET_1_FOR_EACH_INDIVIDUAL_PARAMETER_INSTEAD.toLocalizedString(attName, trimAttName));
                }
                if (valueType.equals(FlowControlParams.class)) {
                    String[] values = attValue.split(",");
                    if (values.length != 3) {
                        throw new IllegalArgumentException(LocalizedStrings.AbstractConfig_0_VALUE_1_MUST_HAVE_THREE_ELEMENTS_SEPARATED_BY_COMMAS.toLocalizedString(attName, attValue));
                    }
                    int credits = 0;
                    float thresh = 0.0f;
                    int waittime = 0;
                    try {
                        credits = Integer.parseInt(values[0].trim());
                        thresh = Float.valueOf(values[1].trim()).floatValue();
                        waittime = Integer.parseInt(values[2].trim());
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException(LocalizedStrings.AbstractConfig_0_VALUE_1_MUST_BE_COMPOSED_OF_AN_INTEGER_A_FLOAT_AND_AN_INTEGER.toLocalizedString(attName, attValue));
                    }
                    attObjectValue = new FlowControlParams(credits, thresh, waittime);
                    break block18;
                }
                throw new InternalGemFireException(LocalizedStrings.AbstractConfig_UNHANDLED_ATTRIBUTE_TYPE_0_FOR_1.toLocalizedString(valueType, attName));
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException(LocalizedStrings.AbstractConfig_0_VALUE_1_MUST_BE_A_NUMBER.toLocalizedString(attName, attValue));
            }
        }
        this.setAttributeObject(attName, attObjectValue, source);
    }

    protected static String trimAttributeName(String attName) {
        return attName.substring(0, attName.length() - 1);
    }

    @Override
    public String getAttributeDescription(String attName) {
        this.checkAttributeName(attName);
        if (!this.getAttDescMap().containsKey(attName)) {
            throw new InternalGemFireException(LocalizedStrings.AbstractConfig_UNHANDLED_ATTRIBUTE_NAME_0.toLocalizedString(attName));
        }
        return (String)this.getAttDescMap().get(attName);
    }

    protected static class SortedProperties
    extends Properties {
        private static final long serialVersionUID = 7156507110684631135L;

        protected SortedProperties() {
        }

        @Override
        public Enumeration keys() {
            return Collections.enumeration(new TreeSet<Object>(this.keySet()));
        }
    }
}

