/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.tcpserver;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.distributed.internal.DistributionConfigImpl;
import com.gemstone.gemfire.distributed.internal.DistributionStats;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.PoolStatHelper;
import com.gemstone.gemfire.distributed.internal.PooledExecutorWithDMStats;
import com.gemstone.gemfire.distributed.internal.SharedConfiguration;
import com.gemstone.gemfire.distributed.internal.tcpserver.InfoRequest;
import com.gemstone.gemfire.distributed.internal.tcpserver.InfoResponse;
import com.gemstone.gemfire.distributed.internal.tcpserver.ShutdownRequest;
import com.gemstone.gemfire.distributed.internal.tcpserver.ShutdownResponse;
import com.gemstone.gemfire.distributed.internal.tcpserver.TcpHandler;
import com.gemstone.gemfire.distributed.internal.tcpserver.VersionRequest;
import com.gemstone.gemfire.distributed.internal.tcpserver.VersionResponse;
import com.gemstone.gemfire.internal.DSFIDFactory;
import com.gemstone.gemfire.internal.GemFireVersion;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.VersionedDataInputStream;
import com.gemstone.gemfire.internal.VersionedDataOutputStream;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLException;
import org.apache.logging.log4j.Logger;

public class TcpServer {
    public static final int GOSSIPVERSION = 1002;
    public static final int OLDGOSSIPVERSION = 1001;
    private static final Map GOSSIP_TO_GEMFIRE_VERSION_MAP = new HashMap();
    public static boolean isTesting = false;
    public static int TESTVERSION = 1002;
    public static int OLDTESTVERSION = 1001;
    public static final long SHUTDOWN_WAIT_TIME = 60000L;
    private static int MAX_POOL_SIZE = Integer.getInteger("gemfire.TcpServer.MAX_POOL_SIZE", 100);
    private static int POOL_IDLE_TIMEOUT = 60000;
    private static final Logger log = LogService.getLogger();
    protected static final int READ_TIMEOUT = Integer.getInteger("gemfire.TcpServer.READ_TIMEOUT", 60000);
    private static final int P2P_BACKLOG = Integer.getInteger("p2p.backlog", 1000);
    private static final int BACKLOG = Integer.getInteger("gemfire.TcpServer.BACKLOG", P2P_BACKLOG);
    private final int port;
    private ServerSocket srv_sock = null;
    private InetAddress bind_address;
    private volatile boolean shuttingDown = false;
    private final PoolStatHelper poolHelper;
    private final TcpHandler handler;
    private PooledExecutorWithDMStats executor;
    private final ThreadGroup threadGroup;
    private final String threadName;
    private volatile Thread serverThread;

    public TcpServer(int port, InetAddress bind_address, Properties sslConfig, DistributionConfigImpl cfg, TcpHandler handler, PoolStatHelper poolHelper, ThreadGroup threadGroup, String threadName) {
        this.port = port;
        this.bind_address = bind_address;
        this.handler = handler;
        this.poolHelper = poolHelper;
        DSFIDFactory.registerTypes();
        this.executor = TcpServer.createExecutor(poolHelper, threadGroup);
        this.threadGroup = threadGroup;
        this.threadName = threadName;
        if (cfg == null) {
            if (sslConfig == null) {
                sslConfig = new Properties();
            }
            cfg = new DistributionConfigImpl(sslConfig);
        }
        SocketCreator.getDefaultInstance(cfg);
    }

    private static PooledExecutorWithDMStats createExecutor(PoolStatHelper poolHelper, final ThreadGroup threadGroup) {
        ThreadFactory factory = new ThreadFactory(){
            private final AtomicInteger threadNum = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(threadGroup, r, "locator request thread[" + this.threadNum.incrementAndGet() + "]");
                thread.setDaemon(true);
                return thread;
            }
        };
        return new PooledExecutorWithDMStats(new SynchronousQueue<Runnable>(), MAX_POOL_SIZE, poolHelper, factory, POOL_IDLE_TIMEOUT, (RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public void restarting(InternalDistributedSystem ds, GemFireCacheImpl cache, SharedConfiguration sharedConfig) throws IOException {
        this.shuttingDown = false;
        this.handler.restarting(ds, cache, sharedConfig);
        this.startServerThread();
        this.executor = TcpServer.createExecutor(this.poolHelper, this.threadGroup);
        log.info("TcpServer@" + System.identityHashCode(this) + " restarting: completed.  Server thread=" + this.serverThread + "@" + System.identityHashCode(this.serverThread) + ";alive=" + this.serverThread.isAlive());
    }

    public void start() throws IOException {
        this.shuttingDown = false;
        this.handler.init(this);
        this.startServerThread();
    }

    private void startServerThread() throws IOException {
        if (this.srv_sock == null || this.srv_sock.isClosed()) {
            if (this.bind_address == null) {
                this.srv_sock = SocketCreator.getDefaultInstance().createServerSocket(this.port, BACKLOG);
                this.bind_address = this.srv_sock.getInetAddress();
            } else {
                this.srv_sock = SocketCreator.getDefaultInstance().createServerSocket(this.port, BACKLOG, this.bind_address);
            }
            if (log.isInfoEnabled()) {
                log.info("Locator was created at " + new Date());
            }
            if (log.isInfoEnabled()) {
                log.info("Listening on port " + this.port + " bound on address " + this.bind_address);
            }
            this.srv_sock.setReuseAddress(true);
        }
        if (this.serverThread == null || !this.serverThread.isAlive()) {
            this.serverThread = new Thread(this.threadGroup, this.threadName){

                @Override
                public void run() {
                    TcpServer.this.run();
                }
            };
            this.serverThread.setDaemon(true);
            this.serverThread.start();
        }
    }

    public void join(long millis) throws InterruptedException {
        if (this.serverThread != null) {
            this.serverThread.join(millis);
        }
    }

    public void join() throws InterruptedException {
        if (this.serverThread != null) {
            this.serverThread.join();
        }
    }

    public boolean isAlive() {
        return this.serverThread != null && this.serverThread.isAlive();
    }

    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    public SocketAddress getBindAddress() {
        return this.srv_sock.getLocalSocketAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run() {
        Socket sock = null;
        while (!this.shuttingDown) {
            if (SystemFailure.getFailure() != null) {
                try {
                    this.srv_sock.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                SystemFailure.checkFailure();
            }
            try {
                try {
                    sock = this.srv_sock.accept();
                }
                catch (SSLException ex) {
                    log.error("Locator stopping due to SSL configuration problem.", (Throwable)ex);
                    this.shuttingDown = true;
                    continue;
                }
                this.processRequest(sock);
            }
            catch (Exception ex) {
                if (this.shuttingDown) continue;
                log.error("exception=", (Throwable)ex);
            }
        }
        try {
            this.srv_sock.close();
        }
        catch (IOException ex) {
            log.warn("exception closing server socket during shutdown", (Throwable)ex);
        }
        if (this.shuttingDown) {
            log.info("locator shutting down");
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(60000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.handler.shutDown();
            TcpServer tcpServer = this;
            synchronized (tcpServer) {
                this.notifyAll();
            }
        }
    }

    private void processRequest(final Socket sock) {
        Runnable clientTask = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long startTime = DistributionStats.getStatTime();
                DataInputStream input = null;
                try {
                    Object response;
                    SocketCreator.getDefaultInstance().configureServerSSLSocket(sock);
                    sock.setSoTimeout(READ_TIMEOUT);
                    try {
                        input = new DataInputStream(sock.getInputStream());
                    }
                    catch (StreamCorruptedException e) {
                        log.debug("Discarding illegal request from " + sock.getInetAddress().getHostAddress() + ":" + sock.getPort(), (Throwable)e);
                        try {
                            sock.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        return;
                    }
                    int gossipVersion = input.readInt();
                    short versionOrdinal = Version.CURRENT_ORDINAL;
                    if (gossipVersion > TcpServer.getCurrentGossipVersion() || !GOSSIP_TO_GEMFIRE_VERSION_MAP.containsKey(gossipVersion)) {
                        sock.close();
                        return;
                    }
                    versionOrdinal = (Short)GOSSIP_TO_GEMFIRE_VERSION_MAP.get(gossipVersion);
                    if (Version.GFE_71.compareTo(versionOrdinal) <= 0) {
                        versionOrdinal = input.readShort();
                    }
                    if (log.isDebugEnabled() && versionOrdinal != Version.CURRENT_ORDINAL) {
                        log.debug("Locator reading request from " + sock.getInetAddress() + " with version " + Version.fromOrdinal(versionOrdinal, false));
                    }
                    input = new VersionedDataInputStream(input, Version.fromOrdinal(versionOrdinal, false));
                    Object request = DataSerializer.readObject(input);
                    if (log.isDebugEnabled()) {
                        log.debug("Locator received request " + request + " from " + sock.getInetAddress());
                    }
                    if (request instanceof ShutdownRequest) {
                        TcpServer.this.shuttingDown = true;
                        TcpServer.this.srv_sock.close();
                        response = new ShutdownResponse();
                    } else {
                        response = request instanceof InfoRequest ? TcpServer.this.handleInfoRequest(request) : (request instanceof VersionRequest ? TcpServer.this.handleVersionRequest(request) : TcpServer.this.handler.processRequest(request));
                    }
                    TcpServer.this.handler.endRequest(request, startTime);
                    startTime = DistributionStats.getStatTime();
                    if (response != null) {
                        DataOutputStream output = new DataOutputStream(sock.getOutputStream());
                        if (versionOrdinal != Version.CURRENT_ORDINAL) {
                            output = new VersionedDataOutputStream(output, Version.fromOrdinal(versionOrdinal, false));
                        }
                        DataSerializer.writeObject(response, output);
                        output.flush();
                    }
                    TcpServer.this.handler.endResponse(request, startTime);
                }
                catch (EOFException gossipVersion) {
                }
                catch (CancelException gossipVersion) {
                }
                catch (ClassNotFoundException ex) {
                    String sender = null;
                    if (sock != null) {
                        sender = sock.getInetAddress().getHostAddress();
                    }
                    log.info("Unable to process request from " + sender + " exception=" + ex.getMessage());
                }
                catch (Exception ex) {
                    String sender = null;
                    if (sock != null) {
                        sender = sock.getInetAddress().getHostAddress();
                    }
                    if (ex instanceof IOException) {
                        if (!sock.isClosed()) {
                            log.info("Exception in processing request from " + sender, (Throwable)ex);
                        }
                    } else {
                        log.fatal("Exception in processing request from " + sender, (Throwable)ex);
                    }
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable ex) {
                    SystemFailure.checkFailure();
                    String sender = null;
                    if (sock != null) {
                        sender = sock.getInetAddress().getHostAddress();
                    }
                    try {
                        log.fatal("Exception in processing request from " + sender, ex);
                    }
                    catch (VirtualMachineError err) {
                        SystemFailure.initiateFailure(err);
                        throw err;
                    }
                    catch (Throwable t) {
                        SystemFailure.checkFailure();
                        t.printStackTrace();
                    }
                }
                finally {
                    try {
                        sock.close();
                    }
                    catch (IOException ex) {}
                }
            }
        };
        this.executor.execute(clientTask);
    }

    protected Object handleInfoRequest(Object request) {
        String[] info = new String[2];
        info[0] = System.getProperty("user.dir");
        URL url = GemFireVersion.getJarURL();
        if (url == null) {
            String s = "Could not find gemfire jar";
            throw new IllegalStateException(s);
        }
        File gemfireJar = new File(url.getPath());
        File lib = gemfireJar.getParentFile();
        File product = lib.getParentFile();
        info[1] = product.getAbsolutePath();
        return new InfoResponse(info);
    }

    protected Object handleVersionRequest(Object request) {
        VersionResponse response = new VersionResponse();
        response.setVersionOrdinal(Version.CURRENT_ORDINAL);
        return response;
    }

    public static int getGossipVersionForOrdinal(short ordinal) {
        short closest = -1;
        int closestGV = TcpServer.getCurrentGossipVersion();
        if (ordinal < Version.CURRENT_ORDINAL) {
            for (Map.Entry entry : GOSSIP_TO_GEMFIRE_VERSION_MAP.entrySet()) {
                short o = (Short)entry.getValue();
                if (o == ordinal) {
                    return (Integer)entry.getKey();
                }
                if (o >= ordinal || o <= closest) continue;
                closest = o;
                closestGV = (Integer)entry.getKey();
            }
        }
        return closestGV;
    }

    public static int getCurrentGossipVersion() {
        return isTesting ? TESTVERSION : 1002;
    }

    public static int getOldGossipVersion() {
        return isTesting ? OLDTESTVERSION : 1001;
    }

    public static Map getGossipVersionMapForTestOnly() {
        return GOSSIP_TO_GEMFIRE_VERSION_MAP;
    }

    static {
        GOSSIP_TO_GEMFIRE_VERSION_MAP.put(1002, Version.GFE_71.ordinal());
        GOSSIP_TO_GEMFIRE_VERSION_MAP.put(1001, Version.GFE_57.ordinal());
    }
}

