/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.membership.gms.messenger;

import com.gemstone.gemfire.distributed.internal.membership.gms.Services;
import com.gemstone.gemfire.distributed.internal.membership.gms.messenger.JGAddress;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.PhysicalAddress;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.TP;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Responses;

public class AddressManager
extends Protocol {
    private static final Logger logger = Services.getLogger();
    private TP transport;
    private Method setPingData;
    boolean warningLogged = false;

    public Object up(Event evt) {
        switch (evt.getType()) {
            case 11: {
                List missing = (List)evt.getArg();
                Responses responses = new Responses(false);
                for (Address laddr : missing) {
                    try {
                        if (!(laddr instanceof JGAddress)) continue;
                        PingData pd = new PingData(laddr, true, laddr.toString(), (PhysicalAddress)this.newIpAddress(laddr));
                        responses.addResponse(pd, false);
                        this.updateUDPCache(pd);
                    }
                    catch (RuntimeException e) {
                        logger.warn("Unable to create PingData response", (Throwable)e);
                        throw e;
                    }
                }
                return responses;
            }
        }
        return this.up_prot.up(evt);
    }

    private IpAddress newIpAddress(Address jgaddr) {
        JGAddress addr = (JGAddress)jgaddr;
        return addr.asIpAddress();
    }

    private void updateUDPCache(PingData pd) {
        block4: {
            if (this.setPingData == null && !this.warningLogged) {
                this.findPingDataMethod();
            }
            if (this.setPingData != null) {
                try {
                    this.setPingData.invoke((Object)this.transport, pd);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    if (this.warningLogged) break block4;
                    this.log.warn("Unable to update JGroups address cache - this may affect performance", (Throwable)e);
                    this.warningLogged = true;
                }
            }
        }
    }

    private void findPingDataMethod() {
        block2: {
            this.transport = this.getProtocolStack().getTransport();
            try {
                this.setPingData = TP.class.getDeclaredMethod("setPingData", PingData.class);
                this.setPingData.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                if (this.warningLogged) break block2;
                this.log.warn("Unable to update JGroups address cache - this may affect performance", (Throwable)e);
                this.warningLogged = true;
            }
        }
    }
}

