/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.membership.gms.messages;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.HighPriorityDistributionMessage;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.gms.messages.HasMemberID;
import com.gemstone.gemfire.internal.Version;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;

public class LeaveRequestMessage
extends HighPriorityDistributionMessage
implements HasMemberID {
    private InternalDistributedMember memberID;
    private String reason;

    public LeaveRequestMessage(Collection<InternalDistributedMember> coords, InternalDistributedMember id, String reason) {
        this.setRecipients(coords);
        this.memberID = id;
        this.reason = reason;
    }

    public LeaveRequestMessage(InternalDistributedMember coord, InternalDistributedMember id, String reason) {
        this.setRecipient(coord);
        this.memberID = id;
        this.reason = reason;
    }

    public LeaveRequestMessage() {
    }

    @Override
    public int getDSFID() {
        return -152;
    }

    @Override
    public void process(DistributionManager dm) {
        throw new IllegalStateException("this message is not intended to execute in a thread pool");
    }

    @Override
    public InternalDistributedMember getMemberID() {
        return this.memberID;
    }

    public String getReason() {
        return this.reason;
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeObject(this.memberID, out);
        DataSerializer.writeString(this.reason, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.memberID = (InternalDistributedMember)DataSerializer.readObject(in);
        this.reason = DataSerializer.readString(in);
    }

    @Override
    public String toString() {
        return this.getShortClassName() + "(" + this.memberID + "; reason=" + this.reason + ")";
    }
}

