/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.membership.gms.messages;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.HighPriorityDistributionMessage;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.NetView;
import com.gemstone.gemfire.internal.Version;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class JoinResponseMessage
extends HighPriorityDistributionMessage {
    private NetView currentView;
    private String rejectionMessage;
    private InternalDistributedMember memberID;
    private byte[] messengerData;

    public JoinResponseMessage(InternalDistributedMember memberID, NetView view) {
        this.currentView = view;
        this.memberID = memberID;
        this.setRecipient(memberID);
    }

    public JoinResponseMessage(String rejectionMessage) {
        this.rejectionMessage = rejectionMessage;
    }

    public JoinResponseMessage() {
    }

    public NetView getCurrentView() {
        return this.currentView;
    }

    public InternalDistributedMember getMemberID() {
        return this.memberID;
    }

    public String getRejectionMessage() {
        return this.rejectionMessage;
    }

    public byte[] getMessengerData() {
        return this.messengerData;
    }

    public void setMessengerData(byte[] data) {
        this.messengerData = data;
    }

    @Override
    public void process(DistributionManager dm) {
        throw new IllegalStateException("JoinResponse is not intended to be executed");
    }

    @Override
    public String toString() {
        return this.getShortClassName() + "(" + this.memberID + "; " + (this.currentView == null ? "" : this.currentView.toString()) + (this.rejectionMessage == null ? "" : "; " + this.rejectionMessage) + ")";
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    @Override
    public int getDSFID() {
        return -143;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeObject(this.currentView, out);
        DataSerializer.writeObject(this.memberID, out);
        DataSerializer.writeString(this.rejectionMessage, out);
        DataSerializer.writeByteArray(this.messengerData, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.currentView = (NetView)DataSerializer.readObject(in);
        this.memberID = (InternalDistributedMember)DataSerializer.readObject(in);
        this.rejectionMessage = DataSerializer.readString(in);
        this.messengerData = DataSerializer.readByteArray(in);
    }
}

