/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.membership.gms.messages;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.HighPriorityDistributionMessage;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Version;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class JoinRequestMessage
extends HighPriorityDistributionMessage {
    private InternalDistributedMember memberID;
    private Object credentials;
    private int failureDetectionPort = -1;

    public JoinRequestMessage(InternalDistributedMember coord, InternalDistributedMember id, Object credentials, int fdPort) {
        this.setRecipient(coord);
        this.memberID = id;
        this.credentials = credentials;
        this.failureDetectionPort = fdPort;
    }

    public JoinRequestMessage() {
    }

    @Override
    public int getDSFID() {
        return -142;
    }

    @Override
    public void process(DistributionManager dm) {
        throw new IllegalStateException("this message is not intended to execute in a thread pool");
    }

    public InternalDistributedMember getMemberID() {
        return this.memberID;
    }

    public Object getCredentials() {
        return this.credentials;
    }

    @Override
    public String toString() {
        return this.getShortClassName() + "(" + this.memberID + (this.credentials == null ? ")" : "; with credentials)") + " failureDetectionPort:" + this.failureDetectionPort;
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeObject(this.memberID, out);
        DataSerializer.writeObject(this.credentials, out);
        DataSerializer.writePrimitiveInt(this.failureDetectionPort, out);
        out.writeBoolean(this.getMulticast());
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.memberID = (InternalDistributedMember)DataSerializer.readObject(in);
        this.credentials = DataSerializer.readObject(in);
        this.failureDetectionPort = DataSerializer.readPrimitiveInt(in);
        this.setMulticast(in.readBoolean());
    }

    public int getFailureDetectionPort() {
        return this.failureDetectionPort;
    }
}

