/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.membership.gms.messages;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.HighPriorityDistributionMessage;
import com.gemstone.gemfire.distributed.internal.membership.NetView;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class InstallViewMessage
extends HighPriorityDistributionMessage {
    private NetView view;
    private Object credentials;
    private messageType kind;
    private int previousViewId;

    public InstallViewMessage(NetView view, Object credentials, boolean preparing) {
        this.view = view;
        this.kind = preparing ? messageType.PREPARE : messageType.INSTALL;
        this.credentials = credentials;
    }

    public InstallViewMessage(NetView view, Object credentials, int previousViewId, boolean preparing) {
        this.view = view;
        this.kind = preparing ? messageType.PREPARE : messageType.INSTALL;
        this.credentials = credentials;
        this.previousViewId = previousViewId;
    }

    public InstallViewMessage() {
    }

    public boolean isRebroadcast() {
        return this.kind == messageType.SYNC;
    }

    public NetView getView() {
        return this.view;
    }

    public int getPreviousViewId() {
        return this.previousViewId;
    }

    public Object getCredentials() {
        return this.credentials;
    }

    public boolean isPreparing() {
        return this.kind == messageType.PREPARE;
    }

    @Override
    public int getDSFID() {
        return -150;
    }

    @Override
    public void process(DistributionManager dm) {
        throw new IllegalStateException("this message is not intended to execute in a thread pool");
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        out.writeInt(this.previousViewId);
        out.writeInt(this.kind.ordinal());
        DataSerializer.writeObject(this.view, out);
        DataSerializer.writeObject(this.credentials, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.previousViewId = in.readInt();
        this.kind = messageType.values()[in.readInt()];
        this.view = (NetView)DataSerializer.readObject(in);
        this.credentials = DataSerializer.readObject(in);
    }

    @Override
    public String toString() {
        return "InstallViewMessage(type=" + (Object)((Object)this.kind) + "; Current ViewID=" + this.view.getViewId() + "; Previous View ID=" + this.previousViewId + "; " + this.view + "; cred=" + (this.credentials == null ? "null" : "not null") + ")";
    }

    static enum messageType {
        INSTALL,
        PREPARE,
        SYNC;

    }
}

