/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.membership.gms.messages;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.HighPriorityDistributionMessage;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Version;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class HeartbeatRequestMessage
extends HighPriorityDistributionMessage {
    int requestId;
    InternalDistributedMember target;

    public HeartbeatRequestMessage(InternalDistributedMember neighbour, int id) {
        this.requestId = id;
        this.target = neighbour;
    }

    public HeartbeatRequestMessage() {
    }

    public InternalDistributedMember getTarget() {
        return this.target;
    }

    @Override
    public int getDSFID() {
        return -154;
    }

    @Override
    public void process(DistributionManager dm) {
        throw new IllegalStateException("this message is not intended to execute in a thread pool");
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " [requestId=" + this.requestId + "]";
    }

    public int getRequestId() {
        return this.requestId;
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.requestId);
        DataSerializer.writeObject(this.target, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.requestId = in.readInt();
        this.target = (InternalDistributedMember)DataSerializer.readObject(in);
    }
}

