/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.membership.gms.locator;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.LocatorStats;
import com.gemstone.gemfire.distributed.internal.SharedConfiguration;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.MembershipManager;
import com.gemstone.gemfire.distributed.internal.membership.NetView;
import com.gemstone.gemfire.distributed.internal.membership.gms.GMSUtil;
import com.gemstone.gemfire.distributed.internal.membership.gms.NetLocator;
import com.gemstone.gemfire.distributed.internal.membership.gms.Services;
import com.gemstone.gemfire.distributed.internal.membership.gms.interfaces.Locator;
import com.gemstone.gemfire.distributed.internal.membership.gms.locator.FindCoordinatorRequest;
import com.gemstone.gemfire.distributed.internal.membership.gms.locator.FindCoordinatorResponse;
import com.gemstone.gemfire.distributed.internal.membership.gms.locator.GetViewRequest;
import com.gemstone.gemfire.distributed.internal.membership.gms.locator.GetViewResponse;
import com.gemstone.gemfire.distributed.internal.membership.gms.mgr.GMSMembershipManager;
import com.gemstone.gemfire.distributed.internal.tcpserver.TcpClient;
import com.gemstone.gemfire.distributed.internal.tcpserver.TcpServer;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.VersionedObjectInput;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class GMSLocator
implements Locator,
NetLocator {
    static final int LOCATOR_FILE_STAMP = 2072835905;
    private static final Logger logger = LogService.getLogger();
    private final boolean usePreferredCoordinators;
    private final boolean networkPartitionDetectionEnabled;
    private final String locatorString;
    private final List<InetSocketAddress> locators;
    private Services services;
    private final LocatorStats stats;
    private InternalDistributedMember localAddress;
    private Set<InternalDistributedMember> registrants = new HashSet<InternalDistributedMember>();
    private transient NetView view;
    private File viewFile;

    public GMSLocator(InetAddress bindAddress, File stateFile, String locatorString, boolean usePreferredCoordinators, boolean networkPartitionDetectionEnabled, LocatorStats stats) {
        this.usePreferredCoordinators = usePreferredCoordinators;
        this.networkPartitionDetectionEnabled = networkPartitionDetectionEnabled;
        this.locatorString = locatorString;
        this.locators = this.locatorString == null || this.locatorString.length() == 0 ? new ArrayList<InetSocketAddress>(0) : GMSUtil.parseLocators(locatorString, bindAddress);
        this.viewFile = stateFile;
        this.stats = stats;
    }

    @Override
    public boolean setMembershipManager(MembershipManager mgr) {
        if (this.services == null || this.services.isStopped()) {
            logger.info("Peer locator is connecting to local membership services");
            this.services = ((GMSMembershipManager)mgr).getServices();
            this.localAddress = this.services.getMessenger().getMemberID();
            this.services.setLocator(this);
            NetView newView = this.services.getJoinLeave().getView();
            if (newView != null) {
                this.view = newView;
            }
            return true;
        }
        return false;
    }

    @Override
    public void init(TcpServer server) throws InternalGemFireException {
        logger.info("GemFire peer location service starting.  Other locators: {}  Locators preferred as coordinators: {}  Network partition detection enabled: {}  View persistence file: {}", new Object[]{this.locatorString, this.usePreferredCoordinators, this.networkPartitionDetectionEnabled, this.viewFile});
        this.recover();
    }

    private void findServices() {
        InternalDistributedSystem sys = InternalDistributedSystem.getAnyInstance();
        if (sys != null && this.services == null) {
            logger.info("Peer locator found distributed system " + sys);
            this.setMembershipManager(sys.getDM().getMembershipManager());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void installView(NetView view) {
        Set<InternalDistributedMember> set = this.registrants;
        synchronized (set) {
            this.registrants.clear();
        }
        logger.info("Peer locator received new membership view: " + view);
        this.view = view;
        this.saveView(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object processRequest(Object request) throws IOException {
        FindCoordinatorRequest findRequest;
        DataSerializableFixedID response = null;
        if (logger.isDebugEnabled()) {
            logger.debug("Peer locator processing {}", new Object[]{request});
        }
        if (this.localAddress == null && this.services != null) {
            this.localAddress = this.services.getMessenger().getMemberID();
        }
        if (request instanceof GetViewRequest) {
            if (this.view != null) {
                response = new GetViewResponse(this.view);
            }
        } else if (request instanceof FindCoordinatorRequest && (findRequest = (FindCoordinatorRequest)request).getMemberID() != null) {
            InternalDistributedMember coord = null;
            if (this.view == null) {
                this.findServices();
            }
            boolean fromView = false;
            int viewId = -1;
            NetView v = this.view;
            if (v != null) {
                InternalDistributedMember rid = findRequest.getMemberID();
                for (InternalDistributedMember id : v.getMembers()) {
                    if (rid.compareTo(id, false) != 0) continue;
                    NetView newView = new NetView(v, v.getViewId());
                    newView.remove(id);
                    v = newView;
                    break;
                }
                coord = (viewId = v.getViewId()) > findRequest.getLastViewId() ? v.getCoordinator(Collections.emptyList()) : v.getCoordinator(findRequest.getRejectedCoordinators());
                logger.debug("Peer locator: coordinator from view is {}", new Object[]{coord});
                fromView = true;
            }
            if (coord == null) {
                Collection<InternalDistributedMember> rejections = findRequest.getRejectedCoordinators();
                if (rejections == null) {
                    rejections = Collections.emptyList();
                }
                Set<InternalDistributedMember> set = this.registrants;
                synchronized (set) {
                    this.registrants.add(findRequest.getMemberID());
                    if (this.services != null) {
                        coord = this.services.getJoinLeave().getMemberID();
                    }
                    for (InternalDistributedMember mbr : this.registrants) {
                        if (mbr == coord || coord != null && mbr.compareTo(coord) >= 0 || rejections.contains(mbr) || !mbr.getNetMember().preferredForCoordinator() && mbr.getNetMember().splitBrainEnabled()) continue;
                        coord = mbr;
                    }
                    logger.debug("Peer locator: coordinator from registrations is {}", new Object[]{coord});
                }
            }
            Set<InternalDistributedMember> set = this.registrants;
            synchronized (set) {
                response = new FindCoordinatorResponse(coord, this.localAddress, fromView, this.view, new HashSet<InternalDistributedMember>(this.registrants), this.networkPartitionDetectionEnabled, this.usePreferredCoordinators);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Peer locator returning {}", new Object[]{response});
        }
        return response;
    }

    public void saveView(NetView view) {
        if (this.viewFile == null) {
            return;
        }
        if (!this.viewFile.delete() && this.viewFile.exists()) {
            logger.warn("Peer locator is unable to delete persistent membership information in " + this.viewFile.getAbsolutePath());
        }
        try {
            ObjectOutputStream oos = null;
            try {
                oos = new ObjectOutputStream(new FileOutputStream(this.viewFile));
                oos.writeInt(2072835905);
                oos.writeInt(Version.CURRENT_ORDINAL);
                DataSerializer.writeObject(view, oos);
            }
            finally {
                oos.flush();
                oos.close();
            }
        }
        catch (Exception e) {
            logger.warn("Peer locator encountered an error writing current membership to disk.  Disabling persistence.  Care should be taken when bouncing this locator as it will not be able to recover knowledge of the running distributed system", (Throwable)e);
            this.viewFile = null;
        }
    }

    @Override
    public void endRequest(Object request, long startTime) {
        this.stats.endLocatorRequest(startTime);
    }

    @Override
    public void endResponse(Object request, long startTime) {
        this.stats.endLocatorResponse(startTime);
    }

    @Override
    public void shutDown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InternalDistributedMember> getMembers() {
        if (this.view != null) {
            return new ArrayList<InternalDistributedMember>(this.view.getMembers());
        }
        Set<InternalDistributedMember> set = this.registrants;
        synchronized (set) {
            return new ArrayList<InternalDistributedMember>(this.registrants);
        }
    }

    @Override
    public void restarting(DistributedSystem ds, GemFireCache cache, SharedConfiguration sharedConfig) {
        this.setMembershipManager(((InternalDistributedSystem)ds).getDM().getMembershipManager());
    }

    public void recover() throws InternalGemFireException {
        if (!this.recoverFromOthers()) {
            this.recoverFromFile(this.viewFile);
        }
    }

    private boolean recoverFromOthers() {
        for (InetSocketAddress other : this.locators) {
            if (!this.recover(other)) continue;
            logger.info("Peer locator recovered state from " + other);
            return true;
        }
        return false;
    }

    private boolean recover(InetSocketAddress other) {
        try {
            logger.info("Peer locator attempting to recover from " + other);
            Object response = TcpClient.requestToServer(other.getAddress(), other.getPort(), new GetViewRequest(), 20000, true);
            if (response != null && response instanceof GetViewResponse) {
                this.view = ((GetViewResponse)response).getView();
                logger.info("Peer locator recovered initial membership of {}", new Object[]{this.view});
                return true;
            }
        }
        catch (IOException | ClassNotFoundException ignore) {
            logger.debug("Peer locator could not recover membership view from {}: {}", new Object[]{other, ignore.getMessage()});
        }
        logger.info("Peer locator was unable to recover state from this locator");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean recoverFromFile(File file) throws InternalGemFireException {
        if (!file.exists()) {
            return false;
        }
        logger.info("Peer locator recovering from " + file.getAbsolutePath());
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));){
            if (ois.readInt() != 2072835905) {
                boolean bl = false;
                return bl;
            }
            ObjectInput ois2 = ois;
            int version = ois2.readInt();
            if (version != Version.CURRENT_ORDINAL) {
                Version geodeVersion = Version.fromOrdinalNoThrow((short)version, false);
                logger.info("Peer locator found that persistent view was written with {}", new Object[]{geodeVersion});
                ois2 = new VersionedObjectInput(ois2, geodeVersion);
            }
            Object o = DataSerializer.readObject(ois2);
            this.view = (NetView)o;
            logger.info("Peer locator initial membership is " + this.view);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            String msg = LocalizedStrings.LOCATOR_UNABLE_TO_RECOVER_VIEW.toLocalizedString(file.toString());
            logger.warn(msg, (Throwable)e);
            if (file.delete()) throw new InternalGemFireException(msg, e);
            if (!file.exists()) throw new InternalGemFireException(msg, e);
            logger.warn("Peer locator was unable to recover from or delete " + file);
            this.viewFile = null;
            throw new InternalGemFireException(msg, e);
        }
    }
}

