/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.membership.gms.locator;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.distributed.internal.DistributionManager;
import com.gemstone.gemfire.distributed.internal.HighPriorityDistributionMessage;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.NetView;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.Version;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class FindCoordinatorResponse
extends HighPriorityDistributionMessage
implements DataSerializableFixedID {
    private InternalDistributedMember coordinator;
    private InternalDistributedMember senderId;
    private boolean fromView;
    private NetView view;
    private Set<InternalDistributedMember> registrants;
    private boolean networkPartitionDetectionEnabled;
    private boolean usePreferredCoordinators;
    private boolean isShortForm;

    public FindCoordinatorResponse(InternalDistributedMember coordinator, InternalDistributedMember senderId, boolean fromView, NetView view, HashSet<InternalDistributedMember> registrants, boolean networkPartitionDectionEnabled, boolean usePreferredCoordinators) {
        this.coordinator = coordinator;
        this.senderId = senderId;
        this.fromView = fromView;
        this.view = view;
        this.registrants = registrants;
        this.networkPartitionDetectionEnabled = networkPartitionDectionEnabled;
        this.usePreferredCoordinators = usePreferredCoordinators;
        this.isShortForm = false;
    }

    public FindCoordinatorResponse(InternalDistributedMember coordinator, InternalDistributedMember senderId) {
        this.coordinator = coordinator;
        this.senderId = senderId;
        this.isShortForm = true;
    }

    public FindCoordinatorResponse() {
    }

    public boolean isNetworkPartitionDetectionEnabled() {
        return this.networkPartitionDetectionEnabled;
    }

    public boolean isUsePreferredCoordinators() {
        return this.usePreferredCoordinators;
    }

    public InternalDistributedMember getCoordinator() {
        return this.coordinator;
    }

    public InternalDistributedMember getSenderId() {
        return this.senderId;
    }

    public boolean isFromView() {
        return this.fromView;
    }

    public NetView getView() {
        return this.view;
    }

    public Set<InternalDistributedMember> getRegistrants() {
        return this.registrants;
    }

    @Override
    public String toString() {
        if (this.isShortForm) {
            return "FindCoordinatorResponse(coordinator=" + this.coordinator + ")";
        }
        return "FindCoordinatorResponse(coordinator=" + this.coordinator + ", fromView=" + this.fromView + ", viewId=" + (this.view == null ? "nul" : Integer.valueOf(this.view.getViewId())) + ", registrants=" + (this.registrants == null ? 0 : this.registrants.size()) + ", senderId=" + this.senderId + ", network partition detection enabled=" + this.networkPartitionDetectionEnabled + ", locators preferred as coordinators=" + this.usePreferredCoordinators + ")";
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }

    @Override
    public int getDSFID() {
        return -144;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeObject(this.coordinator, out);
        DataSerializer.writeObject(this.senderId, out);
        out.writeBoolean(this.isShortForm);
        out.writeBoolean(this.fromView);
        out.writeBoolean(this.networkPartitionDetectionEnabled);
        out.writeBoolean(this.usePreferredCoordinators);
        DataSerializer.writeObject(this.view, out);
        InternalDataSerializer.writeSet(this.registrants, out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.coordinator = (InternalDistributedMember)DataSerializer.readObject(in);
        this.senderId = (InternalDistributedMember)DataSerializer.readObject(in);
        this.isShortForm = in.readBoolean();
        if (!this.isShortForm) {
            this.fromView = in.readBoolean();
            this.networkPartitionDetectionEnabled = in.readBoolean();
            this.usePreferredCoordinators = in.readBoolean();
            this.view = (NetView)DataSerializer.readObject(in);
            this.registrants = InternalDataSerializer.readHashSet(in);
        }
    }

    @Override
    protected void process(DistributionManager dm) {
        throw new IllegalStateException("this message should not be executed");
    }
}

