/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.membership.gms;

import com.gemstone.gemfire.GemFireConfigException;
import com.gemstone.gemfire.distributed.internal.membership.gms.Services;
import com.gemstone.gemfire.internal.SocketCreator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.logging.log4j.Logger;

public class GMSUtil {
    static Logger logger = Services.getLogger();

    public static List<InetSocketAddress> parseLocators(String locatorsString, String bindAddress) {
        InetAddress addr = null;
        try {
            addr = bindAddress == null || bindAddress.trim().length() == 0 ? SocketCreator.getLocalHost() : InetAddress.getByName(bindAddress);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return GMSUtil.parseLocators(locatorsString, addr);
    }

    public static List<InetSocketAddress> parseLocators(String locatorsString, InetAddress bindAddress) {
        ArrayList<InetSocketAddress> result = new ArrayList<InetSocketAddress>(2);
        boolean checkLoopback = bindAddress != null;
        boolean isLoopback = checkLoopback ? bindAddress.isLoopbackAddress() : false;
        StringTokenizer parts = new StringTokenizer(locatorsString, ",");
        while (parts.hasMoreTokens()) {
            try {
                String start;
                String str = parts.nextToken();
                String host = str.substring(0, str.indexOf(91));
                int idx = host.lastIndexOf(64);
                if (idx < 0) {
                    idx = host.lastIndexOf(58);
                }
                if ((start = host.substring(0, idx > -1 ? idx : host.length())).indexOf(58) >= 0) {
                    idx = host.lastIndexOf(64);
                }
                if (idx >= 0) {
                    host = host.substring(idx + 1, host.length());
                }
                int startIdx = str.indexOf(91) + 1;
                int endIdx = str.indexOf(93);
                int port = Integer.parseInt(str.substring(startIdx, endIdx));
                InetSocketAddress isa = new InetSocketAddress(host, port);
                if (checkLoopback && isLoopback && !isa.getAddress().isLoopbackAddress()) {
                    throw new GemFireConfigException("This process is attempting to join with a loopback address (" + bindAddress + ") using a locator that does not have a local address (" + isa + ").  On Unix this usually means that /etc/hosts is misconfigured.");
                }
                result.add(isa);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    public static String replaceStrings(String properties, String property, String value) {
        StringBuffer sb = new StringBuffer();
        int start = 0;
        int index = properties.indexOf(property);
        while (index != -1) {
            sb.append(properties.substring(start, index));
            sb.append(value);
            start = index + property.length();
            index = properties.indexOf(property, start);
        }
        sb.append(properties.substring(start));
        return sb.toString();
    }

    public static String formatBytes(byte[] buf, int startIndex, int length) {
        StringBuilder w = new StringBuilder(20000);
        int count = 0;
        int i = startIndex;
        while (i < length) {
            String s = Integer.toHexString(buf[i] & 0xFF);
            if (s.length() == 1) {
                w.append('0');
            }
            w.append(s).append(' ');
            if (count % 50 == 49) {
                w.append("\n");
            }
            ++i;
            ++count;
        }
        return w.toString();
    }

    public static int compareAddresses(InetAddress one, InetAddress two) {
        byte[] twoBytes;
        byte[] oneBytes = one.getAddress();
        if (oneBytes != (twoBytes = two.getAddress())) {
            for (int i = 0; i < oneBytes.length; ++i) {
                if (i >= twoBytes.length) {
                    return -1;
                }
                if (oneBytes[i] < twoBytes[i]) {
                    return -1;
                }
                if (oneBytes[i] <= twoBytes[i]) continue;
                return 1;
            }
            if (oneBytes.length > twoBytes.length) {
                return 1;
            }
        }
        return 0;
    }
}

