/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.distributed.internal.membership;

import com.gemstone.gemfire.distributed.DurableClientAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class MemberAttributes {
    public static final MemberAttributes INVALID = new MemberAttributes(-1, -1, -1, -1, null, null, null);
    private int dcPort;
    private int vmPid;
    private int vmKind;
    private int vmViewId;
    private String name;
    private String[] groups;
    private DurableClientAttributes durableClientAttributes;

    public MemberAttributes(int dcPort, int vmPid, int vmKind, int vmViewId, String p_name, String[] p_groups, DurableClientAttributes durableClientAttributes) {
        String[] l_groups = p_groups;
        this.dcPort = dcPort;
        this.vmPid = vmPid;
        this.vmKind = vmKind;
        this.vmViewId = vmViewId;
        if (l_groups == null) {
            l_groups = new String[]{};
        }
        this.groups = l_groups;
        this.name = p_name == null ? "" : p_name;
        this.durableClientAttributes = durableClientAttributes;
    }

    public int getPort() {
        return this.dcPort;
    }

    public int getVmPid() {
        return this.vmPid;
    }

    public int getVmKind() {
        return this.vmKind;
    }

    public String getName() {
        return this.name;
    }

    public String[] getGroups() {
        return this.groups;
    }

    public DurableClientAttributes getDurableClientAttributes() {
        return this.durableClientAttributes;
    }

    public static String[] parseGroups(String csvRoles, String csvGroups) {
        ArrayList<String> groups = new ArrayList<String>();
        MemberAttributes.parseCsv(groups, csvRoles);
        MemberAttributes.parseCsv(groups, csvGroups);
        return groups.toArray(new String[groups.size()]);
    }

    private static void parseCsv(List<String> groups, String csv) {
        if (csv == null || csv.length() == 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(csv, ",");
        while (st.hasMoreTokens()) {
            String groupName = st.nextToken().trim();
            if (groups.contains(groupName)) continue;
            groups.add(groupName);
        }
    }

    public int getVmViewId() {
        return this.vmViewId;
    }
}

